/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.manager.EditBatchOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.editBatchOutsideOrganizationManagerImpl")
public class EditBatchOutsideOrganizationManagerImpl
extends CommonOutsideOrganizationManager
implements EditBatchOutsideOrganizationManager {
    @Override
    public R<EditOutsideOrganizationDto> editBatchOrganizations(List<EditOutsideOrganizationDto> organs) {
        R result = new R();
        List errors = OrganUtil.validateMany(organs);
        List<String> organCodes = organs.stream().map(item -> StringUtils.trimToEmpty((String)item.getOrganCode())).distinct().collect(Collectors.toList());
        List<String> duplicateCodes = this.sysOrganMapper.selectDuplicateCodeByCodes(organCodes);
        for (EditOutsideOrganizationDto dto : organs) {
            boolean flag = duplicateCodes.contains(StringUtils.trimToEmpty((String)dto.getOrganCode()));
            if (flag) continue;
            OrganUtil.addErrorMsg((List)errors, (Object)dto, (String)"organCode", (String[])new String[]{TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_CODE_NOT_EXIST.getMessage())});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
            LinkedHashSet<SysStru> sysStruCollection = new LinkedHashSet<SysStru>();
            LinkedHashSet<SysOrgan> sysOrganCollection = new LinkedHashSet<SysOrgan>();
            LinkedHashSet<SysOffice> sysOfficeCollection = new LinkedHashSet<SysOffice>();
            for (EditOutsideOrganizationDto dto : organs) {
                SysOrgan sysOrgan = this.findSysOrgan(dto.getOrganCode().trim(), sysOrganCollection);
                SysStru sysStru = this.findSysStru(sysOrgan, sysStruCollection);
                SysOffice sysOffice = this.findSysOffice(sysStru, sysOfficeCollection);
                this.initializationEdit(sysStruCollection, sysOrganCollection, sysOfficeCollection, dto, sysStru, sysOrgan, sysOffice);
                sysStruCollection.add(sysStru);
                sysOrganCollection.add(sysOrgan);
                sysOfficeCollection.add(sysOffice);
                dataMappings.add(new DataMapping(sysStru.getId(), sysOrgan.getOrganCode()));
            }
            result.setSuccessList(dataMappings);
            this.organService.updateBatchById(sysOrganCollection);
            this.sysOfficeService.updateBatchById(sysOfficeCollection);
            this.struService.updateBatchById(sysStruCollection);
        }
        return result;
    }

    public Set<SysOrgan> searchOrgans(SysOrgan sysOrgan, Set<SysOrgan> sysOrganCollection) {
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("organFcode", SqlQueryUtil.transferSpecialChar((String)sysOrgan.getOrganFcode()));
        queryOrgParams.put("organId", sysOrgan.getId());
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<SysOrgan> sysOrgans = this.sysOrganMapper.getSubOrganByFcode(queryOrgParams);
        LinkedHashSet<SysOrgan> update = new LinkedHashSet<SysOrgan>();
        if (HussarUtils.isNotEmpty(sysOrganCollection)) {
            for (SysOrgan temp : sysOrganCollection) {
                if (!temp.getOrganFcode().startsWith(sysOrgan.getOrganFcode()) || sysOrgan.getOrganCode().equals(temp.getOrganCode())) continue;
                update.add(temp);
            }
        }
        if (HussarUtils.isNotEmpty(update) && HussarUtils.isNotEmpty(sysOrgans)) {
            Map organMap = update.stream().collect(Collectors.toMap(item -> item.getOrganCode(), Function.identity()));
            for (SysOrgan temp : sysOrgans) {
                SysOrgan find = (SysOrgan)organMap.get(temp.getOrganCode());
                if (find == null) continue;
                BeanUtils.copyProperties((Object)find, (Object)temp);
            }
        }
        update.addAll(sysOrgans);
        return update;
    }

    protected void initializationEdit(Set<SysStru> sysStruCollection, Set<SysOrgan> sysOrganCollection, Set<SysOffice> sysOfficeCollection, EditOutsideOrganizationDto editOrganizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        String organName = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganName());
        String organAlias = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganAlias());
        String userAccount = StringUtils.trimToEmpty((String)editOrganizationDto.getUserAccount());
        String organShortName = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganShortName());
        String organDescription = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganDescription());
        String organAddress = editOrganizationDto.getOrganAddress();
        String currentFname = sysOrgan.getOrganFname();
        String newFname = currentFname.substring(0, currentFname.lastIndexOf("/")) + "/" + editOrganizationDto.getOrganName().trim();
        if (!Objects.equals(editOrganizationDto.getOrganName().trim(), sysOrgan.getOrganName())) {
            Set<SysOrgan> sysOrgans = this.searchOrgans(sysOrgan, sysOrganCollection);
            for (SysOrgan temp : sysOrgans) {
                temp.setOrganFname(temp.getOrganFname().replaceFirst(currentFname, newFname));
                sysOrganCollection.add(temp);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)organAlias)) {
            sysStru.setOrganAlias(organAlias);
        }
        if (StringUtils.isNotBlank((CharSequence)userAccount)) {
            Long userId = this.getUserId(userAccount);
            sysStru.setPrincipalId(userId);
        }
        if (StringUtils.isNotBlank((CharSequence)organName)) {
            sysOrgan.setOrganName(organName);
        }
        sysOrgan.setOrganFname(sysOrgan.getOrganFname().replaceFirst(currentFname, newFname));
        if (StringUtils.isNotBlank((CharSequence)organShortName)) {
            sysOrgan.setShortName(organShortName);
        }
        if (StringUtils.isNotBlank((CharSequence)organAddress)) {
            sysOffice.setOfficeAddress(organAddress);
        }
        if (StringUtils.isNotBlank((CharSequence)organDescription)) {
            sysOffice.setOfficeAlias(organDescription);
        }
        sysOrganCollection.add(sysOrgan);
        sysStruCollection.add(sysStru);
        sysOfficeCollection.add(sysOffice);
    }

    public SysOrgan findSysOrgan(String organCode, Set<SysOrgan> sysOrganCollection) {
        Optional<SysOrgan> find;
        if (HussarUtils.isNotEmpty(sysOrganCollection) && (find = sysOrganCollection.stream().filter(item -> item.getOrganCode().equals(organCode)).findFirst()).isPresent()) {
            return find.get();
        }
        SysOrgan sysOrgan = (SysOrgan)this.organService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysOrgan::getOrganCode, (Object)StringUtils.trimToEmpty((String)organCode))).ne(SysOrgan::getOrganType, (Object)"9"));
        return sysOrgan;
    }

    private SysStru findSysStru(SysOrgan sysOrgan, Set<SysStru> sysStruCollection) {
        Optional<SysStru> find;
        Long organId = sysOrgan.getId();
        if (HussarUtils.isNotEmpty(sysStruCollection) && (find = sysStruCollection.stream().filter(item -> Objects.equals(item.getOrganId(), organId)).findFirst()).isPresent()) {
            return find.get();
        }
        return (SysStru)this.struService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOrganId, (Object)organId));
    }

    private SysOffice findSysOffice(SysStru sysStru, Set<SysOffice> sysOfficeCollection) {
        Optional<SysOffice> find;
        Long struId = sysStru.getId();
        if (HussarUtils.isNotEmpty(sysOfficeCollection) && (find = sysOfficeCollection.stream().filter(item -> Objects.equals(item.getStruId(), struId)).findFirst()).isPresent()) {
            return find.get();
        }
        return (SysOffice)this.sysOfficeService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOffice::getStruId, (Object)struId));
    }
}

