/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.adapter.role.ISysRolesExternalAdapter;
import com.jxdinfo.hussar.authorization.permit.dto.AppRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.AppRoleMemberDto;
import com.jxdinfo.hussar.authorization.permit.dto.DeleteAppRoleRelateDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserRelationDto;
import com.jxdinfo.hussar.authorization.permit.manager.AddRoleManager;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteRoleManager;
import com.jxdinfo.hussar.authorization.permit.manager.EditRoleManager;
import com.jxdinfo.hussar.authorization.permit.manager.QueryRoleManager;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.vo.AppRoleInfoVo;
import com.jxdinfo.hussar.authorization.permit.vo.AppRoleRelateInfoVo;
import com.jxdinfo.hussar.authorization.permit.vo.AppRoleRelateVo;
import com.jxdinfo.hussar.authorization.permit.vo.ReadOnlyRoleTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.RoleInfoVO;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.authorization.permit.vo.WorkTempRoleSearchVo;
import com.jxdinfo.hussar.authorization.relational.dto.RoleOrganRelationDto;
import com.jxdinfo.hussar.authorization.relational.dto.RolePostRelationDto;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.general.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.sysRolesExternalServiceImpl")
public class SysRolesExternalServiceImpl
implements ISysRolesExternalService {
    @Resource
    private ISysRolesExternalAdapter rolesExternalAdapter;
    @Resource
    private QueryRoleManager queryRoleManager;
    @Resource
    private AddRoleManager addRoleManager;
    @Resource
    private EditRoleManager editRoleManager;
    @Resource
    private DeleteRoleManager deleteRoleManager;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    private ISysStruRoleService sysStruRoleService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysPostRoleService sysPostRoleService;

    public ApiResponse<Long> addAppDevRole(String appName, Long appId) {
        return this.rolesExternalAdapter.addAppDevRole(appName, appId);
    }

    public ApiResponse<Boolean> addOrDelAppDevRoleUser(RoleUserDto roleUserDto) {
        return this.rolesExternalAdapter.addOrDelAppDevRoleUser(roleUserDto);
    }

    public Boolean addAppRoleUser(RoleUserDto roleUserDto) {
        return this.rolesExternalAdapter.addAppRoleUser(roleUserDto);
    }

    public List<RoleVo> getRoleInfoByIds(List<Long> roleIds) {
        return this.rolesExternalAdapter.getRoleInfoByIds(roleIds);
    }

    public List<JSTreeModel> loadRoleGruopTree(Long appId) {
        return this.rolesExternalAdapter.loadRoleGruopTree(appId);
    }

    public List<SysRoles> searchRoleToGroup(Long id, String roleName) {
        return this.rolesExternalAdapter.searchRoleToGroup(id, roleName);
    }

    public Boolean delRole(Long id) {
        return this.rolesExternalAdapter.delRole(id);
    }

    public List<ReadOnlyRoleTreeVo> getRoleTree(Long appId) {
        return this.queryRoleManager.getRoleTree(appId);
    }

    public List<RoleVo> getAppRole(Long appId, String roleType, String roleName) {
        return this.queryRoleManager.getAppRole(appId, roleType, roleName);
    }

    public Long addAppRole(AppRoleDto appRoleDto) {
        return this.addRoleManager.addAppRole(appRoleDto);
    }

    public Boolean editAppRole(AppRoleDto appRoleDto) {
        return this.editRoleManager.editAppRole(appRoleDto);
    }

    public Boolean sameRoleName(String roleName, Long roleId, Long appId) {
        return this.queryRoleManager.sameRoleName(roleName, roleId, appId);
    }

    public AppRoleInfoVo appRoleView(Long roleId) {
        return this.queryRoleManager.appRoleView(roleId);
    }

    public Boolean delAppRole(Long roleId) {
        return this.deleteRoleManager.delAppRole(roleId);
    }

    public Page<AppRoleRelateVo> searchAppRoleRelate(PageInfo pageInfo, Long roleId, String name, String relateType) {
        return this.queryRoleManager.searchAppRoleRelate(pageInfo, roleId, name, relateType);
    }

    public Boolean saveAppOrganRole(RoleOrganRelationDto roleOrganRelationDto) {
        Long roleId = roleOrganRelationDto.getRoleId();
        String struIds = roleOrganRelationDto.getStruIds();
        List<Object> struIdList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)struIds)) {
            struIdList = Arrays.asList(struIds.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        }
        this.sysStruRoleService.saveAppRoleOrgan(roleId, struIdList);
        return Boolean.TRUE;
    }

    public Boolean saveAppUserRole(RoleUserRelationDto roleUserRelationDto) {
        Long roleId = roleUserRelationDto.getRoleId();
        String userIds = roleUserRelationDto.getUserIds();
        List<Object> userIdList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)userIds)) {
            userIdList = Arrays.asList(userIds.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        }
        this.sysUserRoleService.saveAppRoleUser(roleId, userIdList);
        return Boolean.TRUE;
    }

    public Boolean saveAppPostRole(RolePostRelationDto rolePostRelationDto) {
        Long roleId = rolePostRelationDto.getRoleId();
        String postIds = rolePostRelationDto.getPostIds();
        List<Object> postIdList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)postIds)) {
            postIdList = Arrays.asList(postIds.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        }
        this.sysPostRoleService.saveAppPostRole(roleId, postIdList);
        return Boolean.TRUE;
    }

    public Boolean deleteAppRoleRelate(DeleteAppRoleRelateDto deleteAppRoleRelateDto) {
        return this.deleteRoleManager.deleteAppRoleRelate(deleteAppRoleRelateDto);
    }

    public Long copyAppRole(Long roleId) {
        return this.addRoleManager.copyAppRole(roleId);
    }

    public List<ReadOnlyRoleTreeVo> getAppRoleTree(Long appId) {
        return this.queryRoleManager.getAppRoleTree(appId);
    }

    public Page<RoleVo> searchRole(PageInfo pageInfo, QueryRoleDto queryRoleDto) {
        return this.queryRoleManager.searchRole(pageInfo, queryRoleDto);
    }

    public List<WorkTempRoleSearchVo> roleSearch(String name, Long appId) {
        return this.rolesExternalAdapter.roleSearch(name, appId);
    }

    public RoleInfoVO getRoleViewMap(Long id) {
        return this.rolesExternalAdapter.getRoleViewMap(id);
    }

    public Boolean updateRole(SysRoles sysRoles) {
        return this.rolesExternalAdapter.updateRole(sysRoles);
    }

    public List<SysRoles> getRolesByIds(List<Long> roleIds) {
        return this.rolesExternalAdapter.getRolesByIds(roleIds);
    }

    public List<SysRoles> getAllRoles() {
        return this.rolesExternalAdapter.getAllRoles();
    }

    public Boolean saveRoleBatch(List<SysRoles> roleList) {
        return this.rolesExternalAdapter.saveRoleBatch(roleList);
    }

    public List<SysRoleGroup> selectRoleGroupByIds(List<Long> roleGroupIds) {
        return this.rolesExternalAdapter.selectRoleGroupByIds(roleGroupIds);
    }

    public List<SysRoleGroup> getAllRoleGroup() {
        return this.rolesExternalAdapter.getAllRoleGroup();
    }

    public Boolean saveRoleGroupBatch(List<SysRoleGroup> roleGroupList) {
        return this.rolesExternalAdapter.saveRoleGroupBatch(roleGroupList);
    }

    public Boolean saveAppRoleWithMember(AppRoleMemberDto appRoleMemberDto) {
        return this.addRoleManager.saveAppRoleWithMember(appRoleMemberDto);
    }

    public List<SysRoles> getRolesFilterAppDevRole(List<Long> roleIds) {
        return this.queryRoleManager.getRolesFilterAppDevRole(roleIds);
    }

    public List<AppRoleRelateInfoVo> searchAppRoleRelateByRoleIds(List<Long> roleIds) {
        return this.queryRoleManager.searchAppRoleRelateByRoleIds(roleIds);
    }

    public Boolean saveAppRoleInfo(List<AppRoleMemberDto> appRoleMemberList) {
        return this.addRoleManager.saveAppRoleInfo(appRoleMemberList);
    }
}

