/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authentication.lock.UserLockModel;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dto.SearchOrganUserDto;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonQueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganVo;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserAttachmentService;
import com.jxdinfo.hussar.authorization.permit.service.ILocalQueryUserMangerService;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysUserAttachmentVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.localQueryUserManagerServiceImpl")
public class LocalQueryUserManagerServiceImpl
extends CommonQueryOrganizationManager
implements ILocalQueryUserMangerService {
    private Logger logger = LoggerFactory.getLogger(LocalQueryUserManagerServiceImpl.class);
    @Autowired
    private ISysOrganService sysOrganService;
    @Autowired
    private ISysStruService sysStruService;
    @Resource
    @Lazy
    private QueryOrganizationManager queryOrganizationManager;
    @Autowired
    private IHussarBaseUserAttachmentService userAttachmentService;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;

    public Page<SearchUserVo> searchUsers(PageInfo pageInfo, QueryUserDto queryUserDto) {
        String struPath;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)currentUser) && (HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)queryUserDto.getDepStruId()) || HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)queryUserDto.getDepStruId()))) {
            String organProperty = HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)queryUserDto.getDepStruId()) ? "0" : "1";
            Long parentId = this.queryOrganizationManager.getGradeOrganType(queryUserDto.getDepStruId());
            if (HussarUtils.isEmpty((Object)parentId)) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            OrganizationTreeVo organ = this.sysStruMapper.lazyOrganizationById(parentId);
            if (HussarUtils.isNotEmpty((Object)organ) && !HussarUtils.equals((Object)organProperty, (Object)organ.getOrganProperty())) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            queryUserDto.setDepStruId(parentId);
        }
        AtomicReference<Long> depStruId = new AtomicReference<Long>(queryUserDto.getDepStruId());
        if (HussarUtils.isNotEmpty((Object)currentUser) && currentUser.isGradeadmin()) {
            ConditionUtils.isTureOrFalse((boolean)HussarUtils.isEmpty((Object)depStruId.get())).trueOrFalseHandle(() -> depStruId.set(currentUser.getDeptId()), () -> {
                SysStru currentNodeStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)queryUserDto.getDepStruId()));
                SysStru sysStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)currentUser.getDeptId()));
                if (currentNodeStru.getStruLevel() <= sysStru.getStruLevel()) {
                    depStruId.set(currentUser.getDeptId());
                }
            });
        }
        queryParams.put("containSys", StringUtils.trimToEmpty((String)queryUserDto.getContainSys()));
        if (Objects.equals(Constants.ROOT_NODE_ID, depStruId.get())) {
            struPath = "0";
        } else if (Objects.equals(Constants.OUT_STRU_NODE_ID, depStruId.get())) {
            struPath = "1";
            queryParams.put("containSys", "0");
        } else {
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(depStruId.get());
            AssertUtil.isNotNull((Object)struTemp, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_SYSSTRU.getMessage()));
            struPath = struTemp.getStruFid();
            queryParams.put("containSys", "0");
        }
        Object[] arr = new String[]{UserStatus.LOCKED.getCode(), UserStatus.OK.getCode()};
        String accountStatus = queryUserDto.getAccountStatus();
        if (ArrayUtils.contains((Object[])arr, (Object)accountStatus)) {
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            List casKeyList = HussarCacheUtil.getKeysLike((String)"hussar_cas_login_lock", (String)"?");
            if (HussarUtils.isEmpty((Object)keyList) && HussarUtils.isEmpty((Object)casKeyList) && HussarUtils.equals((Object)accountStatus, (Object)UserStatus.LOCKED.getCode())) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            ArrayList<Long> lockUserIds = new ArrayList<Long>();
            queryUserDto.setLockUserIds(lockUserIds);
            if (CollectionUtils.isNotEmpty((Collection)keyList)) {
                Iterator iterator = keyList.iterator();
                while (iterator.hasNext()) {
                    String cacheKey;
                    String tmpKey = cacheKey = (String)iterator.next();
                    lockUserIds.add(Long.parseLong(tmpKey));
                }
            } else if (CollectionUtils.isNotEmpty((Collection)casKeyList)) {
                for (String cacheKey : casKeyList) {
                    UserLockModel model = (UserLockModel)JSON.parseObject((String)((String)HussarCacheUtil.get((String)"hussar_cas_login_lock", (Object)cacheKey)), UserLockModel.class);
                    if (!HussarUtils.isNotEmpty((Object)model)) continue;
                    lockUserIds.add(Long.parseLong(model.getUserId()));
                }
            }
            if (HussarUtils.isNotEmpty(lockUserIds)) {
                queryParams.put("lockUserIds", lockUserIds);
            }
        }
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("userAccount", SqlQueryUtil.transferSpecialChar((String)queryUserDto.getUserAccount()));
        queryParams.put("accountStatus", StringUtils.trimToEmpty((String)queryUserDto.getAccountStatus()));
        queryParams.put("userName", SqlQueryUtil.transferSpecialChar((String)queryUserDto.getUserName()));
        queryParams.put("accountProperty", StringUtils.trimToEmpty((String)queryUserDto.getAccountProperty()));
        queryParams.put("struPath", StringUtils.trimToEmpty((String)struPath));
        List<SearchUserVo> userInfoList = this.sysUsersMapper.searchUserOrganInfosNew((Page<SearchUserVo>)page, queryParams);
        this.fillOrganInfos(userInfoList);
        this.wrapUsers(userInfoList);
        page.setRecords(userInfoList);
        return page;
    }

    private void fillOrganInfos(List<SearchUserVo> userInfoList) {
        if (HussarUtils.isEmpty(userInfoList)) {
            return;
        }
        List userIdList = userInfoList.stream().map(SearchUserVo::getId).collect(Collectors.toList());
        List<UserOrganPostVo> organByUserIds = this.sysStruUserMapper.getOrganByUserIds(LambdaQueryUtil.getSplitList(userIdList), null);
        Map<Long, List<UserOrganPostVo>> userOrganMap = organByUserIds.stream().collect(Collectors.groupingBy(UserOrganPostVo::getUserId));
        for (SearchUserVo vo : userInfoList) {
            List<UserOrganPostVo> organInfoList = userOrganMap.get(vo.getId());
            if (HussarUtils.isEmpty(organInfoList)) continue;
            String organName = organInfoList.stream().map(UserOrganPostVo::getOrganFname).collect(Collectors.joining(","));
            vo.setDepartmentName(organName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Page<SearchUserTreeVo> searchUser(PageInfo pageInfo, SearchOrganUserDto searchOrganUserDto) {
        List<Long> struIdList;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        page.setOptimizeCountSql(false);
        HashMap<String, Object> queryUserParams = new HashMap<String, Object>();
        String resultType = searchOrganUserDto.getResultType();
        List organIds = searchOrganUserDto.getOrganIds();
        List userIds = searchOrganUserDto.getUserIds();
        if ("0".equals(resultType)) {
            List struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, (Collection)organIds)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            if (!HussarUtils.isNotEmpty((Object)struUsers)) return page;
            List userIdList = struUsers.stream().map(SysStruUser::getUserId).collect(Collectors.toList());
            queryUserParams.put("userIds", userIdList);
        } else if ("1".equals(resultType)) {
            struIdList = this.getSubOrganByIds(organIds);
            List struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIdList)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            if (!HussarUtils.isNotEmpty((Object)struUsers)) return page;
            List userIdList = struUsers.stream().map(SysStruUser::getUserId).distinct().collect(Collectors.toList());
            queryUserParams.put("userIds", userIdList);
        } else if ("2".equals(resultType)) {
            queryUserParams.put("userIds", null);
        } else if ("3".equals(resultType)) {
            List struUsers;
            struIdList = this.getSubOrganByIds(organIds);
            if (HussarUtils.isNotEmpty(struIdList) && HussarUtils.isNotEmpty((Object)(struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIdList)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"))))) {
                List userIdList = struUsers.stream().map(SysStruUser::getUserId).collect(Collectors.toList());
                userIds.addAll(userIdList);
                userIds = userIds.stream().distinct().collect(Collectors.toList());
            }
            queryUserParams.put("userIds", userIds);
        }
        queryUserParams.put("name", SqlQueryUtil.transferSpecialChar((String)searchOrganUserDto.getName()));
        queryUserParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<SearchUserTreeVo> searchUserTreeVos = this.sysUsersMapper.searchUserTreeVo((Page<SearchUserTreeVo>)page, queryUserParams);
        if (HussarUtils.isEmpty(searchUserTreeVos)) {
            return page;
        }
        this.wrapSearchUsers(searchUserTreeVos);
        page.setRecords(searchUserTreeVos);
        return page;
    }

    private void wrapSearchUsers(List<SearchUserTreeVo> searchUserTreeVos) {
        List ids = searchUserTreeVos.stream().map(SearchUserTreeVo::getId).collect(Collectors.toList());
        List struUsers = this.sysStruUserService.list((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getUserId, ids));
        Map<Long, List<SysStruUser>> map = struUsers.stream().collect(Collectors.groupingBy(SysStruUser::getUserId));
        List struIds = struUsers.stream().map(SysStruUser::getStruId).distinct().collect(Collectors.toList());
        List organVos = this.sysOrganService.getOrgansByStruIds(struIds);
        Map organVoMap = organVos.stream().collect(Collectors.toMap(SearchOrganVo::getId, Function.identity()));
        for (SearchUserTreeVo userTreeVo : searchUserTreeVos) {
            List<SysStruUser> struUserList = map.get(userTreeVo.getId());
            if (!HussarUtils.isNotEmpty(struUserList)) continue;
            List list = struUserList.stream().map(SysStruUser::getStruId).distinct().collect(Collectors.toList());
            List vos = LocalQueryUserManagerServiceImpl.getCollection(organVoMap, list);
            String organFNames = null;
            String organNames = null;
            if (HussarUtils.isNotEmpty(vos)) {
                organNames = vos.stream().map(SearchOrganVo::getLabel).collect(Collectors.joining(","));
                organFNames = vos.stream().map(SearchOrganVo::getOrganFname).collect(Collectors.joining(","));
            }
            userTreeVo.setParentName(organNames);
            userTreeVo.setOrganFname(organFNames);
        }
    }

    public List<UserVo> getUsersByOrganUser(List<Long> organIds, List<Long> userIds) {
        List list;
        List<Object> result = new ArrayList<UserVo>();
        if (HussarUtils.isEmpty(organIds) && HussarUtils.isEmpty(userIds)) {
            return result;
        }
        if (HussarUtils.isNotEmpty(userIds)) {
            userIds = userIds.stream().distinct().collect(Collectors.toList());
            List<UserVo> userList = this.sysUsersMapper.getUserByIds(userIds);
            result.addAll(userList);
        }
        if (HussarUtils.isNotEmpty(organIds) && HussarUtils.isNotEmpty((Object)(list = this.sysStruService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getId, organIds))))) {
            List fidList = list.stream().map(SysStru::getStruFid).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            for (String fid : fidList) {
                ((LambdaQueryWrapper)wrapper.or()).likeRight(SysStru::getStruFid, (Object)fid);
            }
            List sysStrus = this.sysStruService.list((Wrapper)wrapper);
            List<Long> struIdList = sysStrus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
            List<UserVo> userVoList = this.sysUsersMapper.getUserByOrganIds(struIdList);
            result.addAll(userVoList);
        }
        if (HussarUtils.isNotEmpty(result)) {
            result = result.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<UserVo>(Comparator.comparing(UserVo::getId))), ArrayList::new));
        }
        return result;
    }

    public List<OrganUserTreeVo> lazyOrganUserTree(List<Long> parentOrganIds, Boolean needParentOrganInfo, Integer resultType) {
        ArrayList<OrganUserTreeVo> organUserTreeVos = new ArrayList<OrganUserTreeVo>();
        if (HussarUtils.isEmpty(parentOrganIds)) {
            return organUserTreeVos;
        }
        List<Long> organIds = this.getParentOrganIds(parentOrganIds);
        for (Long organId : organIds) {
            if (organId.equals(Constants.ROOT_NODE_ID)) {
                this.getInAndOutTree(needParentOrganInfo, organUserTreeVos, organId, resultType, "0", this.sysBaseConfigService.getSysBaseConfig("org_in_name").getConfigValue());
                continue;
            }
            if (organId.equals(Constants.OUT_STRU_NODE_ID)) {
                this.getInAndOutTree(needParentOrganInfo, organUserTreeVos, organId, resultType, "1", this.sysBaseConfigService.getSysBaseConfig("org_out_name").getConfigValue());
                continue;
            }
            this.getOrganUserTree(needParentOrganInfo, organUserTreeVos, organId, resultType);
        }
        return HussarTreeParser.getTreeList(organUserTreeVos);
    }

    private List<Long> getParentOrganIds(List<Long> struIds) {
        if (!struIds.contains(Constants.ROOT_NODE_ID) && !struIds.contains(Constants.OUT_STRU_NODE_ID)) {
            List sysStrus = this.sysStruService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStru::getId, struIds)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            Map<Long, String> fidMap = sysStrus.stream().collect(Collectors.toMap(SysStru::getId, SysStru::getStruFid));
            ArrayList<Long> removeIds = new ArrayList<Long>();
            block0: for (Long struId : struIds) {
                int num = 0;
                String fidParent = fidMap.get(struId);
                for (Long id : struIds) {
                    String fid = fidMap.get(id);
                    if (fidParent.contains(fid)) {
                        ++num;
                    }
                    if (num <= 1) continue;
                    removeIds.add(struId);
                    continue block0;
                }
            }
            struIds.removeAll(removeIds);
            return new ArrayList<Long>(struIds);
        }
        if (struIds.contains(Constants.ROOT_NODE_ID) && struIds.contains(Constants.OUT_STRU_NODE_ID)) {
            ArrayList<Long> result = new ArrayList<Long>();
            result.add(Constants.ROOT_NODE_ID);
            result.add(Constants.OUT_STRU_NODE_ID);
            return result;
        }
        Long rootId = struIds.contains(Constants.ROOT_NODE_ID) ? Constants.ROOT_NODE_ID : Constants.OUT_STRU_NODE_ID;
        List sysStrus = this.sysStruService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getId, struIds));
        if (HussarUtils.isNotEmpty((Object)sysStrus)) {
            List<Long> struIdList = sysStrus.stream().map(SysStru::getId).collect(Collectors.toList());
            List parentStrus = this.sysStruService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getParentId, (Object)rootId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            List parentFIdList = parentStrus.stream().map(SysStru::getStruFid).collect(Collectors.toList());
            if (HussarUtils.isEmpty((Object)parentStrus)) {
                List<Long> parentOrganIds = this.getParentOrganIds(struIdList);
                ArrayList<Long> result = new ArrayList<Long>();
                result.add(rootId);
                result.addAll(parentOrganIds);
                return result;
            }
            ArrayList<SysStru> strus = new ArrayList<SysStru>();
            for (SysStru stru : sysStrus) {
                String parentFId;
                String struFid = stru.getStruFid();
                int num = 0;
                Iterator iterator = parentFIdList.iterator();
                while (iterator.hasNext() && !struFid.contains(parentFId = (String)iterator.next())) {
                    ++num;
                }
                if (num != parentFIdList.size()) continue;
                strus.add(stru);
            }
            if (HussarUtils.isEmpty(strus)) {
                ArrayList result = new ArrayList();
                result.add(rootId);
                return result;
            }
            List<Long> parentIds = strus.stream().map(SysStru::getId).collect(Collectors.toList());
            List<Long> parentOrganIds = this.getParentOrganIds(parentIds);
            ArrayList<Long> result = new ArrayList<Long>();
            result.add(rootId);
            result.addAll(parentOrganIds);
            return result;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        result.add(rootId);
        return result;
    }

    private void getOrganUserTree(Boolean needParentOrganInfo, List<OrganUserTreeVo> organUserTreeVos, Long organId, Integer resultType) {
        List<OrganUserTreeVo> organs;
        if (HussarUtils.isEmpty((Object)resultType)) {
            return;
        }
        boolean flag = false;
        if (resultType.equals(0)) {
            organs = this.getOneOrganInfo(organId, resultType, null);
            flag = organs.size() > 0;
            organUserTreeVos.addAll(organs);
        }
        if (resultType.equals(1)) {
            ArrayList<Long> struIds = new ArrayList<Long>();
            struIds.add(organId);
            List<OrganUserTreeVo> userTreeVos = this.sysStruUserMapper.getOrganUserTreeOnlyUser(LambdaQueryUtil.getSplitList(struIds));
            if (HussarUtils.isNotEmpty(userTreeVos)) {
                flag = true;
                organUserTreeVos.addAll(userTreeVos);
            }
        }
        if (resultType.equals(2)) {
            organs = this.getOneOrganInfo(organId, resultType, null);
            ArrayList<Long> struIds = new ArrayList<Long>();
            struIds.add(organId);
            List<OrganUserTreeVo> userTreeVos = this.sysStruUserMapper.getOrganUserTreeOnlyUser(LambdaQueryUtil.getSplitList(struIds));
            if (HussarUtils.isNotEmpty(userTreeVos)) {
                organs.addAll(userTreeVos);
            }
            flag = organs.size() > 0;
            organUserTreeVos.addAll(organs);
        }
        if (needParentOrganInfo.booleanValue()) {
            SearchOrganVo organVo = this.sysStruMapper.getOrganById(organId);
            if (HussarUtils.isEmpty((Object)organVo)) {
                return;
            }
            OrganUserTreeVo organUserTreeVo = this.initRootTree(organVo.getLabel(), organId);
            ArrayList<Long> struIds = new ArrayList<Long>();
            struIds.add(organId);
            Map<Long, Integer> organIdUserCount = this.getUserCountByOrganId(struIds);
            organUserTreeVo.setUserCount(organIdUserCount.get(organId));
            organUserTreeVo.setHasChildren(Boolean.valueOf(flag));
            organUserTreeVo.setIcon(organVo.getIcon());
            organUserTreeVo.setOrganType(organVo.getOrganType());
            organUserTreeVos.add(organUserTreeVo);
        }
    }

    private void getInAndOutTree(Boolean needParentOrganInfo, List<OrganUserTreeVo> organUserTreeVos, Long organId, Integer resultType, String organProperty, String organName) {
        if (HussarUtils.isEmpty((Object)resultType)) {
            return;
        }
        boolean flag = false;
        if (resultType.equals(0) || resultType.equals(2)) {
            List<OrganUserTreeVo> internalOrgans = this.getOneOrganInfo(organId, resultType, organProperty);
            flag = internalOrgans.size() > 0;
            organUserTreeVos.addAll(internalOrgans);
        }
        if (needParentOrganInfo.booleanValue()) {
            OrganUserTreeVo internalOrganStaffTreeVo = this.initRootTree(organName, organId);
            internalOrganStaffTreeVo.setHasChildren(Boolean.valueOf(flag));
            organUserTreeVos.add(internalOrganStaffTreeVo);
        }
    }

    private List<OrganUserTreeVo> getOneOrganInfo(Long organId, Integer resultType, String organProperty) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("parentId", organId);
        queryParams.put("organProperty", organProperty);
        List<OrganUserTreeVo> organs = this.sysStruMapper.getOrganUserTreeOnlyOrgan(queryParams);
        if (HussarUtils.isEmpty(organs)) {
            return organs;
        }
        List<Long> oneOrganIds = organs.stream().map(s -> (Long)s.getId()).distinct().collect(Collectors.toList());
        Map<Long, Integer> organIdUserCount = this.getUserCountByOrganId(oneOrganIds);
        for (OrganUserTreeVo treeVo : organs) {
            int count = organIdUserCount.get((long)((Long)treeVo.getId()));
            treeVo.setUserCount(Integer.valueOf(count));
            if (resultType.equals(1)) {
                treeVo.setHasChildren(Boolean.valueOf(count > 0));
                continue;
            }
            if (!resultType.equals(2)) continue;
            treeVo.setHasChildren(Boolean.valueOf(treeVo.getHasChildren() != false || count > 0));
        }
        return organs;
    }

    private OrganUserTreeVo initRootTree(String organName, Long parentId) {
        OrganUserTreeVo internalOrganUserTreeVo = new OrganUserTreeVo();
        internalOrganUserTreeVo.setLabel(organName);
        internalOrganUserTreeVo.setId((Serializable)parentId);
        internalOrganUserTreeVo.setTypes("organ");
        return internalOrganUserTreeVo;
    }

    private void wrapUsers(List<SearchUserVo> userInfoList) {
        boolean flag;
        List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
        List casKeyList = HussarCacheUtil.getKeysLike((String)"hussar_cas_login_lock", (String)"?");
        List list1 = this.sysDicRefService.getDicListByType("account_state");
        Map<String, String> mapStatus = list1.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        List list2 = this.sysDicRefService.getDicListByType("account_property");
        Map<String, String> mapProperty = list2.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        boolean bl = flag = HussarUtils.isNotEmpty((Object)keyList) || HussarUtils.isNotEmpty((Object)casKeyList);
        if (HussarUtils.isNotEmpty(userInfoList)) {
            for (SearchUserVo vo : userInfoList) {
                Optional<String> optional;
                vo.setAccoutStatusName(mapStatus.get(vo.getAccountStatus()));
                vo.setAccountPropertyName(mapProperty.get(vo.getAccountProperty()));
                if (!flag) continue;
                if (HussarUtils.isNotEmpty((Object)keyList)) {
                    optional = keyList.parallelStream().filter(item -> item.equalsIgnoreCase(String.valueOf(vo.getId()))).findAny();
                    ConditionUtils.isTrue((boolean)optional.isPresent()).handle(() -> {
                        String tmpkey = (String)optional.get();
                        UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)tmpkey);
                        if (null != model && model.getLockTime() != null) {
                            vo.setAccountStatus(UserStatus.LOCKED.getCode());
                        }
                    });
                    continue;
                }
                if (!HussarUtils.isNotEmpty((Object)casKeyList)) continue;
                optional = casKeyList.parallelStream().filter(item -> item.contains(String.valueOf(vo.getId()))).findAny();
                ConditionUtils.isTrue((boolean)optional.isPresent()).handle(() -> {
                    String tmpkey = (String)optional.get();
                    UserLockModel model = (UserLockModel)JSON.parseObject((String)((String)HussarCacheUtil.get((String)"hussar_cas_login_lock", (Object)tmpkey)), UserLockModel.class);
                    if (null != model && model.getLockTime() != null) {
                        vo.setAccountStatus(UserStatus.LOCKED.getCode());
                    }
                });
            }
        }
    }

    public UserStaffVo getUserAndStaffInfo(Long userId) {
        UserStaffVo info = this.sysUsersMapper.getUserAndStaffInfo(userId);
        if (HussarUtils.isEmpty((Object)info)) {
            return info;
        }
        List<UserOrganPostVo> organs = this.sysStruUserMapper.getOrganByUserId(userId);
        List<UserOrganPostVo> posts = this.sysUserPostMapper.getPostByUserId(userId);
        info.setOrgans(organs);
        info.setPosts(posts);
        return info;
    }

    public Page<SearchUserVo> getUserList(PageInfo pageInfo, String userName, String userAccount) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("userAccount", StringUtils.trimToEmpty((String)userAccount));
        queryParams.put("userName", StringUtils.trimToEmpty((String)userName));
        List<SearchUserVo> userInfoList = this.sysUsersMapper.searchUserList((Page<SearchUserVo>)page, queryParams);
        this.wrapUsers(userInfoList);
        page.setRecords(userInfoList);
        return page;
    }

    public Page<SearchUserVo> searchUsersAllowPinyin(PageInfo pageInfo, QueryUserDto queryUserDto) {
        String struPath;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        if (HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)queryUserDto.getDepStruId()) || HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)queryUserDto.getDepStruId())) {
            String organProperty = HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)queryUserDto.getDepStruId()) ? "0" : "1";
            Long parentId = this.queryOrganizationManager.getGradeOrganType(queryUserDto.getDepStruId());
            if (HussarUtils.isEmpty((Object)parentId)) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            OrganizationTreeVo organ = this.sysStruMapper.lazyOrganizationById(parentId);
            if (HussarUtils.isNotEmpty((Object)organ) && !HussarUtils.equals((Object)organProperty, (Object)organ.getOrganProperty())) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            queryUserDto.setDepStruId(parentId);
        }
        AtomicReference<Long> depStruId = new AtomicReference<Long>(queryUserDto.getDepStruId());
        if (HussarUtils.isNotEmpty((Object)currentUser) && currentUser.isGradeadmin()) {
            ConditionUtils.isTureOrFalse((boolean)HussarUtils.isEmpty((Object)depStruId.get())).trueOrFalseHandle(() -> depStruId.set(currentUser.getDeptId()), () -> {
                SysStru currentNodeStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)queryUserDto.getDepStruId()));
                SysStru sysStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)currentUser.getDeptId()));
                if (currentNodeStru.getStruLevel() <= sysStru.getStruLevel()) {
                    depStruId.set(currentUser.getDeptId());
                }
            });
        }
        queryParams.put("containSys", StringUtils.trimToEmpty((String)queryUserDto.getContainSys()));
        if (Objects.equals(Constants.ROOT_NODE_ID, depStruId.get())) {
            struPath = "0";
        } else if (Objects.equals(Constants.OUT_STRU_NODE_ID, depStruId.get())) {
            struPath = "1";
            queryParams.put("containSys", "0");
        } else {
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(depStruId.get());
            AssertUtil.isNotNull((Object)struTemp, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_SYSSTRU.getMessage()));
            struPath = struTemp.getStruFid();
            queryParams.put("containSys", "0");
        }
        Object[] arr = new String[]{UserStatus.LOCKED.getCode(), UserStatus.OK.getCode()};
        String accountStatus = queryUserDto.getAccountStatus();
        if (ArrayUtils.contains((Object[])arr, (Object)accountStatus)) {
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            List casKeyList = HussarCacheUtil.getKeysLike((String)"hussar_cas_login_lock", (String)"?");
            if (HussarUtils.isEmpty((Object)keyList) && HussarUtils.isEmpty((Object)casKeyList) && HussarUtils.equals((Object)accountStatus, (Object)UserStatus.LOCKED.getCode())) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            ArrayList<Long> lockUserIds = new ArrayList<Long>();
            queryUserDto.setLockUserIds(lockUserIds);
            if (CollectionUtils.isNotEmpty((Collection)keyList)) {
                Iterator iterator = keyList.iterator();
                while (iterator.hasNext()) {
                    String cacheKey;
                    String tmpKey = cacheKey = (String)iterator.next();
                    lockUserIds.add(Long.parseLong(tmpKey));
                }
            } else if (CollectionUtils.isNotEmpty((Collection)casKeyList)) {
                for (String cacheKey : casKeyList) {
                    UserLockModel model = (UserLockModel)JSON.parseObject((String)((String)HussarCacheUtil.get((String)"hussar_cas_login_lock", (Object)cacheKey)), UserLockModel.class);
                    if (!HussarUtils.isNotEmpty((Object)model)) continue;
                    lockUserIds.add(Long.parseLong(model.getUserId()));
                }
            }
            if (HussarUtils.isNotEmpty(lockUserIds)) {
                queryParams.put("lockUserIds", lockUserIds);
            }
        }
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("userAccount", SqlQueryUtil.transferSpecialChar((String)queryUserDto.getUserAccount()));
        queryParams.put("accountStatus", StringUtils.trimToEmpty((String)queryUserDto.getAccountStatus()));
        queryParams.put("userName", SqlQueryUtil.transferSpecialChar((String)queryUserDto.getUserName()));
        queryParams.put("accountProperty", StringUtils.trimToEmpty((String)queryUserDto.getAccountProperty()));
        queryParams.put("struPath", StringUtils.trimToEmpty((String)struPath));
        List<SearchUserVo> userInfoList = this.sysUsersMapper.searchUserOrganInfosAllowPinyin((Page<SearchUserVo>)page, queryParams);
        this.fillOrganInfos(userInfoList);
        this.wrapUsers(userInfoList);
        this.fillUserSignInfos(userInfoList);
        page.setRecords(userInfoList);
        return page;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Page<SearchUserTreeVo> searchUserAllowPinyin(PageInfo pageInfo, SearchOrganUserDto searchOrganUserDto) {
        List<Long> struIdList;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        page.setOptimizeCountSql(false);
        HashMap<String, Object> queryUserParams = new HashMap<String, Object>();
        String resultType = searchOrganUserDto.getResultType();
        List organIds = searchOrganUserDto.getOrganIds();
        List userIds = searchOrganUserDto.getUserIds();
        if ("0".equals(resultType)) {
            List struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, (Collection)organIds)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            if (!HussarUtils.isNotEmpty((Object)struUsers)) return page;
            List userIdList = struUsers.stream().map(SysStruUser::getUserId).collect(Collectors.toList());
            queryUserParams.put("userIds", userIdList);
        } else if ("1".equals(resultType)) {
            struIdList = this.getSubOrganByIds(organIds);
            List struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIdList)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            if (!HussarUtils.isNotEmpty((Object)struUsers)) return page;
            List userIdList = struUsers.stream().map(SysStruUser::getUserId).distinct().collect(Collectors.toList());
            queryUserParams.put("userIds", userIdList);
        } else if ("2".equals(resultType)) {
            queryUserParams.put("userIds", null);
        } else if ("3".equals(resultType)) {
            List struUsers;
            struIdList = this.getSubOrganByIds(organIds);
            if (HussarUtils.isNotEmpty(struIdList) && HussarUtils.isNotEmpty((Object)(struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, struIdList)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"))))) {
                List userIdList = struUsers.stream().map(SysStruUser::getUserId).collect(Collectors.toList());
                userIds.addAll(userIdList);
                userIds = userIds.stream().distinct().collect(Collectors.toList());
            }
            queryUserParams.put("userIds", userIds);
        }
        queryUserParams.put("userName", SqlQueryUtil.transferSpecialChar((String)searchOrganUserDto.getName()));
        queryUserParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<SearchUserTreeVo> searchUserTreeVos = this.sysUsersMapper.searchUserTreeVoAllowPinyin((Page<SearchUserTreeVo>)page, queryUserParams);
        if (HussarUtils.isEmpty(searchUserTreeVos)) {
            return page;
        }
        this.wrapSearchUsers(searchUserTreeVos);
        page.setRecords(searchUserTreeVos);
        return page;
    }

    private void fillUserSignInfos(List<SearchUserVo> searchUserVoList) {
        if (HussarUtils.isEmpty(searchUserVoList)) {
            return;
        }
        List userIdList = searchUserVoList.stream().map(SearchUserVo::getId).collect(Collectors.toList());
        List userSignVoList = this.userAttachmentService.listUserSignByUserIds(userIdList);
        if (HussarUtils.isEmpty((Object)userSignVoList)) {
            return;
        }
        Map<Long, List<SysUserAttachmentVo>> userSignMap = userSignVoList.stream().collect(Collectors.groupingBy(SysUserAttachmentVo::getUserId));
        for (SearchUserVo vo : searchUserVoList) {
            List<SysUserAttachmentVo> signInfoList = userSignMap.get(vo.getId());
            if (HussarUtils.isEmpty(signInfoList)) continue;
            if (signInfoList.size() > 1) {
                this.logger.info("\u5f53\u524d\u7528\u6237\u5b58\u5728\u591a\u4e2a\u7b7e\u540d,\u907f\u514d\u524d\u7aef\u5f02\u5e38\uff0c\u53d6\u7b2c\u4e00\u4e2a===>{}", (Object)vo.getId());
            }
            SysUserAttachmentVo userAttachmentVo = signInfoList.get(0);
            vo.setFileType(userAttachmentVo.getFileType());
            vo.setBusiType(userAttachmentVo.getBusiType());
            vo.setUserSignImgBase64(userAttachmentVo.getImgBase64());
            vo.setUserSignFileId(userAttachmentVo.getFileId());
        }
    }
}

