/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.vo.OrganTreeInitVo;
import com.jxdinfo.hussar.authorization.organ.vo.UserTreeVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.dto.AddUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.CopyUserRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.EditUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryCopyRoleUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResetSecureUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.UserInfolVo;
import com.jxdinfo.hussar.authorization.permit.dto.UserPartialVo;
import com.jxdinfo.hussar.authorization.permit.dto.UserSecureDto;
import com.jxdinfo.hussar.authorization.permit.manager.AddUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.EditUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.ExportUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.QueryUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.RestUserSecureManager;
import com.jxdinfo.hussar.authorization.permit.manager.SortUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.impl.HussarBaseUserCustomExcelServiceImpl;
import com.jxdinfo.hussar.authorization.permit.model.UserExcel;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserService;
import com.jxdinfo.hussar.authorization.permit.vo.ResetSecureUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserMobileVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.UpdateInfoVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.excel.constants.ExcelConstants;
import com.jxdinfo.hussar.excel.model.ImportSheetMsg;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.service.IHussarBaseCustomExcelService;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.http.HussarHttpServletRequest;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.hussarBaseUserServiceImpl")
public class HussarBaseUserServiceImpl
implements IHussarBaseUserService {
    @Lazy
    @Autowired
    private QueryUserManager queryUserManager;
    @Autowired
    private RestUserSecureManager restUserSecureManager;
    @Autowired
    private AddUserManager addUserManager;
    @Autowired
    private EditUserManager editUserManager;
    @Autowired
    private DeleteUserManager deleteUserManager;
    @Autowired
    private SortUserManager sortUserManager;
    @Autowired
    @Lazy
    private QueryOrganizationManager queryOrganizationManager;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private ExportUserManager exportUserManager;
    @Autowired
    private HussarBaseUserCustomExcelServiceImpl hussarBaseCustomExcelService;
    @Resource
    private IHussarBaseExcelService hussarBaseExcelServiceImpl;
    @Autowired
    private OssService ossService;
    @Autowired
    private ISysExcelTaskService iSysExcelTaskService;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;

    public ApiResponse<Page<SearchUserVo>> searchUsers(PageInfo pageInfo, QueryUserDto queryUserDto) {
        return ApiResponse.success(this.queryUserManager.searchUsersAllowPinyin(pageInfo, queryUserDto));
    }

    public ApiResponse<List<UserTreeVo>> lazyLoadingUserTree(Long parentId, String organProperty) {
        return ApiResponse.success(this.queryUserManager.lazyLoadingUserTree(parentId, organProperty));
    }

    public ApiResponse<List<UserTreeVo>> getOrderUserTree(Long parentId) {
        return ApiResponse.success(this.queryUserManager.getOrderUserTree(parentId));
    }

    public ApiResponse<List<UserTreeVo>> backUserTree(Long id) {
        return ApiResponse.success(this.queryUserManager.backUserTree(id));
    }

    public ApiResponse<UserPartialVo> viewUser(Long id) {
        return ApiResponse.success((Object)this.queryUserManager.viewUser(id));
    }

    public ApiResponse<UserInfolVo> loadUser(Long id) {
        return ApiResponse.success((Object)this.queryUserManager.loadUser(id));
    }

    @HussarTransactional
    public ApiResponse<Long> addUser(AddUserDto addUserDto) {
        return this.addUserManager.addUser(addUserDto);
    }

    @HussarTransactional
    public ApiResponse<String> editUser(EditUserDto editUserDto) {
        return ApiResponse.success((String)this.editUserManager.editUser(editUserDto));
    }

    @HussarTransactional
    public ApiResponse<String> deleteUser(Long id) {
        return ApiResponse.success((String)this.deleteUserManager.deleteUser(id));
    }

    @HussarTransactional
    public ApiResponse<String> copyUserRole(CopyUserRoleDto copyRoleDto) {
        return ApiResponse.success((String)this.editUserManager.copyUserRole(copyRoleDto));
    }

    @HussarTransactional
    public ApiResponse<String> dormancyUser(Long id) {
        return ApiResponse.success((String)this.editUserManager.dormancyUser(id));
    }

    @HussarTransactional
    public ApiResponse<String> sortUser(List<Long> idList) {
        return ApiResponse.success((String)this.sortUserManager.sortUser(idList));
    }

    public ApiResponse<String> cancelUser(Long id) {
        return ApiResponse.success((String)this.editUserManager.cancelUser(id));
    }

    public ApiResponse<String> activateUser(Long id) {
        return ApiResponse.success((String)this.editUserManager.activateUser(id));
    }

    public ApiResponse<Page<SearchUserVo>> searchCopyRoleUsers(PageInfo pageInfo, QueryCopyRoleUserDto queryCopyRoleUserDto) {
        return ApiResponse.success(this.queryUserManager.searchCopyRoleUsers(pageInfo, queryCopyRoleUserDto));
    }

    public ApiResponse<Page<SearchUserVo>> unRelateStaffUserList(PageInfo pageInfo, QueryUserDto queryUserDto) {
        return ApiResponse.success(this.queryUserManager.unRelateStaffUserList(pageInfo, queryUserDto));
    }

    public ApiResponse<List<UserVo>> getUserByPostId(Long postId) {
        return ApiResponse.success(this.queryUserManager.getUserByPostId(postId));
    }

    public ApiResponse<Page<SearchUserVo>> postUserList(PageInfo pageInfo, String organTypeCode, List<Long> organIds, String userName, String userAccount) {
        return ApiResponse.success(this.queryUserManager.postUserList(pageInfo, organTypeCode, organIds, userName, userAccount));
    }

    public ApiResponse<Page<SearchUserVo>> getUserList(PageInfo pageInfo, String userName, String userAccount) {
        return ApiResponse.success(this.queryUserManager.getUserList(pageInfo, userName, userAccount));
    }

    public ApiResponse<Page<ResetSecureUserVo>> searchResetSecureUsers(PageInfo pageInfo, ResetSecureUserDto resetSecureUserDto) {
        return ApiResponse.success(this.queryUserManager.searchResetSecureUsers(pageInfo, resetSecureUserDto));
    }

    @HussarTransactional
    public ApiResponse<UpdateInfoVo> resetUserSecure(UserSecureDto userSecureDto) {
        return ApiResponse.success((Object)this.restUserSecureManager.resetUserSecure(userSecureDto));
    }

    public List<OrganTreeInitVo> getUserTreeInitVos(Long parentId, int ifLazy, Integer defaultLevel) {
        if (ifLazy != 0 && ifLazy != 1) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ENTER_TRUE_LAZY_PARAM.getMessage()));
        }
        int defaultLevelNum = 1;
        if (defaultLevel != null && defaultLevel > 0) {
            defaultLevelNum = defaultLevel;
        }
        if (ifLazy == 0) {
            defaultLevelNum = 0;
        }
        List<OrganTreeInitVo> organs = this.queryOrganizationManager.getOrgansByParentIdAndLevel(parentId, defaultLevelNum, false, true);
        ArrayList<Long> organIds = new ArrayList<Long>();
        for (OrganTreeInitVo organ : organs) {
            if (defaultLevelNum != 0) {
                if (organ.getChangedLevel() >= defaultLevelNum) continue;
                organIds.add((Long)organ.getId());
                continue;
            }
            organIds.add((Long)organ.getId());
        }
        List<Object> users = new ArrayList();
        if (organIds.size() != 0) {
            users = this.queryUserManager.getUsersByOrganIds(organIds);
        }
        if (parentId.equals(OrganConstants.ROOT_ORGAN_ID)) {
            OrganTreeInitVo firstOrgan = new OrganTreeInitVo();
            firstOrgan.setId((Serializable)OrganConstants.ROOT_ORGAN_ID);
            firstOrgan.setLabel(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SYSTEM_USER.getMessage()));
            firstOrgan.setParentId((Serializable)Long.valueOf(0L));
            firstOrgan.setStruLevel(0);
            firstOrgan.setChangedLevel(1);
            List<OrganTreeInitVo> organTreeInitVos = this.sysStruMapper.queryChildrenOrgan(parentId, false, false);
            if (organTreeInitVos != null) {
                firstOrgan.setHasChildren(Boolean.valueOf(true));
            }
            organs.add(firstOrgan);
        }
        organs.addAll(users);
        List<OrganTreeInitVo> organTree = this.queryOrganizationManager.getOrganTree(organs);
        return organTree;
    }

    public List<OrganTreeInitVo> getChildrenUsersByParentId(Long parentId) {
        List<OrganTreeInitVo> organs = this.queryOrganizationManager.getChildrenOrgan(parentId, false, true);
        List<OrganTreeInitVo> users = this.queryUserManager.getChildrenUsersByParentId(parentId);
        organs.addAll(users);
        return organs;
    }

    public ApiResponse<List<OrganTreeInitVo>> getUsersLikeName(String searchValue) {
        List<OrganTreeInitVo> users = this.queryUserManager.getUsersLikeName(searchValue);
        return ApiResponse.success(users);
    }

    public List<OrganTreeInitVo> getUpUserTreeByUserId(Long userId, Long parentId) {
        Integer defaultLevel = 0;
        Integer parentLevel = 0;
        if (!userId.equals(OrganConstants.ROOT_ORGAN_ID)) {
            parentLevel = this.queryOrganizationManager.getOrganLevelByOrganId(parentId);
            if (parentLevel != null) {
                defaultLevel = parentLevel + 1;
            } else {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ENTER_TRUE_PARAM.getMessage()));
            }
        }
        List<OrganTreeInitVo> parentLevelOrganUsersList = this.sysStruMapper.queryUpOrgansByFidAndLevelForUserTree("", defaultLevel, false, true);
        for (OrganTreeInitVo organ : parentLevelOrganUsersList) {
            organ.setChangedLevel(organ.getStruLevel() + 1);
        }
        OrganTreeInitVo firstOrgan = new OrganTreeInitVo();
        firstOrgan.setId((Serializable)OrganConstants.ROOT_ORGAN_ID);
        firstOrgan.setLabel(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SYSTEM_USER.getMessage()));
        firstOrgan.setParentId((Serializable)Long.valueOf(0L));
        firstOrgan.setStruLevel(0);
        firstOrgan.setChangedLevel(1);
        firstOrgan.setHasChildren(Boolean.valueOf(true));
        parentLevelOrganUsersList.add(firstOrgan);
        List<OrganTreeInitVo> users = this.queryUserManager.queryUpUsersByFidAndLevel("", parentLevel);
        parentLevelOrganUsersList.addAll(users);
        List<OrganTreeInitVo> brotherUsers = this.sysUsersMapper.queryBrotherUsersByParentId(parentId);
        List<OrganTreeInitVo> brotherOrgans = this.sysStruMapper.queryBrotherOrganForUserTree(parentId, false, true);
        ArrayList<OrganTreeInitVo> organsAndUsers = new ArrayList<OrganTreeInitVo>();
        organsAndUsers.addAll(parentLevelOrganUsersList);
        organsAndUsers.addAll(brotherOrgans);
        organsAndUsers.addAll(brotherUsers);
        return this.queryOrganizationManager.getOrganTree(organsAndUsers);
    }

    public ApiResponse<OrganTreeInitVo> getUserInfoByUserId(Long userId) {
        List<OrganTreeInitVo> users = this.queryUserManager.getUserInfoByUserId(userId);
        if (users.size() < 1) {
            return null;
        }
        OrganTreeInitVo user = users.get(0);
        String firstFId = user.getStruFid();
        String firstFName = user.getParentName();
        for (int i = 1; i < users.size(); ++i) {
            String fId = users.get(i).getStruFid();
            String fName = users.get(i).getParentName();
            firstFId = firstFId + "," + fId;
            firstFName = firstFName + "," + fName;
        }
        user.setStruFid(firstFId);
        user.setParentName(firstFName);
        return ApiResponse.success((Object)user);
    }

    public ApiResponse<List<OrganTreeInitVo>> getUsersByParentId(Long parentId) {
        String fid = "";
        if (!parentId.equals(OrganConstants.ROOT_ORGAN_ID)) {
            fid = this.sysStruMapper.getStruFidByOrganId(parentId);
        }
        List<OrganTreeInitVo> users = this.queryUserManager.getAllChildrenUsers(fid);
        return ApiResponse.success(users);
    }

    public ApiResponse<List<SearchUserMobileVo>> getUsersByStruId(Long struId) {
        List<SearchUserMobileVo> userList = this.queryUserManager.getUsersByStruId(struId);
        return ApiResponse.success(userList);
    }

    public ApiResponse<List<SearchUserMobileVo>> getUsersByUserIds(List<Long> userIds) {
        List<SearchUserMobileVo> userList = this.queryUserManager.getUsersByUserIds(userIds);
        return ApiResponse.success(userList);
    }

    public ApiResponse<List<UserVo>> getRoleUser(String roleId) {
        return ApiResponse.success(this.queryUserManager.getRoleUser(roleId));
    }

    public List<UserVo> getUsersByStruIds(List<Long> struIds) {
        return this.queryUserManager.getUsersByStruIds(struIds);
    }

    public void exportUserExcel(String ids, Long taskId, boolean exportKey) throws Exception {
        this.exportUserManager.exportUserExcel(ids, taskId, exportKey);
    }

    public void downloadUserExcelImpTpl(HttpServletResponse response, String fileKey) {
        this.hussarBaseExcelServiceImpl.downloadImportTpl(response, "\u7528\u6237\u4eba\u5458Excel\u5bfc\u5165\u6a21\u677f", fileKey);
    }

    @HussarTransactional
    public void importUserExcel(String scenario, Long taskId, String organProperty) {
        this.hussarBaseCustomExcelService.addOrganPropertyMap(taskId, organProperty);
        String connName = HussarContextHolder.getConnName();
        String tenantCode = HussarContextHolder.getHussarTenant().getTenantCode();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes newServletRequestAttributes = new ServletRequestAttributes((HttpServletRequest)new HussarHttpServletRequest(servletRequestAttributes.getRequest()));
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            RequestContextHolder.setRequestAttributes((RequestAttributes)newServletRequestAttributes);
            HussarContextHolder.setTenant((String)connName, (String)tenantCode);
            ImportSheetMsg importSheetMsg = new ImportSheetMsg(Integer.valueOf(0), UserExcel.class, (IHussarBaseCustomExcelService)this.hussarBaseCustomExcelService);
            LinkedList<ImportSheetMsg> importSheetMsgs = new LinkedList<ImportSheetMsg>();
            importSheetMsgs.add(importSheetMsg);
            this.hussarBaseExcelServiceImpl.importExcelSheets(importSheetMsgs, scenario, taskId, this.getExcludeColumnIndexesMap());
        });
    }

    public void checkUserExcel(MultipartFile userFile, String scenario, Long taskId, String organProperty) {
        InputStream input;
        try {
            input = userFile.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String fileName = userFile.getOriginalFilename();
        ApiResponse fileResponse = this.ossService.backgroundUpload(userFile);
        SysExcelTask task = new SysExcelTask();
        task.setId(taskId);
        task.setFileName(fileName);
        task.setCheckScenario(scenario);
        task.setTaskFile((Long)fileResponse.getData());
        this.iSysExcelTaskService.updateById((Object)task);
        this.hussarBaseCustomExcelService.addOrganPropertyMap(taskId, organProperty);
        Map<Integer, List<String>> selectParamMap = this.exportUserManager.getUserExcelOptions();
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            ImportSheetMsg importSheetMsg1 = new ImportSheetMsg(Integer.valueOf(0), UserExcel.class, (IHussarBaseCustomExcelService)this.hussarBaseCustomExcelService);
            LinkedList<ImportSheetMsg> importSheetMsgs = new LinkedList<ImportSheetMsg>();
            importSheetMsgs.add(importSheetMsg1);
            this.hussarBaseExcelServiceImpl.checkExcelSheets(input, importSheetMsgs, scenario, taskId, this.getExcludeColumnIndexesMap(), selectParamMap);
        });
    }

    private Map<String, Integer> getExcludeColumnIndexesMap() {
        HashMap<String, Integer> excludeColumnIndexesMap = new HashMap<String, Integer>();
        excludeColumnIndexesMap.put("\u4eba\u5458\u7f16\u7801", 16);
        excludeColumnIndexesMap.put("\u4e3b\u952e", 24);
        return excludeColumnIndexesMap;
    }

    static {
        ExcelConstants.TemplateMap.put("userImportTpl", "static/userImportTpl.xlsx");
        ExcelConstants.TemplateMap.put("userImportTplWithKey", "static/userImportTplWithKey.xlsx");
    }
}

