/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleDataRightMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleStruRightsMapper;
import com.jxdinfo.hussar.authorization.permit.manager.QueryDataRightManager;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceExpand;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceExpandService;
import com.jxdinfo.hussar.authorization.permit.vo.DataRightCacheVo;
import com.jxdinfo.hussar.authorization.permit.vo.DataScopeTypeVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datascope.core.support.extend.factory.DataConditionFactory;
import com.jxdinfo.hussar.support.datascope.core.support.extend.factory.DataRightFactory;
import com.jxdinfo.hussar.support.datascope.core.support.extend.factory.DataScopeFactory;
import com.jxdinfo.hussar.support.datascope.core.support.extend.service.DefaultAllVisibleDataScope;
import com.jxdinfo.hussar.support.datascope.core.support.extend.service.IDataConditionService;
import com.jxdinfo.hussar.support.datascope.core.support.extend.service.IDataRightService;
import com.jxdinfo.hussar.support.datascope.core.support.extend.service.IDataScopeService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.queryDataRightMagagerImpl")
public class QueryDataRightMagagerImpl
implements QueryDataRightManager {
    @Autowired
    private SysRoleDataRightMapper roleDataRightMapper;
    @Autowired
    private SysRoleStruRightsMapper roleStruRightsMapper;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private IHussarBaseResourceExpandService hussarBaseResourceExpandService;

    @Override
    public List<Long> getAbandonDataRight(List<Long> functionIdList, Long roleId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleDataRight::getRoleId, (Object)roleId);
        if (HussarUtils.isNotEmpty(functionIdList)) {
            queryWrapper.notIn(SysRoleDataRight::getFunctionId, functionIdList);
        }
        List sysRoleDataRightList = this.roleDataRightMapper.selectList((Wrapper)queryWrapper);
        return sysRoleDataRightList.stream().map(SysRoleDataRight::getDataRightsId).collect(Collectors.toList());
    }

    @Override
    public void replaceDataRightCache(Long roleId) {
        List<Long> deptIdList;
        List<DataRightCacheVo> dataRightCacheVoList = this.roleDataRightMapper.getDataRightRes(roleId);
        if (HussarUtils.isEmpty(dataRightCacheVoList)) {
            HussarCacheUtil.evict((String)"data_scope_type", (Object)("'data_scope_type:'" + roleId));
            return;
        }
        List dataRightIdList = dataRightCacheVoList.stream().map(DataRightCacheVo::getDataRightId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleStruRights::getRoleDataRightsId, dataRightIdList);
        List costumDeptList = this.roleStruRightsMapper.selectList((Wrapper)queryWrapper);
        HashMap<Long, ArrayList<Long>> dataRightsDeptMap = new HashMap<Long, ArrayList<Long>>();
        for (SysRoleStruRights sysRoleStruRights : costumDeptList) {
            deptIdList = (ArrayList<Long>)dataRightsDeptMap.get(sysRoleStruRights.getRoleDataRightsId());
            if (ToolUtil.isNotEmpty((Object)deptIdList)) {
                deptIdList.add(sysRoleStruRights.getStruid());
                continue;
            }
            deptIdList = new ArrayList<Long>();
            deptIdList.add(sysRoleStruRights.getStruid());
            dataRightsDeptMap.put(sysRoleStruRights.getRoleDataRightsId(), (ArrayList<Long>)deptIdList);
        }
        for (DataRightCacheVo dataRightCacheVo : dataRightCacheVoList) {
            deptIdList = (List)dataRightsDeptMap.get(dataRightCacheVo.getDataRightId());
            if (!ToolUtil.isNotEmpty(deptIdList)) continue;
            dataRightCacheVo.setDeptId(deptIdList);
        }
        HussarCacheUtil.put((String)"data_scope_type", (Object)("'data_scope_type:'" + roleId), dataRightCacheVoList);
    }

    @Override
    public void saveDataRightCacheByRoleIds(List<Long> roleIds) {
        List<DataRightCacheVo> dataRightCacheVoList;
        List resourceTypeCodes = DataRightFactory.getResourceTypeCodes();
        resourceTypeCodes.add("res_rights");
        if (HussarUtils.isEmpty(roleIds)) {
            dataRightCacheVoList = this.roleDataRightMapper.getAllDataRicht(resourceTypeCodes);
            if (HussarUtils.isEmpty(dataRightCacheVoList)) {
                return;
            }
        } else {
            dataRightCacheVoList = this.roleDataRightMapper.getDataRightResByRoleIdList(roleIds, resourceTypeCodes);
            if (HussarUtils.isEmpty(dataRightCacheVoList)) {
                for (Long roleId : roleIds) {
                    HussarCacheUtil.evict((String)"data_scope_type", (Object)("'data_scope_type:'" + roleId));
                }
                return;
            }
            List cacheRoleIds = dataRightCacheVoList.stream().map(DataRightCacheVo::getRoleId).distinct().collect(Collectors.toList());
            for (Long id : roleIds) {
                if (cacheRoleIds.contains(id)) continue;
                HussarCacheUtil.evict((String)"data_scope_type", (Object)("'data_scope_type:'" + id));
            }
        }
        HashMap<Long, ArrayList<DataRightCacheVo>> roleDataRightMap = new HashMap<Long, ArrayList<DataRightCacheVo>>();
        List dataRightIdList = dataRightCacheVoList.stream().map(DataRightCacheVo::getDataRightId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleStruRights::getRoleDataRightsId, dataRightIdList);
        List costumDeptList = this.roleStruRightsMapper.selectList((Wrapper)queryWrapper);
        HashMap<Long, Object> dataRightsDeptMap = new HashMap<Long, Object>();
        for (SysRoleStruRights item : costumDeptList) {
            ArrayList<Long> deptIdList = (ArrayList<Long>)dataRightsDeptMap.get(item.getRoleDataRightsId());
            if (ToolUtil.isNotEmpty((Object)deptIdList)) {
                deptIdList.add(item.getStruid());
                continue;
            }
            deptIdList = new ArrayList<Long>();
            deptIdList.add(item.getStruid());
            dataRightsDeptMap.put(item.getRoleDataRightsId(), deptIdList);
        }
        List resIds = dataRightCacheVoList.stream().filter(d -> HussarUtils.isEmpty((Object)d.getMapper())).map(DataRightCacheVo::getResourceId).distinct().collect(Collectors.toList());
        List resourceExpands = new ArrayList();
        if (HussarUtils.isNotEmpty(resIds)) {
            resourceExpands = this.hussarBaseResourceExpandService.list((Wrapper)new LambdaQueryWrapper().in(SysResourceExpand::getResourceId, resIds));
        }
        block3: for (DataRightCacheVo item : dataRightCacheVoList) {
            ArrayList<DataRightCacheVo> resultList;
            List deptIdList = (List)dataRightsDeptMap.get(item.getDataRightId());
            if (ToolUtil.isNotEmpty((Object)deptIdList)) {
                item.setDeptId(deptIdList);
            }
            if (ToolUtil.isNotEmpty((Object)(resultList = (ArrayList<DataRightCacheVo>)roleDataRightMap.get(item.getRoleId())))) {
                resultList.add(item);
            } else {
                resultList = new ArrayList<DataRightCacheVo>();
                resultList.add(item);
                roleDataRightMap.put(item.getRoleId(), resultList);
            }
            if (!HussarUtils.isEmpty((Object)item.getMapper())) continue;
            String mapperCode = DataRightFactory.getDataRight((String)item.getResTypeCode()).mapperCode();
            for (SysResourceExpand resourceExpand : resourceExpands) {
                if (!HussarUtils.equals((Object)resourceExpand.getResourceId(), (Object)item.getResourceId()) || !HussarUtils.equals((Object)resourceExpand.getResourceTypeExpandCode(), (Object)mapperCode)) continue;
                item.setMapper(resourceExpand.getResourceTypeExpandValue());
                continue block3;
            }
        }
        Set keySey = roleDataRightMap.keySet();
        for (Long roleid : keySey) {
            HussarCacheUtil.put((String)"data_scope_type", (Object)("'data_scope_type:'" + roleid), roleDataRightMap.get(roleid));
        }
    }

    @Override
    @HussarDs(value="#connName")
    public void saveDataRightCacheByRoleIds(String connName, List<Long> roleIds) {
        this.saveDataRightCacheByRoleIds(roleIds);
    }

    @Override
    public List<DataScopeTypeVo> getScopeTypeList(String resTypeCode) {
        ArrayList<DataScopeTypeVo> result = new ArrayList<DataScopeTypeVo>();
        if (HussarUtils.equals((Object)"res_rights", (Object)resTypeCode)) {
            List dicVos = this.sysDicRefService.getDicListByType("data_scope_type");
            for (DicVo dicVo : dicVos) {
                DataScopeTypeVo scopeTypeVo = new DataScopeTypeVo();
                scopeTypeVo.setScopeLabel(dicVo.getValue());
                scopeTypeVo.setScopeName(dicVo.getLabel());
                scopeTypeVo.setDefault(Boolean.valueOf(HussarUtils.equals((Object)"1", (Object)dicVo.getValue())));
                result.add(scopeTypeVo);
            }
        } else {
            List scopeLabels;
            IDataRightService dataRightService = DataRightFactory.getDataRight((String)resTypeCode);
            boolean flag = dataRightService.needDefaultAllVisibleScope();
            if (flag) {
                DefaultAllVisibleDataScope defaultAllVisibleDataScope = new DefaultAllVisibleDataScope();
                DataScopeTypeVo scopeTypeVo = new DataScopeTypeVo();
                scopeTypeVo.setScopeLabel(defaultAllVisibleDataScope.label());
                scopeTypeVo.setScopeName(defaultAllVisibleDataScope.name());
                scopeTypeVo.setScopeDesc(defaultAllVisibleDataScope.desc());
                scopeTypeVo.setDefault(Boolean.valueOf(true));
                result.add(scopeTypeVo);
            }
            if (HussarUtils.isEmpty((Object)(scopeLabels = dataRightService.dataScopeLabels()))) {
                return result;
            }
            List dataScopeServices = DataScopeFactory.getDataScopes((List)scopeLabels);
            for (IDataScopeService dataScopeService : dataScopeServices) {
                DataScopeTypeVo scopeTypeVo = new DataScopeTypeVo();
                scopeTypeVo.setScopeLabel(dataScopeService.label());
                scopeTypeVo.setScopeName(dataScopeService.name());
                scopeTypeVo.setScopeDesc(dataScopeService.desc());
                List dataConditions = DataConditionFactory.getDataConditions((List)dataScopeService.conditionExpression());
                for (IDataConditionService conditionService : dataConditions) {
                    if (!conditionService.isCustomValue()) continue;
                    scopeTypeVo.setHasCondition(Boolean.valueOf(true));
                    break;
                }
                result.add(scopeTypeVo);
            }
            if (!flag) {
                ((DataScopeTypeVo)result.get(0)).setDefault(Boolean.valueOf(true));
            }
        }
        return result;
    }
}

