/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.AppRoleDto;
import com.jxdinfo.hussar.authorization.permit.manager.EditRoleManager;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.editRoleManagerImpl")
public class EditRoleManagerImpl
implements EditRoleManager {
    @Resource
    private SysRolesMapper sysRolesMapper;

    @Override
    @HussarTransactional
    public Boolean editAppRole(AppRoleDto appRoleDto) {
        if (ToolUtil.isEmpty((Object)appRoleDto)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_INFO_EMPTY.getMessage()));
        }
        Long appId = appRoleDto.getAppId();
        SysRoles sysRole = new SysRoles();
        try {
            this.validateParam(appRoleDto);
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage());
        }
        BeanUtils.copyProperties((Object)appRoleDto, (Object)sysRole);
        sysRole.setAppId(Long.valueOf(1L));
        sysRole.setFromAppId(appId);
        this.sysRolesMapper.updateById(sysRole);
        return Boolean.TRUE;
    }

    private void validateParam(AppRoleDto appRoleDto) {
        StringBuffer sBuffer = new StringBuffer();
        if (StringUtils.isBlank((CharSequence)appRoleDto.getRoleName())) {
            sBuffer.append(",");
            sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_NAME_NOT_NULL.getMessage()));
        }
        if (StringUtils.isNotBlank((CharSequence)appRoleDto.getRoleName()) && 32 < appRoleDto.getRoleName().length()) {
            sBuffer.append(",");
            sBuffer.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ROLE_NAME_MAX_LENGTH.getMessage()));
        }
        if (0 < sBuffer.length()) {
            String rspStr = sBuffer.substring(1);
            throw new BaseException(rspStr);
        }
    }
}

