/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganTypeBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTypeBo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.organ.service.impl.hussarBaseOrganTypeBoServiceImpl")
public class HussarBaseOrganTypeBoServiceImpl
implements IHussarBaseOrganTypeBoService {
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;

    public OrganizationTypeBo findOrganizationTypeByOrganType(String organType) {
        AssertUtil.isNotEmpty((String)organType, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_PARAM.getMessage()));
        OrganizationTypeBo typeBo = this.sysOrganTypeMapper.getOrganizationTypeByOrganType(organType);
        return typeBo;
    }

    public OrganizationTypeBo findOrganizationTypeByTypeName(String typeName) {
        AssertUtil.isNotEmpty((String)typeName, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_PARAM.getMessage()));
        OrganizationTypeBo typeBo = this.sysOrganTypeMapper.getOrganizationTypeByTypeName(typeName);
        return typeBo;
    }

    public List<OrganizationTypeBo> getAllOrganType() {
        List<OrganizationTypeBo> allOrganType = this.sysOrganTypeMapper.getAllOrganType();
        allOrganType.sort(Comparator.comparingLong(type -> Long.parseLong(type.getOrganType())));
        return allOrganType;
    }
}

