/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.dto.EditStaffDto;
import com.jxdinfo.hussar.authorization.organ.dto.StaffDto;
import com.jxdinfo.hussar.authorization.organ.manager.EditStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonStaffManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.editStaffManagerImpl")
public class EditStaffManagerImpl
extends CommonStaffManager
implements EditStaffManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditStaffManagerImpl.class);
    @Autowired
    private IConvertPinyinService convertPinyinService;

    @Override
    public String editStaff(EditStaffDto editStaffDto) {
        String validateMsg = this.validateService.validate((Object)editStaffDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        SysStru sysStru = new SysStru();
        SysOrgan sysOrgan = new SysOrgan();
        SysStaff sysStaff = new SysStaff();
        this.initialization(editStaffDto, sysStru, sysOrgan, sysStaff);
        this.parentOrganizationAuditDataExists(sysStru.getParentId());
        if (!this.sysStruAuditService.checkCanOperate(sysStru.getId())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.PROHIBIT_UPDATE.getMessage()));
        }
        String assistIds = editStaffDto.getAssistIds();
        String result = this.processAuditIfNecessary(sysStru, sysOrgan, sysStaff, assistIds);
        return result;
    }

    private String processAuditIfNecessary(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String assistIds) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_AUDIT_CONSTANT_2.getMessage()));
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            return this.doEditStaffAuditData(sysStru, sysOrgan, sysStaff, assistIds);
        }
        return this.doEditStaffData(sysStru, sysOrgan, sysStaff, assistIds);
    }

    private String doEditStaffAuditData(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String assistIds) {
        this.auditAdd(sysOrgan, sysStru, sysStaff, "2");
        this.sysStruAssistOrganAuditService.saveAssistOrganAudit(assistIds, sysStru.getId());
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_SUCCESS_WAIT_REVIEW.getMessage());
    }

    private String doEditStaffData(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String assistIds) {
        this.sysOrganMapper.updateById(sysOrgan);
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        this.sysStruMapper.updateById(sysStru);
        this.sysUsersService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysUsers::getEmployeeId, (Object)sysStru.getId())).set(SysUsers::getUserName, (Object)sysOrgan.getOrganName()));
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            sysStaff.setName(sysOrgan.getOrganName());
            this.sysStaffService.saveOrUpdate((Object)sysStaff);
        }
        Long sysStruId = sysStru.getId();
        this.sysStruAssistOrganService.saveAssistOrgan(assistIds, sysStruId);
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage());
    }

    private void initialization(EditStaffDto editStaffDto, SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ACCORDING_PARAM_INITIALIZE.getMessage()), (Object)JSON.toJSONString((Object)editStaffDto));
        Long id = editStaffDto.getId();
        String staffName = StringUtils.trimToEmpty((String)editStaffDto.getStaffName());
        String staffPosition = editStaffDto.getStaffPosition();
        String sex = editStaffDto.getSex();
        String birthday = editStaffDto.getBirthday();
        String idcard = editStaffDto.getIdcard();
        String address = editStaffDto.getAddress();
        String workId = editStaffDto.getWorkId();
        String workDate = editStaffDto.getWorkDate();
        String graduateDate = editStaffDto.getGraduateDate();
        String graduateSchool = editStaffDto.getGraduateSchool();
        SysStru sysStruT = (SysStru)this.sysStruMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysStruT, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NO_ORG_STRU.getMessage()));
        SysOrgan sysOrganT = (SysOrgan)this.sysOrganMapper.selectById(sysStruT.getOrganId());
        String currentFname = sysOrganT.getOrganFname();
        String newFname = currentFname.substring(0, currentFname.lastIndexOf("/")) + "/" + staffName;
        SysStaff sysStaffT = (SysStaff)this.sysStaffMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getStruId, (Object)id));
        BeanUtils.copyProperties((Object)sysOrganT, (Object)sysOrgan);
        BeanUtils.copyProperties((Object)sysStruT, (Object)sysStru);
        BeanUtils.copyProperties((Object)sysStaffT, (Object)sysStaff);
        sysStru.setOrganAlias(staffName);
        sysStru.setStaffPosition(staffPosition);
        sysOrgan.setOrganName(staffName);
        sysOrgan.setOrganFname(sysOrgan.getOrganFname().replaceFirst(currentFname, newFname));
        sysStaff.setSex(sex);
        sysStaff.setName(staffName);
        sysStaff.setBirthday(birthday);
        sysStaff.setIdcard(idcard);
        sysStaff.setWorkId(workId);
        sysStaff.setAddress(address);
        sysStaff.setGraduateSchool(graduateSchool);
        sysStaff.setGraduateDate(graduateDate);
        sysStaff.setWorkDate(workDate);
    }

    @Override
    public String edit(StaffDto staffDto) {
        StringBuilder stringBuilder = new StringBuilder("");
        SysStaff oldStaff = (SysStaff)this.sysStaffService.getOne((Wrapper)new LambdaUpdateWrapper().eq(SysStaff::getId, (Object)staffDto.getId()));
        if (HussarUtils.isNotEmpty((Object)oldStaff)) {
            SysUsers user;
            SysStaff staff = new SysStaff();
            BeanUtil.copy((Object)staffDto, (Object)staff);
            staff.setStaffOrder(oldStaff.getStaffOrder());
            boolean flag = this.compareStaff(staff, oldStaff);
            if (this.createUserConfigService.isOperateStaffWithUser()) {
                if (!flag) {
                    this.sysStaffService.updateById((Object)staff);
                }
                List<Long> delStruIds = this.dealSaveOrUpdate(staffDto);
                this.staffChangeNotify.notify(DataChangeType.UPDATE, new Object[]{staff});
                this.syncUser(staffDto, delStruIds);
                stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage()));
                return stringBuilder.toString();
            }
            if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isStaffAudit()) {
                if (!flag) {
                    SysStaffAudit sysStaffAudit1 = (SysStaffAudit)this.sysStaffAuditService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStaffAudit::getRealStaffId, (Object)staff.getId())).eq(SysStaffAudit::getAuditStatus, (Object)"0"));
                    if (HussarUtils.isNotEmpty((Object)sysStaffAudit1)) {
                        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_FAIL_EXIST_REVIEW.getMessage()));
                    }
                    SysStaffAudit sysStaffAudit = new SysStaffAudit();
                    BeanUtil.copy((Object)staff, (Object)sysStaffAudit);
                    long sysStaffAuditId = IdWorker.getId((Object)sysStaffAudit);
                    sysStaffAudit.setId(Long.valueOf(sysStaffAuditId));
                    sysStaffAudit.setRealStaffId(staff.getId());
                    sysStaffAudit.setAuditStatus("0");
                    sysStaffAudit.setOperateType("2");
                    LocalDateTime now = LocalDateTime.now();
                    sysStaffAudit.setCreateTime(now);
                    sysStaffAudit.setLastTime(now);
                    this.sysStaffAuditService.save((Object)sysStaffAudit);
                }
                this.dealSaveOrUpdate(staffDto);
                this.staffChangeNotify.notify(DataChangeType.UPDATE, new Object[]{oldStaff});
                if (flag) {
                    stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage()));
                } else {
                    stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_SUCCESS_WAIT_REVIEW.getMessage()));
                }
                return stringBuilder.toString();
            }
            if (!flag) {
                user = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)staffDto.getId())).ne(SysUsers::getAccountStatus, (Object)"2"));
                if (HussarUtils.isNotEmpty((Object)user)) {
                    this.sysUsersService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysUsers::getId, (Object)user.getId())).set(SysUsers::getUserName, (Object)staffDto.getName()));
                }
                this.sysStaffService.updateById((Object)staff);
            }
            this.dealSaveOrUpdate(staffDto);
            stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage()));
            this.sysUsersAuditService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysUsersAudit::getEmployeeId, (Object)staff.getId())).set(SysUsersAudit::getUserName, (Object)staffDto.getName()));
            this.staffChangeNotify.notify(DataChangeType.UPDATE, new Object[]{staff});
            user = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)staffDto.getId())).ne(SysUsers::getAccountStatus, (Object)"2"));
            this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{user});
            return stringBuilder.toString();
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL.getMessage()));
    }

    private void syncUser(StaffDto staffDto, List<Long> delStruIds) {
        SysUsers user = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)staffDto.getId())).ne(SysUsers::getAccountStatus, (Object)"2"));
        if (HussarUtils.isEmpty((Object)user)) {
            return;
        }
        String struIds = StringUtils.trimToEmpty((String)staffDto.getOrganId());
        AssertUtil.isNotEmpty((String)struIds, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_STAFF_NO_CONNECT_ORGAN.getMessage()));
        List<String> struIdList = Arrays.asList(struIds.split(","));
        Long[] temp = (Long[])ConvertUtils.convert((String[])struIds.split(","), Long.class);
        ArrayList<Long> currentStaffOrganIds = new ArrayList<Long>(Arrays.asList(temp));
        this.sysUsersService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysUsers::getId, (Object)user.getId())).set(SysUsers::getUserName, (Object)staffDto.getName())).set(SysUsers::getUserNamePinyinFull, (Object)this.convertPinyinService.getNameFullPinyin(staffDto.getName()))).set(SysUsers::getUserNamePinyinInitial, (Object)this.convertPinyinService.getNameInitialsPinyin(staffDto.getName())));
        List struUsers = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)user.getId())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        List oldUserOrganIds = struUsers.stream().map(SysStruUser::getStruId).distinct().collect(Collectors.toList());
        List addOrganIds = currentStaffOrganIds.stream().filter(item -> !oldUserOrganIds.contains(item)).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(addOrganIds)) {
            ArrayList<SysStruUser> struUserList = new ArrayList<SysStruUser>();
            for (Long struId : addOrganIds) {
                SysStruUser struUser = new SysStruUser();
                struUser.setStruId(struId);
                struUser.setUserId(user.getId());
                struUserList.add(struUser);
            }
            this.sysStruUserService.saveBatch(struUserList, struUserList.size());
        }
        if (HussarUtils.isNotEmpty(delStruIds)) {
            List newDelOrganIds = delStruIds.stream().filter(oldUserOrganIds::contains).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(newDelOrganIds)) {
                this.sysStruUserService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)user.getId())).in(SysStruUser::getStruId, newDelOrganIds));
                this.sysUsersService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(SysUsers::getDepartmentId, (Object)struIdList.get(0))).eq(SysUsers::getId, (Object)user.getId()));
            }
        }
    }

    private boolean compareStaff(SysStaff newStaff, SysStaff oldStaff) {
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getName()), (Object)StringUtils.trimToEmpty((String)oldStaff.getName()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getSex()), (Object)StringUtils.trimToEmpty((String)oldStaff.getSex()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getStaffCode()), (Object)StringUtils.trimToEmpty((String)oldStaff.getStaffCode()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getStaffPosition()), (Object)StringUtils.trimToEmpty((String)oldStaff.getStaffPosition()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getAddress()), (Object)StringUtils.trimToEmpty((String)oldStaff.getAddress()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getBirthday()), (Object)StringUtils.trimToEmpty((String)oldStaff.getBirthday()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getGraduateDate()), (Object)StringUtils.trimToEmpty((String)oldStaff.getGraduateDate()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getGraduateSchool()), (Object)StringUtils.trimToEmpty((String)oldStaff.getGraduateSchool()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getIdcard()), (Object)StringUtils.trimToEmpty((String)oldStaff.getIdcard()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getWorkDate()), (Object)StringUtils.trimToEmpty((String)oldStaff.getWorkDate()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getWorkId()), (Object)StringUtils.trimToEmpty((String)oldStaff.getWorkId()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newStaff.getRemark()), (Object)StringUtils.trimToEmpty((String)oldStaff.getRemark()))) {
            return false;
        }
        return HussarUtils.equals((Object)newStaff.getStaffOrder(), (Object)oldStaff.getStaffOrder());
    }
}

