/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.authorization.organ.enums.ExcelOrganEnum;
import com.jxdinfo.hussar.authorization.organ.enums.ExcelOrganLimitTypeEnum;
import com.jxdinfo.hussar.authorization.organ.manager.CheckExcelOrganManager;
import com.jxdinfo.hussar.authorization.organ.model.OrganExcel;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.vo.OrganExcelCheckResult;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.excel.model.ExcelCheckResult;
import com.jxdinfo.hussar.excel.model.ExcelImportMsg;
import com.jxdinfo.hussar.excel.validate.HussarBaseExcelValidateHelper;
import com.jxdinfo.hussar.general.dict.service.ISysDicService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.checkExcelOrganManagerImpl")
public class CheckExcelOrganManagerImpl
implements CheckExcelOrganManager {
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Resource
    private SysStruRuleMapper sysStruRuleMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private ISysDicService sysDicService;

    @Override
    public ExcelCheckResult check(List<OrganExcel> datas, Long taskId, List<Object> otherParams) {
        ArrayList<OrganExcel> rootDataList = new ArrayList<OrganExcel>(datas);
        ArrayList<OrganExcel> successDataList = new ArrayList<OrganExcel>();
        ArrayList<ExcelImportMsg<OrganExcel>> newDataList = new ArrayList<ExcelImportMsg<OrganExcel>>();
        ArrayList<ExcelImportMsg<OrganExcel>> updateDataList = new ArrayList<ExcelImportMsg<OrganExcel>>();
        ArrayList<ExcelImportMsg<OrganExcel>> existDataList = new ArrayList<ExcelImportMsg<OrganExcel>>();
        ArrayList<ExcelImportMsg<OrganExcel>> errorDataList = new ArrayList<ExcelImportMsg<OrganExcel>>();
        OrganExcelCheckResult organExcelCheckResult = new OrganExcelCheckResult();
        HashMap<String, SysOrganType> typeNameAndOrganMap = new HashMap<String, SysOrganType>();
        HashMap<String, String> organTypeAndNameMap = new HashMap<String, String>();
        this.getAllOrganType(typeNameAndOrganMap, organTypeAndNameMap);
        Map<String, List<String>> typeNameAndParentTypeListMap = this.getAllSubOrganType(organTypeAndNameMap);
        HashMap<String, Long> organCodeNumMap = new HashMap<String, Long>();
        HashMap<String, Long> organIdNumMap = new HashMap<String, Long>();
        LinkedHashMap<Integer, OrganExcel> inData = new LinkedHashMap<Integer, OrganExcel>();
        LinkedHashMap<Integer, OrganExcel> outData = new LinkedHashMap<Integer, OrganExcel>();
        this.getInOutExcelData(datas, inData, outData, organCodeNumMap, organIdNumMap);
        List users = this.sysUsersMapper.selectList((Wrapper)new LambdaQueryWrapper().ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode()));
        Map<String, SysUsers> userMap = users.stream().collect(Collectors.toMap(SysUsers::getUserAccount, Function.identity()));
        this.checkDataInExcel(inData, errorDataList, organCodeNumMap, typeNameAndOrganMap, typeNameAndParentTypeListMap, userMap, organIdNumMap);
        this.checkDataInExcel(outData, errorDataList, organCodeNumMap, typeNameAndOrganMap, typeNameAndParentTypeListMap, userMap, organIdNumMap);
        if (HussarUtils.isNotEmpty(errorDataList)) {
            organExcelCheckResult.setRootNum(datas.size());
            organExcelCheckResult.setErrorNum(errorDataList.size());
            ExcelCheckResult excelCheckResult = new ExcelCheckResult(rootDataList, successDataList, errorDataList, newDataList, updateDataList, existDataList);
            excelCheckResult.setCheckMsg((Object)organExcelCheckResult);
            return excelCheckResult;
        }
        ArrayList<String> organCodeDbList = new ArrayList<String>();
        HashMap<String, OrganExcel> organDbInMap = new HashMap<String, OrganExcel>();
        HashMap<String, OrganExcel> organDbOutMap = new HashMap<String, OrganExcel>();
        ArrayList<Long> organIdDbList = new ArrayList<Long>();
        this.getInOutDbData(organDbInMap, organDbOutMap, organCodeDbList, organIdDbList);
        this.checkDataInDb(inData, successDataList, newDataList, updateDataList, existDataList, errorDataList, typeNameAndParentTypeListMap, organDbInMap, organCodeDbList, userMap, organIdDbList);
        this.checkDataInDb(outData, successDataList, newDataList, updateDataList, existDataList, errorDataList, typeNameAndParentTypeListMap, organDbOutMap, organCodeDbList, userMap, organIdDbList);
        organExcelCheckResult.setRootNum(datas.size());
        organExcelCheckResult.setErrorNum(errorDataList.size());
        organExcelCheckResult.setNewNum(newDataList.size());
        organExcelCheckResult.setUpdateNum(updateDataList.size());
        organExcelCheckResult.setExistNum(existDataList.size());
        ExcelCheckResult excelCheckResult = new ExcelCheckResult(rootDataList, successDataList, errorDataList, newDataList, updateDataList, existDataList);
        excelCheckResult.setCheckMsg((Object)organExcelCheckResult);
        return excelCheckResult;
    }

    private void getInOutDbData(Map<String, OrganExcel> organDbInMap, Map<String, OrganExcel> organDbOutMap, List<String> organCodeDbList, List<Long> organIdDbList) {
        List<OrganExcel> organExcelDbList = this.sysStruMapper.getOrganExcelByStruIds(null, null);
        if (HussarUtils.isNotEmpty(organExcelDbList)) {
            for (OrganExcel organExcel : organExcelDbList) {
                String organFName = organExcel.getOrganFName();
                String organProperty = organExcel.getOrganProperty();
                if (HussarUtils.equals((Object)organProperty, (Object)ExcelOrganEnum.ORGAN_IN.getValue()) || HussarUtils.isBlank((CharSequence)organProperty)) {
                    organDbInMap.put(organFName, organExcel);
                }
                if (HussarUtils.equals((Object)organProperty, (Object)ExcelOrganEnum.ORGAN_OUT.getValue())) {
                    organDbOutMap.put(organFName, organExcel);
                }
                organCodeDbList.add(organExcel.getOrganCode());
                organIdDbList.add(Long.parseLong(organExcel.getStruId()));
            }
        }
    }

    private void getInOutExcelData(List<OrganExcel> datas, Map<Integer, OrganExcel> inData, Map<Integer, OrganExcel> outData, Map<String, Long> organCodeNumMap, Map<String, Long> organIdNumMap) {
        for (int i = 0; i < datas.size(); ++i) {
            Long num;
            OrganExcel organExcel = datas.get(i);
            String organCode = organExcel.getOrganCode();
            String organProperty = organExcel.getOrganProperty();
            String struId = organExcel.getStruId();
            if (HussarUtils.equals((Object)organProperty, (Object)ExcelOrganEnum.ORGAN_IN.getValue()) || HussarUtils.isBlank((CharSequence)organProperty)) {
                inData.put(i, organExcel);
            }
            if (HussarUtils.equals((Object)organProperty, (Object)ExcelOrganEnum.ORGAN_OUT.getValue())) {
                outData.put(i, organExcel);
            }
            if (HussarUtils.isNotEmpty((Object)organCode)) {
                num = organCodeNumMap.get(organCode);
                if (HussarUtils.isEmpty((Object)num)) {
                    organCodeNumMap.put(organCode, 1L);
                } else {
                    organCodeNumMap.put(organCode, num + 1L);
                }
            }
            if (!HussarUtils.isNotEmpty((Object)struId)) continue;
            num = organIdNumMap.get(struId);
            if (HussarUtils.isEmpty((Object)num)) {
                organIdNumMap.put(struId, 1L);
                continue;
            }
            organIdNumMap.put(struId, num + 1L);
        }
    }

    private void getAllOrganType(Map<String, SysOrganType> typeNameAndOrganMap, Map<String, String> organTypeAndNameMap) {
        List organTypeList = this.sysOrganTypeMapper.selectList(null);
        if (HussarUtils.isNotEmpty((Object)organTypeList)) {
            for (SysOrganType sysOrganType : organTypeList) {
                String organTypeName = sysOrganType.getTypeName();
                String organType = sysOrganType.getOrganType();
                typeNameAndOrganMap.put(organTypeName, sysOrganType);
                organTypeAndNameMap.put(organType, organTypeName);
            }
        }
    }

    private Map<String, List<String>> getAllSubOrganType(Map<String, String> organTypeAndNameMap) {
        List struRuleList;
        HashMap<String, List<String>> typeNameAndParentTypeListMap = new HashMap<String, List<String>>();
        if (HussarUtils.isNotEmpty(organTypeAndNameMap) && HussarUtils.isNotEmpty((Object)(struRuleList = this.sysStruRuleMapper.selectList(null)))) {
            for (SysStruRule struRule : struRuleList) {
                String organType = struRule.getOrganType();
                String parentType = struRule.getSysOrganType();
                String typeName = organTypeAndNameMap.get(organType);
                String parentTypeName = organTypeAndNameMap.get(parentType);
                List sysOrganTypes = (List)typeNameAndParentTypeListMap.get(typeName);
                if (HussarUtils.isEmpty((Object)sysOrganTypes)) {
                    ArrayList<String> parentOrganTypeList = new ArrayList<String>();
                    parentOrganTypeList.add(parentTypeName);
                    typeNameAndParentTypeListMap.put(typeName, parentOrganTypeList);
                    continue;
                }
                sysOrganTypes.add(parentTypeName);
            }
        }
        return typeNameAndParentTypeListMap;
    }

    private void checkDataInExcel(Map<Integer, OrganExcel> dataMap, List<ExcelImportMsg<OrganExcel>> errorDataList, Map<String, Long> organCodeNumMap, Map<String, SysOrganType> typeNameAndOrganMap, Map<String, List<String>> typeNameAndParentTypeListMap, Map<String, SysUsers> userMap, Map<String, Long> organIdNumMap) {
        List<OrganExcel> datas = dataMap.values().stream().collect(Collectors.toList());
        HashMap<String, OrganExcel> fullNameAndOrganMapInExcel = new HashMap<String, OrganExcel>();
        HashMap<String, Long> fullOrganNameMap = new HashMap<String, Long>();
        this.initDataInExcel(datas, fullNameAndOrganMapInExcel, fullOrganNameMap);
        for (Map.Entry<Integer, OrganExcel> entry : dataMap.entrySet()) {
            Integer i = entry.getKey();
            OrganExcel organExcel = entry.getValue();
            Map cellErrColMap = HussarBaseExcelValidateHelper.validateEntity((Object)organExcel, (Integer)i);
            this.checkExcelForNotNull(i, organExcel, cellErrColMap);
            this.checkExcelForOrganCode(i, organExcel, cellErrColMap, organCodeNumMap);
            this.checkExcelForOrganName(fullOrganNameMap, i, organExcel, cellErrColMap);
            this.checkExcelForOrganBasicInfo(i, organExcel, cellErrColMap);
            this.checkExcelForOrganType(fullNameAndOrganMapInExcel, typeNameAndOrganMap, typeNameAndParentTypeListMap, i, organExcel, cellErrColMap);
            this.checkExcelForParentOrgan(i, organExcel, cellErrColMap);
            this.checkExcelForUserAccount(i, organExcel, userMap, cellErrColMap);
            this.checkExcelForStruOrder(i, organExcel, cellErrColMap);
            this.sysDicService.checkExcelPrimaryKey(i, organExcel.getStruId(), Integer.valueOf(12), cellErrColMap, "organ");
            this.checkExcelForOrganId(i, organExcel, cellErrColMap, organIdNumMap);
            if (!HussarUtils.isNotEmpty((Object)cellErrColMap)) continue;
            errorDataList.add((ExcelImportMsg<OrganExcel>)new ExcelImportMsg((Object)organExcel, cellErrColMap));
        }
    }

    private void checkExcelForOrganBasicInfo(Integer i, OrganExcel organExcel, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String shortName = organExcel.getShortName();
        String organAlias = organExcel.getOrganAlias();
        String officeAlias = organExcel.getOfficeAlias();
        String officeAddress = organExcel.getOfficeAddress();
        if (HussarUtils.isNotEmpty((Object)shortName) && shortName.length() > 64) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)4, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_SHORT_NAME_CHECK.getMessage()), cellErrColMap);
        }
        if (HussarUtils.isNotEmpty((Object)organAlias) && organAlias.length() > 64) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)5, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_ALIAS_CHECK.getMessage()), cellErrColMap);
        }
        if (HussarUtils.isNotEmpty((Object)officeAlias) && officeAlias.length() > 64) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)6, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_OFFICE_ALIAS_CHECK.getMessage()), cellErrColMap);
        }
        if (HussarUtils.isNotEmpty((Object)officeAddress) && officeAddress.length() > 64) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)7, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_OFFICE_ADDRESS_CHECK.getMessage()), cellErrColMap);
        }
    }

    private void checkExcelForStruOrder(Integer i, OrganExcel organExcel, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String struOrder = organExcel.getStruOrder();
        if (HussarUtils.isNotBlank((CharSequence)struOrder)) {
            String regex = "^[0-9]*$";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(struOrder);
            if (!matcher.matches()) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)11, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SORT_MUST_NUMBER.getMessage()), cellErrColMap);
            }
            if (!this.isInIntegerRange(struOrder)) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)11, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SORT_RANGE_OUT.getMessage()), cellErrColMap);
            }
        }
    }

    private boolean isInIntegerRange(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void checkExcelForUserAccount(Integer i, OrganExcel organExcel, Map<String, SysUsers> userMap, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String userAccount = organExcel.getUserAccount();
        if (HussarUtils.isNotEmpty((Object)userAccount) && !userMap.containsKey(userAccount)) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)8, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PRINCIPAL_USER_NOT_EXIST.getMessage()), cellErrColMap);
        }
    }

    private void initDataInExcel(List<OrganExcel> data, Map<String, OrganExcel> fullNameAndOrganMapInExcel, Map<String, Long> fullOrganNameMap) {
        for (OrganExcel organExcel : data) {
            String organName = organExcel.getOrganName();
            String parentOrganNames = HussarUtils.isBlank((CharSequence)organExcel.getParentOrganNames()) ? "" : organExcel.getParentOrganNames();
            String fullOrganName = parentOrganNames + "/" + organName;
            Long nameNum = fullOrganNameMap.get(fullOrganName);
            nameNum = HussarUtils.isEmpty((Object)nameNum) ? 1L : nameNum + 1L;
            fullOrganNameMap.put(fullOrganName, nameNum);
            fullNameAndOrganMapInExcel.put(fullOrganName, organExcel);
        }
    }

    private void checkExcelForNotNull(int i, OrganExcel organExcel, Map<Integer, Map<Integer, String>> cellErrColMap) {
        if (HussarUtils.isEmpty((Object)organExcel.getOrganName())) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_NAME_EMPTY.getMessage()), cellErrColMap);
        }
        if (HussarUtils.isEmpty((Object)organExcel.getOrganTypeName())) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_VALID_NOTBLANK_STRUTYPE.getMessage()), cellErrColMap);
        }
    }

    private void checkExcelForOrganCode(int i, OrganExcel organExcel, Map<Integer, Map<Integer, String>> cellErrColMap, Map<String, Long> organCodeNumMap) {
        String organCode = organExcel.getOrganCode();
        if (HussarUtils.isNotEmpty((Object)organExcel.getOrganCode())) {
            if (HussarUtils.isNotEmpty((Object)organCode) && (organCode.length() > 32 || organCode.contains("/"))) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_CODE_OUTSIDE_CHECK.getMessage()), cellErrColMap);
            }
            if (organCodeNumMap.get(organCode) > 1L) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGANIZATION_CODE_DUPLICATION.getMessage()), cellErrColMap);
            }
        }
    }

    private void checkExcelForOrganId(int i, OrganExcel organExcel, Map<Integer, Map<Integer, String>> cellErrColMap, Map<String, Long> organIdNumMap) {
        String struId = organExcel.getStruId();
        if (HussarUtils.isNotEmpty((Object)struId) && organIdNumMap.get(struId) > 1L) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)12, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_PRIMARY_KEY_DUPLICATION.getMessage()), cellErrColMap);
        }
    }

    private void checkExcelForOrganName(Map<String, Long> fullOrganNameMap, int i, OrganExcel organExcel, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String organName = organExcel.getOrganName();
        String parentOrganNames = HussarUtils.isBlank((CharSequence)organExcel.getParentOrganNames()) ? "" : organExcel.getParentOrganNames();
        String fullOrganName = parentOrganNames + "/" + organName;
        Long num = fullOrganNameMap.get(fullOrganName);
        if (num > 1L) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NAME_DUPLICATION.getMessage()), cellErrColMap);
        }
        if (HussarUtils.isNotEmpty((Object)organName) && (organName.length() > 64 || organName.contains("/"))) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)1, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NAME_CHECK.getMessage()), cellErrColMap);
        }
    }

    private void checkExcelForOrganType(Map<String, OrganExcel> fullNameAndOrganMapInExcel, Map<String, SysOrganType> typeNameAndOrganMap, Map<String, List<String>> organTypeNameAndParentOrganTypeListMap, int i, OrganExcel organExcel, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String organTypeName = organExcel.getOrganTypeName();
        if (!typeNameAndOrganMap.containsKey(organTypeName)) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_ORANG_TYPE.getMessage()), cellErrColMap);
        } else {
            String parentOrganNames;
            if (HussarUtils.isEmpty((Object)organExcel.getParentOrganNames())) {
                List names = typeNameAndOrganMap.values().stream().filter(item -> HussarUtils.equals((Object)item.getParentType(), (Object)"0")).map(SysOrganType::getTypeName).distinct().collect(Collectors.toList());
                if (HussarUtils.isNotEmpty(names) && !names.contains(organTypeName)) {
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_VALID_ORANG_TYPE_RULE.getMessage()), cellErrColMap);
                }
                if (HussarUtils.isEmpty(names)) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_MAINTAIN_ORGAN_TYPE.getMessage()));
                }
            }
            String string = parentOrganNames = HussarUtils.isBlank((CharSequence)organExcel.getParentOrganNames()) ? "" : organExcel.getParentOrganNames();
            if (HussarUtils.isNotEmpty((Object)parentOrganNames) && fullNameAndOrganMapInExcel.containsKey(parentOrganNames)) {
                OrganExcel parentOrganExcel = fullNameAndOrganMapInExcel.get(parentOrganNames);
                String parentOrganTypeName = parentOrganExcel.getOrganTypeName();
                List<String> organTypeNamses = organTypeNameAndParentOrganTypeListMap.get(organTypeName);
                if (HussarUtils.isEmpty(organTypeNamses) || !organTypeNamses.contains(parentOrganTypeName)) {
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_VALID_ORANG_TYPE_RULE.getMessage()), cellErrColMap);
                }
            }
        }
    }

    private void checkExcelForParentOrgan(int i, OrganExcel organExcel, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String parentOrganNames = organExcel.getParentOrganNames();
        if (HussarUtils.isNotBlank((CharSequence)parentOrganNames)) {
            String parentFullName = parentOrganNames.replaceAll(" ", "");
            String regex = "^(?:/[^/]+)+$";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(parentFullName);
            if (!matcher.matches()) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NAME_FORMAT_FALSE.getMessage()), cellErrColMap);
            }
        }
    }

    private void checkDataInDb(Map<Integer, OrganExcel> dataMap, List<OrganExcel> successDataList, List<ExcelImportMsg<OrganExcel>> newDataList, List<ExcelImportMsg<OrganExcel>> updateDataList, List<ExcelImportMsg<OrganExcel>> existDataList, List<ExcelImportMsg<OrganExcel>> errorDataList, Map<String, List<String>> typeNameAndParentTypeListMap, Map<String, OrganExcel> organDbMap, List<String> organCodeDbList, Map<String, SysUsers> userMap, List<Long> organIdDbList) {
        ArrayList<String> errorFullParentOrganName = new ArrayList<String>();
        LinkedHashMap multiValueLevelMap = new LinkedHashMap();
        ArrayList<String> fullOrganNameListExcel = new ArrayList<String>();
        for (Map.Entry<Integer, OrganExcel> entry : dataMap.entrySet()) {
            Map<Integer, OrganExcel> map;
            OrganExcel organExcel = entry.getValue();
            String parentOrganNames = HussarUtils.isBlank((CharSequence)organExcel.getParentOrganNames()) ? "" : organExcel.getParentOrganNames();
            int level = 1;
            if (HussarUtils.isNotBlank((CharSequence)parentOrganNames)) {
                long count = parentOrganNames.chars().filter(item -> HussarUtils.equals((Object)item, (Object)"/")).count();
                level = Integer.parseInt(Long.toString(count)) + 1;
            }
            if (multiValueLevelMap.containsKey(level)) {
                map = (Map)multiValueLevelMap.get(level);
                map.put(entry.getKey(), organExcel);
            } else {
                map = new LinkedHashMap<Integer, OrganExcel>();
                map.put(entry.getKey(), organExcel);
                multiValueLevelMap.put(level, map);
            }
            String fullOrganName = parentOrganNames + "/" + organExcel.getOrganName();
            fullOrganNameListExcel.add(fullOrganName);
        }
        ArrayList levels = new ArrayList(multiValueLevelMap.keySet());
        Collections.sort(levels);
        for (Integer level : levels) {
            Map map = (Map)multiValueLevelMap.get(level);
            for (Map.Entry entry : map.entrySet()) {
                Integer i = (Integer)entry.getKey();
                OrganExcel organExcel = (OrganExcel)entry.getValue();
                HashMap<Integer, Map<Integer, String>> cellErrColMap = new HashMap<Integer, Map<Integer, String>>();
                HashMap<Integer, Map<Integer, String>> cellUpdateColMap = new HashMap<Integer, Map<Integer, String>>();
                HashMap<Integer, Map<Integer, String>> cellNewColMap = new HashMap<Integer, Map<Integer, String>>();
                HashMap<Integer, Map<Integer, String>> cellExitColMap = new HashMap<Integer, Map<Integer, String>>();
                this.checkDbOrganCode(i, organExcel, organDbMap, organCodeDbList, cellErrColMap);
                this.checkDbTypeAndParentOrgan(i, organExcel, fullOrganNameListExcel, typeNameAndParentTypeListMap, organDbMap, errorFullParentOrganName, cellErrColMap);
                if (HussarUtils.isEmpty(cellErrColMap.get(i))) {
                    this.checkOrganForExit(i, organExcel, cellUpdateColMap, cellNewColMap, cellExitColMap, organDbMap, userMap, organIdDbList, cellErrColMap);
                }
                if (cellErrColMap.size() == 0) {
                    successDataList.add(organExcel);
                }
                if (HussarUtils.isNotEmpty(cellErrColMap)) {
                    errorDataList.add((ExcelImportMsg<OrganExcel>)new ExcelImportMsg((Object)organExcel, cellErrColMap));
                }
                if (HussarUtils.isNotEmpty(cellExitColMap)) {
                    existDataList.add((ExcelImportMsg<OrganExcel>)new ExcelImportMsg((Object)organExcel, cellExitColMap));
                }
                if (HussarUtils.isNotEmpty(cellUpdateColMap)) {
                    updateDataList.add((ExcelImportMsg<OrganExcel>)new ExcelImportMsg((Object)organExcel, cellUpdateColMap));
                }
                if (!HussarUtils.isNotEmpty(cellNewColMap)) continue;
                newDataList.add((ExcelImportMsg<OrganExcel>)new ExcelImportMsg((Object)organExcel, cellNewColMap));
            }
        }
    }

    private void checkDbOrganCode(int i, OrganExcel organExcel, Map<String, OrganExcel> organDbMap, List<String> organCodeDbList, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String organCodeDb;
        String organCode = organExcel.getOrganCode();
        String organName = organExcel.getOrganName();
        String parentOrganNames = HussarUtils.isBlank((CharSequence)organExcel.getParentOrganNames()) ? "" : organExcel.getParentOrganNames();
        String fullOrganName = parentOrganNames + "/" + organName;
        if (HussarUtils.isNotBlank((CharSequence)organCode) && !organDbMap.containsKey(fullOrganName) && organCodeDbList.contains(organCode)) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_CODE_EXIST_ON_PLATFORM.getMessage()), cellErrColMap);
        }
        if (HussarUtils.isNotBlank((CharSequence)organCode) && organDbMap.containsKey(fullOrganName) && !HussarUtils.equals((Object)organCode, (Object)(organCodeDb = organDbMap.get(fullOrganName).getOrganCode()))) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_VALID_ORGAN_AND_CODE.getMessage()), cellErrColMap);
        }
    }

    private void checkDbTypeAndParentOrgan(int i, OrganExcel organExcel, List<String> fullOrganNameListExcel, Map<String, List<String>> typeNameAndParentTypeListMap, Map<String, OrganExcel> organDbMap, List<String> errorParentOrganNames, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String parentOrganNames = HussarUtils.isBlank((CharSequence)organExcel.getParentOrganNames()) ? "" : organExcel.getParentOrganNames();
        String organTypeName = organExcel.getOrganTypeName();
        if (HussarUtils.isNotEmpty(errorParentOrganNames) && HussarUtils.isNotEmpty((Object)parentOrganNames) && fullOrganNameListExcel.contains(parentOrganNames)) {
            for (String parentName : errorParentOrganNames) {
                if (!parentOrganNames.startsWith(parentName)) continue;
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NOT_EXIST.getMessage()), cellErrColMap);
            }
        }
        if (HussarUtils.isNotEmpty((Object)parentOrganNames) && !fullOrganNameListExcel.contains(parentOrganNames)) {
            if (!organDbMap.containsKey(parentOrganNames)) {
                errorParentOrganNames.add(parentOrganNames + "/");
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)3, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NOT_EXIST.getMessage()), cellErrColMap);
            } else {
                OrganExcel parentOrgan = organDbMap.get(parentOrganNames);
                String parentOrganTypeName = parentOrgan.getOrganTypeName();
                List<String> organTypeNamses = typeNameAndParentTypeListMap.get(organTypeName);
                if (HussarUtils.isEmpty(organTypeNamses)) {
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_VALID_ORANG_TYPE_RULE.getMessage()), cellErrColMap);
                } else if (!organTypeNamses.contains(parentOrganTypeName)) {
                    HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_VALID_ORANG_TYPE_RULE.getMessage()), cellErrColMap);
                }
            }
        }
    }

    private void checkOrganForExit(int i, OrganExcel organExcel, Map<Integer, Map<Integer, String>> cellUpdateColMap, Map<Integer, Map<Integer, String>> cellNewColMap, Map<Integer, Map<Integer, String>> cellExitColMap, Map<String, OrganExcel> organDbMap, Map<String, SysUsers> userMap, List<Long> organIdDbList, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String organTypeName = organExcel.getOrganTypeName();
        String organAlias = organExcel.getOrganAlias();
        String shortName = organExcel.getShortName();
        String officeAlias = organExcel.getOfficeAlias();
        String officeAddress = organExcel.getOfficeAddress();
        String struOrder = organExcel.getStruOrder();
        String userAccount = organExcel.getUserAccount();
        String validTimeLimitType = HussarUtils.isBlank((CharSequence)organExcel.getValidTimeLimitType()) ? ExcelOrganLimitTypeEnum.ORGAN_LONG.getValue() : organExcel.getValidTimeLimitType();
        String organName = organExcel.getOrganName();
        String parentOrganNames = HussarUtils.isBlank((CharSequence)organExcel.getParentOrganNames()) ? "" : organExcel.getParentOrganNames();
        String fullOrganName = parentOrganNames + "/" + organName;
        List<Long> nodeIdList = Arrays.asList(Constants.ROOT_NODE_ID, Constants.OUT_STRU_NODE_ID);
        if (!organDbMap.containsKey(fullOrganName)) {
            String struId = organExcel.getStruId();
            if (HussarUtils.isNotEmpty((Object)struId) && organIdDbList.contains(Long.parseLong(struId))) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)12, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_ADD_ORGAN_PRIMARY_KEY_EXIST.getMessage()), cellErrColMap);
            }
            if (HussarUtils.isNotEmpty((Object)struId) && nodeIdList.contains(Long.parseLong(struId))) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)12, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_ADD_ORGAN_PRIMARY_KEY_CONFLICT.getMessage()), cellErrColMap);
            }
            int[] indexArr = new int[]{1};
            HussarBaseExcelValidateHelper.addMsgBatch((int)i, (String)"add", cellNewColMap, (int[])indexArr, OrganExcel.class);
        } else {
            int[] indexArr = new int[]{0, 1, 3, 9};
            HussarBaseExcelValidateHelper.addMsgBatch((int)i, (String)"exit", cellExitColMap, (int[])indexArr, OrganExcel.class);
            OrganExcel organDb = organDbMap.get(fullOrganName);
            if (HussarUtils.equals((Object)organDb.getOrganTypeName(), (Object)organTypeName)) {
                HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)2, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_ORGAN_TYPE_EXIST.getMessage()), cellExitColMap);
            } else {
                HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)2, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_ORGAN_TYPE_UPDATE.getMessage()), cellUpdateColMap);
            }
            if (HussarUtils.equals((Object)StringUtils.trimToEmpty((String)organDb.getShortName()), (Object)StringUtils.trimToEmpty((String)shortName))) {
                HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)4, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_ORGAN_SHORT_NAME_EXIST.getMessage()), cellExitColMap);
            } else {
                HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)4, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_ORGAN_SHORT_NAME_UPDATE.getMessage()), cellUpdateColMap);
            }
            if (HussarUtils.equals((Object)StringUtils.trimToEmpty((String)organDb.getOrganAlias()), (Object)StringUtils.trimToEmpty((String)organAlias))) {
                HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)5, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_ORGAN_ALIAS_EXIST.getMessage()), cellExitColMap);
            } else {
                HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)5, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_ORGAN_ALIAS_UPDATE.getMessage()), cellUpdateColMap);
            }
            if (HussarUtils.equals((Object)StringUtils.trimToEmpty((String)organDb.getOfficeAlias()), (Object)StringUtils.trimToEmpty((String)officeAlias))) {
                HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)6, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_ORGAN_OFFICE_ALIAS_EXIST.getMessage()), cellExitColMap);
            } else {
                HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)6, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_ORGAN_OFFICE_ALIAS_UPDATE.getMessage()), cellUpdateColMap);
            }
            if (HussarUtils.equals((Object)StringUtils.trimToEmpty((String)organDb.getOfficeAddress()), (Object)StringUtils.trimToEmpty((String)officeAddress))) {
                HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)7, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_ORGAN_OFFICE_ADDRESS_EXIST.getMessage()), cellExitColMap);
            } else {
                HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)7, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_ORGAN_OFFICE_ADDRESS_UPDATE.getMessage()), cellUpdateColMap);
            }
            if (HussarUtils.isBlank((CharSequence)struOrder) || HussarUtils.equals((Object)StringUtils.trimToEmpty((String)organDb.getStruOrder()), (Object)StringUtils.trimToEmpty((String)struOrder))) {
                HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)11, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_STRU_ORDER_EXIST.getMessage()), cellExitColMap);
            } else {
                HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)11, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_STRU_ORDER_UPDATE.getMessage()), cellUpdateColMap);
            }
            if (HussarUtils.equals((Object)StringUtils.trimToEmpty((String)organDb.getValidTimeLimitType()), (Object)validTimeLimitType)) {
                HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)10, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_VALID_TIME_LIMIT_TYPE_EXIST.getMessage()), cellExitColMap);
            } else {
                HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)10, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_VALID_TIME_LIMIT_TYPE_UPDATE.getMessage()), cellUpdateColMap);
            }
            Long principalId = organDb.getPrincipalId();
            if (HussarUtils.isBlank((CharSequence)userAccount) && HussarUtils.isEmpty((Object)principalId)) {
                HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)8, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_PRINCIPAL_ID_EXIST.getMessage()), cellExitColMap);
            } else if (HussarUtils.isNotBlank((CharSequence)userAccount) && HussarUtils.isNotEmpty((Object)principalId)) {
                Long userId = userMap.get(userAccount).getId();
                if (HussarUtils.equals((Object)userId, (Object)principalId)) {
                    HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)8, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_PRINCIPAL_ID_EXIST.getMessage()), cellExitColMap);
                } else {
                    HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)8, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_PRINCIPAL_ID_UPDATE.getMessage()), cellUpdateColMap);
                }
            } else {
                HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)8, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_PRINCIPAL_ID_UPDATE.getMessage()), cellUpdateColMap);
            }
        }
    }
}

