/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.post.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.post.dao.SysPostMapper;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.ILocalPostBoService;
import com.jxdinfo.hussar.authorization.post.vo.OrganPostTreeVo;
import com.jxdinfo.hussar.authorization.post.vo.PostBasicVo;
import com.jxdinfo.hussar.authorization.post.vo.PostVo;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.common.treemodel.AbstractNoIconHussarLazyTreeDefinition;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.post.service.impl.localPostBoServiceImpl")
public class LocalPostBoServiceImpl
implements ILocalPostBoService {
    private static final String PARENT_ID = "parentId";
    private static final String ORGAN_PROPERTY = "organProperty";
    @Resource
    private SysPostMapper sysPostMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private ISysStruPostService sysStruPostService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private QueryOrganizationManager queryOrganizationManager;

    public List<PostBasicVo> getPostsByStruId(Long struId, String postName) {
        List<PostVo> postVos;
        ArrayList<PostBasicVo> result = new ArrayList<PostBasicVo>();
        if (HussarUtils.isNotEmpty((Object)struId)) {
            postVos = this.sysPostMapper.postSelect(null, struId, postName);
        } else {
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put("postName", postName);
            postVos = this.sysPostMapper.unRelateOrganPostNoPage(queryParams);
        }
        if (HussarUtils.isEmpty(postVos)) {
            return result;
        }
        for (PostVo vo : postVos) {
            PostBasicVo post = new PostBasicVo();
            post.setPostId(vo.getPostId());
            post.setPostName(vo.getPostName());
            result.add(post);
        }
        return result;
    }

    public List<OrganPostTreeVo> lazyLoadOrganPostTree(Long parentId) {
        AssertUtil.isNotNull((Object)parentId, (String)"\u672a\u4f20\u9012\u53c2\u6570");
        ArrayList<Object> result = new ArrayList<Object>();
        if (!HussarUtils.equals((Object)0L, (Object)parentId)) {
            List postIds;
            LambdaQueryWrapper relationWrapper;
            List posts;
            List struPosts;
            String organProperty = HussarUtils.equals((Object)11L, (Object)parentId) ? "0" : (HussarUtils.equals((Object)12L, (Object)parentId) ? "1" : null);
            List<OrganPostTreeVo> organTree = this.getOrganizationTree(parentId, organProperty);
            if (HussarUtils.isNotEmpty(organTree)) {
                List struIds = organTree.stream().map(s -> (Long)s.getId()).collect(Collectors.toList());
                LambdaQueryWrapper wrapper = (LambdaQueryWrapper)LambdaQueryUtil.getMultiQueryWrapper(SysStruPost::getStruId, struIds).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
                List list = this.sysStruPostService.list((Wrapper)wrapper);
                Map<Long, Long> map = list.stream().collect(Collectors.groupingBy(SysStruPost::getStruId, Collectors.counting()));
                for (OrganPostTreeVo tree : organTree) {
                    Boolean flag = tree.getHasChildren();
                    Long postNum = map.get(tree.getId());
                    boolean postFlag = HussarUtils.isNotEmpty((Object)postNum) && postNum > 0L;
                    tree.setHasChildren(Boolean.valueOf(flag != false || postFlag));
                }
                result.addAll(organTree);
            }
            if (!HussarUtils.equals((Object)11L, (Object)parentId) && !HussarUtils.equals((Object)12L, (Object)parentId) && HussarUtils.isNotEmpty((Object)(struPosts = this.sysStruPostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruPost::getStruId, (Object)parentId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0")))) && HussarUtils.isNotEmpty((Object)(posts = this.sysPostMapper.selectList((Wrapper)(relationWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)LambdaQueryUtil.getMultiQueryWrapper(SysPost::getId, postIds = struPosts.stream().map(SysStruPost::getPostId).distinct().collect(Collectors.toList())).eq(HussarDelflagEntity::getDelFlag, (Object)"0")).orderByAsc(SysPost::getPostOrder)))))) {
                ArrayList<OrganPostTreeVo> postTree = new ArrayList<OrganPostTreeVo>();
                for (SysPost post : posts) {
                    OrganPostTreeVo vo = new OrganPostTreeVo();
                    vo.setId((Serializable)post.getId());
                    vo.setLabel(post.getPostName());
                    vo.setParentId((Serializable)parentId);
                    vo.setTypes("post");
                    vo.setHasChildren(Boolean.valueOf(false));
                    postTree.add(vo);
                }
                result.addAll(postTree);
            }
        } else {
            ArrayList<OrganPostTreeVo> postTree = new ArrayList<OrganPostTreeVo>();
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            List<PostVo> postList = this.sysPostMapper.unRelateOrganPostNoPage(queryParams);
            if (HussarUtils.isNotEmpty(postList)) {
                for (PostVo post : postList) {
                    OrganPostTreeVo vo = new OrganPostTreeVo();
                    vo.setId((Serializable)post.getPostId());
                    vo.setLabel(post.getPostName());
                    vo.setTypes("post");
                    vo.setHasChildren(Boolean.valueOf(false));
                    postTree.add(vo);
                }
                result.addAll(postTree);
            }
        }
        return HussarTreeParser.getTreeList(result);
    }

    public List<PostBasicVo> getPostInfoByIds(List<Long> postIds) {
        ArrayList<PostBasicVo> result = new ArrayList<PostBasicVo>();
        if (HussarUtils.isEmpty(postIds)) {
            return result;
        }
        LambdaQueryWrapper wrapper = LambdaQueryUtil.getMultiQueryWrapper(SysPost::getId, postIds);
        wrapper.eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        List posts = this.sysPostMapper.selectList((Wrapper)wrapper);
        if (HussarUtils.isNotEmpty((Object)posts)) {
            for (SysPost post : posts) {
                PostBasicVo vo = new PostBasicVo();
                vo.setPostId(post.getId());
                vo.setPostName(post.getPostName());
                result.add(vo);
            }
        }
        return result;
    }

    private List<OrganPostTreeVo> getOrganizationTree(Long parentId, String organProperty) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(PARENT_ID, parentId);
        queryParams.put(ORGAN_PROPERTY, organProperty);
        return this.sysStruMapper.searchOrganTree(queryParams);
    }

    public List<OrganPostTreeVo> organPostSearch(String name) {
        ArrayList<OrganPostTreeVo> organPostTreeVoList = new ArrayList<OrganPostTreeVo>();
        List sysPosts = this.sysPostMapper.selectList((Wrapper)new LambdaQueryWrapper().like(SysPost::getPostName, (Object)name));
        if (HussarUtils.isNotEmpty((Object)sysPosts)) {
            Map<Long, String> postMaps = sysPosts.stream().collect(Collectors.toMap(SysPost::getId, SysPost::getPostName));
            List<Long> postIds = this.wrapPostInfo(postMaps, organPostTreeVoList);
            this.wrapOrganPostInfo(postIds, organPostTreeVoList);
        }
        List organPostTreeVos = HussarTreeParser.getTreeList(organPostTreeVoList);
        for (OrganPostTreeVo organPostTreeVo : organPostTreeVos) {
            this.sysRolesService.fillHasChildren((AbstractNoIconHussarLazyTreeDefinition)organPostTreeVo);
        }
        return organPostTreeVos;
    }

    private List<Long> wrapPostInfo(Map<Long, String> postMaps, List<OrganPostTreeVo> organPostTreeVoList) {
        ArrayList<Long> postIds = new ArrayList<Long>();
        for (Map.Entry<Long, String> postMap : postMaps.entrySet()) {
            List sysStruPosts = this.sysStruPostService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruPost::getPostId, (Object)postMap.getKey()));
            if (HussarUtils.isNotEmpty((Object)sysStruPosts)) {
                List struIds = sysStruPosts.stream().map(SysStruPost::getStruId).collect(Collectors.toList());
                for (Long struId : struIds) {
                    OrganPostTreeVo organPostTreeVo = new OrganPostTreeVo();
                    organPostTreeVo.setId((Serializable)postMap.getKey());
                    organPostTreeVo.setLabel(postMap.getValue());
                    organPostTreeVo.setParentId((Serializable)struId);
                    organPostTreeVo.setTypes("post");
                    organPostTreeVo.setHasChildren(Boolean.valueOf(false));
                    organPostTreeVoList.add(organPostTreeVo);
                }
            } else {
                OrganPostTreeVo organPostTreeVo = new OrganPostTreeVo();
                organPostTreeVo.setId((Serializable)postMap.getKey());
                organPostTreeVo.setLabel(postMap.getValue());
                organPostTreeVo.setParentId((Serializable)Long.valueOf(13L));
                organPostTreeVo.setTypes("post");
                organPostTreeVo.setHasChildren(Boolean.valueOf(false));
                organPostTreeVoList.add(organPostTreeVo);
                OrganPostTreeVo organPostTreeVo3 = new OrganPostTreeVo();
                organPostTreeVo3.setId((Serializable)Long.valueOf(13L));
                organPostTreeVo3.setLabel("\u672a\u5173\u8054\u7ec4\u7ec7\u5c97\u4f4d");
                organPostTreeVo3.setTypes("organ");
                organPostTreeVoList.add(organPostTreeVo3);
            }
            postIds.add(postMap.getKey());
        }
        return postIds;
    }

    private void wrapOrganPostInfo(List<Long> postIds, List<OrganPostTreeVo> organPostTreeVoList) {
        List sysStruPosts = this.sysStruPostService.list((Wrapper)new LambdaQueryWrapper().in(SysStruPost::getPostId, postIds));
        if (HussarUtils.isNotEmpty((Object)sysStruPosts)) {
            List<Long> struIds = sysStruPosts.stream().map(SysStruPost::getStruId).distinct().collect(Collectors.toList());
            List<Long> finalStruIds = this.queryOrganizationManager.getParentStruByIds(struIds);
            List<OrganUserTreeVo> organUserTreeOnlyOrgan = this.sysStruMapper.getOrganTreeOnlyOrgan(finalStruIds, null);
            List organPostTreeVos = HussarUtils.copy(organUserTreeOnlyOrgan, OrganPostTreeVo.class);
            List interiorOrganList = organUserTreeOnlyOrgan.stream().filter(o -> HussarUtils.equals((Object)o.getParentId(), (Object)11L)).collect(Collectors.toList());
            List outerOrganList = organUserTreeOnlyOrgan.stream().filter(o -> HussarUtils.equals((Object)o.getParentId(), (Object)12L)).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(interiorOrganList)) {
                OrganPostTreeVo organPostTreeVo1 = new OrganPostTreeVo();
                organPostTreeVo1.setId((Serializable)Long.valueOf(11L));
                organPostTreeVo1.setLabel("\u516c\u53f8\u5185\u90e8\u7ec4\u7ec7");
                organPostTreeVo1.setTypes("organ");
                organPostTreeVoList.add(organPostTreeVo1);
            }
            if (HussarUtils.isNotEmpty(outerOrganList)) {
                OrganPostTreeVo organPostTreeVo2 = new OrganPostTreeVo();
                organPostTreeVo2.setId((Serializable)Long.valueOf(12L));
                organPostTreeVo2.setLabel("\u516c\u53f8\u5916\u90e8\u7ec4\u7ec7");
                organPostTreeVo2.setTypes("organ");
                organPostTreeVoList.add(organPostTreeVo2);
            }
            organPostTreeVoList.addAll(organPostTreeVos);
        }
    }
}

