/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.post.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.post.dto.EditOutsidePostDto;
import com.jxdinfo.hussar.authorization.post.manager.EditBatchOutsidePostManager;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.post.manager.impl.editBatchOutsidePostManagerImpl")
public class EditBatchOutsidePostManagerImpl
implements EditBatchOutsidePostManager {
    @Autowired
    private IHussarBasePostService postService;

    @Override
    public R<EditOutsidePostDto> editBatchPosts(List<EditOutsidePostDto> posts) {
        R result = new R();
        List errors = OrganUtil.validateMany(posts);
        for (EditOutsidePostDto dto : posts) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(SysPost::getPostCode, (Object)dto.getPostCode().trim());
            boolean flag = this.postService.count((Wrapper)lambdaQueryWrapper) > 0L;
            if (flag) continue;
            OrganUtil.addErrorMsg((List)errors, (Object)dto, (String)"postCode", (String[])new String[]{"\u5c97\u4f4d\u7f16\u7801\u4e0d\u5b58\u5728"});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
            ArrayList<SysPost> sysPostList = new ArrayList<SysPost>();
            List codes = posts.stream().map(item -> StringUtils.trimToEmpty((String)item.getPostCode())).collect(Collectors.toList());
            List postList = this.postService.list((Wrapper)new LambdaQueryWrapper().in(SysPost::getPostCode, codes));
            Map postMap = postList.stream().collect(Collectors.toMap(SysPost::getPostCode, Function.identity()));
            for (EditOutsidePostDto post : posts) {
                String postCode = StringUtils.trimToEmpty((String)post.getPostCode());
                SysPost sysPost = new SysPost();
                SysPost sysPostTemp = (SysPost)postMap.get(postCode);
                BeanUtils.copyProperties((Object)sysPostTemp, (Object)sysPost);
                this.initializationEdit(post, sysPost);
                sysPostList.add(sysPost);
                dataMappings.add(new DataMapping(sysPost.getId(), sysPost.getPostCode()));
            }
            result.setSuccessList(dataMappings);
            this.postService.updateBatchById(sysPostList);
        }
        return result;
    }

    private void initializationEdit(EditOutsidePostDto editOutsidePostDto, SysPost sysPost) {
        String postName = StringUtils.trimToEmpty((String)editOutsidePostDto.getPostName());
        String postDesc = StringUtils.trimToEmpty((String)editOutsidePostDto.getPostDesc());
        Integer postOrder = editOutsidePostDto.getPostOrder();
        if (StringUtils.isNotBlank((CharSequence)postName)) {
            sysPost.setPostName(postName);
        }
        if (StringUtils.isNotBlank((CharSequence)postDesc)) {
            sysPost.setPostDesc(postDesc);
        }
        if (HussarUtils.isNotEmpty((Object)postOrder)) {
            sysPost.setPostOrder(postOrder);
        }
    }
}

