/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.service.ILocalFunctionAdapterService;
import com.jxdinfo.hussar.authorization.permit.service.ILocalFunctionModuleAdapterService;
import com.jxdinfo.hussar.authorization.permit.service.ILocalFunctionResourceAdapterService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleFunctionsVo;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.properties.SecureAssesmentProperties;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class LocalFunctionAdapterServiceImpl
extends HussarBaseServiceImpl<SysFunctionsMapper, SysFunctions>
implements ILocalFunctionAdapterService {
    @Resource
    private SysFunctionsMapper sysFunctionsMapper;
    @Resource
    private ILocalFunctionResourceAdapterService localFunctionResourceAdapterService;
    @Resource
    private SysFunctionModulesMapper sysFunctionModulesMapper;
    @Resource
    private ILocalFunctionModuleAdapterService localFunctionModuleAdapterService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysResourceMosulesService sysResourceMosulesService;
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysFunctionResourcesService sysFunctionResourcesService;
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private ISysRoleResourceService sysRoleResourceService;
    @Resource
    private SecureAssesmentProperties secureAssesmentProperties;

    public Integer getMaxOrderByParentId(Long moduleId) {
        return this.sysFunctionsMapper.getMaxOrderByParentId(moduleId);
    }

    public List<SysFunctionResources> listByFuncIdAndResId(Long functionId, Long resourceId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)functionId)) {
            lambdaQueryWrapper.eq(SysFunctionResources::getFunctionId, (Object)functionId);
        }
        if (HussarUtils.isNotEmpty((Object)resourceId)) {
            lambdaQueryWrapper.eq(SysFunctionResources::getResourceId, (Object)resourceId);
        }
        return this.localFunctionResourceAdapterService.list((Wrapper)lambdaQueryWrapper);
    }

    public Integer getMaxOrderByParentIdAndAppId(Long moduleId, Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        return this.sysFunctionModulesMapper.getMaxOrderByParentIdAndAppId(moduleId, appId);
    }

    public List<JSTreeModel> getFunModuleMergeTreeForOrg(String functionFlag, Long appId) {
        boolean flag;
        boolean bl = flag = !HussarUtils.isEmpty((Object)functionFlag) && Boolean.parseBoolean(functionFlag);
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        List<Object> moduleList = new ArrayList();
        boolean open = this.secureAssesmentProperties.isOpen();
        moduleList = open ? this.sysFunctionsMapper.getModuleFunctionTreeForSecureAssesment(appId) : this.sysFunctionsMapper.getModuleFunctionTree(appId);
        List<Object> result = new ArrayList<JSTreeModel>(moduleList);
        if (open) {
            result.addAll(this.sysFunctionsMapper.getModuleFunctionTreeWithFunctionDataForSecureAssesment(appId));
        } else {
            result.addAll(this.sysFunctionsMapper.getModuleFunctionTreeWithFunctionData(appId));
        }
        if (!flag) {
            result = result.stream().filter(item -> "1".equals(item.getIsModule())).collect(Collectors.toList());
        }
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        result.add(root);
        return TreeModelUtils.merge(result);
    }

    public SysModuleFunctionsVo getFunctionDetail(Long functionId) {
        return this.sysFunctionsMapper.getFunctionDetail(functionId);
    }

    public List<SysFunctionModules> moduleList(String moduleName, Long parentModuleId, Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(HussarUtils.isNotBlank((CharSequence)moduleName), SysFunctionModules::getFunctionModuleName, (Object)moduleName);
        lambdaQueryWrapper.eq(SysFunctionModules::getParentModuleId, (Object)parentModuleId);
        lambdaQueryWrapper.eq(SysFunctionModules::getApplicationId, (Object)appId);
        lambdaQueryWrapper.orderByAsc(SysFunctionModules::getSeq);
        return this.localFunctionModuleAdapterService.list((Wrapper)lambdaQueryWrapper);
    }

    public Map<Long, String> getFullModuleNameMapByName(String moduleName, Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        List allModules = this.sysFunctionModulesMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getApplicationId, (Object)appId));
        Map<Long, SysFunctionModules> moduleMap = allModules.stream().collect(Collectors.toMap(SysFunctionModules::getId, Function.identity()));
        List modules = this.sysFunctionModulesMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getFunctionModuleName, (Object)moduleName)).eq(SysFunctionModules::getApplicationId, (Object)appId)).orderByAsc(SysFunctionModules::getSeq));
        LinkedHashMap<Long, String> result = new LinkedHashMap<Long, String>();
        for (SysFunctionModules module : modules) {
            StringBuilder fullName = new StringBuilder();
            this.getFullName(moduleMap, module, fullName);
            result.put(module.getId(), this.toReverseFullName(fullName.toString()));
        }
        return result;
    }

    public String getFullModuleNameById(Long moduleId, Long appId) {
        if (HussarUtils.isEmpty((Object)appId)) {
            appId = 1L;
        }
        List allModules = this.sysFunctionModulesMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getApplicationId, (Object)appId));
        Map<Long, SysFunctionModules> moduleMap = allModules.stream().collect(Collectors.toMap(SysFunctionModules::getId, Function.identity()));
        SysFunctionModules module = (SysFunctionModules)this.sysFunctionModulesMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getId, (Object)moduleId)).eq(SysFunctionModules::getApplicationId, (Object)appId));
        StringBuilder fullName = new StringBuilder();
        this.getFullName(moduleMap, module, fullName);
        return this.toReverseFullName(fullName.toString());
    }

    private String toReverseFullName(String fullName) {
        String[] parts = fullName.split("/");
        List<String> partList = Arrays.asList(parts);
        Collections.reverse(partList);
        return partList.stream().collect(Collectors.joining("/", "/", ""));
    }

    private void getFullName(Map<Long, SysFunctionModules> moduleMap, SysFunctionModules module, StringBuilder fullName) {
        fullName.append(module.getFunctionModuleName()).append("/");
        Long parentModuleId = module.getParentModuleId();
        if (!HussarUtils.equals((Object)parentModuleId, (Object)1L)) {
            SysFunctionModules parentModule = moduleMap.get(parentModuleId);
            this.getFullName(moduleMap, parentModule, fullName);
        }
    }

    public List<SysFunctions> getFunsByAllDefaultRes(Long appId) {
        return this.sysFunctionsMapper.getFunsByAllDefaultRes(appId);
    }
}

