/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.jxdinfo.hussar.authorization.client.SyncOrganClient;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseSyncOrganizationService;
import com.jxdinfo.hussar.common.base.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SyncOutsideOrganController {
    protected static final Logger logger = LoggerFactory.getLogger(SyncOutsideOrganController.class);
    @Autowired
    private IHussarBaseSyncOrganizationService organizationService;

    @GetMapping(value={"/SyncOutsideOrgan"})
    public String SyncOutsideOrgan() {
        List<AddOutsideOrganizationDto> organList = SyncOrganClient.getERPDept();
        logger.info("\u603b\u5171\u67e5\u8be2\u5230{}\u4e2a\u7ec4\u7ec7\u673a\u6784", (Object)organList.size());
        if (organList == null || organList.size() == 0) {
            return "\u6ca1\u6709\u67e5\u8be2\u5230\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f,\u6ca1\u6709\u6570\u636e\u9700\u8981\u540c\u6b65";
        }
        logger.info("\u603b\u5171\u67e5\u8be2\u5230{}\u4e2a\u7ec4\u7ec7\u673a\u6784", (Object)organList.size());
        ArrayList result = new ArrayList();
        HashMap<Integer, List<AddOutsideOrganizationDto>> levelMap = new HashMap<Integer, List<AddOutsideOrganizationDto>>();
        this.buildTree(organList, "1", levelMap, 0);
        for (int level = 0; level < levelMap.size(); ++level) {
            List organizationsAtLevel = (List)levelMap.get(level);
            result.addAll(organizationsAtLevel);
        }
        int batchSize = 50;
        for (int i = 0; i < result.size(); i += batchSize) {
            List batchData = result.subList(i, Math.min(i + batchSize, result.size()));
            R r = this.organizationService.addBatchOrganizations(batchData);
        }
        return "\u540c\u6b65\u5b8c\u6210,\u603b\u5171\u67e5\u5230\u4e86" + organList.size() + "\u4e2a\u7ec4\u7ec7\u673a\u6784";
    }

    private void buildTree(List<AddOutsideOrganizationDto> organList, String parentID, Map<Integer, List<AddOutsideOrganizationDto>> levelMap, int level) {
        if (!levelMap.containsKey(level)) {
            levelMap.put(level, new ArrayList());
        }
        for (AddOutsideOrganizationDto organization : organList) {
            if (!organization.getParentOrganCode().equals(parentID)) continue;
            levelMap.get(level).add(organization);
            this.buildTree(organList, organization.getOrganCode(), levelMap, level + 1);
        }
    }
}

