/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dto.SearchOrganUserDto;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ILocalOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganTreeInitVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationInfoVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffBo;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserService;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruUserMapper;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.AbstractNoIconHussarLazyTreeDefinition;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class LocalHussarBaseOrganizationBoServiceImpl
implements ILocalOrganizationBoService {
    @Resource
    private QueryOrganizationManager queryOrganizationManager;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysStruUserMapper sysStruUserMapper;
    @Resource
    private ISysStruPostService sysStruPostService;
    @Resource
    private IHussarBaseStaffService hussarBaseStaffService;
    @Resource
    private IHussarBaseUserService hussarBaseUserService;

    public OrganizationBo findOrganizationById(Long id) {
        OrganizationInfoVo organizationInfoVo = this.queryOrganizationManager.loadOrganizationById(id);
        OrganizationBo bo = new OrganizationBo();
        bo.setId(id);
        bo.setOrganName(organizationInfoVo.getOrganName());
        bo.setOrganCode(organizationInfoVo.getOrganCode());
        bo.setOrganType(organizationInfoVo.getStruType());
        bo.setOrganTypeName(organizationInfoVo.getTypeName());
        bo.setParentId(organizationInfoVo.getParentId());
        bo.setParentOrganName(organizationInfoVo.getParentName());
        bo.setParentOrganType(organizationInfoVo.getParentStruType());
        bo.setParentOrganTypeName(organizationInfoVo.getParentTypeName());
        bo.setParentOrganCode(organizationInfoVo.getParentOrganCode());
        bo.setOrganFname(organizationInfoVo.getOrganFName());
        return bo;
    }

    public List<OrganizationBo> findOrganizationsByIds(List<Long> ids) {
        AssertUtil.isNotEmpty(ids, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isTrue((ids.size() <= 50 ? 1 : 0) != 0, (String)"\u4e00\u6b21\u67e5\u8be2\u6700\u591a50\u4e2a\u7ec4\u7ec7\u673a\u6784\uff01");
        ArrayList<OrganizationBo> list = new ArrayList<OrganizationBo>();
        for (Long id : ids) {
            list.add(this.findOrganizationById(id));
        }
        return list;
    }

    public OrganizationBo findOrganizationByCode(String code) {
        AssertUtil.isNotEmpty((String)code, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        OrganizationBo bo = this.sysOrganMapper.selectOrganizationBoByOrganCode(code);
        return bo;
    }

    public List<OrganizationBo> findOrganizationsByCodes(List<String> codes) {
        AssertUtil.isNotEmpty(codes, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isTrue((codes.size() <= 50 ? 1 : 0) != 0, (String)"\u4e00\u6b21\u67e5\u8be2\u6700\u591a50\u4e2a\u7ec4\u7ec7\u673a\u6784\uff01");
        List<OrganizationBo> bos = this.sysOrganMapper.selectOrganizationBosByOrganCodes(codes);
        return bos;
    }

    public List<OrganizationBo> findOrganizationsByParentId(Long id) {
        AssertUtil.isNotNull((Object)id, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        List<Long> struIds = this.sysStruMapper.getStruIdListByParentId(id);
        List<OrganizationBo> bos = new ArrayList<OrganizationBo>();
        if (struIds.size() > 0) {
            bos = this.selectOrganizationBosByStruIds(struIds);
        }
        return bos;
    }

    public List<List<OrganizationBo>> findOrganizationsByParentsIds(List<Long> ids) {
        AssertUtil.isNotEmpty(ids, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        ArrayList<List<OrganizationBo>> boss = new ArrayList<List<OrganizationBo>>();
        for (Long id : ids) {
            boss.add(this.findOrganizationsByParentId(id));
        }
        return boss;
    }

    public List<OrganizationBo> findOrganizationsByParentCode(String code) {
        AssertUtil.isNotEmpty((String)code, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        List<Long> struIds = this.sysStruMapper.getStruIdListByParentCode(code);
        List<OrganizationBo> bos = new ArrayList<OrganizationBo>();
        if (struIds.size() > 0) {
            bos = this.selectOrganizationBosByStruIds(struIds);
        }
        return bos;
    }

    public List<List<OrganizationBo>> findOrganizationsByParentsCodes(List<String> codes) {
        AssertUtil.isNotEmpty(codes, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        ArrayList<List<OrganizationBo>> boss = new ArrayList<List<OrganizationBo>>();
        for (String code : codes) {
            boss.add(this.findOrganizationsByParentCode(code));
        }
        return boss;
    }

    public Page<OrganizationBo> queryOrganizationsByParentId(PageInfo pageInfo, Long id) {
        Page<OrganizationBo> page = HussarPageUtils.convert((PageInfo)pageInfo);
        AssertUtil.isNotNull((Object)id, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        page = this.sysStruMapper.getOrganizationByParentId(page, id);
        return page;
    }

    public Page<OrganizationBo> queryOrganizationsByParentCode(PageInfo pageInfo, String code) {
        Page<OrganizationBo> page = HussarPageUtils.convert((PageInfo)pageInfo);
        AssertUtil.isNotNull((Object)code, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        Long id = this.sysStruMapper.getStruIdByOrganCode(code);
        page = this.sysStruMapper.getOrganizationByParentId(page, id);
        return page;
    }

    public List<List<OrganizationBo>> findOrgnaizationsByFid(String fid) {
        List<String> fids = Arrays.asList(fid.split(","));
        List<OrganizationBo> organs = this.selectOrganizationBosByStruIds(null);
        Map maps = organs.stream().collect(Collectors.toMap(OrganizationBo::getId, Function.identity(), (key1, key2) -> key2));
        ArrayList<List<OrganizationBo>> allParentOrgans = new ArrayList<List<OrganizationBo>>();
        for (String oneFid : fids) {
            String[] struIds = oneFid.split("/");
            ArrayList<String> ids = new ArrayList<String>(Arrays.asList(struIds));
            ids.remove(0);
            ArrayList parentOrgans = new ArrayList();
            for (String id : ids) {
                parentOrgans.add(maps.get(Long.valueOf(id)));
            }
            allParentOrgans.add(parentOrgans);
        }
        return allParentOrgans;
    }

    public List<List<OrganizationBo>> findAllParentOrganByStaffId(Long id) {
        AssertUtil.isNotNull((Object)id, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        OrganTreeInitVo staffInfo = this.hussarBaseStaffService.getStaffInfoById(id);
        String staffFid = null;
        if (!HussarUtils.isNotEmpty((Object)staffInfo)) {
            throw new BaseException("\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u67e5\u8be2\u53c2\u6570\uff01");
        }
        staffFid = staffInfo.getStruFid();
        return this.findOrgnaizationsByFid(staffFid);
    }

    public List<OrganizationBo> findParentOrganizationsByStaffId(Long id) {
        AssertUtil.isNotNull((Object)id, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        List<List<OrganizationBo>> list = this.findAllParentOrganByStaffId(id);
        if (list.size() != 0) {
            return list.get(0);
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u5148\u5173\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff01");
    }

    public List<OrganizationBo> findParentOrganizationsByStaffCode(String code) {
        AssertUtil.isNotNull((Object)code, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        List<StaffBo> staffs = this.sysStaffMapper.selectStaffBoByStaffCode(code);
        if (staffs.size() == 0) {
            throw new BaseException("\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u67e5\u8be2\u53c2\u6570\uff01");
        }
        StaffBo staff = staffs.get(0);
        Long staffId = staff.getId();
        List<OrganizationBo> bos = this.findParentOrganizationsByStaffId(staffId);
        return bos;
    }

    public List<OrganizationBo> findParentOrganizationsByUserId(Long id) {
        AssertUtil.isNotNull((Object)id, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        ApiResponse organTreeInitVoApiResponse = this.hussarBaseUserService.getUserInfoByUserId(id);
        if (Objects.isNull(organTreeInitVoApiResponse)) {
            return Lists.newArrayList();
        }
        OrganTreeInitVo userInfo = (OrganTreeInitVo)organTreeInitVoApiResponse.getData();
        String userFid = userInfo.getStruFid();
        List<List<OrganizationBo>> searchResult = this.findOrgnaizationsByFid(userFid);
        AssertUtil.isNotEmpty(searchResult, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
        return searchResult.get(0);
    }

    public List<OrganizationBo> findParentOrganizationsByUserAccount(String account) {
        AssertUtil.isNotNull((Object)account, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUsers::getUserAccount, (Object)account);
        SysUsers user = (SysUsers)this.sysUsersMapper.selectOne((Wrapper)wrapper);
        if (Objects.isNull(user)) {
            return Lists.newArrayList();
        }
        Long userId = user.getId();
        AssertUtil.isNotNull((Object)userId, (String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u67e5\u8be2\u53c2\u6570\uff01");
        List<OrganizationBo> bos = this.findParentOrganizationsByUserId(userId);
        return bos;
    }

    public List<OrganizationBo> findParentOrganizationsByOrganId(Long id) {
        AssertUtil.isNotNull((Object)id, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        String struFid = this.sysStruMapper.getStruFidByOrganId(id);
        AssertUtil.isNotNull((Object)struFid, (String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u67e5\u8be2\u53c2\u6570\uff01");
        List<OrganizationBo> bos = this.findOrgnaizationsByFid(struFid).get(0);
        return bos;
    }

    public List<OrganizationBo> findParentOrganizationsByOrganCode(String code) {
        AssertUtil.isNotNull((Object)code, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        Long struId = this.sysStruMapper.getStruIdByOrganCode(code);
        AssertUtil.isNotNull((Object)struId, (String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u67e5\u8be2\u53c2\u6570\uff01");
        List<OrganizationBo> bos = this.findParentOrganizationsByOrganId(struId);
        return bos;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortAscend(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                int compare = ((Comparable)o1.getValue()).compareTo(o2.getValue());
                return compare;
            }
        });
        LinkedHashMap returnMap = new LinkedHashMap();
        for (Map.Entry entry : list) {
            returnMap.put(entry.getKey(), entry.getValue());
        }
        return returnMap;
    }

    public List<OrganizationBo> findAllParentOrganByTypeAndUserId(String organType, Long userId) {
        AssertUtil.isNotNull((Object)organType, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isNotNull((Object)userId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        ApiResponse organTreeInitVoApiResponse = this.hussarBaseUserService.getUserInfoByUserId(userId);
        if (Objects.isNull(organTreeInitVoApiResponse)) {
            return Lists.newArrayList();
        }
        OrganTreeInitVo userInfo = (OrganTreeInitVo)organTreeInitVoApiResponse.getData();
        String userFid = null;
        if (!HussarUtils.isNotEmpty((Object)userInfo)) {
            throw new BaseException("\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u67e5\u8be2\u53c2\u6570\uff01");
        }
        userFid = userInfo.getStruFid();
        AssertUtil.isNotNull((Object)userFid, (String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u67e5\u8be2\u53c2\u6570\uff01");
        List<List<OrganizationBo>> allParentOrgans = this.findOrgnaizationsByFid(userFid);
        Map<OrganizationBo, Integer> map = new LinkedHashMap();
        for (List<OrganizationBo> orgBos : allParentOrgans) {
            Collections.reverse(orgBos);
            for (int i = 0; i < orgBos.size(); ++i) {
                if (!organType.equals(orgBos.get(i).getOrganType())) continue;
                map.put(orgBos.get(i), i);
            }
        }
        if (map.size() == 0) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff01");
        }
        map = LocalHussarBaseOrganizationBoServiceImpl.sortAscend(map);
        List<OrganizationBo> keys = map.keySet().stream().collect(Collectors.toList());
        return keys;
    }

    public OrganizationBo findOrganByTypeAndUserId(String organType, Long userId) {
        AssertUtil.isNotNull((Object)organType, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isNotNull((Object)userId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        List<OrganizationBo> searchResult = this.findAllParentOrganByTypeAndUserId(organType, userId);
        AssertUtil.isNotEmpty(searchResult, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
        return searchResult.get(0);
    }

    public OrganizationBo findOrganByTypeAndUserAccount(String organType, String account) {
        AssertUtil.isNotNull((Object)organType, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isNotNull((Object)account, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUsers::getUserAccount, (Object)account);
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectOne((Wrapper)wrapper);
        AssertUtil.isNotNull((Object)sysUsers, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
        Long userId = sysUsers.getId();
        if (HussarUtils.isEmpty((Object)userId)) {
            throw new BaseException("\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u67e5\u8be2\u53c2\u6570\uff01");
        }
        return this.findOrganByTypeAndUserId(organType, userId);
    }

    public List<OrganizationBo> findAllParentOrganByTypeNameAndUserId(String organTypeName, Long userId) {
        AssertUtil.isNotNull((Object)organTypeName, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isNotNull((Object)userId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        String organType = this.sysOrganMapper.getOrganTypeByTypeName(organTypeName);
        if (HussarUtils.isNotEmpty((Object)organType)) {
            return this.findAllParentOrganByTypeAndUserId(organType, userId);
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6570\u636e\uff01");
    }

    public OrganizationBo findOrganByTypeNameAndUserId(String typeName, Long userId) {
        AssertUtil.isNotNull((Object)typeName, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isNotNull((Object)userId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        List<OrganizationBo> searchResult = this.findAllParentOrganByTypeNameAndUserId(typeName, userId);
        AssertUtil.isNotEmpty(searchResult, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
        return searchResult.get(0);
    }

    public OrganizationBo findOrganByTypeNameAndUserAccount(String typeName, String account) {
        AssertUtil.isNotNull((Object)typeName, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isNotNull((Object)account, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUsers::getUserAccount, (Object)account);
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectOne((Wrapper)wrapper);
        AssertUtil.isNotNull((Object)sysUsers, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
        Long userId = sysUsers.getId();
        if (HussarUtils.isNotEmpty((Object)userId)) {
            return this.findOrganByTypeNameAndUserId(typeName, userId);
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6570\u636e\uff01");
    }

    public List<OrganizationBo> findAllParentOrganByTypeAndStaffId(String organType, Long staffId) {
        AssertUtil.isNotNull((Object)organType, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isNotNull((Object)staffId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        OrganTreeInitVo staffInfo = this.hussarBaseStaffService.getStaffInfoById(staffId);
        String staffFid = null;
        if (!HussarUtils.isNotEmpty((Object)staffInfo)) {
            throw new BaseException("\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u67e5\u8be2\u53c2\u6570");
        }
        staffFid = staffInfo.getStruFid();
        List<List<OrganizationBo>> allParentOrgans = this.findOrgnaizationsByFid(staffFid);
        ArrayList<OrganizationBo> sameTypeOrgans = new ArrayList<OrganizationBo>();
        Map<OrganizationBo, Integer> map = new LinkedHashMap();
        for (List<OrganizationBo> orgBos : allParentOrgans) {
            Collections.reverse(orgBos);
            for (int i = 0; i < orgBos.size(); ++i) {
                if (!organType.equals(orgBos.get(i).getOrganType())) continue;
                sameTypeOrgans.add(orgBos.get(i));
                map.put(orgBos.get(i), i);
            }
        }
        if (HussarUtils.isNotEmpty(sameTypeOrgans)) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
        }
        map = LocalHussarBaseOrganizationBoServiceImpl.sortAscend(map);
        List<OrganizationBo> keys = map.keySet().stream().collect(Collectors.toList());
        return keys;
    }

    public OrganizationBo findOrganByTypeAndStaffId(String organType, Long staffId) {
        AssertUtil.isNotNull((Object)organType, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isNotNull((Object)staffId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        List<OrganizationBo> searchResult = this.findAllParentOrganByTypeAndStaffId(organType, staffId);
        AssertUtil.isNotEmpty(searchResult, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
        return searchResult.get(0);
    }

    public OrganizationBo findOrganByTypeAndStaffCode(String organType, String staffCode) {
        AssertUtil.isNotNull((Object)organType, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isNotNull((Object)staffCode, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        List<StaffBo> staffs = this.sysStaffMapper.selectStaffBoByStaffCode(staffCode);
        if (HussarUtils.isEmpty(staffs)) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff01");
        }
        StaffBo staff = staffs.get(0);
        Long staffId = staff.getId();
        List<OrganizationBo> searchResult = this.findAllParentOrganByTypeAndStaffId(organType, staffId);
        AssertUtil.isNotEmpty(searchResult, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
        return searchResult.get(0);
    }

    public List<OrganizationBo> findAllParentOrganByTypeNameAndStaffId(String organTypeName, Long staffId) {
        AssertUtil.isNotNull((Object)organTypeName, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        AssertUtil.isNotNull((Object)staffId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        String organType = this.sysOrganMapper.getOrganTypeByTypeName(organTypeName);
        if (HussarUtils.isNotEmpty((Object)organType)) {
            return this.findAllParentOrganByTypeAndStaffId(organType, staffId);
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u5148\u5173\u6570\u636e");
    }

    public OrganizationBo findOrganByTypeNameAndStaffId(String typeName, Long staffId) {
        AssertUtil.isNotNull((Object)typeName, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isNotNull((Object)staffId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        List<OrganizationBo> searchResult = this.findAllParentOrganByTypeNameAndStaffId(typeName, staffId);
        AssertUtil.isNotEmpty(searchResult, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
        return searchResult.get(0);
    }

    public OrganizationBo findOrganByTypeNameAndStaffCode(String typeName, String staffCode) {
        AssertUtil.isNotNull((Object)typeName, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isNotNull((Object)staffCode, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        List<StaffBo> staffs = this.sysStaffMapper.selectStaffBoByStaffCode(staffCode);
        if (HussarUtils.isEmpty(staffs)) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff01");
        }
        StaffBo staff = staffs.get(0);
        Long staffId = staff.getId();
        List<OrganizationBo> searchResult = this.findAllParentOrganByTypeNameAndStaffId(typeName, staffId);
        AssertUtil.isNotEmpty(searchResult, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
        return searchResult.get(0);
    }

    public OrganizationBo findOrganByTypeAndOrganId(String organType, Long organId) {
        AssertUtil.isNotNull((Object)organType, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isNotNull((Object)organId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        List<OrganizationBo> orgBos = this.findParentOrganizationsByOrganId(organId);
        Collections.reverse(orgBos);
        for (OrganizationBo orgBo : orgBos) {
            if (!orgBo.getOrganType().equals(organType)) continue;
            return orgBo;
        }
        return null;
    }

    public OrganizationBo findOrganByTypeAndOrganCode(String organType, String organCode) {
        AssertUtil.isNotNull((Object)organType, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isNotNull((Object)organCode, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        List<OrganizationBo> orgBos = this.findParentOrganizationsByOrganCode(organCode);
        Collections.reverse(orgBos);
        for (OrganizationBo orgBo : orgBos) {
            if (!orgBo.getOrganType().equals(organType)) continue;
            return orgBo;
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7c7b\u578b\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff01");
    }

    public OrganizationBo findOrganByTypeNameAndOrganId(String typeName, Long organId) {
        AssertUtil.isNotNull((Object)typeName, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isNotNull((Object)organId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        List<OrganizationBo> orgBos = this.findParentOrganizationsByOrganId(organId);
        Collections.reverse(orgBos);
        for (OrganizationBo orgBo : orgBos) {
            if (!orgBo.getOrganTypeName().equals(typeName)) continue;
            return orgBo;
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7c7b\u578b\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff01");
    }

    public OrganizationBo findOrganByTypeNameAndOrganCode(String typeName, String organCode) {
        AssertUtil.isNotNull((Object)typeName, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isNotNull((Object)organCode, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        List<OrganizationBo> orgBos = this.findParentOrganizationsByOrganCode(organCode);
        Collections.reverse(orgBos);
        for (OrganizationBo orgBo : orgBos) {
            if (!orgBo.getOrganTypeName().equals(typeName)) continue;
            return orgBo;
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7c7b\u578b\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\uff01");
    }

    public List<OrganizationTreeVo> lazyLoadOrganizationTree(Long parentId, String organProperty) {
        AssertUtil.isNotNull((Object)parentId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        AssertUtil.isNotNull((Object)organProperty, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        return this.queryOrganizationManager.lazyLoadOrganizationTree(parentId, organProperty);
    }

    public Page<SearchOrganizationVo> searchOrganization(PageInfo pageInfo, String name) {
        return this.queryOrganizationManager.searchOrganization(pageInfo, name);
    }

    public List<OrganizationBo> searchOrganizationByUserId(Long userId) {
        AssertUtil.isNotNull((Object)userId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        List<Long> struIds = this.sysUsersMapper.selectParentStruIdsByUserId(userId);
        if (HussarUtils.isNotEmpty(struIds)) {
            return this.selectOrganizationBosByStruIds(struIds);
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6570\u636e\uff01");
    }

    public List<OrganizationTreeVo> backOrganizationTree(Long id) {
        AssertUtil.isNotNull((Object)id, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570\uff01");
        return this.queryOrganizationManager.backOrganizationTree(id);
    }

    public List<Long> getPostId(List<Long> ids) {
        List sysStruPosts;
        List<Long> postIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty(ids) && HussarUtils.isNotEmpty((Object)(sysStruPosts = this.sysStruPostService.list((Wrapper)new LambdaQueryWrapper().in(SysStruPost::getStruId, ids))))) {
            postIds = sysStruPosts.stream().map(SysStruPost::getPostId).distinct().collect(Collectors.toList());
        }
        return postIds;
    }

    public Page<SearchOrganVo> searchOrgan(PageInfo pageInfo, SearchOrganUserDto searchOrganUserDto) {
        return this.queryOrganizationManager.searchOrganAllowPinyin(pageInfo, searchOrganUserDto);
    }

    public List<OrganVo> getAllSubOrgan(Long organId) {
        return this.queryOrganizationManager.getAllSubOrgan(organId);
    }

    public List<Long> getOrganIdsByUserIds(String userIds) {
        if (HussarUtils.isEmpty((Object)userIds)) {
            return Collections.emptyList();
        }
        List<Long> result = new ArrayList<Long>();
        String[] userIdList = userIds.split(",");
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(userIdList));
        if (HussarUtils.isNotEmpty(ids)) {
            result = this.sysStruMapper.getOrganIdsByUserIds(LambdaQueryUtil.getSplitList(ids));
            result = result.stream().distinct().collect(Collectors.toList());
        }
        return result;
    }

    public List<Long> getOrganRange(String organRangeIds, String organIds) {
        String[] oldOrganIds = organRangeIds.split(",");
        ArrayList<String> oldOrganIdList = new ArrayList<String>(Arrays.asList(oldOrganIds));
        String[] newOrganIds = organIds.split(",");
        ArrayList<String> newOrganIdList = new ArrayList<String>(Arrays.asList(newOrganIds));
        if (HussarUtils.isNotEmpty((Object)organRangeIds)) {
            List<Long> organIdList = oldOrganIdList.stream().map(s -> Long.parseLong(s.trim())).distinct().collect(Collectors.toList());
            List<Long> subOrganIds = this.queryOrganizationManager.getSubOrgans(organIdList);
            if (HussarUtils.isNotEmpty((Object)organIds)) {
                List<Long> ids = newOrganIdList.stream().map(s -> Long.parseLong(s.trim())).distinct().collect(Collectors.toList());
                ids.retainAll(subOrganIds);
                return ids;
            }
            return new ArrayList<Long>();
        }
        return new ArrayList<Long>();
    }

    public List<UserOrganPostVo> getOrganByUserIds(List<Long> userIds) {
        return this.sysStruUserMapper.getOrganByUserIds(LambdaQueryUtil.getSplitList(userIds), null);
    }

    public List<Long> getSubOrganByCurrentUser(Long userId) {
        return this.queryOrganizationManager.getSubOrganByUser(userId);
    }

    public List<Long> getParentOrganIdsByOrganIds(List<Long> organdIds) {
        if (CollectionUtils.isEmpty(organdIds)) {
            return Collections.emptyList();
        }
        return this.sysStruMapper.getParentOrganIdsByOrganIds(organdIds);
    }

    public List<OrganTreeInitVo> getOrganTreeInitVos() {
        List<OrganTreeInitVo> organs = this.sysStruMapper.queryAllOrganTree();
        for (OrganTreeInitVo organ : organs) {
            organ.setChangedLevel(organ.getStruLevel() + 1);
        }
        OrganTreeInitVo firstOrgan = new OrganTreeInitVo();
        firstOrgan.setId((Serializable)OrganConstants.ROOT_ORGAN_ID);
        firstOrgan.setLabel("\u516c\u53f8\u5185\u90e8\u7ec4\u7ec7");
        firstOrgan.setParentId((Serializable)Long.valueOf(0L));
        firstOrgan.setStruLevel(0);
        firstOrgan.setChangedLevel(1);
        List<OrganTreeInitVo> organTreeInitVos = this.sysStruMapper.queryChildrenOrgan(OrganConstants.ROOT_ORGAN_ID, false, false);
        if (organTreeInitVos.size() != 0) {
            firstOrgan.setHasChildren(Boolean.valueOf(true));
        }
        organs.add(firstOrgan);
        OrganTreeInitVo twoOrgan = new OrganTreeInitVo();
        twoOrgan.setId((Serializable)Long.valueOf(12L));
        twoOrgan.setLabel("\u516c\u53f8\u5916\u90e8\u7ec4\u7ec7");
        twoOrgan.setParentId((Serializable)Long.valueOf(0L));
        twoOrgan.setStruLevel(0);
        twoOrgan.setChangedLevel(1);
        List<OrganTreeInitVo> vos = this.sysStruMapper.queryChildrenOrgan(Long.parseLong("12"), false, false);
        if (vos.size() != 0) {
            twoOrgan.setHasChildren(Boolean.valueOf(true));
        }
        organs.add(twoOrgan);
        List<OrganTreeInitVo> organTree = this.getOrganTree(organs);
        return organTree;
    }

    public List<OrganVo> getSimpleOrganByIds(List<Long> ids) {
        if (HussarUtils.isEmpty(ids)) {
            return new ArrayList<OrganVo>();
        }
        return this.sysStruMapper.getOrganNameAndId(ids);
    }

    public List<OrganizationBo> getAllOrganInfo() {
        return this.sysOrganMapper.selectOrganizationBosByStruIds(null);
    }

    private List<OrganTreeInitVo> getOrganTree(List<OrganTreeInitVo> organs) {
        HashMap<Serializable, OrganTreeInitVo> idAndItem = new HashMap<Serializable, OrganTreeInitVo>();
        for (OrganTreeInitVo organTreeInitVo : organs) {
            idAndItem.put(organTreeInitVo.getId(), organTreeInitVo);
        }
        ArrayList<Serializable> highestIdList = new ArrayList<Serializable>();
        for (OrganTreeInitVo organ : organs) {
            OrganTreeInitVo organTreeInitVo = (OrganTreeInitVo)idAndItem.get(organ.getParentId());
            if (ToolUtil.isNotEmpty((Object)organTreeInitVo)) {
                organTreeInitVo.getChildren().add(organ);
                organ.setChangedLevel(organTreeInitVo.getChangedLevel() + 1);
                organTreeInitVo.setHasChildren(Boolean.valueOf(true));
                continue;
            }
            highestIdList.add(organ.getId());
        }
        ArrayList<OrganTreeInitVo> arrayList = new ArrayList<OrganTreeInitVo>();
        for (Long l : highestIdList) {
            arrayList.add((OrganTreeInitVo)idAndItem.get(l));
        }
        return arrayList;
    }

    public List<OrganizationTreeVo> organSearch(String name) {
        List<Object> organizationTreeVos = new ArrayList<OrganizationTreeVo>();
        List<OrganUserTreeVo> organUserTreeOnlyOrgan = this.sysStruMapper.getOrganTreeOnlyOrgan(null, name);
        if (HussarUtils.isEmpty(organUserTreeOnlyOrgan)) {
            return organizationTreeVos;
        }
        if (HussarUtils.isEmpty((Object)name)) {
            organizationTreeVos = HussarUtils.copy(organUserTreeOnlyOrgan, OrganizationTreeVo.class);
        } else {
            OrganizationTreeVo treeVo;
            List<Long> struIds = organUserTreeOnlyOrgan.stream().map(AbstractNoIconHussarLazyTreeDefinition::getId).collect(Collectors.toList());
            List<Long> finalStruIds = this.queryOrganizationManager.getParentStruByIds(struIds);
            List<OrganUserTreeVo> organTreeOnlyOrgan = this.sysStruMapper.getOrganTreeOnlyOrgan(finalStruIds, null);
            organizationTreeVos = HussarUtils.copy(organTreeOnlyOrgan, OrganizationTreeVo.class);
            for (OrganizationTreeVo organizationTreeVo : organizationTreeVos) {
                organizationTreeVo.setDisabled(Boolean.valueOf(false));
            }
            List interiorOrganList = organTreeOnlyOrgan.stream().filter(o -> HussarUtils.equals((Object)o.getParentId(), (Object)11L)).collect(Collectors.toList());
            List list = organUserTreeOnlyOrgan.stream().filter(o -> HussarUtils.equals((Object)o.getParentId(), (Object)12L)).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(interiorOrganList)) {
                treeVo = new OrganizationTreeVo();
                treeVo.setId((Serializable)Long.valueOf(11L));
                treeVo.setLabel("\u516c\u53f8\u5185\u90e8\u7ec4\u7ec7");
                organizationTreeVos.add(treeVo);
            }
            if (HussarUtils.isNotEmpty(list)) {
                treeVo = new OrganizationTreeVo();
                treeVo.setId((Serializable)Long.valueOf(12L));
                treeVo.setLabel("\u516c\u53f8\u5916\u90e8\u7ec4\u7ec7");
                organizationTreeVos.add(treeVo);
            }
        }
        return HussarTreeParser.getTreeList(organizationTreeVos);
    }

    private List<OrganizationBo> selectOrganizationBosByStruIds(List<Long> ids) {
        List<OrganizationBo> organizationBos = this.sysOrganMapper.selectOrganizationBosByStruIds(ids);
        if (HussarUtils.isEmpty(organizationBos)) {
            return new ArrayList<OrganizationBo>();
        }
        if (HussarUtils.isEmpty(ids)) {
            return organizationBos;
        }
        return organizationBos.stream().sorted((o1, o2) -> {
            int i = ids.indexOf(o1.getId());
            int j = ids.indexOf(o2.getId());
            return Integer.compare(i, j);
        }).collect(Collectors.toList());
    }
}

