/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.manager.EditBatchOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.editBatchOutsideUserManagerImpl")
public class EditBatchOutsideUserManagerImpl
extends CommonOutsideUserManager
implements EditBatchOutsideUserManager {
    private static Logger logger = LoggerFactory.getLogger(EditBatchOutsideUserManagerImpl.class);
    @Resource
    private IHussarBasePostService hussarBasePostService;

    @Override
    public R<EditOutsideUserDto> editBatchUsers(List<EditOutsideUserDto> users) {
        List<Long> existStruIds;
        boolean canEdit = false;
        if (HussarUtils.isNotEmpty(users) && users.size() <= 50) {
            canEdit = true;
        }
        if (!canEdit) {
            throw new BaseException("\u6279\u91cf\u64cd\u4f5c\u6700\u591a\u53ea\u5141\u8bb8\u4e00\u6b21\u64cd\u4f5c50");
        }
        R result = new R();
        ArrayList errors = new ArrayList();
        boolean getLoginUpperOpen = this.hussarLoginConfigService.getLoginUpperOpen();
        ArrayList<Long> struIds = new ArrayList();
        for (EditOutsideUserDto editOutsideUserDto : users) {
            List organIds;
            SysUsers sysUsers;
            boolean convert;
            String account = editOutsideUserDto.getUserAccount();
            boolean bl = convert = !getLoginUpperOpen && !OrganConstants.EXCLUDE_USERS.contains(account);
            if (convert) {
                account = account.toUpperCase();
            }
            if ((sysUsers = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()), false)) == null) {
                OrganUtil.addErrorMsg(errors, (Object)editOutsideUserDto, (String)"userAccount", (String[])new String[]{"\u7528\u6237\u8d26\u53f7\u4e0d\u5b58\u5728"});
            }
            if (!HussarUtils.isNotEmpty((Object)(organIds = editOutsideUserDto.getOrganIds()))) continue;
            organIds = organIds.stream().distinct().collect(Collectors.toList());
            editOutsideUserDto.setOrganIds(organIds);
            struIds.addAll(organIds);
        }
        if (HussarUtils.isNotEmpty(struIds) && (existStruIds = this.sysStruMapper.selectExistIdByIds(struIds = struIds.stream().distinct().collect(Collectors.toList()))).size() != struIds.size()) {
            for (EditOutsideUserDto user : users) {
                List organIds = user.getOrganIds();
                if (!HussarUtils.isNotEmpty((Object)organIds)) continue;
                StringBuilder msg = new StringBuilder();
                boolean errorFlag = false;
                for (Long organId : organIds) {
                    if (existStruIds.contains(organId)) continue;
                    msg.append(organId).append("\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff1b");
                    errorFlag = true;
                }
                if (!errorFlag) continue;
                OrganUtil.addErrorMsg(errors, (Object)user, (String)"organIds", (String[])new String[]{msg.toString()});
            }
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
            LinkedHashSet<SysStaff> linkedHashSet = new LinkedHashSet<SysStaff>();
            LinkedHashSet<SysUsers> sysUsersCollection = new LinkedHashSet<SysUsers>();
            LinkedHashSet<SysStruStaff> struStaffCollection = new LinkedHashSet<SysStruStaff>();
            LinkedHashSet<SysStruUser> struUserCollection = new LinkedHashSet<SysStruUser>();
            HashSet<Long> userIds = new HashSet<Long>();
            HashSet<Long> staffIds = new HashSet<Long>();
            LinkedHashSet<SysUserPost> userPostCollection = new LinkedHashSet<SysUserPost>();
            HashSet<Long> userIds4Post = new HashSet<Long>();
            List postList = this.hussarBasePostService.list();
            Map<String, Long> postMap = postList.stream().collect(Collectors.toMap(SysPost::getPostCode, SysPost::getId));
            for (EditOutsideUserDto userDto : users) {
                boolean convert;
                String account = userDto.getUserAccount();
                boolean bl = convert = !getLoginUpperOpen && !OrganConstants.EXCLUDE_USERS.contains(account);
                if (convert) {
                    account = account.toUpperCase();
                }
                SysUsers sysUsers = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()), false);
                SysStaff sysStaff = (SysStaff)this.sysStaffService.getById((Serializable)sysUsers.getEmployeeId());
                this.initializationEdit(userDto, sysStaff, sysUsers);
                if (HussarUtils.isNotEmpty((Object)userDto.getOrganIds())) {
                    this.handleUserStaff(userDto, sysUsers, struStaffCollection, struUserCollection);
                    userIds.add(sysUsers.getId());
                    staffIds.add(sysUsers.getEmployeeId());
                }
                if (HussarUtils.isNotEmpty((Object)userDto.getJobCode()) && userDto.getJobCode().equals(sysUsers.getJobCode())) {
                    SysUserPost sysUserPost = new SysUserPost();
                    sysUserPost.setUserId(sysUsers.getId());
                    sysUserPost.setPostId(postMap.get(userDto.getJobCode()));
                    sysUserPost.setRelateType("0");
                    userPostCollection.add(sysUserPost);
                    userIds4Post.add(sysUsers.getId());
                }
                linkedHashSet.add(sysStaff);
                sysUsersCollection.add(sysUsers);
                dataMappings.add(new DataMapping(sysUsers.getId(), sysUsers.getUserAccount()));
            }
            if (HussarUtils.isNotEmpty(struIds)) {
                this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getUserId, userIds));
                this.sysStruStaffService.remove((Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, staffIds));
                this.sysStruUserService.saveBatch(struUserCollection);
                this.sysStruStaffService.saveBatch(struStaffCollection);
            }
            result.setSuccessList(dataMappings);
            this.sysStaffService.updateBatchById(linkedHashSet);
            this.sysUsersService.updateBatchById(sysUsersCollection);
            if (HussarUtils.isNotEmpty(userIds)) {
                this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().in(SysStruUser::getUserId, userIds));
                this.sysStruUserService.saveBatch(struUserCollection);
            }
            if (HussarUtils.isNotEmpty(staffIds)) {
                this.sysStruStaffService.remove((Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, staffIds));
                this.sysStruStaffService.saveBatch(struStaffCollection);
            }
            if (HussarUtils.isNotEmpty(userIds4Post)) {
                this.sysUserPostService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysUserPost::getUserId, userIds4Post)).eq(SysUserPost::getRelateType, (Object)"0"));
                this.sysUserPostService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().isNull(SysUserPost::getPostId)).or()).eq(SysUserPost::getPostId, (Object)""));
                this.sysUserPostService.saveBatch(userPostCollection);
            }
        }
        return result;
    }

    private void handleUserStaff(EditOutsideUserDto userDto, SysUsers sysUsers, Set<SysStruStaff> struStaffCollection, Set<SysStruUser> struUserCollection) {
        List organIds = userDto.getOrganIds();
        if (HussarUtils.isNotEmpty((Object)organIds)) {
            for (Long organId : organIds) {
                SysStruStaff sysStruStaff = new SysStruStaff();
                sysStruStaff.setStruId(organId);
                sysStruStaff.setStaffId(sysUsers.getEmployeeId());
                struStaffCollection.add(sysStruStaff);
                SysStruUser sysStruUser = new SysStruUser();
                sysStruUser.setStruId(organId);
                sysStruUser.setUserId(sysUsers.getId());
                struUserCollection.add(sysStruUser);
            }
        }
    }
}

