/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddBatchOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.LinkedMultiValueMap;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.addBatchOutsideUserManagerImpl")
public class AddBatchOutsideUserManagerImpl
extends CommonOutsideUserManager
implements AddBatchOutsideUserManager {
    @Resource
    private IHussarBasePostService hussarBasePostService;

    @Override
    public R<AddOutsideUserDto> addBatchUsers(List<AddOutsideUserDto> users, boolean dealWithSelf) {
        List<Long> existStruIds;
        boolean canAdd = false;
        if (HussarUtils.isNotEmpty(users) && users.size() <= 50) {
            canAdd = true;
        }
        if (!canAdd) {
            throw new BaseException("\u6279\u91cf\u64cd\u4f5c\u6700\u591a\u53ea\u5141\u8bb8\u4e00\u6b21\u64cd\u4f5c50");
        }
        R result = new R();
        List errors = OrganUtil.validateMany(users);
        boolean getLoginUpperOpen = this.hussarLoginConfigService.getLoginUpperOpen();
        ArrayList<Long> struIds = new ArrayList();
        for (AddOutsideUserDto addOutsideUserDto : users) {
            List organIds;
            boolean convert;
            String userAccount = StringUtils.trimToEmpty((String)addOutsideUserDto.getUserAccount());
            boolean bl = convert = !getLoginUpperOpen && !OrganConstants.EXCLUDE_USERS.contains(userAccount);
            if (this.duplicateUserAccount(convert, addOutsideUserDto, users)) {
                OrganUtil.addErrorMsg((List)errors, (Object)addOutsideUserDto, (String)"userAccount", (String[])new String[]{"\u7528\u6237\u8d26\u53f7\u91cd\u590d"});
            }
            Long departmentId = addOutsideUserDto.getDepartmentId();
            List<Object> list = organIds = HussarUtils.isNotEmpty((Object)addOutsideUserDto.getOrganIds()) ? addOutsideUserDto.getOrganIds() : new ArrayList();
            if (HussarUtils.isEmpty((Object)departmentId) && HussarUtils.isEmpty((Object)organIds)) {
                OrganUtil.addErrorMsg((List)errors, (Object)addOutsideUserDto, (String)"departmentId", (String[])new String[]{"\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a"});
                OrganUtil.addErrorMsg((List)errors, (Object)addOutsideUserDto, (String)"organIds", (String[])new String[]{"\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a"});
            }
            if (HussarUtils.isNotEmpty((Object)departmentId)) {
                organIds.add(departmentId);
            }
            if (!HussarUtils.isNotEmpty((Object)organIds)) continue;
            organIds = organIds.stream().distinct().collect(Collectors.toList());
            addOutsideUserDto.setOrganIds(organIds);
            struIds.addAll(organIds);
        }
        if (HussarUtils.isNotEmpty(struIds) && (existStruIds = this.sysStruMapper.selectExistIdByIds(struIds = struIds.stream().distinct().collect(Collectors.toList()))).size() != struIds.size()) {
            for (AddOutsideUserDto user : users) {
                Long departmentId = user.getDepartmentId();
                List organIds = user.getOrganIds();
                StringBuilder msg = new StringBuilder();
                boolean errorFlag = false;
                for (Object organId : organIds) {
                    if (existStruIds.contains(organId) || ((Long)organId).equals(departmentId)) continue;
                    msg.append(organId).append("\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff1b");
                    errorFlag = true;
                }
                if (!existStruIds.contains(departmentId)) {
                    OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"departmentId", (String[])new String[]{"\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728"});
                }
                if (!errorFlag) continue;
                OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"organIds", (String[])new String[]{msg.toString()});
            }
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
            LinkedHashSet<SysStruStaff> linkedHashSet = new LinkedHashSet<SysStruStaff>();
            LinkedHashSet<SysStruUser> sysStruUserCollection = new LinkedHashSet<SysStruUser>();
            LinkedHashSet<SysStaff> sysStaffCollection = new LinkedHashSet<SysStaff>();
            LinkedHashSet<SysUsers> sysUsersCollection = new LinkedHashSet<SysUsers>();
            LinkedHashSet<SysUserRole> sysUserRoleCollection = new LinkedHashSet<SysUserRole>();
            LinkedHashSet<SysUserPost> sysUserPostCollection = new LinkedHashSet<SysUserPost>();
            LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
            for (AddOutsideUserDto user : users) {
                multiValueMap.add((Object)user.getDepartmentId(), (Object)user);
            }
            List postList = this.hussarBasePostService.list();
            Map<String, Long> postMap = postList.stream().collect(Collectors.toMap(SysPost::getPostCode, SysPost::getId));
            for (Map.Entry entry : multiValueMap.entrySet()) {
                List children = (List)entry.getValue();
                for (AddOutsideUserDto userDto : children) {
                    SysStaff sysStaff = new SysStaff();
                    SysUsers sysUsers = new SysUsers();
                    SysUserRole sysUserRole = new SysUserRole();
                    SysUserPost sysUserPost = new SysUserPost();
                    this.initializationAdd(dealWithSelf, getLoginUpperOpen, userDto, linkedHashSet, sysStruUserCollection, sysStaff, sysUsers);
                    this.addStaffUser(userDto, sysStaff, sysUsers, sysUserRole);
                    sysStaffCollection.add(sysStaff);
                    sysUsersCollection.add(sysUsers);
                    sysUserRoleCollection.add(sysUserRole);
                    if (HussarUtils.isNotEmpty((Object)userDto.getJobCode())) {
                        sysUserPost.setUserId(sysUsers.getId());
                        sysUserPost.setPostId(postMap.get(userDto.getJobCode()));
                        sysUserPost.setRelateType("0");
                        sysUserPostCollection.add(sysUserPost);
                    }
                    if (HussarUtils.isNotEmpty((Object)userDto.getConcrntDeptNoList())) {
                        List concrntStruList = userDto.getConcrntDeptNoList();
                        for (int i = 0; i < concrntStruList.size(); ++i) {
                            SysStruStaff sysStruStaffTemp = new SysStruStaff();
                            SysStruUser sysStruUserTemp = new SysStruUser();
                            sysStruUserTemp.setUserId(sysUsers.getId());
                            sysStruUserTemp.setStruId((Long)concrntStruList.get(i));
                            sysStruStaffTemp.setStaffId(sysStaff.getId());
                            sysStruStaffTemp.setStruId((Long)concrntStruList.get(i));
                            linkedHashSet.add(sysStruStaffTemp);
                            sysStruUserCollection.add(sysStruUserTemp);
                        }
                    }
                    dataMappings.add(new DataMapping(sysUsers.getId(), sysUsers.getUserAccount()));
                }
            }
            result.setSuccessList(dataMappings);
            this.sysStruStaffService.saveBatch(linkedHashSet);
            this.sysStruUserService.saveBatch(sysStruUserCollection);
            this.sysStaffService.saveBatch(sysStaffCollection);
            this.sysUsersService.saveBatch(sysUsersCollection);
            this.userRoleService.saveBatch(sysUserRoleCollection);
            if (HussarUtils.isNotEmpty(sysUserPostCollection)) {
                this.sysUserPostService.saveBatch(sysUserPostCollection);
            }
        }
        return result;
    }

    private void addStaffUser(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, SysUsers sysUsers, SysUserRole sysUserRole) {
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setIsLeaf("0");
        sysStru.setStruPath("");
        sysStru.setOrganId(sysOrgan.getId());
        sysStaff.setName(sysOrgan.getOrganName());
        sysStaff.setStruId(sysStru.getId());
        if (StringUtils.isBlank((CharSequence)sysUsers.getPassword())) {
            String pass = "";
            pass = this.createUserConfigService.getCreateUserSendEmail() != false && this.createUserConfigService.getCreateUserUseDefaultPass() == false ? "123456" : this.pwdConfigService.getDefaultPassword();
            String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
            sysUsers.setPassword(pwd);
        }
        sysUsers.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
        sysUsers.setAccountStatus(UserStatus.OK.getCode());
        sysUsers.setSecurityLevel(Integer.valueOf(1));
        sysUsers.setMaxSessions(Integer.valueOf(1));
        sysUsers.setLoginIpLimit("0");
        sysUsers.setLoginTimeLimit("0");
        sysUsers.setIsSys("0");
        sysUsers.setIsCpublic("0");
        sysUsers.setCorporationId(sysStru.getParentId());
        sysUsers.setDepartmentId(sysStru.getParentId());
        sysUsers.setEmployeeId(sysStru.getId());
        sysUsers.setTypeProperty("1");
        sysUserRole.setUserId(sysUsers.getId());
        sysUserRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
        sysUserRole.setAdminOption("1");
    }

    private void initializationAdd(boolean dealWithSelf, boolean getLoginUpperOpen, int level, Integer struOrder, Integer userOrder, AddOutsideUserDto userDto, SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, SysUsers sysUsers) {
        boolean convert;
        long sysStruId = IdWorker.getId((Object)sysStru);
        long sysOrganId = IdWorker.getId((Object)sysOrgan);
        long sysStaffId = IdWorker.getId((Object)sysStaff);
        long sysUserId = IdWorker.getId((Object)sysUsers);
        Long departmentId = userDto.getDepartmentId();
        String userAccount = StringUtils.trimToEmpty((String)userDto.getUserAccount());
        String userName = StringUtils.trimToEmpty((String)userDto.getUserName());
        String weChat = StringUtils.trimToEmpty((String)userDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)userDto.getMobile());
        String telephone = StringUtils.trimToEmpty((String)userDto.getTelephone());
        String staffPosition = StringUtils.trimToEmpty((String)userDto.getStaffPosition());
        String sex = StringUtils.trimToEmpty((String)userDto.getSex());
        String birthday = StringUtils.trimToEmpty((String)userDto.getBirthday());
        String idcard = StringUtils.trimToEmpty((String)userDto.getIdcard());
        String address = StringUtils.trimToEmpty((String)userDto.getAddress());
        String workId = StringUtils.trimToEmpty((String)userDto.getWorkId());
        String workDate = StringUtils.trimToEmpty((String)userDto.getWorkDate());
        String graduateDate = StringUtils.trimToEmpty((String)userDto.getGraduateDate());
        String graduateSchool = StringUtils.trimToEmpty((String)userDto.getGraduateSchool());
        String secure = StringUtils.trimToEmpty((String)userDto.getSecure());
        boolean bl = convert = !getLoginUpperOpen && !OrganConstants.EXCLUDE_USERS.contains(userAccount);
        if (convert) {
            userAccount = userAccount.toUpperCase();
        }
        sysStru.setId(Long.valueOf(sysStruId));
        sysStru.setOrganId(Long.valueOf(sysOrganId));
        sysStru.setParentId(departmentId);
        sysStru.setStruType("9");
        sysStru.setOrganAlias(userName);
        sysStru.setStaffPosition(staffPosition);
        sysStru.setIsEmployee("1");
        sysStru.setStruLevel(Integer.valueOf(level));
        Integer n = struOrder;
        Integer n2 = struOrder = Integer.valueOf(struOrder + 1);
        sysStru.setStruOrder(n);
        sysStaff.setId(Long.valueOf(sysStaffId));
        sysStaff.setStruId(Long.valueOf(sysStruId));
        sysStaff.setName(userName);
        sysStaff.setAddress(address);
        sysStaff.setBirthday(birthday);
        sysStaff.setSex(sex);
        sysStaff.setIdcard(idcard);
        sysStaff.setGraduateDate(graduateDate);
        sysStaff.setGraduateSchool(graduateSchool);
        sysStaff.setWorkDate(workDate);
        sysStaff.setWorkId(workId);
        sysOrgan.setId(Long.valueOf(sysOrganId));
        sysOrgan.setOrganName(sysStaff.getName());
        sysOrgan.setOrganType("9");
        String newCode = this.getCode();
        sysOrgan.setOrganCode(newCode);
        sysUsers.setId(Long.valueOf(sysUserId));
        sysUsers.setSecurityLevel(Integer.valueOf(1));
        sysUsers.setIsSys("0");
        sysUsers.setIsCpublic("0");
        sysUsers.setMaxSessions(Integer.valueOf(1));
        sysUsers.setUserAccount(convert ? userAccount.toUpperCase() : userAccount);
        sysUsers.setUserName(userName);
        sysUsers.setWeChat(weChat);
        sysUsers.setMobile(mobile);
        sysUsers.setTelephone(telephone);
        if (dealWithSelf) {
            sysUsers.setPassword(secure);
        }
        n2 = userOrder;
        Integer n3 = userOrder = Integer.valueOf(userOrder + 1);
        sysUsers.setUserOrder(n2);
    }

    private void initializationAdd(boolean dealWithSelf, boolean getLoginUpperOpen, AddOutsideUserDto userDto, Set<SysStruStaff> struStaffCollection, Set<SysStruUser> struUserCollection, SysStaff sysStaff, SysUsers sysUsers) {
        Integer userOrder;
        boolean convert;
        long sysStaffId = IdWorker.getId((Object)sysStaff);
        long sysUserId = IdWorker.getId((Object)sysUsers);
        List organIds = userDto.getOrganIds();
        String userAccount = StringUtils.trimToEmpty((String)userDto.getUserAccount());
        String userName = StringUtils.trimToEmpty((String)userDto.getUserName());
        String weChat = StringUtils.trimToEmpty((String)userDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)userDto.getMobile());
        String mail = StringUtils.trimToEmpty((String)userDto.getMail());
        String telephone = StringUtils.trimToEmpty((String)userDto.getTelephone());
        String staffPosition = StringUtils.trimToEmpty((String)userDto.getStaffPosition());
        String sex = StringUtils.trimToEmpty((String)userDto.getSex());
        String birthday = StringUtils.trimToEmpty((String)userDto.getBirthday());
        String idcard = StringUtils.trimToEmpty((String)userDto.getIdcard());
        String address = StringUtils.trimToEmpty((String)userDto.getAddress());
        String workId = StringUtils.trimToEmpty((String)userDto.getWorkId());
        String workDate = StringUtils.trimToEmpty((String)userDto.getWorkDate());
        String graduateDate = StringUtils.trimToEmpty((String)userDto.getGraduateDate());
        String graduateSchool = StringUtils.trimToEmpty((String)userDto.getGraduateSchool());
        String secure = StringUtils.trimToEmpty((String)userDto.getSecure());
        boolean bl = convert = !getLoginUpperOpen && !OrganConstants.EXCLUDE_USERS.contains(userAccount);
        if (convert) {
            userAccount = userAccount.toUpperCase();
        }
        int order = 1;
        sysStaff.setId(Long.valueOf(sysStaffId));
        sysStaff.setName(userName);
        sysStaff.setAddress(address);
        sysStaff.setBirthday(birthday);
        sysStaff.setSex(sex);
        sysStaff.setIdcard(idcard);
        sysStaff.setGraduateDate(graduateDate);
        sysStaff.setGraduateSchool(graduateSchool);
        sysStaff.setWorkDate(workDate);
        sysStaff.setWorkId(workId);
        sysStaff.setStaffPosition(staffPosition);
        sysStaff.setStaffCode(this.sysIdtableService.getCurrentCode("STAFF_CODE", "SYS_STAFF"));
        Integer maxStaffOrder = this.sysStaffMapper.getMaxOrder();
        sysStaff.setStaffOrder(Integer.valueOf(HussarUtils.isEmpty((Object)maxStaffOrder) ? order : maxStaffOrder + 1));
        sysUsers.setId(Long.valueOf(sysUserId));
        sysUsers.setSecurityLevel(Integer.valueOf(1));
        sysUsers.setIsSys("0");
        sysUsers.setIsCpublic("0");
        sysUsers.setMaxSessions(Integer.valueOf(1));
        sysUsers.setUserAccount(convert ? userAccount.toUpperCase() : userAccount);
        sysUsers.setUserName(userName);
        sysUsers.setWeChat(weChat);
        sysUsers.setMobile(mobile);
        sysUsers.seteMail(mail);
        sysUsers.setTelephone(telephone);
        if (dealWithSelf) {
            sysUsers.setPassword(secure);
        }
        sysUsers.setUserOrder(Integer.valueOf(HussarUtils.isEmpty((Object)(userOrder = this.sysUsersMapper.getUserMaxOrder())) ? order : userOrder + 1));
        sysUsers.setJobCode(userDto.getJobCode());
        sysUsers.setJobTitle(userDto.getJobTitle());
        sysUsers.setLevelCode(userDto.getLevelCode());
        sysUsers.setLevel(userDto.getLevel());
        sysUsers.setKeyPositions(userDto.getKeyPositions());
        sysUsers.setOrgId(userDto.getOrgId());
        for (Long organId : organIds) {
            SysStruStaff sysStruStaff = new SysStruStaff();
            SysStruUser sysStruUser = new SysStruUser();
            sysStruStaff.setStruId(organId);
            sysStruStaff.setStaffId(Long.valueOf(sysStaffId));
            struStaffCollection.add(sysStruStaff);
            sysStruUser.setStruId(organId);
            sysStruUser.setUserId(Long.valueOf(sysUserId));
            struUserCollection.add(sysStruUser);
        }
    }

    private void addStaffUser(AddOutsideUserDto userDto, SysStaff sysStaff, SysUsers sysUsers, SysUserRole sysUserRole) {
        if (StringUtils.isBlank((CharSequence)sysUsers.getPassword())) {
            String pass = "";
            pass = this.createUserConfigService.getCreateUserSendEmail() != false && this.createUserConfigService.getCreateUserUseDefaultPass() == false ? "123456" : this.pwdConfigService.getDefaultPassword();
            String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
            sysUsers.setPassword(pwd);
        }
        sysUsers.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
        sysUsers.setAccountStatus(UserStatus.OK.getCode());
        sysUsers.setSecurityLevel(Integer.valueOf(1));
        sysUsers.setMaxSessions(Integer.valueOf(1));
        sysUsers.setLoginIpLimit("0");
        sysUsers.setLoginTimeLimit("0");
        sysUsers.setIsSys("0");
        sysUsers.setIsCpublic("0");
        List organIds = userDto.getOrganIds();
        if (HussarUtils.isNotEmpty((Object)organIds)) {
            Long departmentId = (Long)organIds.get(0);
            sysUsers.setCorporationId(departmentId);
            sysUsers.setDepartmentId(departmentId);
        }
        sysUsers.setEmployeeId(sysStaff.getId());
        sysUsers.setTypeProperty("1");
        sysUserRole.setUserId(sysUsers.getId());
        sysUserRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
        sysUserRole.setAdminOption("1");
    }

    private boolean duplicateUserAccount(boolean convert, AddOutsideUserDto user, List<AddOutsideUserDto> users) {
        if (HussarUtils.isNotEmpty(users)) {
            for (AddOutsideUserDto dto : users) {
                if (dto == user) break;
                if (dto == user || !dto.getUserAccount().trim().equals(user.getUserAccount().trim())) continue;
                return true;
            }
        }
        String userAccount = StringUtils.trimToEmpty((String)user.getUserAccount());
        if (convert) {
            userAccount = userAccount.toUpperCase();
        }
        return this.existUser(userAccount);
    }
}

