/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.jxdinfo.hussar.authorization.organ.dto.SysStruRuleDto;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.support.security.core.annotation.CheckSafe;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec4\u7ec7\u89c4\u5219\u5b9a\u4e49"})
@RestController
@RequestMapping(value={"/orgRuleFront"})
public class SysOrganRuleFrontController
extends HussarBaseController<SysStruRule, ISysStruRuleService> {
    @Resource
    private ISysStruRuleService iSysStruRuleService;

    @ApiOperation(value="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\u5217\u8868", notes="\u5206\u9875\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\u5217\u8868")
    @GetMapping(value={"/getList"})
    @CheckPermission(value={"orgRule:search"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u89c4\u5219\u5b9a\u4e49", eventDesc="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<SysStruRuleDto>> list(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<SysStruRuleDto> page, @ApiParam(value="\u7ec4\u7ec7\u89c4\u5219dto") SysStruRuleDto sysStruRuleDto) {
        return ApiResponse.success((Object)this.iSysStruRuleService.getOrganRuleList(page, sysStruRuleDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u89c4\u5219\u8be6\u60c5", notes="\u83b7\u53d6\u89c4\u5219\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    @CheckPermission(value={"orgRule:edit"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u89c4\u5219\u5b9a\u4e49", eventDesc="\u83b7\u53d6\u89c4\u5219\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysStruRule> getDetail(@ApiParam(value="\u7ec4\u7ec7\u89c4\u5219id") @RequestParam Long ruleId) {
        if (ToolUtil.isEmpty((Object)ruleId)) {
            throw new BaseException("\u89c4\u5219id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ApiResponse.success((Object)this.iSysStruRuleService.getById((Serializable)ruleId));
    }

    @ApiOperation(value="\u65b0\u589e\u7ec4\u7ec7\u7ed3\u6784\u89c4\u5219", notes="\u65b0\u589e\u7ec4\u7ec7\u7ed3\u6784\u89c4\u5219")
    @CheckPermission(value={"orgRule:add"})
    @PostMapping(value={"/add"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u89c4\u5219\u5b9a\u4e49", eventDesc="\u65b0\u589e\u7ec4\u7ec7\u7ed3\u6784\u89c4\u5219", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse add(@ApiParam(value="\u7ec4\u7ec7\u89c4\u5219\u5bf9\u8c61") @RequestBody SysStruRule sysStruRule) {
        this.iSysStruRuleService.checkStruRuleInfo((Object)sysStruRule, "add");
        boolean flag = this.iSysStruRuleService.judgeRelationshipOfTypeCascade(sysStruRule.getOrganType(), sysStruRule.getSysOrganType());
        if (!flag) {
            return ApiResponse.fail((String)"\u65b0\u589e\u5931\u8d25\uff01\u4e0a\u4e0b\u7ea7\u7c7b\u578b\u5173\u7cfb\u4e0d\u5408\u89c4\uff01");
        }
        String ruleNode = sysStruRule.getRuleNote();
        if (ToolUtil.isEmpty((Object)ruleNode.trim())) {
            throw new BaseException("\u89c4\u5219\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        sysStruRule.setRuleNote(ruleNode.trim());
        this.iSysStruRuleService.save(sysStruRule);
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u4fee\u6539\u7ec4\u7ec7\u7ed3\u6784\u89c4\u5219", notes="\u4fee\u6539\u7ec4\u7ec7\u7ed3\u6784\u89c4\u5219")
    @CheckPermission(value={"orgRule:edit"})
    @PostMapping(value={"/edit"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u89c4\u5219\u5b9a\u4e49", eventDesc="\u4fee\u6539\u7ec4\u7ec7\u7ed3\u6784\u89c4\u5219", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse edit(@ApiParam(value="\u7ec4\u7ec7\u89c4\u5219\u5bf9\u8c61") @RequestBody SysStruRule sysStruRule) {
        this.iSysStruRuleService.checkStruRuleInfo((Object)sysStruRule, "edit");
        String ruleNode = sysStruRule.getRuleNote();
        if (ToolUtil.isEmpty((Object)ruleNode.trim())) {
            throw new BaseException("\u89c4\u5219\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        sysStruRule.setRuleNote(ruleNode.trim());
        this.iSysStruRuleService.update(sysStruRule);
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u5220\u9664\u7ec4\u7ec7\u7ed3\u6784\u89c4\u5219", notes="\u5220\u9664\u7ec4\u7ec7\u7ed3\u6784\u89c4\u5219")
    @CheckPermission(value={"orgRule:delete"})
    @PostMapping(value={"/delete"})
    @CheckSafe
    @AuditLog(moduleName="\u7ec4\u7ec7\u89c4\u5219\u5b9a\u4e49", eventDesc="\u5220\u9664\u7ec4\u7ec7\u7ed3\u6784\u89c4\u5219", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Object> delete(@ApiParam(value="\u5220\u9664\u7ec4\u7ec7\u89c4\u5219id\u5b57\u7b26\u4e32") @RequestBody String eId) {
        this.iSysStruRuleService.delete(eId);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

