/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.client.utils.EncryptSha256Util;
import com.jxdinfo.hussar.authorization.client.utils.QbeeTokenUtil;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SyncUserClient {
    protected static final Logger logger = LoggerFactory.getLogger(SyncUserClient.class);
    @Value(value="${rzgt.syncUsers.url}")
    private String url;
    @Value(value="${rzgt.syncUsers.userSecretKey}")
    private String userSecretKey;
    @Autowired
    private ISysOrganService sysOrganService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AddOutsideUserDto> getUsersInfo() {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(this.url);
            response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String responseContent = EntityUtils.toString((HttpEntity)response.getEntity());
                List voList = this.sysOrganService.getStruIdAndOrgCode();
                Map<String, String> organMap = voList.stream().collect(Collectors.toMap(SysOrganVo::getOrganCode, SysOrganVo::getStruId));
                ArrayList<AddOutsideUserDto> users = new ArrayList<AddOutsideUserDto>();
                try (BufferedReader reader = new BufferedReader(new StringReader(responseContent));){
                    String line;
                    int num = 0;
                    int totalCount = 0;
                    boolean firstLineSkipped = false;
                    while ((line = reader.readLine()) != null) {
                        Long StruId;
                        if (!firstLineSkipped) {
                            firstLineSkipped = true;
                            continue;
                        }
                        ++totalCount;
                        String[] parts = line.split("!\\^");
                        Long l = StruId = organMap.get(parts[4]) == null ? null : Long.valueOf(Long.parseLong(organMap.get(parts[4])));
                        if (StruId == null) {
                            ++num;
                            continue;
                        }
                        AddOutsideUserDto userDto = new AddOutsideUserDto();
                        userDto.setWorkId(parts[0]);
                        userDto.setUserAccount(parts[0]);
                        userDto.setUserName(parts[1]);
                        String sex = "M".equals(parts[3]) ? "1" : "2";
                        userDto.setSex(sex);
                        userDto.setDepartmentId(StruId);
                        userDto.setOrgId(parts[4]);
                        userDto.setJobCode(parts[5]);
                        userDto.setJobTitle(parts[6]);
                        userDto.setStaffPosition(parts[7]);
                        userDto.setLevelCode(parts[9]);
                        userDto.setLevel(parts[10]);
                        userDto.setMobile(parts[11]);
                        userDto.setTelephone(parts[12]);
                        String email = parts[0].toLowerCase() + "@rizhaosteel.com";
                        userDto.setMail(email);
                        users.add(userDto);
                    }
                    logger.info("\u5171\u67e5\u8be2\u5230{}\u6761\u7528\u6237\u4fe1\u606f,\u5176\u4e2d\u6709{}\u6761\u7528\u6237\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u673a\u6784,\u4e0d\u505a\u540c\u6b65\u5904\u7406", (Object)totalCount, (Object)num);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ArrayList<AddOutsideUserDto> arrayList = users;
                return arrayList;
            }
            try {
                logger.error("HTTP\u8bf7\u6c42\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}", (Object)statusCode);
                throw new BaseException("\u8c03\u7528\u5ba2\u6237\u63a5\u53e3\u7684HTTP\u8bf7\u6c42\u5931\u8d25,\u72b6\u6001\u7801: " + statusCode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public List<AddOutsideUserDto> getUsersInfoNew() {
        JSONArray outsideUsers = this.sendPostWithJson();
        int num = 0;
        List voList = this.sysOrganService.getStruIdAndOrgCode();
        Map<String, String> organMap = voList.stream().collect(Collectors.toMap(SysOrganVo::getOrganCode, SysOrganVo::getStruId));
        ArrayList<AddOutsideUserDto> outsideUserDtoList = new ArrayList<AddOutsideUserDto>();
        for (int i = 0; i < outsideUsers.size(); ++i) {
            Long struId;
            AddOutsideUserDto userDto = new AddOutsideUserDto();
            JSONObject outsideUser = outsideUsers.getJSONObject(i);
            Long l = struId = HussarUtils.isEmpty((Object)organMap.get(outsideUser.getString("deptNo"))) ? null : Long.valueOf(Long.parseLong(organMap.get(outsideUser.getString("deptNo"))));
            if (struId == null) {
                ++num;
                continue;
            }
            userDto.setWorkId(outsideUser.getString("empNo"));
            userDto.setUserAccount(outsideUser.getString("empNo"));
            userDto.setUserName(outsideUser.getString("chiName"));
            String sex = "M".equals(outsideUser.getString("sexType")) ? "1" : "2";
            userDto.setSex(sex);
            userDto.setDepartmentId(struId);
            ArrayList<Long> organIds = new ArrayList<Long>();
            organIds.add(struId);
            userDto.setOrgId(outsideUser.getString("deptNo"));
            userDto.setJobCode(outsideUser.getString("position"));
            userDto.setStaffPosition(outsideUser.getString("title"));
            userDto.setLevelCode(outsideUser.getString("kind"));
            userDto.setMobile(outsideUser.getString("cellphone"));
            userDto.setTelephone(outsideUser.getString("telNo"));
            String email = outsideUser.getString("empNo").toLowerCase() + "@rizhaosteel.com";
            userDto.setMail(email);
            String concrntDeptNo = null;
            if (HussarUtils.isNotEmpty((Object)outsideUser.getString("concrntADeptNo"))) {
                concrntDeptNo = organMap.get(outsideUser.getString("concrntADeptNo"));
                if (HussarUtils.isNotEmpty((Object)concrntDeptNo)) {
                    organIds.add(Long.parseLong(concrntDeptNo));
                } else {
                    logger.warn("\u7528\u6237 {} \u517c\u804c\u7ec4\u7ec7A {} \u672a\u627e\u5230\uff0c\u4e0d\u505a\u5904\u7406", (Object)userDto.getUserName(), (Object)outsideUser.getString("concrntADeptNo"));
                }
            }
            if (HussarUtils.isNotEmpty((Object)outsideUser.getString("concrntBDeptNo"))) {
                concrntDeptNo = organMap.get(outsideUser.getString("concrntBDeptNo"));
                if (HussarUtils.isNotEmpty((Object)concrntDeptNo)) {
                    organIds.add(Long.parseLong(concrntDeptNo));
                } else {
                    logger.warn("\u7528\u6237 {} \u517c\u804c\u7ec4\u7ec7B {} \u672a\u627e\u5230\uff0c\u4e0d\u505a\u5904\u7406", (Object)userDto.getUserName(), (Object)outsideUser.getString("concrntBDeptNo"));
                }
            }
            if (HussarUtils.isNotEmpty((Object)outsideUser.getString("concrntCDeptNo"))) {
                concrntDeptNo = organMap.get(outsideUser.getString("concrntCDeptNo"));
                if (HussarUtils.isNotEmpty((Object)concrntDeptNo)) {
                    organIds.add(Long.parseLong(concrntDeptNo));
                } else {
                    logger.warn("\u7528\u6237 {} \u517c\u804c\u7ec4\u7ec7C {} \u672a\u627e\u5230\uff0c\u4e0d\u505a\u5904\u7406", (Object)userDto.getUserName(), (Object)outsideUser.getString("concrntCDeptNo"));
                }
            }
            userDto.setOrganIds(organIds);
            outsideUserDtoList.add(userDto);
        }
        logger.info("\u5171\u67e5\u8be2\u5230{}\u6761\u7528\u6237\u4fe1\u606f,\u5176\u4e2d\u6709{}\u6761\u7528\u6237\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u673a\u6784,\u4e0d\u505a\u540c\u6b65\u5904\u7406", (Object)outsideUsers.size(), (Object)num);
        return outsideUserDtoList;
    }

    private JSONArray sendPostWithJson() {
        String sysCode = "DDM";
        String reqMethodNo = "ERP-H-04";
        JSONObject reqData = new JSONObject();
        String reqType = "02";
        int pageSize = 500;
        String lastId = null;
        boolean hasMore = true;
        JSONArray outsideUsers = new JSONArray();
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        JSONObject requestData = new JSONObject();
        requestData.put("sysCode", (Object)sysCode);
        requestData.put("reqMethodNo", (Object)reqMethodNo);
        while (hasMore) {
            reqData.put("reqType", (Object)reqType);
            reqData.put("pageSize", (Object)pageSize);
            reqData.put("lastId", lastId);
            String authorization = QbeeTokenUtil.getToken();
            Long reqTime = System.currentTimeMillis();
            String reqId = reqTime.toString();
            String reqToken = EncryptSha256Util.getSha256Str(reqTime.toString() + this.userSecretKey + reqTime.toString());
            requestData.put("reqId", (Object)reqId);
            requestData.put("reqTime", (Object)reqTime);
            requestData.put("reqToken", (Object)reqToken);
            requestData.put("reqData", (Object)reqData);
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)requestData.toJSONString());
            Request request = new Request.Builder().post(body).url(this.url).addHeader("Authorization", authorization).build();
            Call call = client.newCall(request);
            try {
                Response response = call.execute();
                JSONObject res = JSON.parseObject((String)response.body().string());
                if ("0".equals(res.get((Object)"code"))) {
                    JSONObject respData = res.getJSONObject("respData");
                    outsideUsers.addAll((Collection)respData.getJSONArray("datas"));
                    lastId = respData.getString("lastId");
                    hasMore = respData.getBoolean("hasMore");
                    continue;
                }
                throw new BaseException("\u540c\u6b65\u7528\u6237\u65f6\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25: " + res.get((Object)"message"));
            }
            catch (IOException e) {
                throw new BaseException("\u540c\u6b65\u7528\u6237\u65f6\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25: " + e);
            }
        }
        return outsideUsers;
    }
}

