/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.client.utils.EncryptSha256Util;
import com.jxdinfo.hussar.authorization.client.utils.QbeeTokenUtil;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.authorization.post.dto.AddOutsidePostDto;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SyncPostClient {
    private static final Logger logger = LoggerFactory.getLogger(SyncPostClient.class);
    @Value(value="${rzgt.syncPost.url}")
    private String url;
    @Value(value="${rzgt.syncPost.userSecretKey}")
    private String userSecretKey;
    @Autowired
    private ISysOrganService sysOrganService;

    public List<AddOutsidePostDto> getPostInfo() {
        JSONArray outsidePosts = this.sendPostWithJson();
        List voList = this.sysOrganService.getStruIdAndOrgCode();
        Map<String, String> organMap = voList.stream().collect(Collectors.toMap(SysOrganVo::getOrganCode, SysOrganVo::getStruId));
        ArrayList<AddOutsidePostDto> outsidePostDtoList = new ArrayList<AddOutsidePostDto>();
        for (int i = 0; i < outsidePosts.size(); ++i) {
            JSONObject outsidePost = outsidePosts.getJSONObject(i);
            AddOutsidePostDto addOutsidePostDto = new AddOutsidePostDto();
            Long struId = HussarUtils.isEmpty((Object)organMap.get(outsidePost.getString("deptNo"))) ? null : Long.valueOf(Long.parseLong(organMap.get(outsidePost.getString("deptNo"))));
            addOutsidePostDto.setPostCode(outsidePost.getString("position"));
            addOutsidePostDto.setPostDesc(outsidePost.getString("positionChiName"));
            addOutsidePostDto.setPostName(outsidePost.getString("positionChiName"));
            addOutsidePostDto.setStruId(struId);
            addOutsidePostDto.setPostId(Long.valueOf(SyncPostClient.hashWord(addOutsidePostDto.getPostName() + addOutsidePostDto.getPostCode())));
            outsidePostDtoList.add(addOutsidePostDto);
        }
        logger.info("\u5171\u67e5\u8be2\u5230{}\u6761\u5c97\u4f4d\u4fe1\u606f", (Object)outsidePosts.size());
        return outsidePostDtoList;
    }

    private static long hashWord(String word) {
        CRC32 crc32 = new CRC32();
        crc32.update(word.getBytes());
        return crc32.getValue();
    }

    private JSONArray sendPostWithJson() {
        String sysCode = "DDM";
        String reqMethodNo = "ERP-H-03";
        JSONObject reqData = new JSONObject();
        String reqType = "02";
        int pageSize = 500;
        String lastId = "";
        boolean hasMore = true;
        JSONArray outsidePosts = new JSONArray();
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        JSONObject requestData = new JSONObject();
        requestData.put("sysCode", (Object)sysCode);
        requestData.put("reqMethodNo", (Object)reqMethodNo);
        while (hasMore) {
            reqData.put("reqType", (Object)reqType);
            reqData.put("pageSize", (Object)pageSize);
            reqData.put("lastId", (Object)lastId);
            String authorization = QbeeTokenUtil.getToken();
            Long reqTime = System.currentTimeMillis();
            String reqId = reqTime.toString();
            String reqToken = EncryptSha256Util.getSha256Str(this.userSecretKey + reqTime.toString());
            requestData.put("reqId", (Object)reqId);
            requestData.put("reqTime", (Object)reqTime);
            requestData.put("reqToken", (Object)reqToken);
            requestData.put("reqData", (Object)reqData);
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)requestData.toJSONString());
            Request request = new Request.Builder().post(body).url(this.url).addHeader("Authorization", authorization).build();
            Call call = client.newCall(request);
            try {
                Response response = call.execute();
                JSONObject res = JSON.parseObject((String)response.body().string());
                if ("0".equals(res.get((Object)"code"))) {
                    JSONObject respData = res.getJSONObject("respData");
                    outsidePosts.addAll((Collection)respData.getJSONArray("datas"));
                    lastId = respData.getString("lastId");
                    hasMore = respData.getBoolean("hasMore");
                    continue;
                }
                throw new BaseException("\u540c\u6b65\u5c97\u4f4d\u65f6\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f\u5931\u8d25: " + res.get((Object)"message"));
            }
            catch (IOException e) {
                throw new BaseException("\u540c\u6b65\u5c97\u4f4d\u65f6\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f\u5931\u8d25: " + e);
            }
        }
        return outsidePosts;
    }
}

