/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideOrganizationDto;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.springframework.stereotype.Component;

@Component
public class SyncOrganClient {
    private static final String url = "http://wxqy1.rizhaosteel.com:8003/RgService/GetERPDept?wsdl";
    private static final String namespace = "http://WebService.rz.com";
    private static final String methodName = "getERPDept";

    public static List<AddOutsideOrganizationDto> getERPDept() {
        JaxWsDynamicClientFactory factory = JaxWsDynamicClientFactory.newInstance();
        Client client = factory.createClient(url);
        Endpoint endpoint = client.getEndpoint();
        QName opName = new QName(namespace, methodName);
        BindingInfo bindingInfo = endpoint.getEndpointInfo().getBinding();
        if (bindingInfo.getOperation(opName) == null) {
            for (BindingOperationInfo operationInfo : bindingInfo.getOperations()) {
                if (!methodName.equals(operationInfo.getName().getLocalPart())) continue;
                opName = operationInfo.getName();
                break;
            }
        }
        try {
            Object[] objects = client.invoke(opName, new Object[0]);
            Object object = objects[0];
            String resultMsg = object.toString();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(resultMsg);
            ArrayList<AddOutsideOrganizationDto> addOutsideOrganizationDtoList = new ArrayList<AddOutsideOrganizationDto>();
            JsonNode hrDataNode = rootNode.get("HR0001");
            if (hrDataNode != null && hrDataNode.isArray()) {
                for (JsonNode entryNode : hrDataNode) {
                    AddOutsideOrganizationDto addOutsideOrganizationDto = new AddOutsideOrganizationDto();
                    addOutsideOrganizationDto.setOrganAddress(entryNode.get("address").asText());
                    addOutsideOrganizationDto.setChangeDate(entryNode.get("changedate").asText());
                    addOutsideOrganizationDto.setOrganCode(entryNode.get("orgid").asText());
                    addOutsideOrganizationDto.setOrganName(entryNode.get("orgname").asText());
                    if ("\u90e8\u95e8".equals(entryNode.get("orgtype").asText())) {
                        addOutsideOrganizationDto.setOrganType("2");
                    } else if ("\u5355\u4f4d".equals(entryNode.get("orgtype").asText())) {
                        addOutsideOrganizationDto.setOrganType("1");
                    } else {
                        addOutsideOrganizationDto.setOrganType("3");
                    }
                    if (ToolUtil.isEmpty((Object)entryNode.get("porgid").asText())) {
                        addOutsideOrganizationDto.setParentOrganCode("1");
                    } else {
                        addOutsideOrganizationDto.setParentOrganCode(entryNode.get("porgid").asText());
                    }
                    addOutsideOrganizationDto.setOrganShortName(entryNode.get("sorgname").asText());
                    addOutsideOrganizationDto.setOrganAlias(entryNode.get("orgname").asText());
                    addOutsideOrganizationDtoList.add(addOutsideOrganizationDto);
                }
            }
            return addOutsideOrganizationDtoList;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u5f02\u5e38\u4fe1\u606f \uff1a" + e.getMessage());
            return null;
        }
    }
}

