/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.post.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.post.manager.DeleteBatchOutsidePostManager;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.post.manager.impl.deleteBatchOutsidePostManagerImpl")
public class DeleteBatchOutsidePostManagerImpl
implements DeleteBatchOutsidePostManager {
    @Autowired
    private IHussarBasePostService postService;
    @Autowired
    private ISysStruPostService sysStruPostService;
    @Autowired
    private ISysPostRoleService sysPostRoleService;
    @Autowired
    private ISysUserPostService sysUserPostService;

    @Override
    public R<String> deleteBatchPosts(List<String> postCodes) {
        R result = new R();
        ArrayList errors = new ArrayList();
        for (String postCode : postCodes) {
            if (!HussarUtils.isBlank((CharSequence)postCode)) continue;
            OrganUtil.addErrorMsg(errors, (Object)postCode, (String)"postCode", (String[])new String[]{"\u5c97\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
            List postList = this.postService.list((Wrapper)new LambdaQueryWrapper().in(SysPost::getPostCode, postCodes));
            if (HussarUtils.isNotEmpty((Object)postList)) {
                List postIds = postList.stream().map(SysPost::getId).distinct().collect(Collectors.toList());
                this.sysUserPostService.remove((Wrapper)new LambdaQueryWrapper().in(SysUserPost::getPostId, postIds));
                this.sysPostRoleService.remove((Wrapper)new LambdaQueryWrapper().in(SysPostRole::getPostId, postIds));
                this.sysStruPostService.remove((Wrapper)new LambdaQueryWrapper().in(SysStruPost::getPostId, postIds));
                this.postService.removeByIds(postIds);
                for (SysPost sysPost : postList) {
                    dataMappings.add(new DataMapping(sysPost.getId(), sysPost.getPostCode()));
                }
            }
            result.setSuccessList(dataMappings);
        }
        return result;
    }
}

