/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.post.manager.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.post.dao.SysPostMapper;
import com.jxdinfo.hussar.authorization.post.dto.AddOutsidePostDto;
import com.jxdinfo.hussar.authorization.post.manager.AddBatchOutsidePostManager;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.sync.service.ISysSyncDataInService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.post.manager.impl.addBatchOutsidePostManagerImpl")
public class AddBatchOutsidePostManagerImpl
implements AddBatchOutsidePostManager {
    @Autowired
    private IHussarBasePostService postService;
    @Autowired
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Autowired
    private SysPostMapper sysPostMapper;
    @Autowired(required=false)
    protected ISysSyncDataInService sysSyncDataInService;

    @Override
    public R<AddOutsidePostDto> addBatchPosts(List<AddOutsidePostDto> posts) {
        R result = new R();
        List errors = OrganUtil.validateMany(posts);
        List listOrganType = this.sysOrganTypeMapper.selectList(null);
        Map organTypeMap = listOrganType.stream().collect(Collectors.toMap(SysOrganType::getOrganType, Function.identity()));
        HashMap<String, Long> codeMap = new HashMap<String, Long>();
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        for (AddOutsidePostDto post : posts) {
            String postCode = StringUtils.trimToEmpty((String)post.getPostCode());
            Long postId = post.getPostId();
            if (HussarUtils.isEmpty(codeMap.get(postCode))) {
                codeMap.put(postCode, 1L);
            } else {
                codeMap.put(postCode, (Long)codeMap.get(postCode) + 1L);
            }
            if (!HussarUtils.isNotEmpty((Object)postId)) continue;
            if (HussarUtils.isEmpty(idMap.get(postId))) {
                idMap.put(postId, 1L);
                continue;
            }
            idMap.put(postId, (Long)idMap.get(postId) + 1L);
        }
        Set codeSet = codeMap.keySet();
        Set idSet = idMap.keySet();
        List<String> duplicateCodes = this.sysPostMapper.selectDuplicateCodeByCodes(new ArrayList<String>(codeSet));
        List<Long> duplicateIds = this.sysPostMapper.selectDuplicateIdByIds(new ArrayList<Long>(idSet));
        for (AddOutsidePostDto post : posts) {
            String organType = StringUtils.trimToEmpty((String)post.getOrganType());
            String postCode = StringUtils.trimToEmpty((String)post.getPostCode());
            if ((Long)codeMap.get(postCode) > 1L) {
                OrganUtil.addErrorMsg((List)errors, (Object)post, (String)"postCode", (String[])new String[]{"\u5c97\u4f4d\u7f16\u7801\u91cd\u590d"});
            }
            if (HussarUtils.isNotEmpty(duplicateCodes) && duplicateCodes.contains(postCode)) {
                OrganUtil.addErrorMsg((List)errors, (Object)post, (String)"postCode", (String[])new String[]{"\u5c97\u4f4d\u7f16\u7801\u91cd\u590d"});
            }
            if (HussarUtils.isNotEmpty((Object)post.getPostId())) {
                Long postId = post.getPostId();
                if ((Long)idMap.get(postId) > 1L) {
                    OrganUtil.addErrorMsg((List)errors, (Object)post, (String)"postId", (String[])new String[]{"\u5c97\u4f4did\u91cd\u590d"});
                }
                if (HussarUtils.isNotEmpty(duplicateIds) && duplicateIds.contains(postId)) {
                    OrganUtil.addErrorMsg((List)errors, (Object)post, (String)"postId", (String[])new String[]{"\u5c97\u4f4did\u91cd\u590d"});
                }
            }
            if (!HussarUtils.isNotEmpty((Object)organType) || !HussarUtils.isEmpty(organTypeMap.get(organType))) continue;
            OrganUtil.addErrorMsg((List)errors, (Object)post, (String)"organType", (String[])new String[]{"\u4e0d\u5b58\u5728\u7684\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b"});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
            ArrayList<SysPost> postList = new ArrayList<SysPost>();
            for (AddOutsidePostDto post : posts) {
                SysPost sysPost = new SysPost();
                this.initializationAdd(post, sysPost);
                postList.add(sysPost);
                dataMappings.add(new DataMapping(sysPost.getId(), sysPost.getPostCode()));
            }
            result.setSuccessList(dataMappings);
            this.postService.saveBatch(postList);
            if (HussarUtils.isNotEmpty((Object)this.sysSyncDataInService)) {
                this.sysSyncDataInService.saveSyncRecord(SysPost.class, dataMappings);
            }
        }
        return result;
    }

    private void initializationAdd(AddOutsidePostDto addOutsidePostDto, SysPost sysPost) {
        Long postId = addOutsidePostDto.getPostId();
        String postName = StringUtils.trimToEmpty((String)addOutsidePostDto.getPostName());
        String postDesc = StringUtils.trimToEmpty((String)addOutsidePostDto.getPostDesc());
        String postCode = StringUtils.trimToEmpty((String)addOutsidePostDto.getPostCode());
        String organType = StringUtils.trimToEmpty((String)addOutsidePostDto.getOrganType());
        Integer postOrder = addOutsidePostDto.getPostOrder();
        if (HussarUtils.isEmpty((Object)postId)) {
            postId = IdWorker.getId((Object)sysPost);
        }
        if (HussarUtils.isEmpty((Object)postOrder)) {
            postOrder = 1;
            Integer maxOrder = this.sysPostMapper.getMaxOrder();
            postOrder = HussarUtils.isEmpty((Object)maxOrder) ? postOrder : maxOrder + 1;
        }
        sysPost.setId(postId);
        sysPost.setPostCode(postCode);
        sysPost.setPostName(postName);
        sysPost.setPostDesc(postDesc);
        sysPost.setOrganTypeCode(organType);
        sysPost.setPostOrder(postOrder);
    }
}

