/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.permit.dto.QueryAuditUserDto;
import com.jxdinfo.hussar.authorization.permit.manager.QueryAuditUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.impl.CommonUserAuditManager;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.vo.AuditUserData;
import com.jxdinfo.hussar.authorization.permit.vo.AuditUserDetailVo;
import com.jxdinfo.hussar.authorization.permit.vo.AuditUserListVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.queryAuditUserManagerImpl")
public class QueryAuditUserManagerImpl
extends CommonUserAuditManager
implements QueryAuditUserManager {
    @Override
    public Page<AuditUserListVo> queryUserAudit(PageInfo pageInfo, QueryAuditUserDto queryAuditUserDto) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("userAccount", StringUtils.trimToEmpty((String)queryAuditUserDto.getUserAccount()));
        queryParams.put("type", queryAuditUserDto.getState());
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List<AuditUserListVo> auditUserVos = this.sysUsersAuditMapper.queryUserAuditList((Page<AuditUserListVo>)page, queryParams);
        page.setRecords(auditUserVos);
        return page;
    }

    @Override
    public AuditUserDetailVo viewUserAudit(Long id) {
        AuditUserDetailVo vo = new AuditUserDetailVo();
        AuditUserData newData = vo.getNewData();
        AuditUserData oldData = vo.getOldData();
        SysUsersAudit usersAudit = (SysUsersAudit)this.sysUsersAuditMapper.selectById(id);
        AssertUtil.isNotNull((Object)usersAudit, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u5ba1\u6838\u4fe1\u606f");
        String type = usersAudit.getCurrentStatus();
        Long userId = usersAudit.getUserId();
        if ("0".equals(type)) {
            newData = this.getAuditUserData(usersAudit);
        } else if ("4".equals(type)) {
            oldData = this.getUserData(userId);
            BeanUtils.copyProperties((Object)oldData, (Object)newData);
            newData.setAccountStatusName("\u6ce8\u9500");
        } else if ("1".equals(type)) {
            oldData = this.getUserData(userId);
            newData = this.getAuditUserData(usersAudit);
        } else if ("2".equals(type)) {
            oldData = this.getUserData(userId);
        }
        vo.setOldData(oldData);
        vo.setNewData(newData);
        return vo;
    }

    private AuditUserData getUserData(Long userId) {
        AuditUserData oldData = new AuditUserData();
        SysUsers user = this.sysUsersService.getUser(userId);
        AssertUtil.isNotNull((Object)user, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        oldData.setUserAccount(user.getUserAccount());
        oldData.setUserName(user.getUserName());
        oldData.setMaxSessions(user.getMaxSessions());
        oldData.setMail(user.geteMail());
        oldData.setWeChat(user.getWeChat());
        oldData.setMobile(user.getMobile());
        oldData.setTelephone(user.getTelephone());
        String accountStatusName = this.dicRefService.getDictLabel("account_state", user.getAccountStatus());
        oldData.setAccountStatusName(accountStatusName);
        String accountPropertyName = this.dicRefService.getDictLabel("account_property", user.getTypeProperty());
        oldData.setAccountPropertyName(accountPropertyName);
        oldData.setLoginTimeLimit(user.getLoginTimeLimit().equals("1"));
        if (oldData.isLoginTimeLimit()) {
            oldData.setAccessLoginStartTime(Java8DateUtils.convertLocalTimeToString((LocalTime)user.getAccessLoginStartTime()));
            oldData.setAccessLoginEndTime(Java8DateUtils.convertLocalTimeToString((LocalTime)user.getAccessLoginEndTime()));
        }
        oldData.setStartTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)user.getStartTime()));
        oldData.setEndTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)user.getExpiredTime()));
        oldData.setLoginIpLimit(user.getLoginIpLimit().equals("1"));
        if (oldData.isLoginIpLimit()) {
            oldData.setAllowedIps(this.queryIp(userId));
        }
        return oldData;
    }

    private AuditUserData getAuditUserData(SysUsersAudit usersAudit) {
        AuditUserData newData = new AuditUserData();
        newData.setUserAccount(usersAudit.getUserAccount());
        newData.setUserName(usersAudit.getUserName());
        newData.setMaxSessions(usersAudit.getMaxSessions());
        newData.setMail(usersAudit.geteMail());
        newData.setWeChat(usersAudit.getWeChat());
        newData.setMobile(usersAudit.getMobile());
        newData.setTelephone(usersAudit.getTelephone());
        String accountStatusName = this.dicRefService.getDictLabel("account_state", usersAudit.getAccountStatus());
        newData.setAccountStatusName(accountStatusName);
        String accountPropertyName = this.dicRefService.getDictLabel("account_property", usersAudit.getTypeProperty());
        newData.setAccountPropertyName(accountPropertyName);
        newData.setLoginTimeLimit(usersAudit.getLoginTimeLimit().equals("1"));
        if (newData.isLoginTimeLimit()) {
            newData.setAccessLoginStartTime(Java8DateUtils.convertLocalTimeToString((LocalTime)usersAudit.getAccessLoginStartTime()));
            newData.setAccessLoginEndTime(Java8DateUtils.convertLocalTimeToString((LocalTime)usersAudit.getAccessLoginEndTime()));
        }
        newData.setStartTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)usersAudit.getStartTime()));
        newData.setEndTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)usersAudit.getExpiredTime()));
        newData.setLoginIpLimit(usersAudit.getLoginIpLimit().equals("1"));
        if (newData.isLoginIpLimit()) {
            newData.setAllowedIps(this.queryAuditIp(usersAudit.getUserId(), usersAudit.getCurrentStatus()));
        }
        return newData;
    }
}

