/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.audit.dao.SysStaffAuditMapper;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.vo.StaffAuditDetailsVo;
import com.jxdinfo.hussar.authorization.audit.vo.StaffAuditVo;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonStaffManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationVo;
import com.jxdinfo.hussar.authorization.permit.manager.QueryAuditStaffManager;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaffAudit;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.queryAuditStaffManagerImpl")
public class QueryAuditStaffManagerImpl
extends CommonStaffManager
implements QueryAuditStaffManager {
    @Resource
    private SysStaffAuditMapper sysStaffAuditMapper;

    @Override
    public Page<StaffAuditVo> list(PageInfo pageInfo, String staffName, String auditStatus) {
        Page staffAuditVoPage = HussarPageUtils.convert((PageInfo)pageInfo);
        List<StaffAuditVo> staffAuditVos = this.sysStaffAuditMapper.listByAndStaffNameAndAuditStatus((Page<StaffAuditVo>)staffAuditVoPage, SqlQueryUtil.transferSpecialChar((String)staffName), auditStatus);
        if (HussarUtils.isEmpty(staffAuditVos)) {
            staffAuditVoPage.setRecords(staffAuditVos);
            return staffAuditVoPage;
        }
        List addStaffIds = staffAuditVos.stream().filter(item -> "1".equals(item.getOperateType())).map(SysStaffAudit::getRealStaffId).collect(Collectors.toList());
        List staffIds = staffAuditVos.stream().filter(item -> !"1".equals(item.getOperateType())).map(SysStaffAudit::getRealStaffId).collect(Collectors.toList());
        List adds = new ArrayList();
        Map<Object, Object> addStruIdMap = new HashMap();
        if (HussarUtils.isNotEmpty(addStaffIds)) {
            adds = this.sysStruStaffAuditService.list((Wrapper)new LambdaQueryWrapper().in(SysStruStaffAudit::getStaffId, addStaffIds));
            addStruIdMap = adds.stream().collect(Collectors.groupingBy(SysStruStaffAudit::getStaffId, Collectors.mapping(SysStruStaffAudit::getStruId, Collectors.toList())));
        }
        List noAdds = new ArrayList();
        Map<Object, Object> struIdMap = new HashMap();
        if (HussarUtils.isNotEmpty(staffIds)) {
            noAdds = this.sysStruStaffService.list((Wrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, staffIds));
            struIdMap = noAdds.stream().collect(Collectors.groupingBy(SysStruStaff::getStaffId, Collectors.mapping(SysStruStaff::getStruId, Collectors.toList())));
        }
        List<Long> struIds = adds.stream().map(SysStruStaffAudit::getStruId).collect(Collectors.toList());
        List noAddStruIds = noAdds.stream().map(SysStruStaff::getStruId).collect(Collectors.toList());
        struIds.addAll(noAddStruIds);
        struIds = struIds.stream().distinct().collect(Collectors.toList());
        List<Object> organIdAndNames = new ArrayList();
        Map<Object, Object> map = new HashMap();
        if (HussarUtils.isNotEmpty(struIds)) {
            organIdAndNames = this.sysStaffMapper.getOrganIdAndName(struIds);
            map = organIdAndNames.stream().collect(Collectors.toMap(OrganizationVo::getId, Function.identity()));
        }
        for (StaffAuditVo staffAuditVo : staffAuditVos) {
            StringBuilder organName = new StringBuilder("");
            List struIdList = "1".equals(staffAuditVo.getOperateType()) ? (List)addStruIdMap.get(staffAuditVo.getRealStaffId()) : (List)struIdMap.get(staffAuditVo.getRealStaffId());
            if (!HussarUtils.isNotEmpty((Object)struIdList)) continue;
            for (Long struId : struIdList) {
                OrganizationVo organizationVo = (OrganizationVo)map.get(String.valueOf(struId));
                if (!HussarUtils.isNotEmpty((Object)organizationVo)) continue;
                organName.append(organizationVo.getOrganName()).append(",");
            }
            if (!HussarUtils.isNotEmpty((Object)organName)) continue;
            String str = organName.toString();
            str = str.substring(0, str.length() - 1);
            staffAuditVo.setOrganName(str);
        }
        staffAuditVoPage.setRecords(staffAuditVos);
        return staffAuditVoPage;
    }

    @Override
    public StaffAuditDetailsVo detail(Long auditId) {
        if (HussarUtils.isNotEmpty((Object)auditId)) {
            StaffAuditDetailsVo staffAuditDetailsVo = new StaffAuditDetailsVo();
            StaffAuditVo staffAuditVo = this.sysStaffAuditMapper.detailByAuditId(auditId);
            SysStaff sysStaff = (SysStaff)this.sysStaffService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getId, (Object)staffAuditVo.getRealStaffId()));
            staffAuditDetailsVo.setNewData(staffAuditVo);
            staffAuditDetailsVo.setOldData(sysStaff);
            return staffAuditDetailsVo;
        }
        throw new BaseException("id\u4e3a\u7a7a");
    }
}

