/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.authorization.organ.dto.SysStruRuleDto;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysStruRuleServiceImpl
extends HussarServiceImpl<SysStruRuleMapper, SysStruRule>
implements ISysStruRuleService {
    @Resource
    private SysStruRuleMapper sysStruRuleMapper;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private ISysOrganTypeService iSysOrganTypeService;
    @Autowired
    private ISysOrganTypeService sysOrganTypeService;

    public IPage<SysStruRuleDto> getOrganRuleList(Page<SysStruRuleDto> page, SysStruRuleDto sysStruRuleDto) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        page.setRecords(this.sysStruRuleMapper.getOrganRuleList(page, sysStruRuleDto));
        return page;
    }

    @HussarTransactional
    public boolean save(SysStruRule sysStruRule) {
        int result;
        if (ToolUtil.isEmpty((Object)sysStruRule)) {
            throw new BaseException("\u7ec4\u7ec7\u89c4\u5219\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String parentOrg = sysStruRule.getSysOrganType();
        String sonOrg = sysStruRule.getOrganType();
        if ("9".equals(parentOrg) && !"9".equals(sonOrg)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u5f53\u524d\u89c4\u5219\u4e0d\u7b26\u5408\u7ec4\u7ec7\u7c7b\u578b\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u5b9a\u4e49\uff01");
        }
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("parentOrg", parentOrg);
        map.put("sonOrg", sonOrg);
        List<Map<String, Object>> list = this.getRuleExist(map);
        if (list.size() > 0) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u5f53\u524d\u7ec4\u7ec7\u89c4\u5219\u5df2\u5b58\u5728\uff01");
        }
        if (!"9".equals(sonOrg)) {
            List allType = this.iSysOrganTypeService.list();
            SysOrganType parentSysOrganType = this.iSysOrganTypeService.getSysOrganTypeByTypeCode(parentOrg);
            String pType = "";
            if (parentSysOrganType != null) {
                pType = parentSysOrganType.getOrganType();
            }
            String sType = "";
            SysOrganType sonSysOrganType = this.iSysOrganTypeService.getSysOrganTypeByTypeCode(sonOrg);
            if (sonSysOrganType != null) {
                sType = sonSysOrganType.getOrganType();
            }
            ArrayList<String> resultType = new ArrayList<String>();
            this.recursive(allType, resultType, pType);
            resultType.add(parentOrg);
            if (!resultType.contains(sonOrg)) {
                ArrayList<String> newResultType = new ArrayList<String>();
                this.recursive(allType, newResultType, sType);
                newResultType.add(sonOrg);
                if (newResultType.contains(parentOrg)) {
                    throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u5f53\u524d\u89c4\u5219\u4e0d\u7b26\u5408\u7ec4\u7ec7\u7c7b\u578b\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u5b9a\u4e49\uff01");
                }
            }
        }
        if ((result = this.sysStruRuleMapper.insert(sysStruRule)) != 1) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        this.abstractPushMsgMatcher.insertOperation("sysStruRule", "add", (Object)sysStruRule, Constants.NONE_ID);
        return true;
    }

    @HussarTransactional
    public boolean update(SysStruRule sysStruRule) {
        if (ToolUtil.isEmpty((Object)sysStruRule)) {
            throw new BaseException("\u7ec4\u7ec7\u89c4\u5219\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int result = this.sysStruRuleMapper.updateById(sysStruRule);
        if (result != 1) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        this.abstractPushMsgMatcher.insertOperation("sysStruRule", "update", (Object)sysStruRule, Constants.NONE_ID);
        return true;
    }

    @HussarTransactional
    public boolean delete(String eId) {
        if (ToolUtil.isEmpty((Object)eId)) {
            throw new BaseException("\u8981\u5220\u9664\u7684\u7ec4\u7ec7\u89c4\u5219id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] ids = eId.split(",");
        ArrayList<String> idList = new ArrayList<String>();
        for (String id : ids) {
            if (this.isInUse(id)) {
                throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u6b63\u5728\u4f7f\u7528\u7684\u7ec4\u7ec7\u89c4\u5219\uff01");
            }
            idList.add(id);
        }
        List cdids = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        int result = this.sysStruRuleMapper.deleteBatchIds(cdids);
        if (result < 1) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        JSONObject ruleIds = new JSONObject();
        ruleIds.put("idList", idList);
        this.abstractPushMsgMatcher.insertOperation("sysStruRule", "delete", (Object)ruleIds, Constants.NONE_ID);
        return true;
    }

    public List<Map<String, Object>> getRuleExist(Map map) {
        return this.sysStruRuleMapper.getRuleExist(map.get("parentOrg").toString(), map.get("sonOrg").toString());
    }

    public List<String> getBanDelRule() {
        return this.sysStruRuleMapper.getBanDelRule();
    }

    public boolean isInUse(String ruleId) {
        boolean isExist = false;
        List<String> list = this.sysStruRuleMapper.getInUseRule(Long.parseLong(ruleId));
        if (ToolUtil.isNotEmpty(list)) {
            isExist = true;
        }
        return isExist;
    }

    public List<Map<String, Object>> getOrganByTypes(String[] organTypes) {
        return this.sysStruRuleMapper.getOrganByTypes(organTypes);
    }

    public List<String> getAllowStaffOrganType() {
        List<Map<String, Object>> allowStaffList = this.sysStruRuleMapper.getAllowStaff();
        ArrayList<String> list = new ArrayList<String>();
        for (Map<String, Object> map : allowStaffList) {
            list.add(String.valueOf(map.get("sysorgantype")));
        }
        return list;
    }

    public boolean judgeRelationshipOfType(String organTypeCode, String sysOrganTypeCode) {
        String parentTypeCode;
        boolean flag = false;
        QueryWrapper sysOrganTypeQueryWrapper = new QueryWrapper();
        sysOrganTypeQueryWrapper.lambda().eq(SysOrganType::getOrganType, (Object)sysOrganTypeCode);
        List sysOrganTypeList = this.sysOrganTypeService.list((Wrapper)sysOrganTypeQueryWrapper);
        if (ToolUtil.isNotEmpty((Object)sysOrganTypeList) && organTypeCode.equals(parentTypeCode = ((SysOrganType)sysOrganTypeList.get(0)).getParentType())) {
            flag = true;
        }
        return flag;
    }

    public boolean judgeRelationshipOfTypeCascade(String organTypeCode, String sysOrganTypeCode) {
        boolean flag = true;
        boolean flags = true;
        String parentTypeCode = sysOrganTypeCode;
        List sysOrganTypeList = this.sysOrganTypeService.list();
        if (organTypeCode.equals(sysOrganTypeCode)) {
            flags = false;
        }
        while (flags) {
            String finalParentTypeCode = parentTypeCode;
            List sysOrganTypes = sysOrganTypeList.stream().filter(o -> finalParentTypeCode.equals(String.valueOf(o.getOrganType()))).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(sysOrganTypes)) {
                parentTypeCode = ((SysOrganType)sysOrganTypes.get(0)).getParentType();
                if (!organTypeCode.equals(parentTypeCode)) continue;
                flag = false;
                flags = false;
                continue;
            }
            flags = false;
        }
        return flag;
    }

    private void recursive(List<SysOrganType> allType, List<String> resultType, String pType) {
        for (int i = 0; i < allType.size(); ++i) {
            SysOrganType iType = allType.get(i);
            if (!pType.equals(iType.getParentType())) continue;
            allType.remove(iType);
            --i;
            resultType.add(iType.getOrganType());
            String newpType = iType.getOrganType();
            this.recursive(allType, resultType, newpType);
        }
    }

    public void checkStruRuleInfo(Object object, String type) {
        ArrayList<String> messageList = new ArrayList<String>();
        switch (type) {
            case "add": 
            case "edit": {
                SysStruRule sysStruRule = (SysStruRule)JSONObject.parseObject((String)JSON.toJSONString((Object)object), SysStruRule.class);
                if (ToolUtil.isEmpty((Object)sysStruRule)) {
                    messageList.add("\u89c4\u5219\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ToolUtil.isEmpty((Object)sysStruRule.getOrganType())) {
                    messageList.add("\u672a\u586b\u5199\u7ec4\u7ec7\u7c7b\u578b\u7f16\u7801");
                }
                if (ToolUtil.isEmpty((Object)sysStruRule.getSysOrganType())) {
                    messageList.add("\u672a\u586b\u5199\u4e0a\u7ea7\u7ec4\u7ec7\u673a\u6784\u7f16\u7801");
                }
                if (sysStruRule.getRuleNote().trim().length() > 100) {
                    messageList.add("\u89c4\u5219\u63cf\u8ff0\u6700\u591a\u53ef\u8f93\u5165100\u4e2a\u5b57\u7b26");
                }
                if (!"edit".equals(type) || !ToolUtil.isEmpty((Object)sysStruRule.getId())) break;
                messageList.add("\u672a\u586b\u5199\u89c4\u5219\u5b9a\u4e49id");
                break;
            }
        }
        if (ToolUtil.isNotEmpty(messageList)) {
            String allMessage = StringUtils.join((Object[])messageList.toArray(), (String)",");
            throw new BaseException(allMessage);
        }
    }
}

