/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.manager.EditOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.editOutsideUserManagerImpl")
public class EditOutsideUserManagerImpl
extends CommonOutsideUserManager
implements EditOutsideUserManager {
    @Override
    public R<EditOutsideUserDto> editUser(EditOutsideUserDto user) {
        List<Long> organIds;
        SysUsers sysUsers;
        boolean convert;
        R result = new R();
        List errors = OrganUtil.validateOne((Object)user);
        String account = user.getUserAccount();
        boolean bl = convert = this.hussarLoginConfigService.getLoginUpperOpen() == false && !OrganConstants.EXCLUDE_USERS.contains(account);
        if (convert) {
            account = account.toUpperCase();
        }
        if ((sysUsers = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()), false)) == null) {
            OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"userAccount", (String[])new String[]{"\u7528\u6237\u8d26\u53f7\u4e0d\u5b58\u5728"});
        }
        if (HussarUtils.isNotEmpty((Object)(organIds = user.getOrganIds()))) {
            organIds = organIds.stream().distinct().collect(Collectors.toList());
            user.setOrganIds(organIds);
            List<Long> existStruIds = this.sysStruMapper.selectExistIdByIds(organIds);
            if (existStruIds.size() != organIds.size()) {
                StringBuilder msg = new StringBuilder();
                for (Long organId : organIds) {
                    if (existStruIds.contains(organId)) continue;
                    msg.append(organId).append("\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff1b");
                }
                OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"organIds", (String[])new String[]{msg.toString()});
            }
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysStaff sysStaff = (SysStaff)this.sysStaffService.getById((Serializable)sysUsers.getEmployeeId());
            this.initializationEdit(user, sysStaff, sysUsers);
            if (HussarUtils.isNotEmpty(organIds)) {
                Long departmentId = organIds.get(0);
                sysUsers.setCorporationId(departmentId);
                sysUsers.setDepartmentId(departmentId);
                this.handleUserStaff(user, sysUsers);
            }
            this.sysStaffService.updateById((Object)sysStaff);
            this.sysUsersService.updateById((Object)sysUsers);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), StringUtils.trimToEmpty((String)sysUsers.getUserAccount()))}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void handleUserStaff(EditOutsideUserDto user, SysUsers sysUsers) {
        this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)sysUsers.getId()));
        this.sysStruStaffService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruStaff::getStaffId, (Object)sysUsers.getEmployeeId()));
        List organIds = user.getOrganIds();
        if (HussarUtils.isNotEmpty((Object)organIds)) {
            ArrayList<SysStruStaff> struStaffList = new ArrayList<SysStruStaff>();
            ArrayList<SysStruUser> struUserList = new ArrayList<SysStruUser>();
            for (Long organId : organIds) {
                SysStruStaff sysStruStaff = new SysStruStaff();
                sysStruStaff.setStruId(organId);
                sysStruStaff.setStaffId(sysUsers.getEmployeeId());
                struStaffList.add(sysStruStaff);
                SysStruUser sysStruUser = new SysStruUser();
                sysStruUser.setStruId(organId);
                sysStruUser.setUserId(sysUsers.getId());
                struUserList.add(sysStruUser);
            }
            this.sysStruStaffService.saveBatch(struStaffList);
            this.sysStruUserService.saveBatch(struUserList);
        }
    }
}

