/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.addOutsideUserManagerImpl")
public class AddOutsideUserManagerImpl
extends CommonOutsideUserManager
implements AddOutsideUserManager {
    @Override
    public R<AddOutsideUserDto> addUser(AddOutsideUserDto user, boolean dealWithSelf) {
        List<Long> organIds;
        boolean exists;
        boolean convert;
        R result = new R();
        List errors = OrganUtil.validateOne((Object)user);
        String account = StringUtils.trimToEmpty((String)user.getUserAccount());
        boolean bl = convert = this.hussarLoginConfigService.getLoginUpperOpen() == false && !OrganConstants.EXCLUDE_USERS.contains(account);
        if (convert) {
            account = account.toUpperCase();
        }
        if (exists = this.existUser(account)) {
            OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"userAccount", (String[])new String[]{"\u7528\u6237\u8d26\u53f7\u91cd\u590d"});
        }
        Long departmentId = user.getDepartmentId();
        List<Long> list = organIds = HussarUtils.isNotEmpty((Object)user.getOrganIds()) ? user.getOrganIds() : new ArrayList();
        if (HussarUtils.isEmpty((Object)departmentId) && HussarUtils.isEmpty((Object)organIds)) {
            OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"departmentId", (String[])new String[]{"\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a"});
            OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"organIds", (String[])new String[]{"\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        if (HussarUtils.isNotEmpty((Object)departmentId)) {
            organIds.add(departmentId);
        }
        if (HussarUtils.isNotEmpty((Object)organIds)) {
            organIds = organIds.stream().distinct().collect(Collectors.toList());
            user.setOrganIds(organIds);
            List<Long> existStruIds = this.sysStruMapper.selectExistIdByIds(organIds);
            if (existStruIds.size() != organIds.size()) {
                StringBuilder msg = new StringBuilder();
                boolean errorFlag = false;
                for (Long organId : organIds) {
                    if (existStruIds.contains(organId) || organId.equals(departmentId)) continue;
                    msg.append(organId).append("\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff1b");
                    errorFlag = true;
                }
                if (!existStruIds.contains(departmentId)) {
                    OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"departmentId", (String[])new String[]{"\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728"});
                }
                if (errorFlag) {
                    OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"organIds", (String[])new String[]{msg.toString()});
                }
            }
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysStaff sysStaff = new SysStaff();
            SysUsers sysUsers = new SysUsers();
            ArrayList<SysStruStaff> struStaffList = new ArrayList<SysStruStaff>();
            ArrayList<SysStruUser> struUserList = new ArrayList<SysStruUser>();
            user.setUserAccount(account);
            this.initializationAdd(convert, user, struStaffList, struUserList, sysStaff, sysUsers);
            if (dealWithSelf) {
                sysUsers.setPassword(StringUtils.trimToEmpty((String)user.getSecure()));
            }
            this.addStaffUser(struStaffList, struUserList, sysStaff, sysUsers);
            if (HussarUtils.isNotEmpty((Object)this.sysSyncDataInService)) {
                this.sysSyncDataInService.saveSyncRecord(SysUsers.class, (List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), sysUsers.getUserAccount())}));
            }
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), sysUsers.getUserAccount())}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void addStaffUser(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, SysUsers sysUsers) {
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setOrganId(null);
        sysStru.setIsLeaf("0");
        sysStru.setStruPath("");
        Integer order = 1;
        Integer maxOrder = this.staffUserMapper.getMaxOrderUnderParent(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            order = maxOrder + 1;
        }
        sysStru.setStruOrder(order);
        this.sysOrganMapper.insert(sysOrgan);
        sysStru.setOrganId(sysOrgan.getId());
        this.sysStruMapper.insert(sysStru);
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            sysStaff.setName(sysOrgan.getOrganName());
            sysStaff.setStruId(sysStru.getId());
            this.staffUserMapper.insert(sysStaff);
        }
        if (StringUtils.isBlank((CharSequence)sysUsers.getPassword())) {
            String pass = "";
            pass = this.createUserConfigService.getCreateUserSendEmail() != false && this.createUserConfigService.getCreateUserUseDefaultPass() == false ? "123456" : this.pwdConfigService.getDefaultPassword();
            String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
            sysUsers.setPassword(pwd);
        }
        sysUsers.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
        sysUsers.setAccountStatus(UserStatus.OK.getCode());
        sysUsers.setSecurityLevel(Integer.valueOf(1));
        sysUsers.setMaxSessions(Integer.valueOf(1));
        sysUsers.setLoginIpLimit("0");
        sysUsers.setLoginTimeLimit("0");
        sysUsers.setIsSys("0");
        sysUsers.setIsCpublic("0");
        sysUsers.setCorporationId(sysStru.getParentId());
        sysUsers.setDepartmentId(sysStru.getParentId());
        sysUsers.setEmployeeId(sysStru.getId());
        sysUsers.setTypeProperty("1");
        Integer userOrder = this.sysUsersService.getMaxOrder(sysUsers.getDepartmentId());
        userOrder = ToolUtil.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
        sysUsers.setUserOrder(userOrder);
        this.sysUsersService.save((Object)sysUsers);
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(sysUsers.getId());
        userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
        userRole.setAdminOption("1");
        this.sysUserRoleMapper.insert(userRole);
    }

    private void initializationAdd(boolean convert, AddOutsideUserDto userDto, SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, SysUsers sysUsers) {
        long sysStruId = IdWorker.getId((Object)sysStru);
        long sysOrganId = IdWorker.getId((Object)sysOrgan);
        long sysStaffId = IdWorker.getId((Object)sysStaff);
        long sysUserId = IdWorker.getId((Object)sysUsers);
        Long departmentId = userDto.getDepartmentId();
        String userAccount = StringUtils.trimToEmpty((String)userDto.getUserAccount());
        String userName = StringUtils.trimToEmpty((String)userDto.getUserName());
        String weChat = StringUtils.trimToEmpty((String)userDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)userDto.getMobile());
        String telephone = StringUtils.trimToEmpty((String)userDto.getTelephone());
        String staffPosition = StringUtils.trimToEmpty((String)userDto.getStaffPosition());
        String sex = StringUtils.trimToEmpty((String)userDto.getSex());
        String birthday = StringUtils.trimToEmpty((String)userDto.getBirthday());
        String idcard = StringUtils.trimToEmpty((String)userDto.getIdcard());
        String address = StringUtils.trimToEmpty((String)userDto.getAddress());
        String workId = StringUtils.trimToEmpty((String)userDto.getWorkId());
        String workDate = StringUtils.trimToEmpty((String)userDto.getWorkDate());
        String graduateDate = StringUtils.trimToEmpty((String)userDto.getGraduateDate());
        String graduateSchool = StringUtils.trimToEmpty((String)userDto.getGraduateSchool());
        sysStru.setId(Long.valueOf(sysStruId));
        sysStru.setOrganId(Long.valueOf(sysOrganId));
        sysStru.setParentId(departmentId);
        sysStru.setStruType("9");
        sysStru.setOrganAlias(userName);
        sysStru.setStaffPosition(staffPosition);
        sysStru.setIsEmployee("1");
        int level = 0;
        SysStru temp = (SysStru)this.sysStruMapper.selectById(sysStru.getParentId());
        level = HussarUtils.isEmpty((Object)temp) ? 1 : temp.getStruLevel() + 1;
        sysStru.setStruLevel(Integer.valueOf(level));
        Integer orderTree = 1;
        Integer maxOrder = this.sysStruMapper.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            orderTree = maxOrder + 1;
        }
        Integer struOrder = orderTree;
        sysStru.setStruOrder(struOrder);
        sysStaff.setId(Long.valueOf(sysStaffId));
        sysStaff.setStruId(Long.valueOf(sysStruId));
        sysStaff.setName(userName);
        sysStaff.setAddress(address);
        sysStaff.setBirthday(birthday);
        sysStaff.setSex(sex);
        sysStaff.setIdcard(idcard);
        sysStaff.setGraduateDate(graduateDate);
        sysStaff.setGraduateSchool(graduateSchool);
        sysStaff.setWorkDate(workDate);
        sysStaff.setWorkId(workId);
        sysOrgan.setId(Long.valueOf(sysOrganId));
        sysOrgan.setOrganName(sysStaff.getName());
        sysOrgan.setOrganType("9");
        String newCode = this.getCode();
        sysOrgan.setOrganCode(newCode);
        sysUsers.setId(Long.valueOf(sysUserId));
        sysUsers.setSecurityLevel(Integer.valueOf(1));
        sysUsers.setIsSys("0");
        sysUsers.setIsCpublic("0");
        sysUsers.setMaxSessions(Integer.valueOf(1));
        sysUsers.setUserAccount(convert ? userAccount.toUpperCase() : userAccount);
        sysUsers.setUserName(userName);
        sysUsers.setWeChat(weChat);
        sysUsers.setMobile(mobile);
        sysUsers.setTelephone(telephone);
    }

    private void initializationAdd(boolean convert, AddOutsideUserDto userDto, List<SysStruStaff> struStaffList, List<SysStruUser> struUserList, SysStaff sysStaff, SysUsers sysUsers) {
        long sysStaffId = IdWorker.getId((Object)sysStaff);
        long sysUserId = IdWorker.getId((Object)sysUsers);
        List organIds = userDto.getOrganIds();
        String userAccount = StringUtils.trimToEmpty((String)userDto.getUserAccount());
        String userName = StringUtils.trimToEmpty((String)userDto.getUserName());
        String weChat = StringUtils.trimToEmpty((String)userDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)userDto.getMobile());
        String mail = StringUtils.trimToEmpty((String)userDto.getMail());
        String telephone = StringUtils.trimToEmpty((String)userDto.getTelephone());
        String staffPosition = StringUtils.trimToEmpty((String)userDto.getStaffPosition());
        String sex = StringUtils.trimToEmpty((String)userDto.getSex());
        String birthday = StringUtils.trimToEmpty((String)userDto.getBirthday());
        String idcard = StringUtils.trimToEmpty((String)userDto.getIdcard());
        String address = StringUtils.trimToEmpty((String)userDto.getAddress());
        String workId = StringUtils.trimToEmpty((String)userDto.getWorkId());
        String workDate = StringUtils.trimToEmpty((String)userDto.getWorkDate());
        String graduateDate = StringUtils.trimToEmpty((String)userDto.getGraduateDate());
        String graduateSchool = StringUtils.trimToEmpty((String)userDto.getGraduateSchool());
        sysStaff.setId(Long.valueOf(sysStaffId));
        sysStaff.setName(userName);
        sysStaff.setAddress(address);
        sysStaff.setBirthday(birthday);
        sysStaff.setSex(sex);
        sysStaff.setIdcard(idcard);
        sysStaff.setGraduateDate(graduateDate);
        sysStaff.setGraduateSchool(graduateSchool);
        sysStaff.setWorkDate(workDate);
        sysStaff.setWorkId(workId);
        sysStaff.setStaffPosition(staffPosition);
        sysStaff.setStaffCode(this.sysIdtableService.getCurrentCode("STAFF_CODE", "SYS_STAFF"));
        sysUsers.setId(Long.valueOf(sysUserId));
        sysUsers.setSecurityLevel(Integer.valueOf(1));
        sysUsers.setIsSys("0");
        sysUsers.setIsCpublic("0");
        sysUsers.setMaxSessions(Integer.valueOf(-1));
        sysUsers.setUserAccount(convert ? userAccount.toUpperCase() : userAccount);
        sysUsers.setUserName(userName);
        sysUsers.setWeChat(weChat);
        sysUsers.seteMail(mail);
        sysUsers.setMobile(mobile);
        sysUsers.setTelephone(telephone);
        sysUsers.setEmployeeId(Long.valueOf(sysStaffId));
        for (Long organId : organIds) {
            SysStruStaff sysStruStaff = new SysStruStaff();
            SysStruUser sysStruUser = new SysStruUser();
            sysStruStaff.setStruId(organId);
            sysStruStaff.setStaffId(Long.valueOf(sysStaffId));
            struStaffList.add(sysStruStaff);
            sysStruUser.setStruId(organId);
            sysStruUser.setUserId(Long.valueOf(sysUserId));
            struUserList.add(sysStruUser);
        }
    }

    private void addStaffUser(List<SysStruStaff> struStaffList, List<SysStruUser> struUserList, SysStaff sysStaff, SysUsers sysUsers) {
        if (HussarUtils.isNotEmpty(struStaffList)) {
            this.sysStruStaffService.saveBatch(struStaffList);
        }
        if (HussarUtils.isNotEmpty(struUserList)) {
            this.sysStruUserService.saveBatch(struUserList);
        }
        int order = 1;
        Integer maxStaffOrder = this.sysStaffMapper.getMaxOrder();
        sysStaff.setStaffOrder(Integer.valueOf(HussarUtils.isEmpty((Object)maxStaffOrder) ? order : maxStaffOrder + 1));
        this.sysStaffMapper.insert(sysStaff);
        if (StringUtils.isBlank((CharSequence)sysUsers.getPassword())) {
            String pass = "";
            pass = this.createUserConfigService.getCreateUserSendEmail() != false && this.createUserConfigService.getCreateUserUseDefaultPass() == false ? "123456" : this.pwdConfigService.getDefaultPassword();
            String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
            sysUsers.setPassword(pwd);
        }
        sysUsers.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
        sysUsers.setAccountStatus(UserStatus.OK.getCode());
        sysUsers.setSecurityLevel(Integer.valueOf(1));
        sysUsers.setMaxSessions(Integer.valueOf(1));
        sysUsers.setLoginIpLimit("0");
        sysUsers.setLoginTimeLimit("0");
        sysUsers.setIsSys("0");
        sysUsers.setIsCpublic("0");
        Long departmentId = struUserList.get(0).getStruId();
        if (HussarUtils.isNotEmpty((Object)departmentId)) {
            sysUsers.setCorporationId(departmentId);
            sysUsers.setDepartmentId(departmentId);
        }
        sysUsers.setEmployeeId(sysStaff.getId());
        sysUsers.setTypeProperty("1");
        Integer userOrder = this.sysUsersMapper.getUserMaxOrder();
        sysUsers.setUserOrder(Integer.valueOf(HussarUtils.isEmpty((Object)userOrder) ? order : userOrder + 1));
        this.sysUsersService.save((Object)sysUsers);
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(sysUsers.getId());
        userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
        userRole.setAdminOption("1");
        this.sysUserRoleMapper.insert(userRole);
    }
}

