/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.menu.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.menu.manager.DeleteBatchOutsideMenuManager;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.impl.CommonOutsideMenuManager;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.sync.model.SysSyncDataIn;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.menu.manager.impl.deleteBatchOutsideMenuManagerImpl")
public class DeleteBatchOutsideMenuManagerImpl
extends CommonOutsideMenuManager
implements DeleteBatchOutsideMenuManager {
    @Override
    public R<String> deleteMenuWithResFun(List<String> menuCodes) {
        R result = new R();
        ArrayList errors = new ArrayList();
        ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
        List syncDataIns = new ArrayList();
        if (HussarUtils.isEmpty(menuCodes)) {
            OrganUtil.addErrorMsg(errors, (Object)"", (String)"menuCode", (String[])new String[]{"\u7f16\u7801\u4f20\u9012\u4e3a\u7a7a"});
        } else {
            syncDataIns = ((LambdaQueryChainWrapper)this.sysSyncDataInService.lambdaQuery().in(SysSyncDataIn::getHussarOutsideUniqueValue, menuCodes)).list();
            if (HussarUtils.isEmpty(syncDataIns)) {
                OrganUtil.addErrorMsg(errors, (Object)"", (String)"menuCode", (String[])new String[]{"\u672a\u627e\u5230\u8be5\u83dc\u5355"});
            } else {
                List menuCodeList = syncDataIns.stream().map(SysSyncDataIn::getHussarOutsideUniqueValue).collect(Collectors.toList());
                for (String menuCode : menuCodes) {
                    if (menuCodeList.contains(menuCode)) continue;
                    OrganUtil.addErrorMsg(errors, (Object)menuCode, (String)"menuCode", (String[])new String[]{"\u8be5\u7f16\u7801\u7684\u83dc\u5355\u672a\u8fdb\u884c\u540c\u6b65"});
                }
            }
        }
        if (HussarUtils.isEmpty(errors)) {
            List menuIds = syncDataIns.stream().map(SysSyncDataIn::getHussarTablePkVal).collect(Collectors.toList());
            List menuList = this.sysMenuManageService.listByIds(menuIds);
            ArrayList<Long> menuRootIds = new ArrayList<Long>();
            for (SysMenu menu : menuList) {
                if (!menu.getParentId().equals(DEFAULT_MENU_PARENT_ID) && menuIds.contains(menu.getParentId())) continue;
                menuRootIds.add(menu.getId());
            }
            List rootMenuCodes = syncDataIns.stream().filter(s -> menuRootIds.contains(s.getHussarTablePkVal())).map(SysSyncDataIn::getHussarOutsideUniqueValue).collect(Collectors.toList());
            ArrayList allMenuIds = Lists.newArrayList(menuRootIds);
            this.getChildMenuIds(allMenuIds, allMenuIds);
            Map syncDataInMap = syncDataIns.stream().collect(Collectors.toMap(SysSyncDataIn::getHussarOutsideUniqueValue, Function.identity()));
            for (String menuCode : rootMenuCodes) {
                SysSyncDataIn currentSysSyncDataIn = (SysSyncDataIn)syncDataInMap.get(menuCode);
                Long menuId = currentSysSyncDataIn.getHussarTablePkVal();
                SysMenu sysMenu = (SysMenu)this.sysMenuManageService.getById((Serializable)menuId);
                if (HussarUtils.isEmpty((Object)sysMenu)) continue;
                this.sysMenuManageService.deleteMenus(menuId.toString());
                if (sysMenu.getIsLeaf().equals("1")) {
                    SysFunctions sysFunctions = (SysFunctions)((LambdaQueryChainWrapper)this.sysFunctionsService.lambdaQuery().eq(SysFunctions::getFunctionCode, (Object)menuCode)).one();
                    SysResources sysResources = (SysResources)((LambdaQueryChainWrapper)this.sysResourcesService.lambdaQuery().eq(SysResources::getResourceCode, (Object)menuCode)).one();
                    this.sysFunctionsService.deleteFunction(sysFunctions.getId());
                    this.sysResManageService.delModuleResCascade(null, sysResources.getId());
                } else {
                    SysFunctionModules sysFunctionModules = (SysFunctionModules)((LambdaQueryChainWrapper)this.sysFunctionModulesService.lambdaQuery().eq(SysFunctionModules::getFunctionModuleCode, (Object)menuCode)).one();
                    SysResourceModules sysResourceModules = (SysResourceModules)((LambdaQueryChainWrapper)this.sysResourceMosulesService.lambdaQuery().eq(SysResourceModules::getModuleCode, (Object)menuCode)).one();
                    this.sysFunctionModulesService.deleteFunctionModules(sysFunctionModules.getId());
                    this.sysResManageService.delModuleResCascade(sysResourceModules.getId(), null);
                }
                dataMappings.add(new DataMapping(menuId, menuCode));
            }
            this.sysSyncDataInService.remove((Wrapper)new LambdaUpdateWrapper().in(SysSyncDataIn::getHussarTablePkVal, (Collection)allMenuIds));
            result.setSuccess(true);
            result.setSuccessList(dataMappings);
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void getChildMenuIds(List<Long> menuIds, List<Long> parentIds) {
        ArrayList parentIdls = Lists.newArrayList(parentIds);
        List childMenuList = this.sysMenuManageService.list((Wrapper)new LambdaQueryWrapper().in(SysMenu::getParentId, (Collection)parentIdls));
        ArrayList<Long> childIds = new ArrayList<Long>();
        if (childMenuList.size() > 0) {
            childMenuList.forEach(child -> childIds.add(child.getId()));
        }
        if (childIds.size() > 0) {
            menuIds.addAll(childIds);
            this.getChildMenuIds(menuIds, childIds);
        }
    }
}

