/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.relational.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserRoleExpandService;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.relational.service.impl.hussarBaseUserPostRoleServiceImpl")
public class HussarBaseUserPostRoleServiceImpl
implements IHussarBaseUserRoleExpandService {
    @Autowired
    private ISysUserPostService sysUserPostService;
    @Autowired
    private ISysPostRoleService sysPostRoleService;

    public String getRelateType() {
        return "post";
    }

    public List<Long> getExpandRolesByUserId(Long userId) {
        List userPosts = this.sysUserPostService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)userId));
        if (HussarUtils.isEmpty((Object)userPosts)) {
            return Collections.emptyList();
        }
        List postIds = userPosts.stream().map(SysUserPost::getUserId).distinct().collect(Collectors.toList());
        List postRoles = this.sysPostRoleService.list((Wrapper)new LambdaQueryWrapper().in(SysPostRole::getPostId, postIds));
        if (HussarUtils.isEmpty((Object)postRoles)) {
            return Collections.emptyList();
        }
        return postRoles.stream().map(SysPostRole::getRoleId).distinct().collect(Collectors.toList());
    }

    public List<Long> getRolesByBusinessId(List<Long> businessIds) {
        if (HussarUtils.isEmpty(businessIds)) {
            throw new BaseException("\u5c97\u4f4did\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List postRoles = this.sysPostRoleService.list((Wrapper)new LambdaQueryWrapper().in(SysPostRole::getPostId, businessIds));
        if (HussarUtils.isEmpty((Object)postRoles)) {
            return Collections.emptyList();
        }
        return postRoles.stream().map(SysPostRole::getRoleId).collect(Collectors.toList());
    }
}

