/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.relational.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.post.dao.SysPostMapper;
import com.jxdinfo.hussar.authorization.post.manager.impl.PostUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.relational.dao.SysUserPostAuditMapper;
import com.jxdinfo.hussar.authorization.relational.manager.AuditUserPostManager;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPostAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.postmanager.PostChangeNotify;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.usermanager.UserChangeNotify;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.relational.manager.impl.auditUserPostManagerImpl")
public class AuditUserPostManagerImpl
implements AuditUserPostManager {
    @Resource
    private SysUserPostAuditMapper sysUserPostAuditMapper;
    @Autowired
    private ISysUserPostService sysUserPostService;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private IHussarBasePostService hussarBasePostService;
    @Autowired
    private PostChangeNotify postChangeNotify;
    @Resource
    private SysPostMapper sysPostMapper;
    @Autowired
    private UserChangeNotify userChangeNotify;
    @Autowired
    private PostUserAuthorizationChangeReporter postUserAuthorizationChangeReporter;

    @Override
    public Boolean pass(Long auditId) {
        boolean result;
        SysUserPostAudit userPostAudit = (SysUserPostAudit)this.sysUserPostAuditMapper.selectById(auditId);
        String operateType = userPostAudit.getOperateType();
        if ("1".equals(operateType)) {
            result = this.doAuditAdd(userPostAudit);
        } else if ("2".equals(operateType)) {
            result = this.doAuditDelete(userPostAudit);
        } else {
            throw new BaseException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b");
        }
        if (result) {
            ArrayList<Long> userIds = new ArrayList<Long>();
            userIds.add(userPostAudit.getUserId());
            this.postUserAuthorizationChangeReporter.report(new Object[]{userIds});
        }
        return result;
    }

    @Override
    public Boolean reject(Long auditId) {
        SysUserPostAudit userPostAudit = (SysUserPostAudit)this.sysUserPostAuditMapper.selectById(auditId);
        userPostAudit.setAuditStatus("2");
        return this.sysUserPostAuditMapper.updateById(userPostAudit) > 0;
    }

    private boolean doAuditDelete(SysUserPostAudit userPostAudit) {
        List userPosts = this.sysUserPostService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPost::getPostId, (Object)userPostAudit.getPostId())).eq(SysUserPost::getUserId, (Object)userPostAudit.getUserId())).eq(SysUserPost::getRelateType, (Object)userPostAudit.getRelateType())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (HussarUtils.isEmpty((Object)userPosts)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\u7528\u6237\u5c97\u4f4d\u5df2\u53d6\u6d88\u5173\u8054\uff01");
        }
        boolean remove = this.sysUserPostService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPost::getPostId, (Object)userPostAudit.getPostId())).eq(SysUserPost::getUserId, (Object)userPostAudit.getUserId())).eq(SysUserPost::getRelateType, (Object)userPostAudit.getRelateType()));
        userPostAudit.setAuditStatus("1");
        boolean updateFlag = this.sysUserPostAuditMapper.updateById(userPostAudit) > 0;
        SysPost post = (SysPost)this.sysPostMapper.selectById(userPostAudit.getPostId());
        this.postChangeNotify.notify(DataChangeType.UPDATE, new Object[]{post});
        SysUsers user = this.sysUsersService.getById(userPostAudit.getUserId());
        this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{user});
        return remove && updateFlag;
    }

    private boolean doAuditAdd(SysUserPostAudit userPostAudit) {
        List usersList = this.sysUsersService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getId, (Object)userPostAudit.getUserId())).ne(SysUsers::getAccountStatus, (Object)"2"));
        if (HussarUtils.isEmpty((Object)usersList)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        List postList = this.hussarBasePostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPost::getId, (Object)userPostAudit.getPostId())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (HussarUtils.isEmpty((Object)postList)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u5c97\u4f4d\u4e0d\u5b58\u5728\uff01");
        }
        List userPosts = this.sysUserPostService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPost::getPostId, (Object)userPostAudit.getPostId())).eq(SysUserPost::getUserId, (Object)userPostAudit.getUserId())).eq(SysUserPost::getRelateType, (Object)userPostAudit.getRelateType())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (HussarUtils.isNotEmpty((Object)userPosts)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u7528\u6237\u5c97\u4f4d\u5df2\u5173\u8054\uff01");
        }
        SysUserPost userPost = new SysUserPost();
        userPost.setPostId(userPostAudit.getPostId());
        userPost.setUserId(userPostAudit.getUserId());
        userPost.setRelateType(userPostAudit.getRelateType());
        boolean saveFlag = this.sysUserPostService.save((Object)userPost);
        userPostAudit.setAuditStatus("1");
        boolean updateFlag = this.sysUserPostAuditMapper.updateById(userPostAudit) > 0;
        SysPost post = (SysPost)this.sysPostMapper.selectById(userPostAudit.getPostId());
        this.postChangeNotify.notify(DataChangeType.UPDATE, new Object[]{post});
        SysUsers user = this.sysUsersService.getById(userPost.getUserId());
        this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{user});
        return saveFlag && updateFlag;
    }
}

