/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddBatchOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.AddOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteBatchOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.EditBatchOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.EditOutsideUserManager;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseSyncUserService;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.hussarBaseSyncUserServiceImpl")
public class HussarBaseSyncUserServiceImpl
implements IHussarBaseSyncUserService {
    private static final Logger logger = LoggerFactory.getLogger(HussarBaseSyncUserServiceImpl.class);
    private static final String CACHE = "hussarOrganizationJob";
    @Autowired
    private AddOutsideUserManager addOutsideUserManager;
    @Autowired
    private AddBatchOutsideUserManager addBatchOutsideUserManager;
    @Autowired
    private EditOutsideUserManager editOutsideUserManager;
    @Autowired
    private EditBatchOutsideUserManager editBatchOutsideUserManager;
    @Autowired
    private DeleteOutsideUserManager deleteOutsideUserManager;
    @Autowired
    private DeleteBatchOutsideUserManager deleteBatchOutsideUserManager;

    @HussarTransactional
    public synchronized R<AddOutsideUserDto> addUser(AddOutsideUserDto user) {
        R<AddOutsideUserDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u65b0\u589e\u7528\u6237\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u65b0\u589e\u7528\u6237\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.addOutsideUserManager.addUser(user, false);
        }
        catch (BaseException e) {
            throw new BaseException("\u65b0\u589e\u7528\u6237\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    public R<AddOutsideUserDto> addUserWithSecure(AddOutsideUserDto user) {
        R<AddOutsideUserDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u65b0\u589e\u7528\u6237\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u65b0\u589e\u7528\u6237\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.addOutsideUserManager.addUser(user, true);
        }
        catch (BaseException e) {
            throw new BaseException("\u65b0\u589e\u7528\u6237\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<AddOutsideUserDto> addBatchUsers(List<AddOutsideUserDto> users) {
        R<AddOutsideUserDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u6279\u91cf\u65b0\u589e\u7528\u6237\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u6279\u91cf\u65b0\u589e\u7528\u6237\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.addBatchOutsideUserManager.addBatchUsers(users, false);
        }
        catch (BaseException e) {
            throw new BaseException("\u6279\u91cf\u65b0\u589e\u7528\u6237\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    public R<AddOutsideUserDto> addBatchUsersWithSecure(List<AddOutsideUserDto> users) {
        R<AddOutsideUserDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u6279\u91cf\u65b0\u589e\u7528\u6237\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u6279\u91cf\u65b0\u589e\u7528\u6237\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.addBatchOutsideUserManager.addBatchUsers(users, true);
        }
        catch (BaseException e) {
            throw new BaseException("\u6279\u91cf\u65b0\u589e\u7528\u6237\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<EditOutsideUserDto> editUser(EditOutsideUserDto user) {
        R<EditOutsideUserDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u4fee\u6539\u7528\u6237\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u4fee\u6539\u7528\u6237\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.editOutsideUserManager.editUser(user);
        }
        catch (BaseException e) {
            throw new BaseException("\u4fee\u6539\u7528\u6237\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<EditOutsideUserDto> editBatchUsers(List<EditOutsideUserDto> users) {
        R<EditOutsideUserDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u6279\u91cf\u4fee\u6539\u7528\u6237\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u6279\u91cf\u4fee\u6539\u7528\u6237\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.editBatchOutsideUserManager.editBatchUsers(users);
        }
        catch (BaseException e) {
            throw new BaseException("\u6279\u91cf\u4fee\u6539\u7528\u6237\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteUser(String userAccount) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u5220\u9664\u7528\u6237\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u5220\u9664\u7528\u6237\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteOutsideUserManager.deleteUser(userAccount);
        }
        catch (BaseException e) {
            throw new BaseException("\u5220\u9664\u7528\u6237\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public R<String> deleteBatchUsers(List<String> accounts) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u5220\u9664\u7528\u6237\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u5220\u9664\u7528\u6237\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE, (long)600L);
            r = this.deleteBatchOutsideUserManager.deleteBatchUsers(accounts);
        }
        catch (BaseException e) {
            throw new BaseException("\u5220\u9664\u7528\u6237\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }
}

