/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.impl.SysMenuManageServiceImpl;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.AddOutsidePostRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.AddOutsideStruRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.AddOutsideUserRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.OutsideRoleGroupDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleFuncDto;
import com.jxdinfo.hussar.authorization.permit.dto.SaveOutsideMenuRoleDto;
import com.jxdinfo.hussar.authorization.permit.manager.OutsideRoleManager;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.relational.model.SysPostRole;
import com.jxdinfo.hussar.authorization.relational.service.ISysPostRoleService;
import com.jxdinfo.hussar.authorization.sync.model.SysSyncDataIn;
import com.jxdinfo.hussar.authorization.sync.service.ISysSyncDataInService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.outsideRoleManagerImpl")
public class OutsideRoleManagerImpl
implements OutsideRoleManager {
    @Resource
    private SysRoleGroupMapper sysRoleGroupMapper;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysStruRoleService sysStruRoleService;
    @Resource
    private ISysPostRoleService sysPostRoleService;
    @Resource
    private ISysRolesService sysRolesService;
    @Autowired(required=false)
    protected ISysSyncDataInService sysSyncDataInService;
    @Autowired
    private SysMenuManageServiceImpl sysMenuManageServiceImpl;

    @Override
    public R<OutsideRoleGroupDto> addRoleGroup(OutsideRoleGroupDto roleGroup) {
        R result = new R();
        List errors = OrganUtil.validateOne((Object)roleGroup);
        Long groupId = roleGroup.getGroupId();
        SysRoleGroup sysRoleGroup = new SysRoleGroup();
        if (HussarUtils.isNotEmpty((Object)groupId)) {
            SysRoleGroup group = (SysRoleGroup)this.sysRoleGroupMapper.selectById(groupId);
            if (HussarUtils.isNotEmpty((Object)group)) {
                OrganUtil.addErrorMsg((List)errors, (Object)roleGroup, (String)"groupId", (String[])new String[]{"\u89d2\u8272\u5206\u7ec4Id\u91cd\u590d"});
            }
        } else {
            groupId = IdWorker.getId((Object)sysRoleGroup);
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            String groupName = StringUtils.trimToEmpty((String)roleGroup.getGroupName());
            String groupAlias = StringUtils.trimToEmpty((String)roleGroup.getGroupAlias());
            sysRoleGroup.setId(groupId);
            sysRoleGroup.setGroupName(groupName);
            sysRoleGroup.setGroupAlias(groupAlias);
            sysRoleGroup.setParentId(Long.valueOf(1L));
            sysRoleGroup.setIsSys("0");
            int groupOrder = this.sysRoleGroupMapper.getMaxOrder() + 1;
            sysRoleGroup.setGroupOrder(Integer.valueOf(groupOrder));
            this.sysRoleGroupMapper.insert(sysRoleGroup);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysRoleGroup.getId(), String.valueOf(sysRoleGroup.getId()))}));
            if (HussarUtils.isNotEmpty((Object)this.sysSyncDataInService)) {
                this.sysSyncDataInService.saveSyncRecord(SysRoleGroup.class, (List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysRoleGroup.getId(), String.valueOf(sysRoleGroup.getId()))}));
            }
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    @Override
    public R<OutsideRoleGroupDto> editRoleGroup(OutsideRoleGroupDto roleGroup) {
        R result = new R();
        List errors = OrganUtil.validateOne((Object)roleGroup);
        Long groupId = roleGroup.getGroupId();
        if (HussarUtils.isEmpty((Object)groupId)) {
            throw new BaseException("\u89d2\u8272\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysRoleGroup sysRoleGroup = (SysRoleGroup)this.sysRoleGroupMapper.selectById(groupId);
        if (HussarUtils.isEmpty((Object)sysRoleGroup)) {
            OrganUtil.addErrorMsg((List)errors, (Object)roleGroup, (String)"groupId", (String[])new String[]{"\u89d2\u8272\u5206\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            String groupName = StringUtils.trimToEmpty((String)roleGroup.getGroupName());
            String groupAlias = StringUtils.trimToEmpty((String)roleGroup.getGroupAlias());
            sysRoleGroup.setGroupName(groupName);
            sysRoleGroup.setGroupAlias(groupAlias);
            this.sysRoleGroupMapper.updateById(sysRoleGroup);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysRoleGroup.getId(), String.valueOf(sysRoleGroup.getId()))}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    @Override
    public R<Long> deleteRoleGroup(Long roleGroupId) {
        R result = new R();
        ArrayList errors = new ArrayList();
        SysRoleGroup sysRoleGroup = (SysRoleGroup)this.sysRoleGroupMapper.selectById(roleGroupId);
        if (sysRoleGroup == null) {
            OrganUtil.addErrorMsg(errors, (Object)roleGroupId, (String)"roleGroupId", (String[])new String[]{"\u89d2\u8272\u5206\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"});
        } else {
            Long count = this.sysRolesMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getGroupId, (Object)roleGroupId));
            if (count > 0L) {
                OrganUtil.addErrorMsg(errors, (Object)roleGroupId, (String)"roleGroupId", (String[])new String[]{"\u89d2\u8272\u5206\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"});
            }
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            this.sysRoleGroupMapper.deleteById(roleGroupId);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysRoleGroup.getId(), String.valueOf(sysRoleGroup.getId()))}));
        }
        return result;
    }

    @Override
    public Boolean saveUserRole(AddOutsideUserRoleDto userRoleDto) {
        List ids = userRoleDto.getIds();
        String type = userRoleDto.getType();
        List userRoleList = userRoleDto.getUserRoleList();
        if ("user".equals(type)) {
            this.sysUserRoleService.remove((Wrapper)new LambdaQueryWrapper().in(SysUserRole::getUserId, (Collection)ids));
        } else if ("role".equals(type)) {
            this.sysUserRoleService.remove((Wrapper)new LambdaQueryWrapper().in(SysUserRole::getGrantedRole, (Collection)ids));
        } else {
            throw new BaseException("\u4e0d\u652f\u6301\u6b64\u7c7b\u578b");
        }
        if (HussarUtils.isNotEmpty((Object)userRoleList)) {
            for (SysUserRole sysUserRole : userRoleList) {
                sysUserRole.setAdminOption("1");
            }
            this.sysUserRoleService.saveBatch((Collection)userRoleList);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean saveStruRole(AddOutsideStruRoleDto struRoleDto) {
        List ids = struRoleDto.getIds();
        String type = struRoleDto.getType();
        List struRoleList = struRoleDto.getStruRoleList();
        if ("organ".equals(type)) {
            this.sysStruRoleService.remove((Wrapper)new LambdaQueryWrapper().in(SysStruRole::getStruId, (Collection)ids));
        } else if ("role".equals(type)) {
            this.sysStruRoleService.remove((Wrapper)new LambdaQueryWrapper().in(SysStruRole::getGrantedRole, (Collection)ids));
        } else {
            throw new BaseException("\u4e0d\u652f\u6301\u8be5\u7c7b\u578b");
        }
        if (HussarUtils.isNotEmpty((Object)struRoleList)) {
            this.sysStruRoleService.saveBatch((Collection)struRoleList);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean savePostRole(AddOutsidePostRoleDto postRoleDto) {
        List ids = postRoleDto.getIds();
        String type = postRoleDto.getType();
        List postRoleList = postRoleDto.getPostRoleList();
        if ("post".equals(type)) {
            this.sysPostRoleService.remove((Wrapper)new LambdaQueryWrapper().in(SysPostRole::getPostId, (Collection)ids));
        } else if ("role".equals(type)) {
            this.sysPostRoleService.remove((Wrapper)new LambdaQueryWrapper().in(SysPostRole::getRoleId, (Collection)ids));
        } else {
            throw new BaseException("\u4e0d\u652f\u6301\u8be5\u7c7b\u578b");
        }
        if (HussarUtils.isNotEmpty((Object)postRoleList)) {
            this.sysPostRoleService.saveBatch((Collection)postRoleList);
        }
        return Boolean.TRUE;
    }

    @Override
    public R<Boolean> saveMenuRole(SaveOutsideMenuRoleDto menuRoleDto) {
        R result = new R();
        ArrayList errors = new ArrayList();
        SysSyncDataIn sysSyncDataIn = (SysSyncDataIn)((LambdaQueryChainWrapper)this.sysSyncDataInService.lambdaQuery().eq(SysSyncDataIn::getHussarOutsideUniqueValue, (Object)menuRoleDto.getRoleId().toString())).one();
        if (HussarUtils.isEmpty((Object)sysSyncDataIn)) {
            OrganUtil.addErrorMsg(errors, (Object)Boolean.FALSE, (String)"roleId", (String[])new String[]{"\u5f53\u524d\u89d2\u8272\u4e0d\u5b58\u5728"});
        }
        Long roleId = menuRoleDto.getRoleId();
        List sysSyncDataInList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)menuRoleDto.getMenuCodes())) {
            sysSyncDataInList = ((LambdaQueryChainWrapper)this.sysSyncDataInService.lambdaQuery().in(SysSyncDataIn::getHussarOutsideUniqueValue, (Collection)menuRoleDto.getMenuCodes())).list();
            if (HussarUtils.isEmpty(sysSyncDataInList)) {
                OrganUtil.addErrorMsg(errors, (Object)Boolean.FALSE, (String)"menuCodes", (String[])new String[]{"\u83dc\u5355\u4e0d\u5b58\u5728"});
            } else {
                List menuCodes = sysSyncDataInList.stream().map(SysSyncDataIn::getHussarOutsideUniqueValue).collect(Collectors.toList());
                for (String menuCode : menuRoleDto.getMenuCodes()) {
                    if (menuCodes.contains(menuCode)) continue;
                    OrganUtil.addErrorMsg(errors, (Object)Boolean.FALSE, (String)"menuCodes", (String[])new String[]{"\u7f16\u7801\u4e3a" + menuCode + "\u7684\u83dc\u5355\u4e0d\u5b58\u5728"});
                }
            }
        }
        if (HussarUtils.isEmpty(errors)) {
            RoleFuncDto roleFuncDto = new RoleFuncDto();
            roleFuncDto.setFunctionsIds("");
            if (HussarUtils.isNotEmpty(sysSyncDataInList)) {
                List menuIds = sysSyncDataInList.stream().map(SysSyncDataIn::getHussarTablePkVal).collect(Collectors.toList());
                List funIds = this.sysMenuManageServiceImpl.listByIds(menuIds).stream().map(SysMenu::getFunctionId).collect(Collectors.toList());
                String funStr = StringUtil.join(funIds, (String)",");
                roleFuncDto.setFunctionsIds(funStr);
            }
            roleFuncDto.setRoleId(roleId);
            this.sysRolesService.saveFunctions(roleFuncDto);
            result.setSuccess(true);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(menuRoleDto.getRoleId(), menuRoleDto.getRoleId().toString())}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }
}

