/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.addOutsideOrganizationManagerImpl")
public class AddOutsideOrganizationManagerImpl
extends CommonOutsideOrganizationManager
implements AddOutsideOrganizationManager {
    @Override
    public R<AddOutsideOrganizationDto> addOrganization(AddOutsideOrganizationDto addOrganizationDto) {
        Map organTypeMap;
        boolean existCode;
        R result = new R();
        List errors = OrganUtil.validateOne((Object)addOrganizationDto);
        String organCode = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganCode());
        String organType = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganType());
        String parentOrganCode = StringUtils.trimToEmpty((String)addOrganizationDto.getParentOrganCode());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysOrgan::getOrganCode, (Object)organCode);
        boolean bl = existCode = this.organService.count((Wrapper)lambdaQueryWrapper) > 0L;
        if (existCode) {
            OrganUtil.addErrorMsg((List)errors, (Object)addOrganizationDto, (String)"organCode", (String[])new String[]{"\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u91cd\u590d"});
        }
        if (!(organTypeMap = this.organTypeService.queryOrganTypeMap()).containsKey(organType)) {
            OrganUtil.addErrorMsg((List)errors, (Object)addOrganizationDto, (String)"organType", (String[])new String[]{"\u4e0d\u5b58\u5728\u7684\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b"});
        } else {
            Boolean typeRuleFlag = this.whetherComplianceWithOrganizationRule(parentOrganCode, organType, organTypeMap);
            if (!typeRuleFlag.booleanValue()) {
                OrganUtil.addErrorMsg((List)errors, (Object)addOrganizationDto, (String)"organType", (String[])new String[]{"\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u89c4\u5219"});
            }
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysStru sysStru = new SysStru();
            SysOffice sysOffice = new SysOffice();
            SysOrgan sysOrgan = new SysOrgan();
            this.initializationAdd(addOrganizationDto, sysStru, sysOrgan, sysOffice);
            this.wrapAddOrgan(sysStru, sysOrgan);
            this.organService.save((Object)sysOrgan);
            this.sysStruMapper.insert(sysStru);
            this.sysOfficeService.save((Object)sysOffice);
            result.setSuccess(true);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), sysOrgan.getOrganCode())}));
            if (HussarUtils.isNotEmpty((Object)this.sysSyncDataInService)) {
                this.sysSyncDataInService.saveSyncRecord(SysStru.class, (List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), sysOrgan.getOrganCode())}));
            }
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void initializationAdd(AddOutsideOrganizationDto addOrganizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        String parentOrganCode = StringUtils.trimToEmpty((String)addOrganizationDto.getParentOrganCode());
        String organCode = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganCode());
        String organType = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganType());
        String organName = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganName());
        String organAlias = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganAlias());
        String userAccount = StringUtils.trimToEmpty((String)addOrganizationDto.getUserAccount());
        String organShortName = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganShortName());
        String organDescription = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganDescription());
        String organAddress = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganAddress());
        long sysStruId = IdWorker.getId((Object)sysStru);
        long sysOrganId = IdWorker.getId((Object)sysOrgan);
        long sysOfficeId = IdWorker.getId((Object)sysOffice);
        sysStru.setId(Long.valueOf(sysStruId));
        sysStru.setOrganId(Long.valueOf(sysOrganId));
        Long parentId = this.getOrganId(parentOrganCode);
        sysStru.setParentId(parentId);
        Long userId = this.getUserId(userAccount);
        sysStru.setPrincipalId(userId);
        sysStru.setStruType(organType);
        sysStru.setOrganAlias(organAlias);
        int level = 0;
        SysStru temp = (SysStru)this.sysStruMapper.selectById(sysStru.getParentId());
        level = HussarUtils.isEmpty((Object)temp) ? 1 : temp.getStruLevel() + 1;
        sysStru.setStruLevel(Integer.valueOf(level));
        Integer orderTree = 1;
        Integer maxOrder = this.sysStruMapper.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            orderTree = maxOrder + 1;
        }
        Integer struOrder = orderTree;
        sysStru.setStruOrder(struOrder);
        sysOffice.setId(Long.valueOf(sysOfficeId));
        sysOffice.setStruId(Long.valueOf(sysStruId));
        sysOffice.setOfficeAddress(organAddress);
        sysOffice.setOfficeAlias(organDescription);
        if (parentId.equals(Constants.ROOT_NODE_ID)) {
            sysOrgan.setOrganProperty("0");
        } else if (parentId.equals(Constants.OUT_STRU_NODE_ID)) {
            sysOrgan.setOrganProperty("1");
        } else {
            SysOrgan sysOrganTemp = (SysOrgan)this.organService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOrgan::getOrganCode, (Object)StringUtils.trimToEmpty((String)parentOrganCode)));
            sysOrgan.setOrganProperty(sysOrganTemp.getOrganProperty());
        }
        sysOrgan.setId(Long.valueOf(sysOrganId));
        sysOrgan.setOrganCode(organCode);
        sysOrgan.setOrganName(organName);
        sysOrgan.setShortName(HussarUtils.isBlank((CharSequence)organShortName) ? sysOrgan.getOrganName() : StringUtils.trimToEmpty((String)organShortName));
        sysOrgan.setOrganType(organType);
        sysStru.setOrganAlias(HussarUtils.isBlank((CharSequence)addOrganizationDto.getOrganAlias()) ? sysOrgan.getOrganName() : StringUtils.trimToEmpty((String)addOrganizationDto.getOrganAlias()));
        sysOrgan.setOrganCode(organCode);
        sysStru.setIsLeaf("Y");
    }

    public void wrapAddOrgan(SysStru sysStru, SysOrgan sysOrgan) {
        String organFcode = "/" + sysOrgan.getOrganCode();
        String organFname = "/" + sysOrgan.getOrganName();
        long struIdTemp = HussarUtils.isEmpty((Object)sysStru.getId()) ? IdWorker.getId((Object)sysStru) : sysStru.getId();
        String struFid = "/" + struIdTemp;
        String pSeq = "";
        String pFid = "/";
        int level = sysStru.getStruLevel();
        if (level > 1) {
            SysStru pSysStru = (SysStru)this.sysStruMapper.selectById(sysStru.getParentId());
            SysOrgan pSysOrgan = (SysOrgan)this.sysOrganMapper.selectById(pSysStru.getOrganId());
            pSeq = pSysStru.getStruSeq();
            pFid = pSysStru.getStruFid();
            sysOrgan.setParentTypeCode(pSysOrgan.getOrganType());
            organFcode = pSysOrgan.getOrganFcode() + organFcode;
            struFid = pFid + struFid;
            organFname = pSysOrgan.getOrganFname() + organFname;
            pSysStru.setIsLeaf("N");
            this.sysStruMapper.updateById(pSysStru);
        }
        if (!sysOrgan.getOrganType().equals("9")) {
            sysStru.setStruSeq(this.getStruSeq(pFid, pSeq, level));
        } else {
            sysStru.setStruSeq(pSeq);
        }
        sysOrgan.setOrganFcode(OrganUtil.convert((String)organFcode));
        sysOrgan.setOrganFname(organFname);
        sysStru.setId(Long.valueOf(struIdTemp));
        sysStru.setStruFid(OrganUtil.convert((String)struFid));
        sysStru.setStruLevel(Integer.valueOf(sysStru.getStruFid().split("/").length - 1));
    }

    private Boolean whetherComplianceWithOrganizationRule(String parentOrganCode, String organType, Map<String, SysOrganType> organTypeMap) {
        if (HussarUtils.isNotBlank((CharSequence)parentOrganCode) && !parentOrganCode.equals(String.valueOf(Constants.ROOT_NODE_ID)) && !parentOrganCode.equals(String.valueOf(Constants.OUT_STRU_NODE_ID))) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(SysOrgan::getOrganCode, (Object)parentOrganCode);
            SysOrgan parentOrgan = (SysOrgan)this.organService.getOne((Wrapper)lambdaQueryWrapper);
            String parentOrganType = parentOrgan.getOrganType();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysStruRule::getSysOrganType, (Object)parentOrganType);
            wrapper.eq(SysStruRule::getOrganType, (Object)organType);
            return this.sysStruRuleMapper.selectCount((Wrapper)wrapper) > 0L;
        }
        String parentType = organTypeMap.get(organType).getParentType();
        return "0".equals(parentType);
    }
}

