/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.menu.manager.impl;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.jxdinfo.hussar.authorization.menu.dto.EditOutsideMenuWithResFunDto;
import com.jxdinfo.hussar.authorization.menu.manager.EditBatchOutsideMenuManager;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.impl.CommonOutsideMenuManager;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.dto.FuncInfoDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncModuleInfoDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.sync.model.SysSyncDataIn;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.menu.manager.impl.editBatchOutsideMenuManagerImpl")
public class EditBatchOutsideMenuManagerImpl
extends CommonOutsideMenuManager
implements EditBatchOutsideMenuManager {
    @Override
    public R<EditOutsideMenuWithResFunDto> editMenuWithResFun(List<EditOutsideMenuWithResFunDto> menuDtos) {
        R result = new R();
        ArrayList errors = new ArrayList();
        Map<String, EditOutsideMenuWithResFunDto> editMap = menuDtos.stream().collect(Collectors.toMap(EditOutsideMenuWithResFunDto::getMenuCode, e -> e));
        Class<SysMenu> clazz = SysMenu.class;
        Map<String, SysSyncDataIn> syncDataIns = ((LambdaQueryChainWrapper)this.sysSyncDataInService.lambdaQuery().eq(SysSyncDataIn::getHussarTable, (Object)clazz.getAnnotation(TableName.class).value())).list().stream().collect(Collectors.toMap(SysSyncDataIn::getHussarOutsideUniqueValue, Function.identity()));
        Set<String> existMenuCodes = syncDataIns.keySet();
        for (String menuCode : editMap.keySet()) {
            if (existMenuCodes.contains(menuCode)) continue;
            OrganUtil.addErrorMsg(errors, (Object)editMap.get(menuCode), (String)"menuCode", (String[])new String[]{"\u5f53\u524d\u540c\u6b65\u6570\u636e\u4e0d\u5b58\u5728"});
        }
        for (String editMenuCode : editMap.keySet()) {
            String parentCode = editMap.get(editMenuCode).getParentCode();
            if (!HussarUtils.isNotEmpty((Object)parentCode) || syncDataIns.keySet().contains(parentCode)) continue;
            OrganUtil.addErrorMsg(errors, (Object)editMap.get(editMenuCode), (String)"parentCode", (String[])new String[]{"\u5f53\u524d\u83dc\u5355\u7684\u7236\u7ea7\u83dc\u5355\u4e0d\u5b58\u5728"});
        }
        if (HussarUtils.isNotEmpty(errors)) {
            result.setSuccess(false);
            result.setErrorList(errors);
            return result;
        }
        this.editBatchOutsideMenu(menuDtos, (R<EditOutsideMenuWithResFunDto>)result, syncDataIns);
        return result;
    }

    private void editBatchOutsideMenu(List<EditOutsideMenuWithResFunDto> menuWithResFunDtos, R<EditOutsideMenuWithResFunDto> result, Map<String, SysSyncDataIn> syncDataIns) {
        ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
        for (EditOutsideMenuWithResFunDto menuResFunsDto : menuWithResFunDtos) {
            Long resPId;
            Long funcPId;
            Long menuPId;
            SysSyncDataIn currentSysSyncDataIn = syncDataIns.get(menuResFunsDto.getMenuCode());
            String parentCode = StringUtils.trimToEmpty((String)menuResFunsDto.getParentCode());
            if (HussarUtils.isEmpty((Object)parentCode)) {
                menuPId = DEFAULT_MENU_PARENT_ID;
                funcPId = DEFAULT_FUNC_PARENT_ID;
                resPId = DEFAULT_RES_PARENT_ID;
            } else {
                SysSyncDataIn parentSysSyncDataIn = (SysSyncDataIn)((LambdaQueryChainWrapper)this.sysSyncDataInService.lambdaQuery().eq(SysSyncDataIn::getHussarOutsideUniqueValue, (Object)parentCode)).one();
                menuPId = ((SysMenu)this.sysMenuManageService.getById((Serializable)parentSysSyncDataIn.getHussarTablePkVal())).getId();
                funcPId = ((SysFunctionModules)this.sysFunctionModulesService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getFunctionModuleCode, (Object)parentCode))).getId();
                resPId = ((SysResourceModules)this.sysResourceMosulesService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysResourceModules::getModuleCode, (Object)parentCode))).getId();
            }
            SysMenu sysMenu = (SysMenu)this.sysMenuManageService.getById((Serializable)currentSysSyncDataIn.getHussarTablePkVal());
            sysMenu.setMenuAlias(menuResFunsDto.getMenuName());
            sysMenu.setText(menuResFunsDto.getMenuName());
            String icons = HussarUtils.isNotEmpty((Object)StringUtils.trimToEmpty((String)menuResFunsDto.getIcons())) ? StringUtils.trimToEmpty((String)menuResFunsDto.getIcons()) : "caidan-2Jmoren";
            String openType = HussarUtils.isNotEmpty((Object)StringUtils.trimToEmpty((String)menuResFunsDto.getOpenType())) ? StringUtils.trimToEmpty((String)menuResFunsDto.getOpenType()) : "inside";
            String openMode = HussarUtils.isNotEmpty((Object)StringUtils.trimToEmpty((String)menuResFunsDto.getOpenMode())) ? StringUtils.trimToEmpty((String)menuResFunsDto.getOpenMode()) : "0";
            sysMenu.setIcons(icons);
            sysMenu.setOpenType(openType);
            sysMenu.setOpenMode(openMode);
            sysMenu.setComponent(menuResFunsDto.getComponent());
            sysMenu.setParentId(menuPId);
            sysMenu.setSeq(menuResFunsDto.getSeq());
            sysMenu.setPath(menuResFunsDto.getPath());
            this.sysMenuManageService.updateMenu(sysMenu);
            if (sysMenu.getIsLeaf().equals("1")) {
                SysResourceModules sysResourceModules = (SysResourceModules)this.sysResourceMosulesService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysResourceModules::getModuleCode, (Object)menuResFunsDto.getMenuCode()));
                sysResourceModules.setModuleName(menuResFunsDto.getMenuName());
                sysResourceModules.setParentModuleId(resPId);
                this.sysResManageService.saveModules(sysResourceModules);
                SysResources sysResources = (SysResources)this.sysResourcesService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysResources::getResourceCode, (Object)menuResFunsDto.getMenuCode()));
                String resAndFunName = menuResFunsDto.getMenuName();
                ResourceDto resourceDto = new ResourceDto();
                HussarUtils.copy((Object)sysResources, (Object)resourceDto);
                resourceDto.setPath(menuResFunsDto.getPath());
                resourceDto.setComponent(menuResFunsDto.getComponent());
                resourceDto.setResourceAlias(resAndFunName + "\u9875\u9762");
                resourceDto.setResourceName(resAndFunName + "\u9875\u9762");
                this.sysResManageService.saveResource(resourceDto);
                this.sysResourcesService.remove((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysResources::getModuleId, (Object)sysResources.getModuleId())).ne(SysResources::getId, (Object)sysResources.getId()));
                SysFunctions sysFunctions = (SysFunctions)this.sysFunctionsService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysFunctions::getFunctionCode, (Object)menuResFunsDto.getMenuCode()));
                ArrayList<Long> resIds = new ArrayList<Long>();
                List<ResourceDto> resourceDtoList = this.initialResources((List<String>)menuResFunsDto.getUrlNames(), menuResFunsDto, sysResources.getModuleId());
                for (ResourceDto resourceDto1 : resourceDtoList) {
                    Long resId = this.sysResManageService.saveResource(resourceDto1);
                    resIds.add(resId);
                }
                this.sysFunctionResourcesService.remove((Wrapper)new LambdaUpdateWrapper().eq(SysFunctionResources::getFunctionId, (Object)sysFunctions.getId()));
                FuncInfoDto funcInfoDto = new FuncInfoDto();
                funcInfoDto.setFunctionId(sysFunctions.getId());
                funcInfoDto.setApplicationId(DEFAULT_APPLICATION_ID);
                funcInfoDto.setFunctionName(resAndFunName);
                funcInfoDto.setParentModuleId(funcPId);
                funcInfoDto.setDefaultResourceId(sysResources.getId());
                ArrayList sysResourcesMap = new ArrayList();
                HashMap<String, String> defualtResource = new HashMap<String, String>();
                defualtResource.put("id", sysResources.getId().toString());
                defualtResource.put("type", "res_menu");
                sysResourcesMap.add(defualtResource);
                for (Long resId : resIds) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put("id", resId.toString());
                    temp.put("type", "res_btn");
                    sysResourcesMap.add(temp);
                }
                funcInfoDto.setResources(sysResourcesMap);
                funcInfoDto.setFunctionCode(menuResFunsDto.getMenuCode());
                this.sysFunctionsService.saveOrUpdateFunction(funcInfoDto);
            } else {
                SysFunctionModules sysFunctionModules = (SysFunctionModules)this.sysFunctionModulesService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getFunctionModuleCode, (Object)menuResFunsDto.getMenuCode()));
                SysResourceModules sysResourceModules = (SysResourceModules)this.sysResourceMosulesService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysResourceModules::getModuleCode, (Object)menuResFunsDto.getMenuCode()));
                sysResourceModules.setModuleName(menuResFunsDto.getMenuName());
                sysResourceModules.setParentModuleId(resPId);
                this.sysResManageService.saveModules(sysResourceModules);
                FuncModuleInfoDto editFuncModuleInfoDto = new FuncModuleInfoDto();
                editFuncModuleInfoDto.setFunctionModuleId(sysFunctionModules.getId());
                editFuncModuleInfoDto.setFunctionModuleCode(sysFunctionModules.getFunctionModuleCode());
                editFuncModuleInfoDto.setFunctionModuleName(menuResFunsDto.getMenuName());
                editFuncModuleInfoDto.setApplicationId(sysFunctionModules.getApplicationId());
                editFuncModuleInfoDto.setParentModuleId(funcPId);
                this.sysFunctionModulesService.saveOrUpdateFunctionModule(editFuncModuleInfoDto);
            }
            dataMappings.add(new DataMapping(sysMenu.getId(), menuResFunsDto.getMenuCode()));
        }
        result.setSuccess(true);
        result.setSuccessList(dataMappings);
    }
}

