/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.audit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.audit.dao.SysUsersAuditMapper;
import com.jxdinfo.hussar.authorization.audit.model.SysUserIpAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysUserIpAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.audit.vo.SysUsersAuditVo;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.util.CreateUserSendMailUtil;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.service.impl.FunctionRoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.permit.util.UserLogoutCacheUtil;
import com.jxdinfo.hussar.authorization.permit.vo.SysUsersVo;
import com.jxdinfo.hussar.authorization.permit.vo.UsersAuditTransDetailVo;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUserAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPostAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.general.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.usermanager.UserChangeNotify;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysUsersAuditServiceImpl
extends HussarServiceImpl<SysUsersAuditMapper, SysUsersAudit>
implements ISysUsersAuditService {
    @Resource
    private SysUsersAuditMapper sysUsersAuditMapper;
    @Resource
    private ISysUserIpService iSysUserIpService;
    @Resource
    @Lazy
    private ISysUsersService sysUsersService;
    @Resource
    private ISysUserIpAuditService iSysUserIpAuditService;
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    private String AUDIT_ID_NOT_EMPTY = "\u7528\u6237\u5ba1\u6838id\u4e0d\u80fd\u4e3a\u7a7a";
    @Resource
    private ISysUserRoleService userRoleService;
    @Resource
    private IHussarPwdConfigService hussarPwdConfigService;
    @Resource
    private ICreateUserConfigService createUserConfigService;
    @Autowired
    private ISysUserPostService sysUserPostService;
    @Autowired
    private ISysUserPostAuditService sysUserPostAuditService;
    @Autowired
    private ISysStruUserService sysStruUserService;
    @Autowired
    private ISysStruUserAuditService sysStruUserAuditService;
    @Autowired
    private UserChangeNotify userChangeNotify;
    @Resource
    private FunctionRoleUserAuthorizationChangeReporter functionRoleUserAuthorizationChangeReporter;

    public List<SysUsersAudit> pageUsersAudit(Page page) {
        return this.sysUsersAuditMapper.pageUsersAudit(page);
    }

    public boolean adjust(String userAccount, String currentStatus) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysUsersAudit::getUserAccount, (Object)userAccount)).eq(SysUsersAudit::getCurrentStatus, (Object)currentStatus)).eq(SysUsersAudit::getIsAudit, (Object)"0");
        return this.sysUsersAuditMapper.selectCount((Wrapper)wrapper) > 0L;
    }

    public boolean adjustEdit(Long userId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysUsersAudit::getUserId, (Object)userId)).eq(SysUsersAudit::getIsAudit, (Object)"0");
        return this.sysUsersAuditMapper.selectCount((Wrapper)wrapper) > 0L;
    }

    @HussarTransactional
    public ApiResponse passAdd(Long id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException(this.AUDIT_ID_NOT_EMPTY);
        }
        SysUsersAudit sysUsersAudit = (SysUsersAudit)this.getById(id);
        String secure = sysUsersAudit.getPassword();
        if (this.sysUsersService.isExistAccount(sysUsersAudit.getUserAccount())) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u8be5\u7528\u6237\u8d26\u53f7\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
        }
        sysUsersAudit.setIsAudit("1");
        SysUsers sysUsers = new SysUsers();
        CopyPropertieUtils.copyProperties((Object)sysUsers, (Object)sysUsersAudit);
        sysUsers.setId(sysUsersAudit.getUserId());
        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(secure).getBytes());
        sysUsers.setPassword(pwd);
        if (this.sysUsersService.save((Object)sysUsers) && this.updateById((BaseEntity)sysUsersAudit)) {
            String ips = this.listAuditIps(sysUsersAudit.getUserId(), "0");
            this.iSysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)sysUsersAudit.getUserId()));
            this.saveUserIP(sysUsersAudit.getUserId(), ips);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysUserIpAudit::getUserId, (Object)sysUsersAudit.getUserId());
            this.iSysUserIpAuditService.remove((Wrapper)wrapper);
            LambdaQueryWrapper userroleAuditLambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)userroleAuditLambdaQueryWrapper.eq(SysUserroleAudit::getUserId, (Object)sysUsersAudit.getUserId())).eq(SysUserroleAudit::getStatus, (Object)UserRoleStatus.UserAuditButRoleNotAudit.getCode());
            List sysUserroleAudits = this.sysUserroleAuditMapper.selectList((Wrapper)userroleAuditLambdaQueryWrapper);
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            for (SysUserroleAudit sysUserroleAudit : sysUserroleAudits) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(sysUserroleAudit.getUserId());
                sysUserRole.setGrantedRole(sysUserroleAudit.getRoleId());
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                userRoleList.add(sysUserRole);
            }
            this.userRoleService.saveBatch(userRoleList);
            this.sysUserroleAuditMapper.delete((Wrapper)userroleAuditLambdaQueryWrapper);
            if (this.createUserConfigService.getCreateUserSendEmail().booleanValue() && StringUtils.isNotBlank((CharSequence)sysUsers.geteMail())) {
                CreateUserSendMailUtil.sendMail((SysUsers)sysUsers, (String)secure);
            }
            this.userChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysUsers});
            return ApiResponse.success((String)"\u901a\u8fc7\u6210\u529f\uff01");
        }
        throw new BaseException("\u901a\u8fc7\u5931\u8d25\uff01");
    }

    @HussarTransactional
    public ApiResponse passAdd(String id) {
        return this.passAdd(Long.parseLong(id));
    }

    @HussarTransactional
    public ApiResponse passEdit(Long id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException(this.AUDIT_ID_NOT_EMPTY);
        }
        SysUsersAudit sysUsersAudit = (SysUsersAudit)this.getById(id);
        SysUsers sysUsers = new SysUsers();
        CopyPropertieUtils.copyProperties((Object)sysUsers, (Object)sysUsersAudit);
        sysUsers.setId(sysUsersAudit.getUserId());
        sysUsersAudit.setIsAudit("1");
        String ips = this.listAuditIps(sysUsersAudit.getUserId(), "1");
        this.iSysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)sysUsersAudit.getUserId()));
        this.saveUserIP(sysUsersAudit.getUserId(), ips);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUserIpAudit::getUserId, (Object)sysUsersAudit.getUserId());
        this.iSysUserIpAuditService.remove((Wrapper)wrapper);
        SysUsers old = this.sysUsersService.getById(sysUsers.getId());
        sysUsers.setUserOrder(old.getUserOrder());
        if (!"1".equals(old.getAccountStatus()) && "1".equals(sysUsers.getAccountStatus())) {
            sysUsers.setLastLoginTime(Java8DateUtils.currentLocalDateTime());
        }
        if (this.sysUsersService.updateById((Object)sysUsers) && this.updateById((BaseEntity)sysUsersAudit)) {
            this.bpmAbstractPushMsgMatcher.pushUser(sysUsers, "update", null);
            SysUsersAudit usersAudit = (SysUsersAudit)this.getById(id);
            SysUsers user = this.sysUsersService.getUser(usersAudit.getUserId());
            this.abstractPushMsgMatcher.insertOperation("user", "update", (Object)user, Constants.NONE_ID);
            this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sysUsers});
            this.functionRoleUserAuthorizationChangeReporter.report(new Object[]{"user", Collections.singletonList(sysUsersAudit.getUserId())});
            return ApiResponse.success((String)"\u901a\u8fc7\u6210\u529f\uff01");
        }
        throw new BaseException("\u901a\u8fc7\u5931\u8d25\uff01");
    }

    @HussarTransactional
    public ApiResponse passEdit(String id) {
        return this.passEdit(Long.parseLong(id));
    }

    @HussarTransactional
    public ApiResponse passDel(Long id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException(this.AUDIT_ID_NOT_EMPTY);
        }
        SysUsersAudit sysUsersAudit = (SysUsersAudit)this.getById(id);
        sysUsersAudit.setIsAudit("1");
        SysUsers sysUsers = new SysUsers();
        sysUsers.setId(Long.valueOf(sysUsersAudit.getUserId()));
        sysUsers.setAccountStatus(UserStatus.DELETE.getCode());
        Long employeeId = sysUsers.getEmployeeId();
        HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(sysUsersAudit.getUserId()));
        this.sysStruMapper.updatePrincipal(sysUsers.getId());
        this.sysUserroleAuditMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)sysUsers.getId()));
        this.iSysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)sysUsersAudit.getUserId()));
        if (this.sysUsersService.updateById((Object)sysUsers) && this.updateById((BaseEntity)sysUsersAudit)) {
            sysUsers.setEmployeeId(employeeId);
            this.bpmAbstractPushMsgMatcher.delete("organ", sysUsers.getId(), null);
            this.bpmAbstractPushMsgMatcher.delete("userRole", sysUsers.getId(), "deleteByUserId");
            SysUsersAudit usersAudit = (SysUsersAudit)this.getById(id);
            SysUsers user = this.sysUsersService.getUser(usersAudit.getUserId());
            this.abstractPushMsgMatcher.insertOperation("user", null, (Object)user, Constants.NONE_ID);
            Long userId = sysUsersAudit.getUserId();
            this.sysUserPostAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPostAudit::getUserId, (Object)userId));
            this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)userId));
            this.sysUserPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)userId));
            this.userChangeNotify.notify(DataChangeType.DELETE, new Object[]{sysUsers});
            this.functionRoleUserAuthorizationChangeReporter.report(new Object[]{"user", Collections.singletonList(sysUsersAudit.getUserId())});
            UserLogoutCacheUtil.kickOutUser((Long)sysUsers.getId());
            return ApiResponse.success((String)"\u901a\u8fc7\u6210\u529f\uff01");
        }
        throw new BaseException("\u901a\u8fc7\u5931\u8d25\uff01");
    }

    @HussarTransactional
    public ApiResponse passDel(String id) {
        return this.passDel(Long.parseLong(id));
    }

    @HussarTransactional
    public ApiResponse reject(Long id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException(this.AUDIT_ID_NOT_EMPTY);
        }
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        sysUsersAudit.setId(id);
        sysUsersAudit.setIsAudit("2");
        if (this.updateById((BaseEntity)sysUsersAudit)) {
            SysUsersAudit audit = (SysUsersAudit)this.sysUsersAuditMapper.selectById(sysUsersAudit.getId());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysUserIpAudit::getUserId, (Object)audit.getUserId());
            this.iSysUserIpAuditService.remove((Wrapper)wrapper);
            if ("0".equals(audit.getCurrentStatus())) {
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper1.eq(SysUserroleAudit::getUserId, (Object)audit.getUserId())).eq(SysUserroleAudit::getStatus, (Object)UserRoleStatus.LOCKED.getCode());
                SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                sysUserroleAudit.setStatus(UserRoleStatus.REFUSE.getCode());
                this.sysUserroleAuditMapper.update(sysUserroleAudit, (Wrapper)wrapper1);
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)wrapper2.eq(SysUserroleAudit::getUserId, (Object)audit.getUserId())).eq(SysUserroleAudit::getStatus, (Object)UserRoleStatus.UserAuditButRoleNotAudit.getCode());
                this.sysUserroleAuditMapper.delete((Wrapper)wrapper2);
            }
            return ApiResponse.success((String)"\u9a73\u56de\u6210\u529f\uff01");
        }
        throw new BaseException("\u9a73\u56de\u5931\u8d25\uff01");
    }

    public String queryIp(Long userId) {
        return this.listIps(userId);
    }

    public String queryAuditIp(Long userId, String status) {
        return this.listAuditIps(userId, status);
    }

    @HussarTransactional
    public ApiResponse passCalcel(Long id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException(this.AUDIT_ID_NOT_EMPTY);
        }
        SysUsersAudit sysUsersAudit = (SysUsersAudit)this.getById(id);
        sysUsersAudit.setIsAudit("1");
        SysUsers sysUsers = new SysUsers();
        sysUsers.setId(Long.valueOf(sysUsersAudit.getUserId()));
        sysUsers.setAccountStatus(UserStatus.CANCEL.getCode());
        HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(sysUsersAudit.getUserId()));
        this.sysUserroleAuditMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)sysUsers.getId()));
        if (this.sysUsersService.updateById((Object)sysUsers) && this.updateById((BaseEntity)sysUsersAudit)) {
            this.bpmAbstractPushMsgMatcher.delete("organ", sysUsers.getId(), null);
            this.bpmAbstractPushMsgMatcher.delete("userRole", sysUsers.getId(), "deleteByUserId");
            SysUsersAudit usersAudit = (SysUsersAudit)this.getById(id);
            SysUsers user = this.sysUsersService.getUser(usersAudit.getUserId());
            this.abstractPushMsgMatcher.insertOperation("user", "update", (Object)user, Constants.NONE_ID);
            this.sysUserPostAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPostAudit::getUserId, (Object)sysUsers.getId()));
            this.sysStruUserAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUserAudit::getUserId, (Object)sysUsers.getId()));
            UserLogoutCacheUtil.kickOutUser((Long)sysUsers.getId());
            this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{user});
            return ApiResponse.success((String)"\u901a\u8fc7\u6210\u529f\uff01");
        }
        throw new BaseException("\u901a\u8fc7\u5931\u8d25\uff01");
    }

    public SysUsersAuditVo getCancelDetail(Long id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException(this.AUDIT_ID_NOT_EMPTY);
        }
        SysUsersAudit sysUsersAudit = (SysUsersAudit)this.getById(id);
        SysUsersAuditVo sysUsersAuditVo = new SysUsersAuditVo();
        BeanUtils.copyProperties((Object)sysUsersAudit, (Object)sysUsersAuditVo);
        String ips = this.queryIp(sysUsersAudit.getUserId());
        if (!StringUtils.isBlank((CharSequence)ips)) {
            sysUsersAuditVo.setAccessLoginIp(ips);
        } else {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysUserIpAudit::getUserId, (Object)sysUsersAudit.getUserId());
            wrapper.eq(SysUserIpAudit::getCurrentStatus, (Object)"0");
            wrapper.eq(SysUserIpAudit::getIsAudit, (Object)"0");
            List ipAuditlist = this.iSysUserIpAuditService.list((Wrapper)wrapper);
            List collect = ipAuditlist.stream().map(SysUserIpAudit::getUserIp).collect(Collectors.toList());
            String join = String.join((CharSequence)",", collect);
            sysUsersAuditVo.setAccessLoginIp(join);
        }
        return sysUsersAuditVo;
    }

    public SysUsersAuditVo getCancelDetail(String id) {
        return this.getCancelDetail(Long.parseLong(id));
    }

    public SysUsersAuditVo getUpdateDetail(Long id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException(this.AUDIT_ID_NOT_EMPTY);
        }
        SysUsersAudit sysUsersAudit = (SysUsersAudit)this.getById(id);
        SysUsers sysUsers = this.sysUsersService.getById(sysUsersAudit.getUserId());
        SysUsersVo sysUsersVo = new SysUsersVo();
        BeanUtils.copyProperties((Object)sysUsers, (Object)sysUsersVo);
        if ("1".equals(sysUsersVo.getTypeProperty())) {
            sysUsersVo.setStartTime(null);
            sysUsersVo.setExpiredTime(null);
        }
        if ("0".equals(sysUsersVo.getLoginTimeLimit())) {
            sysUsersVo.setAccessLoginStartTime(null);
            sysUsersVo.setAccessLoginEndTime(null);
        }
        sysUsersVo.setAccessLoginIp(this.queryIp(sysUsersAudit.getUserId()));
        SysUsersAuditVo sysUsersAuditVo = new SysUsersAuditVo();
        BeanUtils.copyProperties((Object)sysUsersAudit, (Object)sysUsersAuditVo);
        if ("1".equals(sysUsersAuditVo.getTypeProperty())) {
            sysUsersAuditVo.setStartTime(null);
            sysUsersAuditVo.setExpiredTime(null);
        }
        if ("0".equals(sysUsersAuditVo.getLoginTimeLimit())) {
            sysUsersAuditVo.setAccessLoginStartTime(null);
            sysUsersAuditVo.setAccessLoginEndTime(null);
        }
        sysUsersAuditVo.setAccessLoginIp(this.queryAuditIp(sysUsersAudit.getUserId(), "1"));
        sysUsersAuditVo.setSysUsersVo(sysUsersVo);
        return sysUsersAuditVo;
    }

    public SysUsersAuditVo getUpdateDetail(String id) {
        return this.getUpdateDetail(Long.parseLong(id));
    }

    public UsersAuditTransDetailVo getTransDetail(String id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException(this.AUDIT_ID_NOT_EMPTY);
        }
        SysUsersAudit sysUsersAudit = (SysUsersAudit)this.getById((Serializable)((Object)id));
        SysUsers sysUsers = this.sysUsersService.getById(sysUsersAudit.getUserId());
        SysOrgan sysOrganPre = this.sysStruMapper.getOrganInfoByDeparmentId(sysUsers.getDepartmentId());
        SysOrgan sysOrganAft = this.sysStruMapper.getOrganInfoByDeparmentId(sysUsersAudit.getDepartmentId());
        UsersAuditTransDetailVo usersAuditTransDetailVo = new UsersAuditTransDetailVo();
        usersAuditTransDetailVo.setUserData(ToolUtil.isEmpty((Object)sysOrganAft) ? null : sysOrganAft);
        usersAuditTransDetailVo.setOldUserData(ToolUtil.isEmpty((Object)sysOrganPre) ? null : sysOrganPre);
        return usersAuditTransDetailVo;
    }

    public IPage<SysUsersAudit> queryList(Page<SysUsersAudit> page, SysUsersAudit sysUsersAudit) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ToolUtil.isNotEmpty((Object)sysUsersAudit.getCurrentStatus()), SysUsersAudit::getCurrentStatus, (Object)sysUsersAudit.getCurrentStatus())).like(ToolUtil.isNotEmpty((Object)sysUsersAudit.getUserAccount()), SysUsersAudit::getUserAccount, (Object)sysUsersAudit.getUserAccount())).eq(ToolUtil.isNotEmpty((Object)sysUsersAudit.getIsAudit()), SysUsersAudit::getIsAudit, (Object)sysUsersAudit.getIsAudit())).orderByAsc(SysUsersAudit::getIsAudit)).orderByDesc(HussarBaseEntity::getCreateTime);
        return this.page((IPage)page, (Wrapper)wrapper);
    }

    @HussarTransactional
    public ApiResponse passTrans(String id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException(this.AUDIT_ID_NOT_EMPTY);
        }
        SysUsersAudit sysUsersAudit = (SysUsersAudit)this.getById((Serializable)((Object)id));
        sysUsersAudit.setIsAudit("1");
        SysUsers sysUsers = new SysUsers();
        CopyPropertieUtils.copyProperties((Object)sysUsers, (Object)sysUsersAudit);
        sysUsers.setId(sysUsersAudit.getUserId());
        if (this.sysUsersService.updateById((Object)sysUsers) && this.updateById((BaseEntity)sysUsersAudit)) {
            this.bpmAbstractPushMsgMatcher.pushUser(sysUsers, "update", null);
            this.abstractPushMsgMatcher.insertOperation("user", "update", (Object)sysUsers, Constants.NONE_ID);
            return ApiResponse.success((String)"\u901a\u8fc7\u6210\u529f\uff01");
        }
        throw new BaseException("\u901a\u8fc7\u5931\u8d25\uff01");
    }

    private String listIps(Long userId) {
        List userIps = this.iSysUserIpService.selectUserIp(userId);
        StringBuilder ips = new StringBuilder();
        if (userIps != null && userIps.size() > 0) {
            for (String sysUserIp : userIps) {
                ips.append(sysUserIp);
                ips.append(",");
            }
            String ipsStr = ips.toString();
            ipsStr = ipsStr.substring(0, ipsStr.length() - 1);
            return ipsStr;
        }
        return "";
    }

    private String listAuditIps(Long userId, String status) {
        List userIps = this.iSysUserIpAuditService.selectUserIp(userId, status);
        StringBuilder ips = new StringBuilder();
        if (userIps != null && userIps.size() > 0) {
            for (String sysUserIp : userIps) {
                ips.append(sysUserIp);
                ips.append(",");
            }
            String ipsStr = ips.toString();
            ipsStr = ipsStr.substring(0, ipsStr.length() - 1);
            return ipsStr;
        }
        return "";
    }

    @HussarTransactional
    private boolean saveUserIP(Long userId, String accessLoginIp) {
        boolean flag = false;
        ArrayList<SysUserIp> sysUserIps = new ArrayList<SysUserIp>();
        if (StringUtils.isNotEmpty((CharSequence)accessLoginIp)) {
            List<String> list = Arrays.asList(accessLoginIp.split(","));
            for (String ip : list) {
                SysUserIp sysUserIp = new SysUserIp();
                sysUserIp.setUserId(userId);
                sysUserIp.setUserIp(ip);
                sysUserIps.add(sysUserIp);
            }
        }
        if (ToolUtil.isNotEmpty(sysUserIps)) {
            flag = this.iSysUserIpService.saveBatch(sysUserIps);
        }
        return flag;
    }
}

