/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dto.RoleFuncDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleResDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleTreeQueryDto;
import com.jxdinfo.hussar.authorization.permit.dto.SysRolesDto;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteDataRightManager;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteRoleStruRightManager;
import com.jxdinfo.hussar.authorization.permit.manager.QueryDataRightManager;
import com.jxdinfo.hussar.authorization.permit.model.SysConfRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataScopeService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleGroupVo;
import com.jxdinfo.hussar.authorization.permit.vo.RoleInfoVO;
import com.jxdinfo.hussar.base.config.baseconfig.service.IGlobalService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.general.idtable.util.DataExportUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SysRolesServiceImpl
extends HussarServiceImpl<SysRolesMapper, SysRoles>
implements ISysRolesService {
    private Logger logger = LoggerFactory.getLogger(SysRolesServiceImpl.class);
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private SysUserroleAuditMapper auditMapper;
    @Resource
    private SysRoleGroupMapper sysRoleGroupMapper;
    @Resource
    private ISysRoleGroupService sysRoleGroupService;
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private IGlobalService globalservice;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    private ISysRoleDataScopeService roleDataScopeService;
    @Resource
    @Lazy
    private ISysConfRolesService isConfRolesService;
    @Resource
    private SysStruRoleAuditMapper sysStruRoleAuditMapper;
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private ISysRoleResourceService sysRoleResourceService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysRolesService iSysRolesService;
    @Resource
    private ISysOrganTypeService organTypeService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private DeleteDataRightManager deleteDataRightManager;
    @Resource
    private DeleteRoleStruRightManager deleteRoleStruRightManager;
    @Resource
    private QueryDataRightManager queryDataRightManager;

    @HussarTransactional
    public Long saveRole(SysRolesDto sysRolesDto) {
        if (ToolUtil.isEmpty((Object)sysRolesDto)) {
            throw new BaseException("\u89d2\u8272\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.validateParam(sysRolesDto, "roleAdd");
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage());
        }
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        SysRoles sysRoles = new SysRoles();
        BeanUtils.copyProperties((Object)sysRolesDto, (Object)sysRoles);
        Long checkNodeId = sysRolesDto.getGroupId();
        boolean isOrganRoleAdd = false;
        if (currentUser.isGradeadmin() && "organRoleAdd".equals(sysRolesDto.getRoleType())) {
            isOrganRoleAdd = true;
        }
        sysRoles.setId(null);
        sysRoles.setIsSys("0");
        if (isOrganRoleAdd) {
            sysRoles.setCorporationId(checkNodeId);
            sysRoles.setGroupId(null);
        } else {
            sysRoles.setCorporationId(Long.valueOf(0L));
            sysRoles.setGroupId(checkNodeId);
        }
        this.sysRolesMapper.insert(sysRoles);
        this.bpmAbstractPushMsgMatcher.pushRole("add", sysRoles, null);
        return sysRoles.getId();
    }

    @HussarTransactional
    public void updateRole(SysRoles sysRoles) {
        int num;
        if (ToolUtil.isEmpty((Object)sysRoles)) {
            throw new BaseException("\u89d2\u8272\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!BaseSecurityUtil.isGradeadmin()) {
            try {
                this.validateParam(sysRoles, "roleEdit");
            }
            catch (BaseException e) {
                throw new BaseException(e.getMessage());
            }
        }
        if ((num = this.sysRolesMapper.updateById(sysRoles)) == 0) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        this.bpmAbstractPushMsgMatcher.pushRole("update", sysRoles, null);
        List<Long> userIds = this.delCacheAuthInfo(sysRoles.getId());
        for (Long userId : userIds) {
            this.delAuthCacheInfo(userId);
        }
    }

    public RoleInfoVO getRoleViewMap(Long id) {
        SysRoleGroup group;
        HashMap map = new HashMap();
        SysRoles role = (SysRoles)this.sysRolesMapper.selectById(id);
        RoleInfoVO roleInfoVO = new RoleInfoVO();
        BeanUtils.copyProperties((Object)role, (Object)roleInfoVO);
        Long groupId = role.getGroupId();
        if (groupId != null && (group = (SysRoleGroup)this.sysRoleGroupMapper.selectById(groupId)) != null) {
            roleInfoVO.setGroupName(group.getGroupName());
        }
        return roleInfoVO;
    }

    public RoleInfoVO getRoleViewMap(String id) {
        return this.getRoleViewMap(Long.parseLong(id));
    }

    public List<SysRoleResource> getRoleResource(String id) {
        String[] idStr = id == null ? "".split(",") : id.split(",");
        Long[] idStrl = new Long[idStr.length];
        for (int i = 0; i < idStr.length; ++i) {
            idStrl[i] = Long.parseLong(idStr[i]);
        }
        return this.sysRoleResourceMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysRoleResource::getId, Arrays.asList(idStrl)));
    }

    public ApiResponse deleteRole(Long id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException("\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.isConfRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysConfRoles::getId, (Object)id));
        if (ToolUtil.isNotEmpty((Object)list)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\uff08\u89d2\u8272\u5df2\u5173\u8054\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\uff01\uff09");
        }
        int num = this.auditMapper.isDelete(id);
        if (num > 0) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\uff08\u89d2\u8272\u5df2\u5173\u8054\u7528\u6237\uff01\uff09");
        }
        int num1 = this.sysStruRoleAuditMapper.isDelete(id);
        if (num1 > 0) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\uff08\u89d2\u8272\u5df2\u5173\u8054\u7ec4\u7ec7\uff01\uff09");
        }
        boolean flag = this.removeById(id);
        if (!flag) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        this.sysRoleResourceMapper.deleteById(id);
        LambdaQueryWrapper roleFuncQueryWrapper = new LambdaQueryWrapper();
        roleFuncQueryWrapper.eq(SysRoleFunctions::getRoleId, (Object)id);
        this.sysRoleFunctionsService.remove((Wrapper)roleFuncQueryWrapper);
        this.auditMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getRoleId, (Object)id));
        this.bpmAbstractPushMsgMatcher.delete("role", id, null);
        this.bpmAbstractPushMsgMatcher.delete("userRole", id, "deleteByRoleId");
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public List<Long> delCacheAuthInfo(Long roleId) {
        return this.sysRolesMapper.getUserIdByRoleId(roleId);
    }

    @CacheEvict(value={"authorization_info"}, key="'hussar_authInfo:'+#userId")
    public void delAuthCacheInfo(Long userId) {
        if (this.hussarBaseProperties.isTenantOpen()) {
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            String code = null;
            if (ToolUtil.isNotEmpty((Object)securityUser)) {
                code = securityUser.getConnName();
            }
            HussarCacheUtil.evict((String)"menu_info", (Object)("hussar_menus:" + userId + code));
        } else {
            HussarCacheUtil.evict((String)"menu_info", (Object)("hussar_menus:" + userId));
        }
    }

    public List<JSTreeModel> getRoleTree() {
        return this.sysRoleGroupMapper.getRoleTree();
    }

    public List<JSTreeModel> getLazyRoleTree(Long nodeId) {
        List<JSTreeModel> jsTreeModels;
        if (ToolUtil.isEmpty((Object)nodeId)) {
            throw new BaseException("\u8282\u70b9ID\u4e3a\u7a7a");
        }
        if (nodeId.equals(Constants.ROOT_NODE_PARENT)) {
            jsTreeModels = this.sysRoleGroupMapper.getFirstRoleTree();
            JSTreeModel jsTreeModel = new JSTreeModel();
            jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
            jsTreeModel.setCode("GROUP");
            jsTreeModel.setText("\u89d2\u8272\u6811");
            jsTreeModel.setId(Constants.ROLE_ROOT_ID);
            jsTreeModel.setType("isRoot");
            jsTreeModels.add(jsTreeModel);
        } else {
            jsTreeModels = this.sysRoleGroupMapper.getLazyRoleTree(nodeId);
        }
        return jsTreeModels;
    }

    public List<JSTreeModel> getRoleGroupTree() {
        ArrayList jsTreeModels = Lists.newArrayList();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setCode("GROUP");
        jsTreeModel.setText("\u89d2\u8272\u6811");
        jsTreeModel.setId(Constants.RES_NODE_ID);
        jsTreeModel.setType("isRoot");
        jsTreeModels.add(jsTreeModel);
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = securityUser.isGradeadmin();
        if (isGradeAdmin) {
            jsTreeModel.setId(Constants.ROOT_NODE_ID);
            int currentLevel = this.sysStruMapper.selectStruLevel(securityUser.getEmployeeId());
            HashSet chooseStruId = Sets.newHashSet((Object[])new Long[]{securityUser.getEmployeeId()});
            List<SysStru> superiorList = this.sysStruMapper.getParentStruTree(currentLevel);
            HashSet ancestorStruIds = Sets.newHashSet((Object[])new Long[]{securityUser.getDeptId()});
            for (SysStru parentStru : superiorList) {
                if (!ancestorStruIds.contains(parentStru.getId())) continue;
                chooseStruId.add(parentStru.getId());
                ancestorStruIds.add(parentStru.getParentId());
            }
            List<SysStru> childStruList = this.sysStruMapper.getChildStruTree(currentLevel - 1);
            HashSet subStruIds = Sets.newHashSet((Object[])new Long[]{securityUser.getEmployeeId()});
            for (SysStru subStru : childStruList) {
                if (!subStruIds.contains(subStru.getParentId())) continue;
                chooseStruId.add(subStru.getId());
                subStruIds.add(subStru.getId());
            }
            List<JSTreeModel> gradAdminRoleTree = this.sysStruMapper.findOrganRoleTreeForGradeAdmin(new ArrayList<Long>(chooseStruId));
            jsTreeModels.addAll(gradAdminRoleTree);
        } else {
            List<JSTreeModel> allGroup = this.sysRoleGroupMapper.getRoleGroupTree();
            if (securityUser.getRolesList().contains(Constants.BUSSINESSADMIN_ROLE_ID)) {
                allGroup.removeIf(l -> l.getId().equals(Constants.SYSTEM_ROLE_GROUP));
            }
            jsTreeModels.addAll(allGroup);
        }
        return TreeModelUtils.merge((List)jsTreeModels);
    }

    public List<JSTreeModel> getGroupOrderTree() {
        List<JSTreeModel> result = this.sysRoleGroupMapper.getGroupOrderTree();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setCode("GROUP");
        jsTreeModel.setText("\u89d2\u8272\u6811");
        jsTreeModel.setId(Constants.RES_NODE_ID);
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        return TreeModelUtils.merge(result);
    }

    public List<JSTreeModel> getRoleOrderTree(Long parent) {
        List<Object> result = new ArrayList();
        if (BaseSecurityUtil.getUser().isGradeadmin()) {
            List<JSTreeModel> result1 = this.getLazyOrganRoleTree(parent, false, true);
            Long parentId = parent;
            for (JSTreeModel jsTreeModel : result1) {
                String type = jsTreeModel.getType();
                if (!"ORGANROLE".equals(type)) continue;
                result.add(jsTreeModel);
                parentId = jsTreeModel.getParent();
            }
            JSTreeModel root = new JSTreeModel();
            root.setId(parentId);
            root.setCode("ORGANROLEROOT");
            root.setText("\u7ec4\u7ec7\u89d2\u8272\u6811");
            root.setParent(Constants.ROOT_NODE_PARENT);
            root.setType("ORGANROLEROOT");
            result.add(root);
        } else {
            result = this.sysRoleGroupMapper.getRoleOrderTree(parent);
            JSTreeModel root = new JSTreeModel();
            SysRoleGroup group = (SysRoleGroup)this.sysRoleGroupMapper.selectById(parent);
            if (ToolUtil.isNotEmpty((Object)group)) {
                root.setParent(Constants.ROOT_NODE_PARENT);
                root.setCode("GROUP");
                root.setText(group.getGroupName());
                root.setId(group.getId());
                root.setType("GROUP");
            } else {
                root.setParent(Constants.ROOT_NODE_PARENT);
                root.setCode("GROUP");
                root.setText("\u89d2\u8272\u6811");
                root.setId(Constants.RES_NODE_ID);
                root.setType("isRoot");
            }
            result.add(root);
        }
        return TreeModelUtils.merge(result);
    }

    @HussarTransactional
    public boolean updateGroupOrder(List<Long> idList) {
        ArrayList<SysRoleGroup> list = new ArrayList<SysRoleGroup>();
        for (int i = 0; i < idList.size(); ++i) {
            Long id = idList.get(i);
            SysRoleGroup group = new SysRoleGroup();
            group.setId(id);
            group.setGroupOrder(Integer.valueOf(i + 1));
            list.add(group);
        }
        this.bpmAbstractPushMsgMatcher.pushRoleSort(list, null);
        return ToolUtil.isNotEmpty(list) && this.sysRoleGroupService.updateBatchById(list, list.size());
    }

    @HussarTransactional
    public boolean updateRoleOrder(List<Long> idList) {
        ArrayList<SysRoles> list = new ArrayList<SysRoles>();
        for (int i = 0; i < idList.size(); ++i) {
            Long id = idList.get(i);
            SysRoles role = new SysRoles();
            role.setId(id);
            role.setRoleOrder(Integer.valueOf(i + 1));
            list.add(role);
        }
        this.bpmAbstractPushMsgMatcher.pushRoleSort(null, list);
        return ToolUtil.isNotEmpty(list) && super.updateBatchById(list, list.size());
    }

    @HussarTransactional
    public ApiResponse saveGroup(SysRoleGroup sysRoleGroup) {
        if (ToolUtil.isEmpty((Object)sysRoleGroup)) {
            throw new BaseException("\u89d2\u8272\u5206\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.validateParam(sysRoleGroup, "add");
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage());
        }
        int groupOrder = this.sysRoleGroupMapper.getMaxOrder() + 1;
        sysRoleGroup.setGroupOrder(Integer.valueOf(groupOrder));
        int count = this.sysRoleGroupMapper.insert(sysRoleGroup);
        if (count == 1) {
            this.bpmAbstractPushMsgMatcher.pushRole("add", null, sysRoleGroup);
            return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @HussarTransactional
    public ApiResponse updateGroup(SysRoleGroup sysRoleGroup) {
        if (ToolUtil.isEmpty((Object)sysRoleGroup)) {
            throw new BaseException("\u89d2\u8272\u5206\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int count = this.sysRoleGroupMapper.updateById(sysRoleGroup);
        if (count == 1) {
            this.bpmAbstractPushMsgMatcher.pushRole("update", null, sysRoleGroup);
            return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
    }

    public ApiResponse deleteGroup(Long groupId) {
        int count = this.sysRoleGroupMapper.deleteById(groupId);
        if (count == 1) {
            this.bpmAbstractPushMsgMatcher.delete("role", groupId, null);
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
    }

    public List<JSTreeModel> getLazyOrganRoleTree(Long nodeId, boolean isExport, boolean isLazy) {
        Long parentId = nodeId;
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        Long empolyeeId = securityUser.getEmployeeId();
        int userLevel = 0;
        boolean isGradeAdmin = securityUser.isGradeadmin();
        if (isGradeAdmin) {
            userLevel = this.sysStruMapper.selectStruLevel(empolyeeId);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId(Constants.ROOT_NODE_ID);
        jsTreeModel.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        jsTreeModel.setText("\u7ec4\u7ec7\u89d2\u8272\u6811");
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setType("isRoot");
        if (isGradeAdmin) {
            jsTreeModel.getState().put("isOrganRoleTree", true);
            jsTreeModel.getState().put("gradeDisabled", true);
        }
        List<Object> list = new ArrayList();
        List list1 = new ArrayList();
        if (this.globalservice.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)parentId)) {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)parentId)) {
                parentId = Constants.ROOT_NODE_ID;
                result.add(jsTreeModel);
            }
            list1 = this.sysOrgManageService.geOrganRoleTree(parentId);
        } else {
            result.add(jsTreeModel);
        }
        if (isGradeAdmin) {
            if (isLazy) {
                list = this.sysOrgManageService.getGradeStruTree(list1, userLevel);
                for (JSTreeModel treeModel : list) {
                    treeModel.getState().put("isOrganRoleTree", true);
                }
            } else {
                List<JSTreeModel> organRoleList = this.getGradeAdminOrganRoleTree();
                for (JSTreeModel treeModel : organRoleList) {
                    treeModel.getState().put("isOrganRoleTree", true);
                }
                list = organRoleList;
            }
        } else {
            list = list1;
        }
        result.addAll(list);
        if (isExport) {
            for (JSTreeModel model : result) {
                String type = model.getType();
                if ("ORGANROLE".equals(type)) {
                    model.setState(false, false, false);
                    continue;
                }
                model.setState(false, false, true);
            }
        }
        return result;
    }

    public void exportData(List<String> idList, HttpServletResponse response) {
        List cdids = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List roleGroups = this.sysRoleGroupMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysRoleGroup::getId, cdids));
        List roles = this.sysRolesMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysRoles::getId, cdids));
        List roleResources = this.sysRoleResourceMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysRoleResource::getId, cdids));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("roleGroups", roleGroups);
        data.put("roles", roles);
        data.put("roleResources", roleResources);
        data.put("export_type", "role");
        byte[] serializeData = new byte[]{};
        try {
            serializeData = SerializeUtils.serialize(data);
        }
        catch (Exception e) {
            this.logger.error("\u5e8f\u5217\u5316\u51fa\u9519", (Throwable)e);
            throw new BaseException("\u5e8f\u5217\u5316\u51fa\u9519");
        }
        String fileName = "role_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    @HussarTransactional
    public Map<String, String> importVueData(byte[] content) {
        Map data;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (Exception e) {
            this.logger.error("\u53cd\u5e8f\u5217\u5316\u6570\u636e\u51fa\u9519", (Throwable)e);
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        if (ToolUtil.isEmpty((Object)data)) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        String export_type = (String)data.get("export_type");
        if (!"role".equals(export_type)) {
            map.put("success", "false");
            map.put("errorImport", export_type);
            map.put("import", "role");
            return map;
        }
        List roleGroups = (List)data.get("roleGroups");
        List roles = (List)data.get("roles");
        List roleResources = (List)data.get("roleResources");
        Map<String, Integer> roleGroupsCount = this.insertOrUpdateList(roleGroups);
        Map<String, Integer> rolesCount = this.insertOrUpdateList(roles);
        Map<String, Integer> roleResourcesCount = this.insertOrUpdateList(roleResources);
        map.put("success", "true");
        map.put("insertGroups", "" + roleGroupsCount.get("insert"));
        map.put("updateGroups", "" + roleGroupsCount.get("update"));
        map.put("insertRoles", "" + rolesCount.get("insert"));
        map.put("updateRoles", "" + rolesCount.get("update"));
        map.put("insertRoleResources", "" + roleResourcesCount.get("insert"));
        map.put("updateRoleResources", "" + roleResourcesCount.get("update"));
        return map;
    }

    public List<JSTreeModel> getGradeAdminOrganRoleTree() {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        Long empolyeeId = securityUser.getEmployeeId();
        ArrayList<JSTreeModel> list = new ArrayList<JSTreeModel>();
        Long organId = empolyeeId;
        JSTreeModel organ = new JSTreeModel();
        List childSysStruIdList = this.sysStruService.getChildOrgId(securityUser.getDeptId(), "01");
        List<JSTreeModel> roleLists = new ArrayList<JSTreeModel>();
        childSysStruIdList.add(securityUser.getDeptId());
        for (Long id : childSysStruIdList) {
            if (!id.equals(securityUser.getDeptId())) {
                organ = this.sysOrgManageService.getThisOneOrg(id);
                list.add(organ);
            }
            List<JSTreeModel> roleList = this.sysStruMapper.getRoleTree(id);
            if (ToolUtil.isEmpty(roleLists)) {
                roleLists = roleList;
                continue;
            }
            roleLists.addAll(roleList);
        }
        while (ToolUtil.isNotEmpty((Object)organ)) {
            organ = this.sysOrgManageService.getOneOrg(organId);
            if (!ToolUtil.isNotEmpty((Object)organ)) continue;
            organId = organ.getId();
            list.add(organ);
        }
        ArrayList<JSTreeModel> lists = list;
        list = roleLists;
        list.addAll(lists);
        return list;
    }

    public List<JSTreeModel> getRoleTree(RoleTreeDto roleTreeDto) {
        Long nodeId = roleTreeDto.getNodeId();
        Long userId = roleTreeDto.getUserId();
        String functionType = roleTreeDto.getFunctionType();
        Object result = new ArrayList();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = securityUser.isGradeadmin();
        if (isGradeAdmin) {
            List<JSTreeModel> gradeAdminStruList = this.getLazyOrganRoleTree(nodeId, false, false);
            List<Object> rolesList = new ArrayList();
            if (userId != null) {
                rolesList = this.sysUserRoleMapper.getRolesByUserId(userId);
            }
            if ("view".equals(functionType)) {
                ArrayList roleResult = new ArrayList();
                for (JSTreeModel iterator : gradeAdminStruList) {
                    String type = iterator.getType();
                    if ("ORGANROLE".equals(type)) {
                        Long roleId = iterator.getId();
                        if (rolesList.contains(roleId)) {
                            iterator.setState(true, true, true);
                            result.add(iterator);
                            roleResult.add(iterator);
                            continue;
                        }
                        iterator.setState(false, false, true);
                        continue;
                    }
                    iterator.setState(false, false, true);
                    result.add(iterator);
                }
                HashSet<JSTreeModel> delResult = new HashSet<JSTreeModel>();
                Iterator iterator = roleResult.iterator();
                while (iterator.hasNext()) {
                    JSTreeModel node = (JSTreeModel)iterator.next();
                    this.getOwnTreeModel(node, (List<JSTreeModel>)result, delResult);
                }
                result = roleResult;
                result.addAll(new ArrayList(delResult));
            }
            if ("edit".equals(functionType) || "add".equals(functionType)) {
                for (JSTreeModel jsTreeModel : gradeAdminStruList) {
                    String string = jsTreeModel.getType();
                    if ("ORGANROLE".equals(string)) {
                        Long roleId = jsTreeModel.getId();
                        if (rolesList.contains(roleId)) {
                            jsTreeModel.setState(true, true, false);
                        } else {
                            jsTreeModel.setState(false, false, false);
                        }
                        result.add(jsTreeModel);
                        continue;
                    }
                    jsTreeModel.setState(false, false, true);
                    result.add(jsTreeModel);
                }
            }
            List listOrganType = this.organTypeService.list();
            Map mapOrganType = listOrganType.stream().collect(Collectors.toMap(SysOrganType::getOrganType, Function.identity()));
            if (CollectionUtils.isNotEmpty(result)) {
                Iterator iterator = result.iterator();
                while (iterator.hasNext()) {
                    JSTreeModel jsTreeModel = (JSTreeModel)iterator.next();
                    if (!HussarUtils.isNotBlank((CharSequence)jsTreeModel.getStruType())) continue;
                    jsTreeModel.setImgUrl(((SysOrganType)mapOrganType.get(jsTreeModel.getStruType())).getImgUrl());
                }
            }
        } else {
            result = this.getRoleTree();
            JSTreeModel jsTreeModel = new JSTreeModel();
            jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
            jsTreeModel.setCode("GROUP");
            jsTreeModel.setText("\u89d2\u8272\u6811");
            jsTreeModel.setId(Constants.RES_NODE_ID);
            jsTreeModel.setType("isRoot");
            result.add(jsTreeModel);
        }
        return result;
    }

    public List<JSTreeModel> getRoleMergeTree(RoleTreeDto roleTreeDto) {
        return TreeModelUtils.merge(this.getRoleTree(roleTreeDto));
    }

    private void getOwnTreeModel(JSTreeModel node, List<JSTreeModel> total, Set<JSTreeModel> result) {
        for (JSTreeModel jsTreeModel : total) {
            if (!HussarUtils.equals((Object)node.getParent(), (Object)jsTreeModel.getId())) continue;
            result.add(jsTreeModel);
            if (HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)jsTreeModel.getId())) break;
            this.getOwnTreeModel(jsTreeModel, total, result);
            break;
        }
    }

    public boolean isContainsOrganRole(RoleTreeDto roleTreeDto) {
        List<JSTreeModel> struRoleList = this.getRoleTree(roleTreeDto);
        boolean flag = false;
        for (JSTreeModel stru : struRoleList) {
            String type = stru.getType();
            if (!"ORGANROLE".equals(type)) continue;
            flag = true;
        }
        return flag;
    }

    public List<JSTreeModel> getSelfRoleTree(String[] roleIds) {
        List<Object> tree = new ArrayList();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = securityUser.isGradeadmin();
        if (!isGradeAdmin) {
            List result = this.sysOrgManageService.selfRoleTree(roleIds);
            tree = this.doRecursive(result);
        }
        return TreeModelUtils.merge(tree);
    }

    public List<Long> getUserRoleList(Long userId) {
        return this.sysUserRoleMapper.getRolesByUserId(userId);
    }

    public String getRoleDataScopeByUserId(Set<Long> orgList, Long userId) {
        List<Long> roleIds = this.getUserRoleList(userId);
        String type = "";
        if (ToolUtil.isNotEmpty(roleIds)) {
            List roles = this.list((Wrapper)new LambdaQueryWrapper().in(SysRoles::getId, roleIds));
            for (SysRoles role : roles) {
                String roleType = role.getDataScopeType();
                if (ToolUtil.isEmpty((Object)roleType)) continue;
                if (ToolUtil.isEmpty((Object)type)) {
                    type = roleType;
                }
                if (Long.parseLong(roleType) < Long.parseLong(type)) {
                    type = roleType;
                }
                if (!"7".equals(roleType)) continue;
                List orgIds = this.roleDataScopeService.getOrgListByRoleId(role.getId());
                orgList.addAll(orgIds);
            }
        }
        if (ToolUtil.isEmpty((Object)type)) {
            type = "1";
        }
        return type;
    }

    public IPage getRoleInfoList(Page page, RoleTreeQueryDto roleTreeQueryDto) {
        Long roleGroupOrDepId = roleTreeQueryDto.getNodeId();
        if (ToolUtil.isEmpty((Object)roleGroupOrDepId)) {
            throw new BaseException("\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = securityUser.isGradeadmin();
        if (isGradeAdmin) {
            String roleName;
            HashMap mapperQuery = Maps.newHashMap();
            mapperQuery.put("deptId", roleGroupOrDepId);
            String string = roleName = roleTreeQueryDto.getRoleName() == null ? "" : roleTreeQueryDto.getRoleName().trim();
            if (StringUtils.isNotBlank((CharSequence)roleName)) {
                mapperQuery.put("roleName", roleName);
            }
            List<RoleInfoVO> roleInfoVOList = this.sysRolesMapper.findRoleList(page, mapperQuery);
            for (RoleInfoVO roleInfoVO : roleInfoVOList) {
                roleInfoVO.setRoleType("STRU_ROLE");
            }
            page.setRecords(roleInfoVOList);
        } else if (Constants.RES_NODE_ID.equals(roleGroupOrDepId)) {
            String groupName;
            Page roleGroupPage = new Page(page.getCurrent(), page.getSize());
            LambdaQueryWrapper queryRoleCondition = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleGroup::getParentId, (Object)roleGroupOrDepId);
            String string = groupName = roleTreeQueryDto.getGroupName() == null ? "" : roleTreeQueryDto.getGroupName().trim();
            if (StringUtils.isNotBlank((CharSequence)groupName)) {
                queryRoleCondition.like(SysRoleGroup::getGroupName, (Object)groupName);
            }
            queryRoleCondition.orderByAsc(SysRoleGroup::getGroupOrder);
            queryRoleCondition.orderByDesc(HussarBaseEntity::getCreateTime);
            queryRoleCondition.orderByDesc(SysRoleGroup::getId);
            this.sysRoleGroupMapper.selectPage((IPage)roleGroupPage, (Wrapper)queryRoleCondition);
            ArrayList fmtGroupDataList = Lists.newArrayList();
            for (SysRoleGroup roleGroup : roleGroupPage.getRecords()) {
                RoleGroupVo roleGroupVO = new RoleGroupVo();
                BeanUtils.copyProperties((Object)roleGroup, (Object)roleGroupVO);
                roleGroupVO.setRoleType("GROUP");
                fmtGroupDataList.add(roleGroupVO);
            }
            if (securityUser.getRolesList().contains(Constants.BUSSINESSADMIN_ROLE_ID)) {
                fmtGroupDataList.removeIf(l -> l.getId().equals(Constants.SYSTEM_ROLE_GROUP));
                page.setTotal(roleGroupPage.getTotal() - 1L);
            } else {
                page.setTotal(roleGroupPage.getTotal());
            }
            page.setRecords((List)fmtGroupDataList);
        } else {
            String roleName;
            HashMap mapperQuery = Maps.newHashMap();
            mapperQuery.put("roleGroupId", roleGroupOrDepId);
            String string = roleName = roleTreeQueryDto.getRoleName() == null ? "" : roleTreeQueryDto.getRoleName().trim();
            if (StringUtils.isNotBlank((CharSequence)roleName)) {
                mapperQuery.put("roleName", roleName);
            }
            List<RoleInfoVO> roleInfoVOList = this.sysRolesMapper.findRoleList(page, mapperQuery);
            for (RoleInfoVO roleInfoVO : roleInfoVOList) {
                roleInfoVO.setRoleType("ROLE");
            }
            page.setRecords(roleInfoVOList);
        }
        return page;
    }

    public IPage getRoleInfoListForGradeadmin(Page page) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        assert (securityUser != null);
        boolean isGradeAdmin = securityUser.isGradeadmin();
        if (isGradeAdmin) {
            Long struId = Objects.requireNonNull(BaseSecurityUtil.getUser()).getEmployeeId();
            Long gradeParentId = this.orgMaintenanceService.getOneOrg(struId).getId();
            List childrenStruIdList = this.sysStruService.getChildOrgId(gradeParentId, "01");
            childrenStruIdList.add(gradeParentId);
            QueryWrapper sysRolesQueryWrapper = new QueryWrapper();
            sysRolesQueryWrapper.lambda().in(SysRoles::getCorporationId, (Collection)childrenStruIdList);
            List sysRolesList = this.iSysRolesService.list((Wrapper)sysRolesQueryWrapper);
            ArrayList roleInfoVOList = new ArrayList();
            sysRolesList.forEach(o -> {
                RoleInfoVO roleInfoVO = new RoleInfoVO();
                BeanUtils.copyProperties((Object)o, (Object)roleInfoVO);
                roleInfoVO.setRoleType("STRU_ROLE");
                roleInfoVOList.add(roleInfoVO);
            });
            page.setRecords(roleInfoVOList);
            page.setTotal((long)roleInfoVOList.size());
        }
        return page;
    }

    public List<JSTreeModel> getRoleTreeByLazy(RoleTreeDto roleTreeDto) {
        Long nodeId = roleTreeDto.getNodeId();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = securityUser.isGradeadmin();
        if (isGradeAdmin) {
            boolean isExport = roleTreeDto.isExport();
            return TreeModelUtils.merge(this.getLazyOrganRoleTree(nodeId, isExport, true));
        }
        return TreeModelUtils.merge(this.getLazyRoleTree(nodeId));
    }

    public List<JSTreeModel> getRoleUserTreeAdd() {
        List result = this.sysOrgManageService.getUserTree();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId(Constants.ROOT_NODE_ID);
        jsTreeModel.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        jsTreeModel.setText("\u5173\u8054\u7528\u6237");
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        for (JSTreeModel model : result) {
            model.setState(false, false, false);
            if (!"USER".equals(model.getType()) || !Constants.ROOT_NODE_ID.equals(model.getParent())) continue;
            model.setState(((Boolean)model.getState().get("selected")).booleanValue(), ((Boolean)model.getState().get("checked")).booleanValue(), true);
        }
        return TreeModelUtils.merge((List)result);
    }

    public List<JSTreeModel> getRoleUserTreeEdit(String roleId) {
        boolean isSysRole = false;
        SysRoles role = (SysRoles)this.getById((Serializable)((Object)roleId));
        if (ToolUtil.isEmpty((Object)role)) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u89d2\u8272");
        }
        String sysRoleGroup = "sys_role_group";
        if (sysRoleGroup.equals(role.getGroupId())) {
            isSysRole = true;
        }
        List result = this.sysOrgManageService.getUserTree();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId(Constants.ROOT_NODE_ID);
        jsTreeModel.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        jsTreeModel.setText("\u5173\u8054\u7528\u6237");
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        List<String> userRoles = this.sysUserRoleMapper.selectUserIdByRoleId(roleId);
        for (JSTreeModel model : result) {
            model.setState(false, false, false);
            if (userRoles.contains(model.getId())) {
                model.setState(true, true, false);
            }
            if (!isSysRole && (!"USER".equals(model.getType()) || !Constants.ROOT_NODE_ID.equals(model.getParent()))) continue;
            model.setState(((Boolean)model.getState().get("selected")).booleanValue(), ((Boolean)model.getState().get("checked")).booleanValue(), true);
        }
        return TreeModelUtils.merge((List)result);
    }

    public List<JSTreeModel> getRoleUserTreeView(Long roleId) {
        List result = this.sysUsersService.getUserByRole(roleId);
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        root.setText("\u5173\u8054\u7528\u6237");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setType("isRoot");
        result.add(root);
        for (JSTreeModel model : result) {
            if ("USER".equals(model.getType())) {
                model.setState(true, false, true);
                continue;
            }
            model.setState(false, false, true);
        }
        return this.filterNoChildNode(TreeModelUtils.merge((List)result));
    }

    private List<JSTreeModel> filterNoChildNode(List<JSTreeModel> items) {
        ArrayList<JSTreeModel> newItems = new ArrayList<JSTreeModel>();
        for (JSTreeModel model : items) {
            List children = model.getChildrenList();
            if ("USER".equals(model.getType())) {
                newItems.add(model);
                continue;
            }
            if (ToolUtil.isNotEmpty((Object)children)) {
                List<JSTreeModel> newChildren = this.filterNoChildNode(children);
                if (ToolUtil.isNotEmpty(newChildren)) {
                    model.setChildrenList(newChildren);
                    newItems.add(model);
                } else if (Constants.ROOT_NODE_ID.equals(model.getId())) {
                    model.setChildrenList(newChildren);
                }
            }
            if (!Constants.ROOT_NODE_ID.equals(model.getId()) || newItems.contains(model)) continue;
            newItems.add(model);
        }
        return newItems;
    }

    public List<JSTreeModel> getRoleUserTreeView(String roleId) {
        return this.getRoleUserTreeView(Long.parseLong(roleId));
    }

    public List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        ArrayList<Long> ids = new ArrayList<Long>();
        list.forEach(r -> {
            if ("ROLE".equals(r.getCode())) {
                ids.add(r.getId());
            }
        });
        this.recursive(list, result, ids);
        JSTreeModel model = new JSTreeModel();
        model.setId(Constants.RES_NODE_ID);
        model.setCode("GROUP");
        model.setParent(Constants.ROOT_NODE_PARENT);
        model.setText("\u89d2\u8272\u6811");
        model.setType("isRoot");
        result.add(model);
        return result;
    }

    public void recursive(List<JSTreeModel> list, List<JSTreeModel> result, List<Long> ids) {
        ArrayList<Long> parentIds = new ArrayList<Long>();
        ArrayList<JSTreeModel> tempList = new ArrayList<JSTreeModel>();
        for (JSTreeModel map : list) {
            if (ids.contains(map.getId())) {
                result.add(map);
                if (map.getParent() == null) continue;
                parentIds.add(map.getParent());
                continue;
            }
            tempList.add(map);
        }
        if (ToolUtil.isNotEmpty(parentIds)) {
            this.recursive(tempList, result, parentIds);
        }
    }

    private Map<String, Integer> insertOrUpdateList(List<?> objects) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(objects)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                Object obj = objects.get(i);
                if (obj instanceof SysRoles) {
                    SysRoles role = (SysRoles)obj;
                    if (this.updateById((BaseEntity)role)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.save((BaseEntity)role);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof SysRoleGroup) {
                    SysRoleGroup roleGroup = (SysRoleGroup)obj;
                    if (SqlHelper.retBool((Integer)this.sysRoleGroupMapper.updateById(roleGroup))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysRoleGroupMapper.insert(roleGroup);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof SysRoleResource) {
                    SysRoleResource roleResource = (SysRoleResource)obj;
                    if (SqlHelper.retBool((Integer)this.sysRoleResourceMapper.update(roleResource, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysRoleResource::getId, (Object)roleResource.getId())).eq(SysRoleResource::getResourceId, (Object)roleResource.getResourceId())))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysRoleResourceMapper.insert(roleResource);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }

    public void saveFunctions(RoleFuncDto roleFuncDto) {
        String functionsIds = roleFuncDto.getFunctionsIds();
        Long roleId = roleFuncDto.getRoleId();
        this.sysRoleFunctionsService.saveFunctions(functionsIds, roleId);
        List<Long> userIds = this.delCacheAuthInfo(roleId);
        for (Long userId : userIds) {
            this.delAuthCacheInfo(userId);
        }
        ArrayList<Long> roleIdList = new ArrayList<Long>();
        roleIdList.add(roleId);
        this.queryDataRightManager.saveDataRightCacheByRoleIds(roleIdList);
    }

    public void saveResources(RoleResDto roleResDto) {
        String resourceId = roleResDto.getResourceId();
        Long roleId = roleResDto.getRoleId();
        this.sysRoleResourceService.saveRoleResourceAndRelation(resourceId, roleId);
        List<Long> userIds = this.delCacheAuthInfo(roleId);
        for (Long userId : userIds) {
            this.delAuthCacheInfo(userId);
        }
    }

    private void validateParam(Object o, String mdType) {
        SysRoleGroup reqBO;
        StringBuffer sBuffer = new StringBuffer();
        if (("add".equals(mdType) || "edit".equals(mdType)) && o instanceof SysRoleGroup) {
            reqBO = (SysRoleGroup)o;
            if ("edit".equals(mdType) && null == reqBO.getId()) {
                sBuffer.append(",");
                sBuffer.append("\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getGroupName())) {
                sBuffer.append(",");
                sBuffer.append("\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getGroupName()) && 32 < reqBO.getGroupName().length()) {
                sBuffer.append(",");
                sBuffer.append("\u5206\u7ec4\u540d\u79f0\u6700\u591a\u53ef\u8f93\u516532\u4e2a\u5b57\u7b26");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getGroupAlias())) {
                sBuffer.append(",");
                sBuffer.append("\u5206\u7ec4\u542b\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getGroupAlias()) && 32 < reqBO.getGroupAlias().length()) {
                sBuffer.append(",");
                sBuffer.append("\u5206\u7ec4\u542b\u4e49\u6700\u591a\u53ef\u8f93\u516532\u4e2a\u5b57\u7b26");
            }
        }
        if ("roleAdd".equals(mdType) && o instanceof SysRolesDto) {
            reqBO = (SysRolesDto)o;
            if (null == reqBO.getGroupId()) {
                sBuffer.append(",");
                sBuffer.append("\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getRoleName())) {
                sBuffer.append(",");
                sBuffer.append("\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getRoleName()) && 32 < reqBO.getRoleName().length()) {
                sBuffer.append(",");
                sBuffer.append("\u89d2\u8272\u540d\u79f0\u6700\u591a\u53ef\u8f93\u516532\u4e2a\u5b57\u7b26");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getRoleAlias())) {
                sBuffer.append(",");
                sBuffer.append("\u89d2\u8272\u542b\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getRoleAlias()) && 32 < reqBO.getRoleAlias().length()) {
                sBuffer.append(",");
                sBuffer.append("\u89d2\u8272\u542b\u4e49\u6700\u591a\u53ef\u8f93\u516532\u4e2a\u5b57\u7b26");
            }
        }
        if ("roleEdit".equals(mdType) && o instanceof SysRoles) {
            reqBO = (SysRoles)o;
            if (null == reqBO.getGroupId()) {
                sBuffer.append(",");
                sBuffer.append("\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getId()) {
                sBuffer.append(",");
                sBuffer.append("\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getRoleName())) {
                sBuffer.append(",");
                sBuffer.append("\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getRoleName()) && 32 < reqBO.getRoleName().length()) {
                sBuffer.append(",");
                sBuffer.append("\u89d2\u8272\u540d\u79f0\u6700\u591a\u53ef\u8f93\u516532\u4e2a\u5b57\u7b26");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getRoleAlias())) {
                sBuffer.append(",");
                sBuffer.append("\u89d2\u8272\u542b\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getRoleAlias()) && 32 < reqBO.getRoleAlias().length()) {
                sBuffer.append(",");
                sBuffer.append("\u89d2\u8272\u542b\u4e49\u6700\u591a\u53ef\u8f93\u516532\u4e2a\u5b57\u7b26");
            }
        }
        if (0 < sBuffer.length()) {
            String rspStr = sBuffer.substring(1);
            throw new BaseException(rspStr);
        }
    }

    public void insertOrUpdateRoleList(List<SysRoles> rolesList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(rolesList)) {
            this.logger.info("\u89d2\u8272\u65b0\u589e{}\u6761", (Object)rolesList.size());
            this.logger.info("\u89d2\u8272\u4fee\u6539{}\u6761", (Object)rolesList.size());
            return;
        }
        List allTableData = this.list();
        List allIds = allTableData.stream().map(SysRoles::getId).collect(Collectors.toList());
        ArrayList<SysRoles> insertData = new ArrayList<SysRoles>();
        ArrayList<SysRoles> updateData = new ArrayList<SysRoles>();
        Integer maxOrder = this.sysRolesMapper.getMaxOrder();
        for (SysRoles item : rolesList) {
            if (allIds.contains(item.getId())) {
                updateData.add(item);
                continue;
            }
            Integer n = maxOrder;
            Integer n2 = maxOrder = Integer.valueOf(maxOrder + 1);
            item.setRoleOrder(maxOrder);
            insertData.add(item);
        }
        if (ToolUtil.isNotEmpty(insertData)) {
            this.saveBatch(insertData);
        }
        if (ToolUtil.isNotEmpty(updateData)) {
            this.updateBatchById(updateData);
        }
        this.logger.info("\u89d2\u8272\u65b0\u589e{}\u6761", (Object)insertData.size());
        this.logger.info("\u89d2\u8272\u4fee\u6539{}\u6761", (Object)updateData.size());
    }

    public Integer getMaxOrder() {
        return this.sysRolesMapper.getMaxOrder();
    }
}

