/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.vo.UserTreeVo;
import com.jxdinfo.hussar.authorization.permit.dto.AddUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.CopyUserRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.EditUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryCopyRoleUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResetSecureUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.UserInfolVo;
import com.jxdinfo.hussar.authorization.permit.dto.UserPartialVo;
import com.jxdinfo.hussar.authorization.permit.dto.UserSecureDto;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.ResetSecureUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.UpdateInfoVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.support.security.core.annotation.CheckSafe;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u65b0\u7248\u7528\u6237\u7ba1\u7406"})
@RestController(value="com.jxdinfo.hussar.authorization.permit.controller.hussarBaseUserController")
@RequestMapping(value={"/hussarBase/authorization/permit/user"})
public class HussarBaseUserController {
    @Autowired
    private IHussarBaseUserService userService;
    @Resource
    private ISysUsersService sysUsersService;

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u5217\u8868\u6570\u636e", notes="\u67e5\u8be2\u7528\u6237\u5217\u8868\u6570\u636e")
    @CheckPermission(value={"hussarBase:authorization:permit:user:searchUsers"})
    @GetMapping(value={"/searchUsers"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u67e5\u8be2\u7528\u6237\u5217\u8868\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SearchUserVo>> searchUsers(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u67e5\u8be2\u7528\u6237dto") QueryUserDto queryUserDto) {
        return this.userService.searchUsers(pageInfo, queryUserDto);
    }

    @ApiOperation(value="\u67e5\u8be2\u590d\u5236\u89d2\u8272\u7528\u6237\u5217\u8868\u6570\u636e", notes="\u67e5\u8be2\u590d\u5236\u89d2\u8272\u7528\u6237\u5217\u8868\u6570\u636e")
    @CheckPermission(value={"hussarBase:authorization:permit:user:searchCopyRoleUsers"})
    @GetMapping(value={"/searchCopyRoleUsers"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u67e5\u8be2\u590d\u5236\u89d2\u8272\u7528\u6237\u5217\u8868\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SearchUserVo>> searchCopyRoleUsers(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u67e5\u8be2\u7528\u6237dto") QueryCopyRoleUserDto queryCopyRoleUserDto) {
        return this.userService.searchCopyRoleUsers(pageInfo, queryCopyRoleUserDto);
    }

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u61d2\u52a0\u8f7d\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u6811")
    @CheckPermission(value={"hussarBase:authorization:permit:user:lazyLoadingUserTree"})
    @GetMapping(value={"/lazyLoadingUserTree"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u7ea7\u8054\u83b7\u53d6\u7528\u6237\u90e8\u95e8", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<UserTreeVo>> lazyLoadingUserTree(@ApiParam(value="\u7528\u6237\u6240\u5728\u673a\u6784ID") @RequestParam Long parentId) {
        return this.userService.lazyLoadingUserTree(parentId);
    }

    @ApiOperation(value="\u67e5\u8be2\u9700\u8981\u6392\u5e8f\u7684\u7528\u6237\u6811", notes="\u67e5\u8be2\u9700\u8981\u6392\u5e8f\u7684\u7528\u6237\u6811")
    @CheckPermission(value={"hussarBase:authorization:permit:user:getOrderUserTree"})
    @GetMapping(value={"/getOrderUserTree"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u52a0\u8f7d\u6392\u5e8f\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<UserTreeVo>> getOrderUserTree(@ApiParam(value="\u4e0a\u7ea7") @RequestParam Long parentId) {
        return this.userService.getOrderUserTree(parentId);
    }

    @ApiOperation(value="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u6811")
    @CheckPermission(value={"hussarBase:authorization:permit:user:backUserTree"})
    @GetMapping(value={"/backUserTree"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u70b9\u51fb\u7ec4\u7ec7\u673a\u6784\u8fd4\u56de\u7528\u6237\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<UserTreeVo>> backUserTree(@ApiParam(value="\u9009\u4e2d\u8282\u70b9") @RequestParam Long id) {
        return this.userService.backUserTree(id);
    }

    @ApiOperation(value="\u67e5\u770b\u7528\u6237\u4fe1\u606f", notes="\u67e5\u770b\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/viewUser"})
    @CheckPermission(value={"hussarBase:authorization:permit:user:viewUser"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u67e5\u770b\u7528\u6237\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<UserPartialVo> viewUser(@ApiParam(value="\u7528\u6237ID") @RequestParam Long id) {
        return this.userService.viewUser(id);
    }

    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f", notes="\u6839\u636eID\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/loadUser"})
    @CheckPermission(value={"hussarBase:authorization:permit:user:loadUser"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u6839\u636eID\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<UserInfolVo> loadUser(@ApiParam(value="\u7528\u6237ID") @RequestParam Long id) {
        return this.userService.loadUser(id);
    }

    @ApiOperation(value="\u65b0\u589e\u7528\u6237", notes="\u65b0\u589e\u7528\u6237")
    @CheckPermission(value={"hussarBase:authorization:permit:user:addUser"})
    @PostMapping(value={"/addUser"})
    @CacheEvict(value={"user_ip"}, allEntries=true)
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u65b0\u589e\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> addUser(@ApiParam(value="\u65b0\u589e\u7528\u6237DTO") @RequestBody AddUserDto addUserDto) {
        return this.userService.addUser(addUserDto);
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237", notes="\u4fee\u6539\u7528\u6237")
    @CheckPermission(value={"hussarBase:authorization:permit:user:editUser"})
    @PostMapping(value={"/editUser"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u4fee\u6539\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CacheEvict(value={"resource_info"}, allEntries=true)
    public ApiResponse<String> editUser(@ApiParam(value="\u4fee\u6539\u7528\u6237DTO") @RequestBody EditUserDto editUserDto) {
        return this.userService.editUser(editUserDto);
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237", notes="\u5220\u9664\u7528\u6237")
    @CheckPermission(value={"hussarBase:authorization:permit:user:deleteUser"})
    @PostMapping(value={"/deleteUser"})
    @CheckSafe
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u5220\u9664\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<String> deleteUser(@ApiParam(value="\u7528\u6237id") @RequestBody Long id) {
        return this.userService.deleteUser(id);
    }

    @ApiOperation(value="\u5236\u7528\u6237\u89d2\u8272", notes="\u5236\u7528\u6237\u89d2\u8272")
    @CheckPermission(value={"hussarBase:authorization:permit:user:copyUserRole"})
    @PostMapping(value={"/copyUserRole"})
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u5236\u7528\u6237\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> copyUserRole(@ApiParam(value="\u590d\u5236\u7528\u6237\u89d2\u8272DTO") @RequestBody CopyUserRoleDto copyRoleDto) {
        return this.userService.copyUserRole(copyRoleDto);
    }

    @ApiOperation(value="\u67e5\u8be2\u91cd\u7f6e\u7528\u6237\u5217\u8868\u6570\u636e", notes="\u67e5\u8be2\u91cd\u7f6e\u7528\u6237\u5217\u8868\u6570\u636e")
    @CheckPermission(value={"hussarBase:authorization:permit:user:searchResetSecureUsers"})
    @GetMapping(value={"/searchResetSecureUsers"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u91cd\u7f6e\u7528\u6237\u5217\u8868\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<ResetSecureUserVo>> searchResetSecureUsers(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u67e5\u8be2\u7528\u6237dto") ResetSecureUserDto resetSecureUserDto) {
        return this.userService.searchResetSecureUsers(pageInfo, resetSecureUserDto);
    }

    @ApiOperation(value="\u91cd\u7f6e\u6240\u6709\u7528\u6237\u5bc6\u7801", notes="\u91cd\u7f6e\u6240\u6709\u7528\u6237\u5bc6\u7801")
    @PostMapping(value={"/resetUserSecure"})
    @CheckPermission(value={"hussarBase:authorization:permit:user:resetUserSecure"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u91cd\u7f6e\u6240\u6709\u7528\u6237\u5bc6\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.RESET_PASS)
    public ApiResponse<UpdateInfoVo> resetUserSecure(@ApiParam(value="\u4fee\u6539\u5bc6\u7801dto") @RequestBody UserSecureDto userSecureDto) {
        return this.userService.resetUserSecure(userSecureDto);
    }

    @ApiOperation(value="\u4f11\u7720\u7528\u6237", notes="\u4f11\u7720\u7528\u6237")
    @CheckPermission(value={"hussarBase:authorization:permit:user:dormancyUser"})
    @PostMapping(value={"/dormancyUser"})
    @CacheEvict(value={"authorization_info", "menu_info"}, allEntries=true)
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u4f11\u7720\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> dormancyUser(@ApiParam(value="\u7528\u6237id") @RequestBody Long id) {
        return this.userService.dormancyUser(id);
    }

    @ApiOperation(value="\u6fc0\u6d3b\u7528\u6237", notes="\u6fc0\u6d3b\u7528\u6237")
    @CheckPermission(value={"hussarBase:authorization:permit:user:activateUser"})
    @PostMapping(value={"/activateUser"})
    @CacheEvict(value={"authorization_info", "menu_info"}, allEntries=true)
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u4f11\u7720\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> activateUser(@ApiParam(value="\u7528\u6237id") @RequestBody Long id) {
        return this.userService.activateUser(id);
    }

    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u6392\u5e8f", notes="\u4fdd\u5b58\u7528\u6237\u6392\u5e8f")
    @CheckPermission(value={"hussarBase:authorization:permit:user:sortUser"})
    @PostMapping(value={"/sortUser"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u4fdd\u5b58\u7528\u6237\u6392\u5e8f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> sortUser(@ApiParam(value="\u7528\u6237id\u96c6\u5408") @RequestBody List<Long> idList) {
        return this.userService.sortUser(idList);
    }

    @ApiOperation(value="\u6ce8\u9500\u7528\u6237", notes="\u6ce8\u9500\u7528\u6237")
    @CheckPermission(value={"hussarBase:authorization:permit:user:cancelUser"})
    @PostMapping(value={"/cancelUser"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4", eventDesc="\u6ce8\u9500\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<String> cancelUser(@ApiParam(value="\u7528\u6237id") @RequestBody Long id) {
        return this.userService.cancelUser(id);
    }
}

