/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseStaffBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationInfoVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.authorization.organ.service.impl.hussarBaseOrganizationBoServiceImpl")
public class HussarBaseOrganizationBoServiceImpl
implements IHussarBaseOrganizationBoService {
    @Autowired
    private QueryOrganizationManager queryOrganizationManager;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Autowired
    private IHussarBaseStaffBoService staffBoService;

    public OrganizationBo findOrganizationById(Long id) {
        OrganizationInfoVo organizationInfoVo = this.queryOrganizationManager.loadOrganizationById(id);
        OrganizationBo bo = new OrganizationBo();
        bo.setId(id);
        bo.setOrganName(organizationInfoVo.getOrganName());
        bo.setOrganCode(organizationInfoVo.getOrganCode());
        bo.setOrganType(organizationInfoVo.getStruType());
        bo.setOrganTypeName(organizationInfoVo.getTypeName());
        bo.setParentId(organizationInfoVo.getParentId());
        bo.setParentOrganName(organizationInfoVo.getParentName());
        bo.setParentOrganType(organizationInfoVo.getParentStruType());
        bo.setParentOrganTypeName(organizationInfoVo.getParentTypeName());
        bo.setParentOrganCode(organizationInfoVo.getParentOrganCode());
        return bo;
    }

    public List<OrganizationBo> findOrganizationsByIds(List<Long> ids) {
        AssertUtil.isNotEmpty(ids, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        AssertUtil.isTrue((ids.size() <= 50 ? 1 : 0) != 0, (String)"\u4e00\u6b21\u67e5\u8be2\u6700\u591a50\u4e2a\u7ec4\u7ec7\u673a\u6784");
        ArrayList<OrganizationBo> list = new ArrayList<OrganizationBo>();
        for (Long id : ids) {
            list.add(this.findOrganizationById(id));
        }
        return list;
    }

    public OrganizationBo findOrganizationByCode(String code) {
        AssertUtil.isNotEmpty((String)code, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        OrganizationBo bo = this.sysOrganMapper.selectOrganizationBoByOrganCode(code);
        return bo;
    }

    public List<OrganizationBo> findOrganizationsByCodes(List<String> codes) {
        AssertUtil.isNotEmpty(codes, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        AssertUtil.isTrue((codes.size() <= 50 ? 1 : 0) != 0, (String)"\u4e00\u6b21\u67e5\u8be2\u6700\u591a50\u4e2a\u7ec4\u7ec7\u673a\u6784");
        List<OrganizationBo> bos = this.sysOrganMapper.selectOrganizationBosByOrganCodes(codes);
        return bos;
    }

    public List<OrganizationBo> findOrganizationsByParentId(Long id) {
        AssertUtil.isNotNull((Object)id, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        List<Long> struIds = this.sysStruMapper.getStruIdListByParentId(id);
        List<OrganizationBo> bos = new ArrayList<OrganizationBo>();
        if (struIds.size() > 0) {
            bos = this.sysOrganMapper.selectOrganizationBosByIds(struIds);
        }
        return bos;
    }

    public List<List<OrganizationBo>> findOrganizationsByParentsIds(List<Long> ids) {
        AssertUtil.isNotEmpty(ids, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        ArrayList<List<OrganizationBo>> boss = new ArrayList<List<OrganizationBo>>();
        for (Long id : ids) {
            boss.add(this.findOrganizationsByParentId(id));
        }
        return boss;
    }

    public List<OrganizationBo> findOrganizationsByParentCode(String code) {
        AssertUtil.isNotEmpty((String)code, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        List<Long> struIds = this.sysStruMapper.getStruIdListByParentCode(code);
        List<OrganizationBo> bos = new ArrayList<OrganizationBo>();
        if (struIds.size() > 0) {
            bos = this.sysOrganMapper.selectOrganizationBosByIds(struIds);
        }
        return bos;
    }

    public List<List<OrganizationBo>> findOrganizationsByParentsCodes(List<String> codes) {
        AssertUtil.isNotEmpty(codes, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        ArrayList<List<OrganizationBo>> boss = new ArrayList<List<OrganizationBo>>();
        for (String code : codes) {
            boss.add(this.findOrganizationsByParentCode(code));
        }
        return boss;
    }

    public Page<OrganizationBo> queryOrganizationsByParentId(PageInfo pageInfo, Long id) {
        Page<OrganizationBo> page = HussarPageUtils.convert((PageInfo)pageInfo);
        AssertUtil.isNotNull((Object)id, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        page = this.sysStruMapper.getOrganizationByParentId(page, id);
        return page;
    }

    public Page<OrganizationBo> queryOrganizationsByParentCode(PageInfo pageInfo, String code) {
        Page<OrganizationBo> page = HussarPageUtils.convert((PageInfo)pageInfo);
        AssertUtil.isNotNull((Object)code, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        Long id = this.sysStruMapper.getStruIdByOrganCode(code);
        page = this.sysStruMapper.getOrganizationByParentId(page, id);
        return page;
    }

    public List<OrganizationBo> findOrgnaizationsByStruFid(String struFid) {
        String[] struIds = struFid.split("/");
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(struIds));
        ids.remove(ids.size() - 1);
        ids.remove(0);
        AssertUtil.isNotEmpty(ids, (String)"\u672a\u67e5\u8be2\u5230\u4e0a\u7ea7\u7ec4\u7ec7\u673a\u6784");
        List<Long> newIds = ids.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List<OrganizationBo> bos = this.sysOrganMapper.selectOrganizationBosByIds(newIds);
        return bos;
    }

    public List<OrganizationBo> findParentOrganizationsByStaffId(Long id) {
        AssertUtil.isNotNull((Object)id, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        String struFid = this.sysStruMapper.getStruFidByStaffId(id);
        AssertUtil.isNotNull((Object)struFid, (String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> bos = this.findOrgnaizationsByStruFid(struFid);
        return bos;
    }

    public List<OrganizationBo> findParentOrganizationsByStaffCode(String code) {
        AssertUtil.isNotNull((Object)code, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        Long struId = this.sysStruMapper.getStruIdByStaffCode(code);
        AssertUtil.isNotNull((Object)struId, (String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> bos = this.findParentOrganizationsByStaffId(struId);
        return bos;
    }

    public List<OrganizationBo> findParentOrganizationsByUserId(Long id) {
        AssertUtil.isNotNull((Object)id, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        Long employeeId = this.sysUsersMapper.findEmployeeIdByUserId(id);
        AssertUtil.isNotNull((Object)employeeId, (String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> bos = this.findParentOrganizationsByStaffId(employeeId);
        return bos;
    }

    public List<OrganizationBo> findParentOrganizationsByUserAccount(String account) {
        AssertUtil.isNotNull((Object)account, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        Long employeeId = this.sysUsersMapper.findEmployeeIdByUserAccount(account);
        AssertUtil.isNotNull((Object)employeeId, (String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> bos = this.findParentOrganizationsByStaffId(employeeId);
        return bos;
    }

    public List<OrganizationBo> findParentOrganizationsByOrganId(Long id) {
        AssertUtil.isNotNull((Object)id, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        String struFid = this.sysStruMapper.getStruFidByOrganId(id);
        AssertUtil.isNotNull((Object)struFid, (String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> bos = this.findOrgnaizationsByStruFid(struFid);
        return bos;
    }

    public List<OrganizationBo> findParentOrganizationsByOrganCode(String code) {
        AssertUtil.isNotNull((Object)code, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        Long struId = this.sysStruMapper.getStruIdByOrganCode(code);
        AssertUtil.isNotNull((Object)struId, (String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> bos = this.findParentOrganizationsByOrganId(struId);
        return bos;
    }

    public OrganizationBo findOrganByTypeAndUserId(String organType, Long userId) {
        AssertUtil.isNotNull((Object)organType, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        AssertUtil.isNotNull((Object)userId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> orgBos = this.findParentOrganizationsByUserId(userId);
        Collections.reverse(orgBos);
        for (OrganizationBo orgBo : orgBos) {
            if (!organType.equals(orgBo.getOrganType())) continue;
            return orgBo;
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
    }

    public OrganizationBo findOrganByTypeAndUserAccount(String organType, String account) {
        AssertUtil.isNotNull((Object)organType, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        AssertUtil.isNotNull((Object)account, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> orgBos = this.findParentOrganizationsByUserAccount(account);
        Collections.reverse(orgBos);
        for (OrganizationBo orgBo : orgBos) {
            if (!orgBo.getOrganType().equals(organType)) continue;
            return orgBo;
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7c7b\u578b\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
    }

    public OrganizationBo findOrganByTypeNameAndUserId(String typeName, Long userId) {
        AssertUtil.isNotNull((Object)typeName, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        AssertUtil.isNotNull((Object)userId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> orgBos = this.findParentOrganizationsByUserId(userId);
        Collections.reverse(orgBos);
        for (OrganizationBo orgBo : orgBos) {
            if (!orgBo.getOrganTypeName().equals(typeName)) continue;
            return orgBo;
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7c7b\u578b\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
    }

    public OrganizationBo findOrganByTypeNameAndUserAccount(String typeName, String account) {
        AssertUtil.isNotNull((Object)typeName, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        AssertUtil.isNotNull((Object)account, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> orgBos = this.findParentOrganizationsByUserAccount(account);
        Collections.reverse(orgBos);
        for (OrganizationBo orgBo : orgBos) {
            if (!orgBo.getOrganTypeName().equals(typeName)) continue;
            return orgBo;
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7c7b\u578b\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
    }

    public OrganizationBo findOrganByTypeAndStaffId(String organType, Long staffId) {
        AssertUtil.isNotNull((Object)organType, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        AssertUtil.isNotNull((Object)staffId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> orgBos = this.findParentOrganizationsByStaffId(staffId);
        Collections.reverse(orgBos);
        for (OrganizationBo orgBo : orgBos) {
            if (!orgBo.getOrganType().equals(organType)) continue;
            return orgBo;
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7c7b\u578b\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
    }

    public OrganizationBo findOrganByTypeAndStaffCode(String organType, String staffCode) {
        AssertUtil.isNotNull((Object)organType, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        AssertUtil.isNotNull((Object)staffCode, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> orgBos = this.findParentOrganizationsByStaffCode(staffCode);
        Collections.reverse(orgBos);
        for (OrganizationBo orgBo : orgBos) {
            if (!orgBo.getOrganType().equals(organType)) continue;
            return orgBo;
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7c7b\u578b\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
    }

    public OrganizationBo findOrganByTypeNameAndStaffId(String typeName, Long staffId) {
        AssertUtil.isNotNull((Object)typeName, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        AssertUtil.isNotNull((Object)staffId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> orgBos = this.findParentOrganizationsByStaffId(staffId);
        Collections.reverse(orgBos);
        for (OrganizationBo orgBo : orgBos) {
            if (!orgBo.getOrganTypeName().equals(typeName)) continue;
            return orgBo;
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7c7b\u578b\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
    }

    public OrganizationBo findOrganByTypeNameAndStaffCode(String typeName, String staffCode) {
        AssertUtil.isNotNull((Object)typeName, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        AssertUtil.isNotNull((Object)staffCode, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> orgBos = this.findParentOrganizationsByStaffCode(staffCode);
        Collections.reverse(orgBos);
        for (OrganizationBo orgBo : orgBos) {
            if (!orgBo.getOrganTypeName().equals(typeName)) continue;
            return orgBo;
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7c7b\u578b\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
    }

    public OrganizationBo findOrganByTypeAndOrganId(String organType, Long organId) {
        AssertUtil.isNotNull((Object)organType, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        AssertUtil.isNotNull((Object)organId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> orgBos = this.findParentOrganizationsByOrganId(organId);
        Collections.reverse(orgBos);
        for (OrganizationBo orgBo : orgBos) {
            if (!orgBo.getOrganType().equals(organType)) continue;
            return orgBo;
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7c7b\u578b\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
    }

    public OrganizationBo findOrganByTypeAndOrganCode(String organType, String organCode) {
        AssertUtil.isNotNull((Object)organType, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        AssertUtil.isNotNull((Object)organCode, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> orgBos = this.findParentOrganizationsByOrganCode(organCode);
        Collections.reverse(orgBos);
        for (OrganizationBo orgBo : orgBos) {
            if (!orgBo.getOrganType().equals(organType)) continue;
            return orgBo;
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7c7b\u578b\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
    }

    public OrganizationBo findOrganByTypeNameAndOrganId(String typeName, Long organId) {
        AssertUtil.isNotNull((Object)typeName, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        AssertUtil.isNotNull((Object)organId, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> orgBos = this.findParentOrganizationsByOrganId(organId);
        Collections.reverse(orgBos);
        for (OrganizationBo orgBo : orgBos) {
            if (!orgBo.getOrganTypeName().equals(typeName)) continue;
            return orgBo;
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7c7b\u578b\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
    }

    public OrganizationBo findOrganByTypeNameAndOrganCode(String typeName, String organCode) {
        AssertUtil.isNotNull((Object)typeName, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        AssertUtil.isNotNull((Object)organCode, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        List<OrganizationBo> orgBos = this.findParentOrganizationsByOrganCode(organCode);
        Collections.reverse(orgBos);
        for (OrganizationBo orgBo : orgBos) {
            if (!orgBo.getOrganTypeName().equals(typeName)) continue;
            return orgBo;
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u7c7b\u578b\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
    }
}

