/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dto.QueryOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryTransferOrganizationListDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryTransferOrganizationTreeDto;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonQueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.organ.vo.CustomOrgTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.InstitutionVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationInfoVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationPartialVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.ReadOnlyOrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.SysStruRuleVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleStruRightsMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.vo.SelectCustomOrgTreeVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.ibatis.session.ResultHandler;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.queryOrganizationManagerImpl")
public class QueryOrganizationManagerImpl
extends CommonQueryOrganizationManager
implements QueryOrganizationManager {
    @Resource
    private SysRoleStruRightsMapper sysRoleStruRightsMapper;

    @Override
    public List<OrganizationTreeVo> lazyLoadOrganizationTree(Long parentId) {
        ArrayList<OrganizationTreeVo> result = new ArrayList<OrganizationTreeVo>();
        List<OrganizationTreeVo> data = this.getOrganizationTree(parentId);
        this.fillOrganizationPermissions(data);
        result.addAll(data);
        return HussarTreeParser.getTreeList(result);
    }

    @Override
    public List<ReadOnlyOrganizationTreeVo> lazyLoadOrganizationTreeNoPermissions(Long parentId) {
        ArrayList<ReadOnlyOrganizationTreeVo> result = new ArrayList<ReadOnlyOrganizationTreeVo>();
        List<OrganizationTreeVo> data = this.getOrganizationTree(parentId);
        ReadOnlyOrganizationTreeVo readOnlyOrganizationTreeVo = null;
        if (HussarUtils.isNotEmpty(data)) {
            for (OrganizationTreeVo vo : data) {
                readOnlyOrganizationTreeVo = new ReadOnlyOrganizationTreeVo();
                readOnlyOrganizationTreeVo.setId(vo.getId());
                readOnlyOrganizationTreeVo.setLabel(vo.getLabel());
                readOnlyOrganizationTreeVo.setHasChildren(vo.getHasChildren());
                readOnlyOrganizationTreeVo.setChildren(vo.getChildren());
                readOnlyOrganizationTreeVo.setIcon(vo.getIcon());
                readOnlyOrganizationTreeVo.setStruType(vo.getStruType());
                readOnlyOrganizationTreeVo.setStruLevel(vo.getStruLevel());
                readOnlyOrganizationTreeVo.setParentId(vo.getParentId());
                result.add(readOnlyOrganizationTreeVo);
            }
        }
        return HussarTreeParser.getTreeList(result);
    }

    @Override
    public OrganizationPartialVo viewOrganization(Long id) {
        SysUsers sysUsers;
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysStru, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7ed3\u6784");
        SysOrgan sysOrgan = (SysOrgan)this.sysOrganMapper.selectById(sysStru.getOrganId());
        AssertUtil.isNotNull((Object)sysOrgan, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u673a\u6784");
        LambdaQueryWrapper officeWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysOffice::getStruId, (Object)id);
        SysOffice sysOffice = (SysOffice)this.sysOfficeMapper.selectOne((Wrapper)officeWrapper);
        AssertUtil.isNotNull((Object)sysOffice, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u673a\u6784\u6269\u5c55\u4fe1\u606f");
        LambdaQueryWrapper organtypeWrapper = new LambdaQueryWrapper();
        organtypeWrapper.eq(SysOrganType::getOrganType, (Object)sysStru.getStruType());
        SysOrganType organType = (SysOrganType)this.organTypeService.getOne((Wrapper)organtypeWrapper);
        AssertUtil.isNotNull((Object)sysOffice, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7ed3\u6784\u7c7b\u578b\u4fe1\u606f");
        OrganizationPartialVo vo = new OrganizationPartialVo();
        vo.setId(sysStru.getId());
        vo.setParentName(OrganUtil.getShortParentName((String)sysOrgan.getOrganFname()));
        vo.setOrganCode(sysOrgan.getOrganCode());
        vo.setTypeName(organType.getTypeName());
        vo.setOrganName(sysOrgan.getOrganName());
        vo.setOrganAlias(sysStru.getOrganAlias());
        vo.setShortName(sysOrgan.getShortName());
        vo.setOfficeAddress(sysOffice.getOfficeAddress());
        vo.setOfficeAlias(sysOffice.getOfficeAlias());
        Long principalId = sysStru.getPrincipalId();
        if (HussarUtils.isNotEmpty((Object)principalId) && HussarUtils.isNotEmpty((Object)(sysUsers = (SysUsers)this.sysUsersMapper.selectById(principalId)))) {
            vo.setUserName(sysUsers.getUserName());
        }
        return vo;
    }

    @Override
    public OrganizationInfoVo loadOrganizationById(Long id) {
        SysUsers sysUsers;
        Long principalId;
        AssertUtil.isNotNull((Object)id, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysStru, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7ed3\u6784");
        SysOrgan sysOrgan = (SysOrgan)this.sysOrganMapper.selectById(sysStru.getOrganId());
        AssertUtil.isNotNull((Object)sysOrgan, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u673a\u6784");
        LambdaQueryWrapper officeWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysOffice::getStruId, (Object)id);
        SysOffice sysOffice = (SysOffice)this.sysOfficeMapper.selectOne((Wrapper)officeWrapper);
        AssertUtil.isNotNull((Object)sysOffice, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u673a\u6784\u6269\u5c55\u4fe1\u606f");
        LambdaQueryWrapper organtypeWrapper = new LambdaQueryWrapper();
        organtypeWrapper.eq(SysOrganType::getOrganType, (Object)sysStru.getStruType());
        Map organTypeMap = this.organTypeService.queryOrganTypeMap();
        SysStru parentSysStru = null;
        OrganizationInfoVo vo = new OrganizationInfoVo();
        vo.setId(sysStru.getId());
        vo.setParentId(sysStru.getParentId());
        vo.setStruType(sysStru.getStruType());
        vo.setBeginDate(sysOrgan.getBeginDate());
        vo.setEndDate(sysOrgan.getEndDate());
        vo.setOrganCode(sysOrgan.getOrganCode());
        vo.setTypeName(((SysOrganType)organTypeMap.get(sysStru.getStruType())).getTypeName());
        vo.setOrganName(sysOrgan.getOrganName());
        vo.setOrganAlias(sysStru.getOrganAlias());
        vo.setShortName(sysOrgan.getShortName());
        vo.setOfficeAddress(sysOffice.getOfficeAddress());
        vo.setOfficeAlias(sysOffice.getOfficeAlias());
        vo.setOrganId(sysOrgan.getId());
        vo.setOfficeId(sysOffice.getId());
        if (HussarUtils.isNotEmpty((Object)sysStru.getParentId()) && HussarUtils.isNotEmpty((Object)(parentSysStru = (SysStru)this.sysStruMapper.selectById(sysStru.getParentId())))) {
            vo.setParentName(OrganUtil.getShortParentName((String)sysOrgan.getOrganFname()));
            vo.setParentOrganCode(OrganUtil.getShortParentName((String)sysOrgan.getOrganFcode()));
            vo.setParentStruType(parentSysStru.getStruType());
            vo.setParentTypeName(((SysOrganType)organTypeMap.get(parentSysStru.getStruType())).getTypeName());
        }
        if (HussarUtils.isNotEmpty((Object)(principalId = sysStru.getPrincipalId())) && HussarUtils.isNotEmpty((Object)(sysUsers = (SysUsers)this.sysUsersMapper.selectById(principalId)))) {
            vo.setPrincipalId(sysUsers.getId());
            vo.setUserName(sysUsers.getUserName());
            vo.setUserAccount(sysUsers.getUserAccount());
        }
        return vo;
    }

    @Override
    public Page<SearchOrganizationVo> searchOrganization(PageInfo pageInfo, String name) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("name", SqlQueryUtil.transferSpecialChar((String)name));
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        if (currentUser.isGradeadmin()) {
            Long deptId = currentUser.getDeptId();
            String struFid = ((SysStru)this.sysStruMapper.selectById(deptId)).getStruFid();
            queryOrgParams.put("struFid", struFid);
            String[] split = struFid.split("/");
            ArrayList<Long> parentIds = new ArrayList<Long>();
            for (String str : split) {
                if (!HussarUtils.isNotBlank((CharSequence)str) || deptId.toString().equals(str)) continue;
                parentIds.add(Long.parseLong(str));
            }
            queryOrgParams.put("parentIds", parentIds);
        }
        page.setRecords(this.sysStruMapper.searchOrganization(page, queryOrgParams));
        return page;
    }

    private boolean getGradeFlag(String fid, String currentStruFid, int level, Map<Integer, String> mapStruFid) {
        boolean flag = false;
        if (fid.startsWith(currentStruFid)) {
            if (level == 1) {
                flag = true;
            } else {
                String reduceStruFidByLevel = mapStruFid.get(level - 1);
                if (fid.startsWith(reduceStruFidByLevel)) {
                    flag = true;
                }
            }
        }
        return flag;
    }

    private boolean getFlag(String fid, int level, Map<Integer, String> mapStruFid) {
        boolean flag = false;
        if (level == 1) {
            flag = true;
        } else {
            String reduceStruFidByLevel = mapStruFid.get(level - 1);
            if (fid.startsWith(reduceStruFidByLevel)) {
                flag = true;
            }
        }
        return flag;
    }

    @Override
    public List<OrganizationTreeVo> backOrganizationTree(Long id) {
        ArrayList<OrganizationTreeVo> result = new ArrayList<OrganizationTreeVo>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = currentUser.isGradeadmin();
        AtomicReference<String> currentStruFidT = new AtomicReference<String>("");
        Long deptId = currentUser.getDeptId();
        ConditionUtils.isTrue((boolean)isGradeAdmin).handle(() -> currentStruFidT.set(((SysStru)this.sysStruMapper.selectById(deptId)).getStruFid()));
        String currentStruFid = currentStruFidT.get();
        AtomicReference<String> paramStruFid = new AtomicReference<String>("/%");
        AtomicInteger parentLevel = new AtomicInteger(1);
        HashMap mapStruFid = new HashMap();
        ConditionUtils.isTrue((!Objects.equals(id, Constants.ROOT_NODE_ID) ? 1 : 0) != 0).handle(() -> {
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(id);
            parentLevel.set(sysStru.getStruLevel());
            String struFid = sysStru.getStruFid();
            for (int i = 1; i <= parentLevel.get(); ++i) {
                mapStruFid.put(i, OrganUtil.convert((String)OrganUtil.getStruFidByLevel((String)struFid, (int)i)));
            }
            paramStruFid.set((String)mapStruFid.get(1) + "%");
        });
        this.sysStruMapper.findInstitution(paramStruFid.get(), parentLevel.get(), (ResultHandler<InstitutionVo>)((ResultHandler)resultContext -> {
            InstitutionVo t = (InstitutionVo)resultContext.getResultObject();
            int level = t.getStruLevel();
            String idT = t.getId();
            String fid = t.getStruFid();
            String label = t.getLabel();
            String parentId = t.getParentId();
            String struType = t.getStruType();
            Boolean hasChild = t.getHasChildren();
            AtomicBoolean flag = new AtomicBoolean(false);
            ConditionUtils.isTureOrFalse((boolean)isGradeAdmin).trueOrFalseHandle(() -> flag.set(this.getGradeFlag(fid, currentStruFid, level, mapStruFid)), () -> flag.set(this.getFlag(fid, level, mapStruFid)));
            if (flag.get()) {
                OrganizationTreeVo organizationTreeVo = new OrganizationTreeVo();
                organizationTreeVo.setId(idT);
                organizationTreeVo.setLabel(label);
                organizationTreeVo.setParentId(parentId);
                organizationTreeVo.setStruType(struType);
                organizationTreeVo.setStruLevel(level);
                organizationTreeVo.setHasChildren(hasChild);
                result.add(organizationTreeVo);
            }
        }));
        this.fillOrganizationPermissions(result);
        return HussarTreeParser.getTreeList(result);
    }

    @Override
    public Page<OrganizationVo> queryOrganization(PageInfo pageInfo, QueryOrganizationDto queryOrganizationDto) {
        String organTypes;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryOrgParams = new HashMap<String, Object>();
        queryOrgParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        String struFid = "/";
        Long parentStruId = queryOrganizationDto.getParentId();
        AssertUtil.isNotNull((Object)parentStruId, (String)"\u4e0a\u7ea7\u53c2\u6570\u672a\u4f20\u9012");
        boolean isRoot = Objects.equals(Constants.ROOT_NODE_ID, parentStruId);
        if (!isRoot) {
            SysStru pSysStru = (SysStru)Optional.ofNullable(this.sysStruMapper.selectById(parentStruId)).orElse(new SysStru());
            struFid = pSysStru.getStruFid();
        }
        if (HussarUtils.isNotBlank((CharSequence)(organTypes = queryOrganizationDto.getOrganTypes()))) {
            List<String> organTypesList = Arrays.asList(organTypes.split(","));
            queryOrgParams.put("organTypes", organTypesList);
        }
        int level = OrganUtil.getSubordinateLevel((String)OrganUtil.convert((String)struFid));
        queryOrgParams.put("parentStruId", OrganUtil.convert((Long)parentStruId));
        queryOrgParams.put("organName", SqlQueryUtil.transferSpecialChar((String)queryOrganizationDto.getOrganName()));
        queryOrgParams.put("organCode", SqlQueryUtil.transferSpecialChar((String)queryOrganizationDto.getOrganCode()));
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        int gradePLevel = 0;
        if (currentUser.isGradeadmin()) {
            Long deptId = currentUser.getDeptId();
            SysStru gradePSysStru = (SysStru)this.sysStruMapper.selectById(deptId);
            gradePLevel = gradePSysStru.getStruLevel();
            int gradeDepStruLevel = gradePLevel + 1;
            int searchStruLevel = 0;
            if (!isRoot) {
                searchStruLevel = this.sysStruMapper.selectStruLevel(parentStruId);
            }
            if (searchStruLevel < gradeDepStruLevel) {
                struFid = ((SysStru)this.sysStruMapper.selectById(deptId)).getStruFid();
                level = OrganUtil.getSubordinateLevel((String)OrganUtil.convert((String)struFid));
            }
        }
        queryOrgParams.put("struFid", OrganUtil.convert((String)struFid));
        if (queryOrganizationDto instanceof QueryTransferOrganizationListDto) {
            QueryTransferOrganizationListDto dto = (QueryTransferOrganizationListDto)queryOrganizationDto;
            Long transferId = dto.getTransferId();
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(transferId);
            AssertUtil.isNotNull((Object)struTemp, (String)"\u67e5\u8be2\u4e0d\u5230\u8981\u8f6c\u79fb\u7684\u7ec4\u7ec7\u673a\u6784");
            List<Long> excludeIds = this.getTransferExcludeIds(struTemp);
            queryOrgParams.put("excludeIds", excludeIds);
            --level;
        }
        queryOrgParams.put("struLevel", level);
        List<OrganizationVo> organizationVos = this.sysStruMapper.queryOrganization((Page<OrganizationVo>)page, queryOrgParams);
        page.setRecords(organizationVos);
        return page;
    }

    private List<Long> getTransferExcludeIds(SysStru stru) {
        ArrayList<Long> list = new ArrayList<Long>();
        Long id = stru.getId();
        String struType = stru.getStruType();
        if (!struType.equals("9")) {
            list.add(id);
        }
        return list;
    }

    @Override
    public List<OrganizationTreeVo> getTransferOrganizationTree(QueryTransferOrganizationTreeDto queryTransferOrganizationDto) {
        ArrayList result = new ArrayList();
        Long parentId = queryTransferOrganizationDto.getParentId();
        String transferId = queryTransferOrganizationDto.getTransferId().toString();
        List<OrganizationTreeVo> list = this.getOrganizationTree(parentId);
        ConditionUtils.isTrue((boolean)HussarUtils.isNotEmpty(list)).handle(() -> {
            for (OrganizationTreeVo vo : list) {
                if (Objects.equals(vo.getId(), transferId)) continue;
                result.add(vo);
            }
        });
        return HussarTreeParser.getTreeList(result);
    }

    @Override
    public List<SysStruRuleVo> getOrganizationTypeByParentId(Long parentId) {
        ArrayList<SysStruRuleVo> list = new ArrayList<SysStruRuleVo>();
        SysStru stru = (SysStru)this.sysStruMapper.selectById(parentId);
        SysStruRuleVo rule = null;
        if (HussarUtils.isEmpty((Object)parentId) || HussarUtils.isEmpty((Object)stru)) {
            rule = new SysStruRuleVo();
            rule.setOrganType("1");
            rule.setOrganTypeName("\u5355\u4f4d");
            rule.setSysOrganType("1");
            rule.setSysOrganTypeName("\u5355\u4f4d");
            list.add(rule);
        } else {
            String parentType = stru.getStruType();
            Map typeMap = this.organTypeService.queryOrganTypeMap();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysStruRule::getSysOrganType, (Object)parentType);
            wrapper.ne(SysStruRule::getOrganType, (Object)"9");
            wrapper.orderByAsc(SysStruRule::getOrganType);
            List sysStruRules = this.sysStruRuleMapper.selectList((Wrapper)wrapper);
            for (SysStruRule temp : sysStruRules) {
                rule = new SysStruRuleVo();
                rule.setOrganType(temp.getOrganType());
                rule.setOrganTypeName(((SysOrganType)typeMap.get(rule.getOrganType())).getTypeName());
                rule.setSysOrganType(temp.getSysOrganType());
                rule.setSysOrganTypeName(((SysOrganType)typeMap.get(rule.getSysOrganType())).getTypeName());
                list.add(rule);
            }
        }
        return list;
    }

    @Override
    public List<OrganizationTreeVo> getOrderOrganizationTree(Long parentId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("parentId", parentId);
        ArrayList<OrganizationTreeVo> result = new ArrayList<OrganizationTreeVo>();
        List<OrganizationTreeVo> data = this.searchOrganizationTree(queryParams);
        OrganizationTreeVo root = null;
        if (HussarUtils.isEmpty((Object)parentId) || Objects.equals(Constants.ROOT_NODE_ID, parentId)) {
            root = new OrganizationTreeVo();
            root.setId(String.valueOf(Constants.ROOT_NODE_ID));
            root.setHasChildren(Boolean.valueOf(true));
            root.setLabel("\u7ec4\u7ec7\u673a\u6784");
            root.setDisabled(Boolean.valueOf(true));
            root.setStruLevel(0);
            root.setStruType("isRoot");
            root.setIcon("tree-com");
        } else {
            root = this.lazyOrganizationById(parentId);
        }
        root.setChildren(data);
        result.add(root);
        return result;
    }

    @Override
    public OrganizationTreeVo lazyOrganizationById(Long id) {
        OrganizationTreeVo organizationTreeVo = this.sysStruMapper.lazyOrganizationById(id);
        List<SysStruRule> list = this.searchWithoutStaffRuleList();
        this.fillSingleOrganizationPermissions(organizationTreeVo, list);
        return organizationTreeVo;
    }

    @Override
    public Page<OrganizationVo> transferOrganizationList(PageInfo pageInfo, QueryTransferOrganizationListDto queryOrganizationDto) {
        return this.queryOrganization(pageInfo, (QueryOrganizationDto)queryOrganizationDto);
    }

    @Override
    public String getOrganFname(Long struId) {
        return this.sysStruMapper.getOrganFname(struId);
    }

    @Override
    public SelectCustomOrgTreeVo getCustomOrgTree(Long dataRightId) {
        ArrayList<CustomOrgTreeVo> customOrgTreeVoList = new ArrayList<CustomOrgTreeVo>();
        CustomOrgTreeVo customOrgTreeVo = new CustomOrgTreeVo();
        customOrgTreeVo.setId("11");
        customOrgTreeVo.setHasChildren(Boolean.valueOf(true));
        customOrgTreeVo.setLabel("\u7ec4\u7ec7\u673a\u6784");
        customOrgTreeVo.setStruType("0");
        customOrgTreeVoList.add(customOrgTreeVo);
        customOrgTreeVoList.addAll(this.sysStruMapper.getCustomOrgTree());
        SelectCustomOrgTreeVo selectCustomOrgTreeVo = new SelectCustomOrgTreeVo();
        selectCustomOrgTreeVo.setStruTree(HussarTreeParser.getTreeList(customOrgTreeVoList));
        if (dataRightId != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysRoleStruRights::getRoleDataRightsId, (Object)dataRightId);
            List roleStruRightsList = this.sysRoleStruRightsMapper.selectList((Wrapper)queryWrapper);
            List customDeptIdList = roleStruRightsList.stream().map(SysRoleStruRights::getStruid).collect(Collectors.toList());
            selectCustomOrgTreeVo.setSelectedStru(customDeptIdList);
        }
        return selectCustomOrgTreeVo;
    }

    @Override
    public List<SysOrgan> getOrganByIds(List<Long> ids) {
        if (HussarUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.sysOrganMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysOrgan::getId, ids));
    }
}

