/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.vo.OrganTreeInitVo;
import com.jxdinfo.hussar.authorization.organ.vo.UserTreeVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.dto.AddUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.CopyUserRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.EditUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryCopyRoleUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResetSecureUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.UserInfolVo;
import com.jxdinfo.hussar.authorization.permit.dto.UserPartialVo;
import com.jxdinfo.hussar.authorization.permit.dto.UserSecureDto;
import com.jxdinfo.hussar.authorization.permit.manager.AddUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.EditUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.QueryUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.RestUserSecureManager;
import com.jxdinfo.hussar.authorization.permit.manager.SortUserManager;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserService;
import com.jxdinfo.hussar.authorization.permit.vo.ResetSecureUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.UpdateInfoVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.hussarBaseUserServiceImpl")
public class HussarBaseUserServiceImpl
implements IHussarBaseUserService {
    @Autowired
    private QueryUserManager queryUserManager;
    @Autowired
    private RestUserSecureManager restUserSecureManager;
    @Autowired
    private AddUserManager addUserManager;
    @Autowired
    private EditUserManager editUserManager;
    @Autowired
    private DeleteUserManager deleteUserManager;
    @Autowired
    private SortUserManager sortUserManager;
    @Autowired
    private QueryOrganizationManager queryOrganizationManager;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;

    public ApiResponse<Page<SearchUserVo>> searchUsers(PageInfo pageInfo, QueryUserDto queryUserDto) {
        return ApiResponse.success(this.queryUserManager.searchUsers(pageInfo, queryUserDto));
    }

    public ApiResponse<List<UserTreeVo>> lazyLoadingUserTree(Long parentId) {
        return ApiResponse.success(this.queryUserManager.lazyLoadingUserTree(parentId));
    }

    public ApiResponse<List<UserTreeVo>> getOrderUserTree(Long parentId) {
        return ApiResponse.success(this.queryUserManager.getOrderUserTree(parentId));
    }

    public ApiResponse<List<UserTreeVo>> backUserTree(Long id) {
        return ApiResponse.success(this.queryUserManager.backUserTree(id));
    }

    public ApiResponse<UserPartialVo> viewUser(Long id) {
        return ApiResponse.success((Object)this.queryUserManager.viewUser(id));
    }

    public ApiResponse<UserInfolVo> loadUser(Long id) {
        return ApiResponse.success((Object)this.queryUserManager.loadUser(id));
    }

    @HussarTransactional
    public ApiResponse<Long> addUser(AddUserDto addUserDto) {
        return this.addUserManager.addUser(addUserDto);
    }

    @HussarTransactional
    public ApiResponse<String> editUser(EditUserDto editUserDto) {
        return ApiResponse.success((String)this.editUserManager.editUser(editUserDto));
    }

    @HussarTransactional
    public ApiResponse<String> deleteUser(Long id) {
        return ApiResponse.success((String)this.deleteUserManager.deleteUser(id));
    }

    @HussarTransactional
    public ApiResponse<String> copyUserRole(CopyUserRoleDto copyRoleDto) {
        return ApiResponse.success((String)this.editUserManager.copyUserRole(copyRoleDto));
    }

    @HussarTransactional
    public ApiResponse<String> dormancyUser(Long id) {
        return ApiResponse.success((String)this.editUserManager.dormancyUser(id));
    }

    @HussarTransactional
    public ApiResponse<String> sortUser(List<Long> idList) {
        return ApiResponse.success((String)this.sortUserManager.sortUser(idList));
    }

    public ApiResponse<String> cancelUser(Long id) {
        return ApiResponse.success((String)this.editUserManager.cancelUser(id));
    }

    public ApiResponse<String> activateUser(Long id) {
        return ApiResponse.success((String)this.editUserManager.activateUser(id));
    }

    public ApiResponse<Page<SearchUserVo>> searchCopyRoleUsers(PageInfo pageInfo, QueryCopyRoleUserDto queryCopyRoleUserDto) {
        return ApiResponse.success(this.queryUserManager.searchCopyRoleUsers(pageInfo, queryCopyRoleUserDto));
    }

    public ApiResponse<Page<ResetSecureUserVo>> searchResetSecureUsers(PageInfo pageInfo, ResetSecureUserDto resetSecureUserDto) {
        return ApiResponse.success(this.queryUserManager.searchResetSecureUsers(pageInfo, resetSecureUserDto));
    }

    @HussarTransactional
    public ApiResponse<UpdateInfoVo> resetUserSecure(UserSecureDto userSecureDto) {
        return ApiResponse.success((Object)this.restUserSecureManager.resetUserSecure(userSecureDto));
    }

    public List<OrganTreeInitVo> getUserTreeInitVos(Long parentId, int ifLazy, Integer defaultLevel) {
        if (ifLazy != 0 && ifLazy != 1) {
            throw new BaseException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u662f\u5426\u61d2\u52a0\u8f7d\u53c2\u6570");
        }
        int defaultLevelNum = 1;
        if (defaultLevel != null && defaultLevel > 0) {
            defaultLevelNum = defaultLevel;
        }
        if (ifLazy == 0) {
            defaultLevelNum = 0;
        }
        List<OrganTreeInitVo> users = this.queryUserManager.getUsersByParentIdAndLevel(parentId, defaultLevelNum);
        List<OrganTreeInitVo> organs = this.queryOrganizationManager.getOrgansByParentIdAndLevel(parentId, defaultLevelNum, false, true);
        if (parentId.toString().equals("11")) {
            OrganTreeInitVo firstOrgan = new OrganTreeInitVo();
            firstOrgan.setId("11");
            firstOrgan.setLabel("\u7cfb\u7edf\u7528\u6237");
            firstOrgan.setParentId("0");
            firstOrgan.setStruLevel(0);
            firstOrgan.setChangedLevel(1);
            List<OrganTreeInitVo> organTreeInitVos = this.sysStruMapper.queryChildrenOrgan(parentId, false, false);
            if (organTreeInitVos != null) {
                firstOrgan.setHasChildren(Boolean.valueOf(true));
            }
            organs.add(firstOrgan);
        }
        organs.addAll(users);
        List<OrganTreeInitVo> organTree = this.queryOrganizationManager.getOrganTree(organs);
        return organTree;
    }

    public List<OrganTreeInitVo> getChildrenUsersByParentId(Long parentId) {
        List<OrganTreeInitVo> users = this.queryUserManager.getChildrenUsersByParentId(parentId);
        List<OrganTreeInitVo> organs = this.queryOrganizationManager.getChildrenOrgan(parentId, false, true);
        organs.addAll(users);
        return organs;
    }

    public ApiResponse<List<OrganTreeInitVo>> getUsersLikeName(String searchValue) {
        List<OrganTreeInitVo> users = this.queryUserManager.getUsersLikeName(searchValue);
        return ApiResponse.success(users);
    }

    public List<OrganTreeInitVo> getUpUserTreeByUserId(Long userId) {
        int defaultLevel = 0;
        if (!userId.toString().equals("11")) {
            Integer level = this.queryUserManager.getStaffLevelByUserId(userId);
            if (level != null) {
                defaultLevel = level;
            } else {
                throw new BaseException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u53c2\u6570");
            }
        }
        List<OrganTreeInitVo> parentLevelOrganUsersList = this.sysStruMapper.queryUpOrgansByFidAndLevelForUserTree("", defaultLevel, false, true);
        for (OrganTreeInitVo organ : parentLevelOrganUsersList) {
            organ.setChangedLevel(organ.getStruLevel() + 1);
        }
        OrganTreeInitVo firstOrgan = new OrganTreeInitVo();
        firstOrgan.setId("11");
        firstOrgan.setLabel("\u7cfb\u7edf\u7528\u6237");
        firstOrgan.setParentId("0");
        firstOrgan.setStruLevel(0);
        firstOrgan.setChangedLevel(1);
        firstOrgan.setHasChildren(Boolean.valueOf(true));
        parentLevelOrganUsersList.add(firstOrgan);
        List<OrganTreeInitVo> users = this.queryUserManager.queryUpUsersByFidAndLevel("", defaultLevel);
        parentLevelOrganUsersList.addAll(users);
        Long parentOrganId = this.queryUserManager.getUserDepartmentId(userId);
        List<OrganTreeInitVo> brotherUsers = this.sysUsersMapper.queryBrotherUsersByParentId(parentOrganId);
        List<OrganTreeInitVo> brotherOrgans = this.sysStruMapper.queryBrotherOrganForUserTree(parentOrganId, false, true);
        brotherOrgans.addAll(brotherUsers);
        ArrayList<OrganTreeInitVo> organsAndUsers = new ArrayList<OrganTreeInitVo>();
        organsAndUsers.addAll(parentLevelOrganUsersList);
        organsAndUsers.addAll(brotherOrgans);
        return this.queryOrganizationManager.getOrganTree(organsAndUsers);
    }

    public ApiResponse<OrganTreeInitVo> getUserInfoByUserId(Long userId) {
        OrganTreeInitVo user = this.queryUserManager.getUserInfoByUserId(userId);
        return ApiResponse.success((Object)user);
    }

    public ApiResponse<List<OrganTreeInitVo>> getUsersByParentId(Long parentId) {
        String fid = "";
        if (!parentId.toString().equals("11")) {
            fid = this.sysStruMapper.getStruFidByOrganId(parentId);
        }
        List<OrganTreeInitVo> users = this.queryUserManager.getAllChildrenUsers(fid);
        return ApiResponse.success(users);
    }
}

