/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.permit.dto.CopyRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.RepeatPwdDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResetPwdDto;
import com.jxdinfo.hussar.authorization.permit.dto.SelfInfoDto;
import com.jxdinfo.hussar.authorization.permit.dto.UpdatePwdDto;
import com.jxdinfo.hussar.authorization.permit.dto.UserQueryReqDto;
import com.jxdinfo.hussar.authorization.permit.model.SysGetBackPassword;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserDataScopeService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.DataScopeVo;
import com.jxdinfo.hussar.authorization.permit.vo.PrincipalVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysUsersVo;
import com.jxdinfo.hussar.authorization.permit.vo.UpdateInfoVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrgVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.support.security.core.annotation.CheckSafe;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7528\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/userFront"})
public class SysUsersFrontController
extends HussarBaseController<SysUsers, ISysUsersService> {
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private ISysUserDataScopeService sysUserDataScopeService;
    @Resource
    private SysOrgManageService orgMaintenanceService;

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u662f\u5426\u662f\u5206\u7ea7\u7ba1\u7406\u5458", notes="\u5f53\u524d\u7528\u6237\u662f\u5426\u662f\u5206\u7ea7\u7ba1\u7406\u5458")
    @GetMapping(value={"/gradeRole"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u662f\u5426\u662f\u5206\u7ea7\u7ba1\u7406\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> gradeRole() {
        return ApiResponse.success((Object)BaseSecurityUtil.getUser().isGradeadmin());
    }

    @ApiOperation(value="\u52a0\u8f7d\u7ec4\u7ec7\u673a\u6784\u7528\u6237\u6811", notes="\u52a0\u8f7d\u7ec4\u7ec7\u673a\u6784\u7528\u6237\u6811")
    @CheckPermission(value={"userFront:userTree"})
    @GetMapping(value={"/userTree"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u52a0\u8f7d\u7ec4\u7ec7\u673a\u6784\u7528\u6237\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> userTree(@ApiParam(value="\u662f\u5426\u4e3a\u5bfc\u51fa\u6811") @RequestParam(value="isExport", required=false) String isExport, @ApiParam(value="\u4e0a\u7ea7\u8282\u70b9id") @RequestParam(value="parentId", required=false) Long parentId) {
        return ApiResponse.success((Object)this.iSysUsersService.getUserTreeVue(isExport, parentId));
    }

    @ApiOperation(value="\u590d\u5236\u6811", notes="\u590d\u5236\u6811")
    @GetMapping(value={"/copyTree"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u590d\u5236\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> copyTree(@ApiParam(value="\u662f\u5426\u4e3a\u5bfc\u51fa\u6811") @RequestParam(value="isExport", required=false) String isExport, @ApiParam(value="\u4e0a\u7ea7\u8282\u70b9id") @RequestParam(value="parentId", required=false) Long parentId) {
        return ApiResponse.success((Object)this.iSysUsersService.getUserTreeVueForCopy(isExport, parentId));
    }

    @ApiOperation(value="\u7ea7\u8054\u83b7\u53d6\u7528\u6237\u90e8\u95e8", notes="\u7ea7\u8054\u83b7\u53d6\u7528\u6237\u90e8\u95e8")
    @CheckPermission(value={"userFront:userTree"})
    @GetMapping(value={"/userDepTree"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u7ea7\u8054\u83b7\u53d6\u7528\u6237\u90e8\u95e8", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> userDepTree(@ApiParam(value="\u4e0a\u7ea7\u8282\u70b9id") @RequestParam Long parentId, @ApiParam(value="\u6811\u7c7b\u578b") @RequestParam String reqModule) {
        return ApiResponse.success((Object)this.iSysUsersService.getUserDepTreeVue(parentId, reqModule));
    }

    @ApiOperation(value="\u67e5\u8be2\u7cfb\u7edf\u7528\u6237\u8868\u7684\u6570\u636e", notes="\u67e5\u8be2\u7cfb\u7edf\u7528\u6237\u8868\u7684\u6570\u636e")
    @CheckPermission(value={"userFront:userInfo"})
    @GetMapping(value={"/sysUserList"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u7cfb\u7edf\u7528\u6237\u67e5\u8be2\u7cfb\u7edf\u7528\u6237\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<UserOrgVo>> systemUserInfoList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<UserOrgVo> page, @ApiParam(value="\u67e5\u8be2\u7528\u6237dto") UserQueryReqDto userQueryReqDto) {
        userQueryReqDto.setUserName(userQueryReqDto.getUserName().replace("%", "\\%").replace("_", "\\_"));
        userQueryReqDto.setUserAccount(userQueryReqDto.getUserAccount().replace("%", "\\%").replace("_", "\\_"));
        return ApiResponse.success((Object)this.iSysUsersService.searchUsers(page, userQueryReqDto));
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u6570\u636e", notes="\u67e5\u8be2\u7528\u6237\u6570\u636e")
    @CheckPermission(value={"userFront:searchUsers"})
    @GetMapping(value={"/searchUsers"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u7cfb\u7edf\u7528\u6237\u67e5\u8be2\u7cfb\u7edf\u7528\u6237\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<UserOrgVo>> searchUsers(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<UserOrgVo> page, @ApiParam(value="\u67e5\u8be2\u7528\u6237dto") UserQueryReqDto userQueryReqDto) {
        userQueryReqDto.setUserName(userQueryReqDto.getUserName().replace("%", "\\%").replace("_", "\\_"));
        userQueryReqDto.setUserAccount(userQueryReqDto.getUserAccount().replace("%", "\\%").replace("_", "\\_"));
        return ApiResponse.success((Object)this.iSysUsersService.searchUsers(page, userQueryReqDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u90e8\u95e8\u4e0b\u7684\u6240\u6709\u7528\u6237\u4fe1\u606f", notes="\u83b7\u53d6\u5f53\u524d\u90e8\u95e8\u4e0b\u7684\u6240\u6709\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/userInfoList"})
    @CheckPermission(value={"userFront:userInfo"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5f53\u524d\u90e8\u95e8\u4e0b\u7684\u6240\u6709\u7528\u6237\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<UserOrgVo>> userInfoList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<UserOrgVo> page, @ApiParam(value="\u67e5\u8be2\u7528\u6237dto") UserQueryReqDto userQueryReqDto) {
        userQueryReqDto.setUserAccount(userQueryReqDto.getUserAccount().replace("%", "\\%").replace("_", "\\_"));
        userQueryReqDto.setUserName(userQueryReqDto.getUserName().replace("%", "\\%").replace("_", "\\_"));
        return ApiResponse.success((Object)this.iSysUsersService.searchUsers(page, userQueryReqDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u7684\u8d26\u6237\u5217\u8868", notes="\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u7684\u8d26\u6237\u5217\u8868")
    @GetMapping(value={"/accountList"})
    @CheckPermission(value={"userFront:accountList"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u673a\u6784\u7684\u8d26\u6237\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<UserOrgVo>> accountList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<UserOrgVo> page, @ApiParam(value="\u67e5\u8be2\u7528\u6237dto") UserQueryReqDto userQueryReqDto) {
        return ApiResponse.success((Object)this.iSysUsersService.getAccountList(userQueryReqDto, page));
    }

    @ApiOperation(value="\u52a0\u8f7d\u7528\u6237\u6392\u5e8f\u6811", notes="\u52a0\u8f7d\u7528\u6237\u6392\u5e8f\u6811")
    @CheckPermission(value={"userFront:orderTree"})
    @GetMapping(value={"/orderTree"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u52a0\u8f7d\u6392\u5e8f\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> orderTree(@ApiParam(value="\u4e0a\u7ea7\u8282\u70b9id") @RequestParam String orgId) {
        return ApiResponse.success((Object)this.sysOrgManageService.getUserOrderTree(orgId));
    }

    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u6392\u5e8f", notes="\u4fdd\u5b58\u7528\u6237\u6392\u5e8f")
    @CheckPermission(value={"userFront:saveUserOrder"})
    @PostMapping(value={"/saveUserOrder"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u7528\u6237\u6392\u5e8f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse saveUserOrder(@ApiParam(value="\u4e0b\u7ea7\u7528\u6237id\u96c6\u5408") @RequestBody List<Long> idList) {
        return this.iSysUsersService.saveUserOrder(idList);
    }

    @ApiOperation(value="\u65b0\u589e\u7528\u6237", notes="\u65b0\u589e\u7528\u6237")
    @CheckPermission(value={"userFront:add"})
    @PostMapping(value={"/add"})
    @CacheEvict(value={"user_ip"}, allEntries=true)
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u7528\u6237\u65b0\u589e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse addUser(@ApiParam(value="\u7528\u6237vo") @RequestBody SysUsersVo sysUsersVo) {
        return this.iSysUsersService.saveUser(sysUsersVo);
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237", notes="\u4fee\u6539\u7528\u6237")
    @CheckPermission(value={"userFront:edit"})
    @PostMapping(value={"/edit"})
    @CacheEvict(value={"authorization_info", "menu_info", "resource_info"}, allEntries=true)
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u7528\u6237\u4fee\u6539", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse editUser(@ApiParam(value="\u7528\u6237vo") @RequestBody SysUsersVo sysUsersVo) {
        return this.iSysUsersService.updateUser(sysUsersVo);
    }

    @ApiOperation(value="\u4f11\u7720\u7528\u6237", notes="\u4f11\u7720\u7528\u6237")
    @CheckPermission(value={"userFront:dormancy"})
    @GetMapping(value={"/dormancy"})
    @CacheEvict(value={"authorization_info", "menu_info"}, allEntries=true)
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u4f11\u7720\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse dormancyUser(@ApiParam(value="\u7528\u6237id") @RequestParam Long userId) {
        return this.iSysUsersService.dormancyUser(userId);
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u7684\u4fe1\u606f", notes="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u7684\u4fe1\u606f")
    @GetMapping(value={"/userInfo"})
    @CheckPermission(value={"userFront:userInfo"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u7684\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<ArrayList<Object>> userInfo(@ApiParam(value="\u7528\u6237id") @RequestParam Long id) {
        return ApiResponse.success((Object)this.iSysUsersService.getUserInfo(id));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u4fe1\u606f", notes="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u4fe1\u606f")
    @GetMapping(value={"/currentUserInfo"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<ArrayList<Object>> currentUserInfo() {
        Long userId = BaseSecurityUtil.getUser().getId();
        return ApiResponse.success((Object)this.iSysUsersService.getUserInfo(userId));
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237", notes="\u5220\u9664\u7528\u6237")
    @CheckPermission(value={"userFront:delete"})
    @PostMapping(value={"/delete"})
    @CheckSafe
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u7528\u6237\u5220\u9664", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse delUser(@ApiParam(value="\u7528\u6237id") @RequestBody Long userId) {
        return this.iSysUsersService.deleteUser(userId);
    }

    @ApiOperation(value="\u6ce8\u9500\u7528\u6237", notes="\u6ce8\u9500\u7528\u6237")
    @CheckPermission(value={"userFront:cancelUser"})
    @PostMapping(value={"/cancelUser"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u7528\u6237\u6ce8\u9500", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse cancelUser(@ApiParam(value="\u7528\u6237id") @RequestBody Long userId) {
        return this.iSysUsersService.cancelUser(userId);
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801", notes="\u6ce8\u9500\u7528\u6237")
    @PostMapping(value={"/updatePwd"})
    @CheckPermission(value={"userFront:updatePwd"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u7528\u6237\u4fee\u6539\u5bc6\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<UpdateInfoVo> updatePwd(@ApiParam(value="\u4fee\u6539\u5bc6\u7801dto") @RequestBody UpdatePwdDto updatePwdDto) {
        return this.iSysUsersService.updatePassword(updatePwdDto);
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u5bc6\u7801", notes="\u6ce8\u9500\u7528\u6237")
    @PostMapping(value={"/resetAllPwd"})
    @CheckPermission(value={"userFront:resetAllPwd"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u91cd\u7f6e\u6240\u6709\u7528\u6237\u5bc6\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.RESET_PASS)
    public ApiResponse<UpdateInfoVo> resetAllPwd(@ApiParam(value="\u4fee\u6539\u5bc6\u7801dto") @RequestBody ResetPwdDto resetPwdDto) {
        return this.iSysUsersService.updatePasswordToReset(resetPwdDto);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u627e\u56de\u5bc6\u7801\u95ee\u9898\u548c\u7b54\u6848", notes="\u8bbe\u7f6e\u627e\u56de\u5bc6\u7801\u95ee\u9898\u548c\u7b54\u6848")
    @PostMapping(value={"/setGetBackPwd"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u8bbe\u7f6e\u627e\u56de\u5bc6\u7801\u95ee\u9898\u548c\u7b54\u6848", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse setGetBackPwd(@ApiParam(value="\u5bc6\u4fdd\u4fe1\u606f\u5b9e\u4f53") @RequestBody SysGetBackPassword sysGetBackPassword) {
        return this.iSysUsersService.saveGetBackPwd(sysGetBackPassword);
    }

    @ApiOperation(value="\u590d\u5236\u89d2\u8272", notes="\u590d\u5236\u89d2\u8272")
    @CheckPermission(value={"userFront:copyRole"})
    @PostMapping(value={"/copyRole"})
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u590d\u5236\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse copyRole(@ApiParam(value="\u590d\u5236\u89d2\u8272dto") @RequestBody CopyRoleDto copyRoleDto) {
        return this.iSysUsersService.saveCopyRole(copyRoleDto.getCopyFrom(), copyRoleDto.getCopyTos());
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u8868\u683c\u6570\u636e", notes="\u83b7\u53d6\u7528\u6237\u8868\u683c\u6570\u636e")
    @GetMapping(value={"/userList"})
    @CheckPermission(value={"userFront:userList"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u83b7\u53d6\u7528\u6237\u8868\u683c\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<SysUsers>> userTableList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<SysUsers> page, @ApiParam(value="\u7528\u6237\u4fe1\u606f") SysUsers sysUsers) {
        return ApiResponse.success((Object)this.iSysUsersService.getUserList(page, sysUsers));
    }

    @ApiOperation(value="\u4e2a\u4eba\u4fe1\u606f\u4fee\u6539\u4fdd\u5b58", notes="\u4e2a\u4eba\u4fe1\u606f\u4fee\u6539\u4fdd\u5b58")
    @PostMapping(value={"/saveSelfInfo"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u4e2a\u4eba\u4fe1\u606f\u4fee\u6539\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse saveSelfInfo(@ApiParam(value="\u4e2a\u4eba\u4fe1\u606fdto") @RequestBody SelfInfoDto selfInfoDto) {
        return this.iSysUsersService.updateSelfInfo(selfInfoDto);
    }

    @ApiOperation(value="\u7528\u6237\u6570\u636e\u5bfc\u51fa", notes="\u7528\u6237\u6570\u636e\u5bfc\u51fa")
    @PostMapping(value={"/exportData"})
    @CheckPermission(value={"userFront:exportData"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u7528\u6237\u6570\u636e\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportData(@ApiParam(value="\u7528\u6237ids") @RequestBody String ids, HttpServletResponse response) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.iSysUsersService.exportData(idList, response);
    }

    @ApiOperation(value="\u7528\u6237\u6570\u636e\u5bfc\u5165", notes="\u7528\u6237\u6570\u636e\u5bfc\u5165")
    @PostMapping(path={"/importData"})
    @CheckPermission(value={"userFront:importData"})
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u7528\u6237\u6570\u636e\u5bfc\u5165", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<Object> importData(@ApiParam(value="\u7528\u6237\u6570\u636e\u6587\u4ef6") @RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        return ApiResponse.success((Object)this.iSysUsersService.importVueData(content));
    }

    @ApiOperation(value="\u9a8c\u8bc1\u4e8c\u6b21\u9a8c\u8bc1\u7684\u5bc6\u7801\u662f\u5426\u6b63\u786e", notes="\u9a8c\u8bc1\u4e8c\u6b21\u9a8c\u8bc1\u7684\u5bc6\u7801\u662f\u5426\u6b63\u786e")
    @PostMapping(value={"/reChecking"})
    @Inner
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u9a8c\u8bc1\u4e8c\u6b21\u9a8c\u8bc1\u7684\u5bc6\u7801\u662f\u5426\u6b63\u786e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> reChecking(@ApiParam(value="\u4e8c\u6b21\u6821\u9a8c\u5bc6\u7801dto") @RequestBody RepeatPwdDto repeatPwdDto) {
        return ApiResponse.success((Object)this.iSysUsersService.reChecking(repeatPwdDto));
    }

    @ApiOperation(value="\u6fc0\u6d3b\u7528\u6237\u8d26\u53f7", notes="\u6fc0\u6d3b\u7528\u6237\u8d26\u53f7")
    @GetMapping(value={"/unlockUser"})
    @CheckPermission(value={"userFront:unlockUser"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u7528\u6237\u5217\u8868\u6fc0\u6d3b\u7528\u6237\u8d26\u53f7", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse unlockUser(@ApiParam(value="\u7528\u6237id") @RequestParam Long userId) {
        return this.iSysUsersService.updateLockAccountStatus(userId);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6570\u636e\u6743\u9650", notes="\u83b7\u53d6\u7528\u6237\u6570\u636e\u6743\u9650")
    @GetMapping(value={"/dataScope"})
    @CheckPermission(value={"userFront:dataScope"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u83b7\u53d6\u7528\u6237\u6570\u636e\u6743\u9650", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<DataScopeVo> getUserDataScope(@ApiParam(value="\u7528\u6237id") @RequestParam String userId) {
        return ApiResponse.success((Object)this.sysUserDataScopeService.queryUserDataScope(userId));
    }

    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u6570\u636e\u6743\u9650", notes="\u4fdd\u5b58\u7528\u6237\u6570\u636e\u6743\u9650")
    @PostMapping(value={"/saveDataScope"})
    @CheckPermission(value={"userFront:saveDataScope"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u7528\u6237\u6570\u636e\u6743\u9650", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse saveDataScope(@ApiParam(value="\u7528\u6237\u6570\u636e\u6743\u9650vo") @RequestBody DataScopeVo dataScopeVo) {
        return this.sysUserDataScopeService.saveDataScope(dataScopeVo);
    }

    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u8d1f\u8d23\u4eba\u5217\u8868", notes="\u6a21\u7cca\u67e5\u8be2\u8d1f\u8d23\u4eba\u5217\u8868")
    @GetMapping(value={"/searchPrincipal"})
    public ApiResponse<Page<PrincipalVo>> searchPrincipal(@RequestParam(value="current", required=false) Long current, @RequestParam(value="size", required=false) Long size, String name) {
        return this.iSysUsersService.searchPrincipal(current, size, name);
    }

    @ApiOperation(value="\u70b9\u51fb\u8d1f\u8d23\u4eba\u8fd4\u56de\u7ec4\u7ec7\u673a\u6784\u7528\u6237\u6811", notes="\u70b9\u51fb\u8d1f\u8d23\u4eba\u8fd4\u56de\u7ec4\u7ec7\u673a\u6784\u7528\u6237\u6811")
    @GetMapping(value={"/userTreeByPrincipal"})
    @AuditLog(moduleName="\u7528\u6237\u7ef4\u62a4\u7ba1\u7406", eventDesc="\u70b9\u51fb\u8d1f\u8d23\u4eba\u8fd4\u56de\u7ec4\u7ec7\u673a\u6784\u7528\u6237\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> userTreeByPrincipal(@RequestParam(value="userId") Long userId) {
        return ApiResponse.success((Object)this.iSysUsersService.getUserTreeByPrincipal(userId));
    }
}

