/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.DataRightCacheVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datascope.core.enums.DataScopeEnum;
import com.jxdinfo.hussar.support.datascope.core.support.model.DataScopeInfo;
import com.jxdinfo.hussar.support.datascope.core.support.service.base.DataScopeService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.dataRightScoptServiceImpl")
public class DataScoptServiceImpl
implements DataScopeService {
    @Resource
    @Lazy
    private SysStruMapper sysStruMapper;
    @Resource
    @Lazy
    private ISysStruAssistOrganService assistOrganService;
    @Resource
    @Lazy
    private ISysUsersService usersService;

    @HussarDs
    public DataScopeInfo getDataScope(Long userId, String mapper, String serverName) {
        SecurityUser shirouser = BaseSecurityUtil.getUser();
        assert (shirouser != null);
        List roleIdList = shirouser.getRolesList();
        List<Object> dataRightCacheVoList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)roleIdList)) {
            for (Long roleId : roleIdList) {
                List cacheList = (List)HussarCacheUtil.get((String)"data_scope_type", (Object)("'data_scope_type:'" + roleId));
                if (!HussarUtils.isNotEmpty((Object)cacheList)) continue;
                dataRightCacheVoList.addAll(cacheList);
            }
            if (HussarUtils.isNotBlank((CharSequence)serverName)) {
                dataRightCacheVoList = dataRightCacheVoList.stream().filter(item -> item.getServerName().equals(serverName)).collect(Collectors.toList());
            }
        }
        if (HussarUtils.isEmpty(dataRightCacheVoList)) {
            return null;
        }
        List<Long> deptIdList = new ArrayList<Long>();
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        ArrayList<Long> companyFidList = new ArrayList<Long>();
        String deptRight = null;
        String userRight = null;
        String companyRight = null;
        ArrayList customdeptIdList = new ArrayList();
        ArrayList customCompanyFidList = new ArrayList();
        for (DataRightCacheVo dataRightCacheVo : dataRightCacheVoList) {
            if (!mapper.equals(dataRightCacheVo.getMapper())) continue;
            deptRight = dataRightCacheVo.getDeptRight();
            userRight = dataRightCacheVo.getUserRight();
            companyRight = dataRightCacheVo.getCompanyRight();
            typeList.add(dataRightCacheVo.getType());
            if (!ToolUtil.isNotEmpty((Object)dataRightCacheVo.getDeptId())) continue;
            if (Integer.parseInt("7") == dataRightCacheVo.getType()) {
                customdeptIdList.addAll(dataRightCacheVo.getDeptId());
                continue;
            }
            customCompanyFidList.addAll(dataRightCacheVo.getDeptId());
        }
        if (typeList.size() == 0) {
            return null;
        }
        SysUsers user = this.usersService.getUser(shirouser.getId());
        int n = (Integer)Collections.min(typeList);
        if (n == DataScopeEnum.OWN_DEPT_CHILD.getType()) {
            deptIdList.addAll(this.getDeptIds(user, true));
        } else if (n == DataScopeEnum.OWN_DEPT.getType()) {
            deptIdList.addAll(this.getDeptIds(user, false));
        } else if (n == DataScopeEnum.CUSTOM.getType()) {
            deptIdList.addAll(customdeptIdList);
        } else if (n == DataScopeEnum.OWN_COMPANY.getType()) {
            companyFidList.add((Long)shirouser.getExtendUserMap("companyId"));
        } else if (n == DataScopeEnum.CUSTOM_COMPANY.getType()) {
            companyFidList.addAll(customCompanyFidList);
        }
        DataScopeInfo dataRightScopeVo = new DataScopeInfo();
        deptIdList = deptIdList.stream().distinct().collect(Collectors.toList());
        dataRightScopeVo.setUserScopeField(userRight);
        dataRightScopeVo.setDeptScopeField(deptRight);
        dataRightScopeVo.setScopeTypes(typeList);
        dataRightScopeVo.setScopeDeptIds(deptIdList);
        dataRightScopeVo.setCompanyScopeField(companyRight);
        dataRightScopeVo.setScopeCompanyIds(companyFidList);
        return dataRightScopeVo;
    }

    public List<Long> getChildrenStruByUserId(Long userId) {
        return this.sysStruMapper.getChildrenStruByUserId(userId);
    }

    public List<Long> getDeptIds(Integer type, Long userid) {
        SysUsers user = this.usersService.getUser(userid);
        if (type == Integer.parseInt("3")) {
            return this.getDeptIds(user, true);
        }
        if (type == Integer.parseInt("4")) {
            return this.getDeptIds(user, false);
        }
        throw new BaseException("\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u53ef\u89c1\u8303\u56f4");
    }

    private List<Long> getDeptIds(SysUsers sysUsers, boolean hasChildren) {
        ArrayList<Long> deptIdList = new ArrayList<Long>();
        deptIdList.add(sysUsers.getDepartmentId());
        deptIdList.addAll(this.getAssitStru(sysUsers.getEmployeeId()));
        if (hasChildren) {
            deptIdList.addAll(this.getChildren(deptIdList));
        }
        return deptIdList;
    }

    private List<Long> getAssitStru(Long struId) {
        List list = this.assistOrganService.list((Wrapper)new LambdaQueryWrapper(SysStruAssistOrgan.class).eq(SysStruAssistOrgan::getStruId, (Object)struId));
        return list.stream().map(SysStruAssistOrgan::getAssistParentId).collect(Collectors.toList());
    }

    private List<Long> getChildren(List<Long> struIds) {
        if (HussarUtils.isEmpty(struIds)) {
            return new ArrayList<Long>();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper(SysStru.class);
        List sysStrus = this.sysStruMapper.selectList((Wrapper)wrapper.in(SysStru::getId, struIds));
        wrapper.clear();
        sysStrus.forEach(stru -> ((LambdaQueryWrapper)wrapper.or()).likeRight(SysStru::getStruFid, (Object)stru.getStruFid()));
        List children = this.sysStruMapper.selectList((Wrapper)wrapper);
        return children.stream().map(SysStru::getId).collect(Collectors.toList());
    }

    private List<String> getCompanyFids(List<Long> companyIds) {
        List strus = this.sysStruMapper.selectBatchIds(companyIds);
        return strus.stream().map(SysStru::getStruFid).collect(Collectors.toList());
    }

    private List<String> getDeptFids(List<Long> companyIds) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.in(SysStru::getParentId, companyIds)).ne(SysStru::getStruType, (Object)"1");
        List strus = this.sysStruMapper.selectList((Wrapper)lambdaQueryWrapper);
        return strus.stream().map(SysStru::getStruFid).collect(Collectors.toList());
    }

    private List<String> findStruFids(Long parentId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(SysStru::getParentId, (Object)parentId)).ne(SysStru::getStruType, (Object)"1");
        List strus = this.sysStruMapper.selectList((Wrapper)lambdaQueryWrapper);
        return strus.stream().map(SysStru::getStruFid).collect(Collectors.toList());
    }
}

