/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.manager.EditBatchOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.editBatchOutsideOrganizationManagerImpl")
public class EditBatchOutsideOrganizationManagerImpl
extends CommonOutsideOrganizationManager
implements EditBatchOutsideOrganizationManager {
    @Override
    public R<EditOutsideOrganizationDto> editBatchOrganizations(List<EditOutsideOrganizationDto> organs) {
        boolean canEdit = false;
        if (HussarUtils.isNotEmpty(organs) && organs.size() <= 50) {
            canEdit = true;
        }
        if (!canEdit) {
            throw new BaseException("\u6279\u91cf\u64cd\u4f5c\u6700\u591a\u53ea\u5141\u8bb8\u4e00\u6b21\u64cd\u4f5c50");
        }
        R result = new R();
        List errors = OrganUtil.validateMany(organs);
        for (EditOutsideOrganizationDto dto : organs) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.ne(SysOrgan::getOrganType, (Object)"9");
            lambdaQueryWrapper.eq(SysOrgan::getOrganCode, (Object)dto.getOrganCode().trim());
            boolean flag = this.organService.count((Wrapper)lambdaQueryWrapper) > 0L;
            if (flag) continue;
            OrganUtil.addErrorMsg((List)errors, (Object)dto, (String)"organCode", (String[])new String[]{"\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u4e0d\u5b58\u5728"});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
            LinkedHashSet<SysStru> sysStruCollection = new LinkedHashSet<SysStru>();
            LinkedHashSet<SysOrgan> sysOrganCollection = new LinkedHashSet<SysOrgan>();
            LinkedHashSet<SysOffice> sysOfficeCollection = new LinkedHashSet<SysOffice>();
            for (EditOutsideOrganizationDto dto : organs) {
                SysOrgan sysOrgan = this.findSysOrgan(dto.getOrganCode().trim(), sysOrganCollection);
                SysStru sysStru = this.findSysStru(sysOrgan, sysStruCollection);
                SysOffice sysOffice = this.findSysOffice(sysStru, sysOfficeCollection);
                this.initializationEdit(sysStruCollection, sysOrganCollection, sysOfficeCollection, dto, sysStru, sysOrgan, sysOffice);
                sysStruCollection.add(sysStru);
                sysOrganCollection.add(sysOrgan);
                sysOfficeCollection.add(sysOffice);
                dataMappings.add(new DataMapping(sysStru.getId(), sysOrgan.getOrganCode()));
            }
            result.setSuccessList(dataMappings);
            this.organService.updateBatchById(sysOrganCollection);
            this.sysOfficeService.updateBatchById(sysOfficeCollection);
            this.struService.updateBatchById(sysStruCollection);
        }
        return result;
    }

    public Set<SysOrgan> searchOrgans(SysOrgan sysOrgan, Set<SysOrgan> sysOrganCollection) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.likeRight(SysOrgan::getOrganFcode, (Object)sysOrgan.getOrganFcode());
        wrapper.ne(SysOrgan::getId, (Object)sysOrgan.getId());
        wrapper.orderByAsc(SysOrgan::getOrganFcode);
        List sysOrgans = this.organService.list((Wrapper)wrapper);
        LinkedHashSet<SysOrgan> update = new LinkedHashSet<SysOrgan>();
        if (HussarUtils.isNotEmpty(sysOrganCollection)) {
            for (SysOrgan temp : sysOrganCollection) {
                if (!temp.getOrganFcode().startsWith(sysOrgan.getOrganFcode()) || sysOrgan.getOrganCode().equals(temp.getOrganCode())) continue;
                update.add(temp);
            }
        }
        if (HussarUtils.isNotEmpty(update) && HussarUtils.isNotEmpty((Object)sysOrgans)) {
            Map organMap = update.stream().collect(Collectors.toMap(item -> item.getOrganCode(), Function.identity()));
            for (SysOrgan temp : sysOrgans) {
                SysOrgan find = (SysOrgan)organMap.get(temp.getOrganCode());
                if (find == null) continue;
                BeanUtils.copyProperties((Object)find, (Object)temp);
            }
        }
        update.addAll(sysOrgans);
        return update;
    }

    protected void initializationEdit(Set<SysStru> sysStruCollection, Set<SysOrgan> sysOrganCollection, Set<SysOffice> sysOfficeCollection, EditOutsideOrganizationDto editOrganizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        String organName = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganName());
        String organAlias = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganAlias());
        String userAccount = StringUtils.trimToEmpty((String)editOrganizationDto.getUserAccount());
        String organShortName = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganShortName());
        String organDescription = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganDescription());
        String organAddress = editOrganizationDto.getOrganAddress();
        String currentFname = sysOrgan.getOrganFname();
        String newFname = currentFname.substring(0, currentFname.lastIndexOf("/")) + "/" + editOrganizationDto.getOrganName().trim();
        if (!Objects.equals(editOrganizationDto.getOrganName().trim(), sysOrgan.getOrganName())) {
            Set<SysOrgan> sysOrgans = this.searchOrgans(sysOrgan, sysOrganCollection);
            for (SysOrgan temp : sysOrgans) {
                temp.setOrganFname(temp.getOrganFname().replaceFirst(currentFname, newFname));
                sysOrganCollection.add(temp);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)organAlias)) {
            sysStru.setOrganAlias(organAlias);
        }
        if (StringUtils.isNotBlank((CharSequence)userAccount)) {
            Long userId = this.getUserId(userAccount);
            sysStru.setPrincipalId(userId);
        }
        if (StringUtils.isNotBlank((CharSequence)organName)) {
            sysOrgan.setOrganName(organName);
        }
        sysOrgan.setOrganFname(sysOrgan.getOrganFname().replaceFirst(currentFname, newFname));
        if (StringUtils.isNotBlank((CharSequence)organShortName)) {
            sysOrgan.setShortName(organShortName);
        }
        if (StringUtils.isNotBlank((CharSequence)organAddress)) {
            sysOffice.setOfficeAddress(organAddress);
        }
        if (StringUtils.isNotBlank((CharSequence)organDescription)) {
            sysOffice.setOfficeAlias(organDescription);
        }
        sysOrganCollection.add(sysOrgan);
        sysStruCollection.add(sysStru);
        sysOfficeCollection.add(sysOffice);
    }

    public SysOrgan findSysOrgan(String organCode, Set<SysOrgan> sysOrganCollection) {
        Optional<SysOrgan> find;
        if (HussarUtils.isNotEmpty(sysOrganCollection) && (find = sysOrganCollection.stream().filter(item -> item.getOrganCode().equals(organCode)).findFirst()).isPresent()) {
            return find.get();
        }
        SysOrgan sysOrgan = (SysOrgan)this.organService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysOrgan::getOrganCode, (Object)StringUtils.trimToEmpty((String)organCode))).ne(SysOrgan::getOrganType, (Object)"9"));
        return sysOrgan;
    }

    private SysStru findSysStru(SysOrgan sysOrgan, Set<SysStru> sysStruCollection) {
        Optional<SysStru> find;
        Long organId = sysOrgan.getId();
        if (HussarUtils.isNotEmpty(sysStruCollection) && (find = sysStruCollection.stream().filter(item -> Objects.equals(item.getOrganId(), organId)).findFirst()).isPresent()) {
            return find.get();
        }
        return (SysStru)this.struService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOrganId, (Object)organId));
    }

    private SysOffice findSysOffice(SysStru sysStru, Set<SysOffice> sysOfficeCollection) {
        Optional<SysOffice> find;
        Long struId = sysStru.getId();
        if (HussarUtils.isNotEmpty(sysOfficeCollection) && (find = sysOfficeCollection.stream().filter(item -> Objects.equals(item.getStruId(), struId)).findFirst()).isPresent()) {
            return find.get();
        }
        return (SysOffice)this.sysOfficeService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOffice::getStruId, (Object)struId));
    }
}

