/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.audit.dao.SysOrganAuditMapper;
import com.jxdinfo.hussar.authorization.audit.dao.SysStaffAuditMapper;
import com.jxdinfo.hussar.authorization.audit.dao.SysStruAssistOrganAuditMapper;
import com.jxdinfo.hussar.authorization.audit.dao.SysStruAuditMapper;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.organ.vo.AssistPost;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryAuditStaffDto;
import com.jxdinfo.hussar.authorization.permit.manager.QueryAuditStaffManager;
import com.jxdinfo.hussar.authorization.permit.vo.AuditStaffData;
import com.jxdinfo.hussar.authorization.permit.vo.AuditStaffDetailVo;
import com.jxdinfo.hussar.authorization.permit.vo.AuditStaffListVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.queryAuditStaffManagerImpl")
public class QueryAuditStaffManagerImpl
implements QueryAuditStaffManager {
    @Resource
    private SysStruAuditMapper sysStruAuditMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysOrganAuditMapper sysOrganAuditMapper;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysStaffAuditMapper sysStaffAuditMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private SysStruAssistOrganAuditMapper sysStruAssistOrganAuditMapper;
    @Resource
    private SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Autowired
    private ISysDicRefService dicRefService;

    @Override
    public Page<AuditStaffListVo> queryStaffAudit(PageInfo pageInfo, QueryAuditStaffDto queryAuditStaffDto) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("staffName", StringUtils.trimToEmpty((String)queryAuditStaffDto.getStaffName()));
        queryParams.put("type", queryAuditStaffDto.getState());
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        List<AuditStaffListVo> auditStaffVos = this.sysStaffAuditMapper.queryStaffAuditList((Page<AuditStaffListVo>)page, queryParams);
        if (HussarUtils.isNotEmpty(auditStaffVos)) {
            for (AuditStaffListVo vo : auditStaffVos) {
                vo.setParentName(OrganUtil.getParentName((String)vo.getParentName()));
            }
        }
        page.setRecords(auditStaffVos);
        return page;
    }

    public AuditStaffData getStaffDataById(Long id) {
        AuditStaffData data = new AuditStaffData();
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysStru, (String)"\u672a\u67e5\u8be2\u5230\u4eba\u5458\u4fe1\u606f");
        SysOrgan sysOrgan = (SysOrgan)this.sysOrganMapper.selectById(sysStru.getOrganId());
        SysStaff sysStaff = (SysStaff)this.sysStaffMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getStruId, (Object)id));
        String staffPosition = sysStru.getStaffPosition();
        String staffPositionName = "";
        if (HussarUtils.isNotBlank((CharSequence)staffPosition)) {
            staffPositionName = this.dicRefService.getDictLabel("staff_position", staffPosition);
        }
        String sex = sysStaff.getSex();
        String sexName = "";
        if (HussarUtils.isNotBlank((CharSequence)sex)) {
            sexName = this.dicRefService.getDictLabel("sex", sex);
        }
        if (sysStaff != null) {
            data.setBirthday(sysStaff.getBirthday());
            data.setIdcard(sysStaff.getIdcard());
            data.setAddress(sysStaff.getAddress());
            data.setWorkId(sysStaff.getWorkId());
            data.setWorkDate(sysStaff.getWorkDate());
            data.setGraduateDate(sysStaff.getGraduateDate());
            data.setGraduateSchool(sysStaff.getGraduateSchool());
        }
        if (sysOrgan != null) {
            data.setParentName(OrganUtil.getShortParentName((String)sysOrgan.getOrganFname()));
            data.setStaffCode(sysOrgan.getOrganCode());
            data.setStaffName(sysOrgan.getOrganName());
            data.setBeginDate(sysOrgan.getBeginDate());
            data.setEndDate(sysOrgan.getEndDate());
        }
        data.setStaffPositionName(staffPositionName);
        data.setSexName(sexName);
        data.setAssistPosts(this.getAssistPosts(id));
        return data;
    }

    public AuditStaffData getAuditStaffDataById(Long id) {
        AuditStaffData data = new AuditStaffData();
        SysStruAudit sysStruAudit = (SysStruAudit)this.sysStruAuditMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysStruAudit, (String)"\u672a\u67e5\u8be2\u5230\u4eba\u5458\u5ba1\u6838\u4fe1\u606f");
        SysOrganAudit sysOrganAudit = (SysOrganAudit)this.sysOrganAuditMapper.selectById(sysStruAudit.getOrganId());
        SysStaffAudit sysStaffAudit = (SysStaffAudit)this.sysStaffAuditMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStaffAudit::getStruId, (Object)id));
        String staffPosition = sysStruAudit.getStaffPosition();
        String staffPositionName = "";
        if (HussarUtils.isNotBlank((CharSequence)staffPosition)) {
            staffPositionName = this.dicRefService.getDictLabel("staff_position", staffPosition);
        }
        if (sysStaffAudit != null) {
            String sex = sysStaffAudit.getSex();
            String sexName = "";
            if (HussarUtils.isNotBlank((CharSequence)sex)) {
                sexName = this.dicRefService.getDictLabel("sex", sex);
            }
            data.setSexName(sexName);
            data.setStaffName(sysStaffAudit.getName());
            data.setBirthday(sysStaffAudit.getBirthday());
            data.setIdcard(sysStaffAudit.getIdcard());
            data.setAddress(sysStaffAudit.getAddress());
            data.setWorkId(sysStaffAudit.getWorkId());
            data.setWorkDate(sysStaffAudit.getWorkDate());
            data.setGraduateDate(sysStaffAudit.getGraduateDate());
            data.setGraduateSchool(sysStaffAudit.getGraduateSchool());
        }
        if (sysOrganAudit != null) {
            data.setParentName(OrganUtil.getShortParentName((String)sysOrganAudit.getOrganFname()));
            data.setStaffCode(sysOrganAudit.getOrganCode());
            data.setBeginDate(sysOrganAudit.getBeginDate());
            data.setEndDate(sysOrganAudit.getEndDate());
        }
        data.setStaffPositionName(staffPositionName);
        data.setAssistPosts(this.getAuditAssistPosts(sysStruAudit.getRealStruId()));
        return data;
    }

    private List<AssistPost> getAuditAssistPosts(Long id) {
        List<AssistPost> collect = this.sysStruAssistOrganAuditMapper.getAssistPosts(id);
        ArrayList<AssistPost> posts = new ArrayList<AssistPost>();
        if (HussarUtils.isNotEmpty(collect)) {
            for (AssistPost ap : collect) {
                AssistPost temp = new AssistPost();
                temp.setAssistPostId(ap.getAssistPostId());
                temp.setAssistPostName(OrganUtil.getPostName((String)ap.getAssistPostName()));
                posts.add(temp);
            }
        }
        return posts;
    }

    private List<AssistPost> getAssistPosts(Long id) {
        List<AssistPost> collect = this.sysStruAssistOrganMapper.getAssistPosts(id);
        ArrayList<AssistPost> posts = new ArrayList<AssistPost>();
        if (HussarUtils.isNotEmpty(collect)) {
            for (AssistPost ap : collect) {
                AssistPost temp = new AssistPost();
                temp.setAssistPostId(ap.getAssistPostId());
                temp.setAssistPostName(OrganUtil.getPostName((String)ap.getAssistPostName()));
                posts.add(temp);
            }
        }
        return posts;
    }

    @Override
    public AuditStaffDetailVo viewStaffAudit(Long id) {
        AuditStaffDetailVo vo = new AuditStaffDetailVo();
        AuditStaffData newData = vo.getNewData();
        AuditStaffData oldData = vo.getOldData();
        SysStruAudit sysStruAudit = (SysStruAudit)this.sysStruAuditMapper.selectById(id);
        AssertUtil.isNotNull((Object)sysStruAudit, (String)"\u672a\u67e5\u8be2\u5230\u4eba\u5458\u5ba1\u6838\u4fe1\u606f");
        Long struId = sysStruAudit.getId();
        String type = sysStruAudit.getInUse();
        Long realStruId = sysStruAudit.getRealStruId();
        if ("1".equals(type)) {
            newData = this.getAuditStaffDataById(struId);
            vo.setNewData(newData);
        } else if ("2".equals(type)) {
            newData = this.getAuditStaffDataById(struId);
            oldData = this.getStaffDataById(realStruId);
        } else if ("3".equals(type)) {
            oldData = this.getStaffDataById(realStruId);
        } else if ("4".equals(type)) {
            oldData = this.getStaffDataById(realStruId);
            BeanUtils.copyProperties((Object)oldData, (Object)newData);
            Long parentId = sysStruAudit.getParentId();
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(parentId);
            AssertUtil.isNotNull((Object)struTemp, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7ed3\u6784\u4fe1\u606f");
            SysOrgan organTemp = (SysOrgan)this.sysOrganMapper.selectById(struTemp.getOrganId());
            AssertUtil.isNotNull((Object)organTemp, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
            newData.setParentName(organTemp.getOrganName());
        }
        vo.setOldData(oldData);
        vo.setNewData(newData);
        return vo;
    }
}

