/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.dto.AddStaffDto;
import com.jxdinfo.hussar.authorization.organ.dto.StruOrganRelationDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddStaffManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonStaffManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.CreateUserSendMailUtil;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.SysLoginUserService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.GeneratePassword;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.addStaffManagerImpl")
public class AddStaffManagerImpl
extends CommonStaffManager
implements AddStaffManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddStaffManagerImpl.class);
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private SysLoginUserService sysLoginUserService;
    @Autowired
    private ISysStruAssistOrganService sysStruAssistOrganService;
    @Autowired
    private ISysStruAuditService sysStruAuditService;

    @Override
    public ApiResponse<Long> addStaff(AddStaffDto addStaffDto) {
        String validateMsg = this.validateService.validate((Object)addStaffDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String staffCode = addStaffDto.getStaffCode();
        if (HussarUtils.isNotBlank((CharSequence)staffCode)) {
            boolean flag;
            boolean bl = flag = !staffCode.contains("/") && staffCode.length() < 33;
            if (!flag) {
                return ApiResponse.fail((String)"\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u5b57\u7b26/,\u4e14\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732");
            }
        }
        SysStru sysStru = new SysStru();
        SysStaff sysStaff = new SysStaff();
        SysOrgan sysOrgan = new SysOrgan();
        this.initialization(addStaffDto, sysStru, sysOrgan, sysStaff);
        this.parentOrganizationAuditDataExists(addStaffDto.getParentId());
        this.addOrganizationManager.wrapAddOrgan(sysStru, sysOrgan);
        String assistIds = addStaffDto.getAssistIds();
        boolean isUpper = false;
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue() && StringUtils.isNotBlank((CharSequence)sysOrgan.getOrganName()) && !ArrayUtils.contains((Object[])EXCLUDE_USER, (Object)sysOrgan.getOrganName())) {
            isUpper = true;
        }
        String result = this.processAuditIfNecessary(sysStru, sysOrgan, sysStaff, assistIds, isUpper);
        return ApiResponse.success((Object)sysStru.getId(), (String)result);
    }

    private String processAuditIfNecessary(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String assistIds, boolean isUpper) {
        LOGGER.info("\u5904\u7406\u4eba\u5458\u5ba1\u6838\u5982\u679c\u9700\u8981\u7684\u8bdd");
        if (this.createUserConfigService.isOperateStaffWithUser()) {
            return this.syncUser(sysStru, sysOrgan, sysStaff, assistIds, isUpper);
        }
        return this.doAddStaff(sysStru, sysOrgan, sysStaff, assistIds);
    }

    private String doAddAuditStaff(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String assistIds) {
        boolean canOperate = this.sysStruAuditService.checkCanOperate(sysStru.getParentId());
        if (!canOperate) {
            throw new BaseException("\u65b0\u5efa\u4eba\u5458\u6240\u5728\u7684\u7ec4\u7ec7\u673a\u6784\u5b58\u5728\u672a\u5ba1\u6838\u6570\u636e\uff01");
        }
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setIsLeaf("0");
        sysStru.setStruPath("");
        Integer struOrder = 1;
        Integer maxOrder = this.orgMaintenanceService.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            struOrder = maxOrder + 1;
        }
        sysStru.setStruOrder(struOrder);
        long sysOrganId = IdWorker.getId((Object)sysOrgan);
        sysOrgan.setId(Long.valueOf(sysOrganId));
        sysStru.setOrganId(sysOrgan.getId());
        long sysStruId = IdWorker.getId((Object)sysStru);
        sysStru.setId(Long.valueOf(sysStruId));
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            sysStaff.setStruId(sysStru.getId());
            sysStaff.setName(sysOrgan.getOrganName());
            long sysStaffId = IdWorker.getId((Object)sysStaff);
            sysStaff.setId(Long.valueOf(sysStaffId));
        }
        this.auditAdd(sysOrgan, sysStru, sysStaff, "1");
        this.sysStruAssistOrganAuditService.saveAssistOrganAudit(assistIds, sysStru.getId());
        return "\u65b0\u589e\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
    }

    private String doAddNoAuditStaff(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String assistIds) {
        Long sysStruId;
        boolean saveAssistOrgan;
        sysStru.setId(null);
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setIsLeaf("0");
        sysStru.setStruPath("");
        Integer struOrder = 1;
        Integer maxOrder = this.orgMaintenanceService.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            struOrder = maxOrder + 1;
        }
        sysStru.setStruOrder(struOrder);
        this.sysOrganMapper.insert(sysOrgan);
        sysStru.setOrganId(sysOrgan.getId());
        this.sysStruMapper.insert(sysStru);
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            sysStaff.setStruId(sysStru.getId());
            sysStaff.setName(sysOrgan.getOrganName());
            this.sysStaffMapper.insert(sysStaff);
        }
        if (!(saveAssistOrgan = this.sysStruAssistOrganService.saveAssistOrgan(assistIds, sysStruId = sysStru.getId()))) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return "\u65b0\u589e\u6210\u529f\uff01";
    }

    private String doAddStaff(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String assistIds) {
        sysStru.setStruLevel(Integer.valueOf(sysStru.getStruFid().split("/").length - 1));
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            Set organIds;
            List sysStruAuditList;
            List sysOrganAuditList = this.sysOrganAuditService.list((Wrapper)new LambdaQueryWrapper().eq(SysOrganAudit::getOrganCode, (Object)sysOrgan.getOrganCode()));
            if (HussarUtils.isNotEmpty((Object)sysOrganAuditList) && HussarUtils.isNotEmpty((Object)(sysStruAuditList = this.sysStruAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruAudit::getOrganId, organIds = sysOrganAuditList.stream().map(SysOrganAudit::getId).collect(Collectors.toSet()))).eq(SysStruAudit::getState, (Object)"0"))))) {
                throw new BaseException("\u5f85\u5ba1\u6838\u6570\u636e\u4e2d\u5b58\u5728\u91cd\u590d\u7f16\u7801");
            }
            return this.doAddAuditStaff(sysStru, sysOrgan, sysStaff, assistIds);
        }
        return this.doAddNoAuditStaff(sysStru, sysOrgan, sysStaff, assistIds);
    }

    private String syncUser(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String assistIds, boolean isUpper) {
        boolean tenantFlag;
        if (this.sysUsersService.isExistAccount(isUpper ? sysOrgan.getOrganName().toUpperCase() : sysOrgan.getOrganName())) {
            LOGGER.warn("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
        }
        this.addStaffUser(sysStru, sysOrgan, sysStaff, isUpper);
        boolean bl = tenantFlag = this.hussarBaseProperties.isTenantOpen() && "2".equals(this.hussarBaseProperties.getTenantUserModel());
        if (tenantFlag) {
            List sysUsers = this.sysUsersService.list((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserName, (Object)sysOrgan.getOrganName()));
            SysUsers users = (SysUsers)sysUsers.get(0);
            boolean existAccount = this.sysLoginUserService.validateAccount(sysOrgan.getOrganName());
            if (existAccount) {
                throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
            }
            LOGGER.info("\u540c\u6b65\u65b0\u589e\u7528\u6237");
            this.sysLoginUserService.syncAddUser(users);
        }
        Long sysStruId = sysStru.getId();
        StruOrganRelationDto relationDto = new StruOrganRelationDto();
        relationDto.setOrganIds(assistIds);
        relationDto.setSysStruId(sysStruId);
        LOGGER.info("\u5904\u7406\u517c\u4efb\u5c97\u4f4d");
        boolean saveAssistOrgan = this.sysStruAssistOrganService.saveAssistOrgan(relationDto);
        if (!saveAssistOrgan) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return "\u65b0\u589e\u6210\u529f\uff01";
    }

    private void addStaffUser(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, boolean isUpper) {
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setOrganId(null);
        sysStru.setIsLeaf("0");
        sysStru.setStruPath("");
        Integer order = 1;
        Integer maxOrder = this.staffUserMapper.getMaxOrderUnderParent(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            order = maxOrder + 1;
        }
        sysStru.setStruOrder(order);
        this.sysOrganMapper.insert(sysOrgan);
        sysStru.setOrganId(sysOrgan.getId());
        this.sysStruMapper.insert(sysStru);
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            sysStaff.setName(sysOrgan.getOrganName());
            sysStaff.setStruId(sysStru.getId());
            this.staffUserMapper.insert(sysStaff);
        }
        SysUsers user = new SysUsers();
        user.setUserAccount(isUpper ? sysOrgan.getOrganName().toUpperCase() : sysOrgan.getOrganName());
        user.setUserName(sysOrgan.getOrganName());
        String pass = "";
        pass = this.createUserConfigService.getCreateUserSendEmail() != false && this.createUserConfigService.getCreateUserUseDefaultPass() == false ? GeneratePassword.generate((String)this.pwdConfigService.getPwdRule()) : this.pwdConfigService.getDefaultPassword();
        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
        user.setPassword(pwd);
        user.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
        user.setAccountStatus(UserStatus.OK.getCode());
        user.setSecurityLevel(Integer.valueOf(1));
        user.setMaxSessions(Integer.valueOf(1));
        user.setLoginIpLimit("0");
        user.setLoginTimeLimit("0");
        user.setIsSys("0");
        user.setIsCpublic("0");
        user.setCorporationId(sysStru.getParentId());
        user.setDepartmentId(sysStru.getParentId());
        user.setCorporationId(sysStru.getParentId());
        user.setEmployeeId(sysStru.getId());
        user.setTypeProperty("1");
        Integer userOrder = this.sysUsersService.getMaxOrder(user.getDepartmentId());
        userOrder = ToolUtil.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
        user.setUserOrder(userOrder);
        this.sysUsersService.save((Object)user);
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue() && user.geteMail() != null) {
            CreateUserSendMailUtil.sendMail((SysUsers)user, (String)pass);
        }
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(user.getId());
        userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
        userRole.setAdminOption("1");
        this.sysUserRoleMapper.insert(userRole);
    }

    private void initialization(AddStaffDto addStaffDto, SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff) {
        LOGGER.info("\u6839\u636eAddStaffDto\u521d\u59cb\u5316SysStru,SysOrgan,SysStaff,\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)addStaffDto));
        long sysStruId = IdWorker.getId((Object)sysStru);
        long sysOrganId = IdWorker.getId((Object)sysOrgan);
        long sysStaffId = IdWorker.getId((Object)sysStaff);
        sysStru.setId(Long.valueOf(sysStruId));
        sysStru.setOrganId(Long.valueOf(sysOrganId));
        sysStru.setParentId(addStaffDto.getParentId());
        sysStru.setStruType("9");
        sysStru.setOrganAlias(StringUtils.trimToEmpty((String)addStaffDto.getStaffName()));
        sysStru.setStaffPosition(StringUtils.trimToEmpty((String)addStaffDto.getStaffPosition()));
        sysStru.setIsEmployee("1");
        int level = 0;
        SysStru temp = (SysStru)this.sysStruMapper.selectById(sysStru.getParentId());
        level = HussarUtils.isEmpty((Object)temp) ? 1 : temp.getStruLevel() + 1;
        sysStru.setStruLevel(Integer.valueOf(level));
        Integer orderTree = 1;
        Integer maxOrder = this.sysStruMapper.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            orderTree = maxOrder + 1;
        }
        Integer struOrder = orderTree;
        sysStru.setStruOrder(struOrder);
        sysStaff.setId(Long.valueOf(sysStaffId));
        sysStaff.setStruId(Long.valueOf(sysStruId));
        sysStaff.setName(StringUtils.trimToEmpty((String)addStaffDto.getStaffName()));
        sysStaff.setAddress(StringUtils.trimToEmpty((String)addStaffDto.getAddress()));
        sysStaff.setBirthday(StringUtils.trimToEmpty((String)addStaffDto.getBirthday()));
        sysStaff.setSex(StringUtils.trimToEmpty((String)addStaffDto.getSex()));
        sysStaff.setIdcard(StringUtils.trimToEmpty((String)addStaffDto.getIdcard()));
        sysStaff.setGraduateDate(StringUtils.trimToEmpty((String)addStaffDto.getGraduateDate()));
        sysStaff.setGraduateSchool(StringUtils.trimToEmpty((String)addStaffDto.getGraduateSchool()));
        sysStaff.setWorkDate(StringUtils.trimToEmpty((String)addStaffDto.getWorkDate()));
        sysStaff.setWorkId(StringUtils.trimToEmpty((String)addStaffDto.getWorkId()));
        sysOrgan.setId(Long.valueOf(sysOrganId));
        sysOrgan.setOrganCode(StringUtils.trimToEmpty((String)addStaffDto.getStaffCode()));
        sysOrgan.setOrganName(sysStaff.getName());
        sysOrgan.setOrganType("9");
        String newCode = this.getCode(sysOrgan);
        sysOrgan.setOrganCode(newCode);
    }
}

