/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authentication.lock.UserLockModel;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonQueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.vo.OrganTreeInitVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.UserTreeVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryCopyRoleUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResetSecureUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleData;
import com.jxdinfo.hussar.authorization.permit.dto.UserInfolVo;
import com.jxdinfo.hussar.authorization.permit.dto.UserPartialVo;
import com.jxdinfo.hussar.authorization.permit.manager.QueryUserManager;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.vo.ResetSecureUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.authorization.sysuserip.dao.SysUserIpMapper;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.queryUserManagerImpl")
public class QueryUserManagerImpl
extends CommonQueryOrganizationManager
implements QueryUserManager {
    @Autowired
    private QueryOrganizationManager queryOrganizationManager;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Autowired
    private ISysDicRefService dicRefService;
    @Resource
    private SysUserIpMapper sysUserIpMapper;
    @Resource
    private SysRolesMapper sysRolesMapper;

    @Override
    public Page<SearchUserVo> searchUsers(PageInfo pageInfo, QueryUserDto queryUserDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        String struFid = "/";
        AtomicReference<Long> depStruId = new AtomicReference<Long>(queryUserDto.getDepStruId());
        if (currentUser.isGradeadmin()) {
            ConditionUtils.isTureOrFalse((boolean)HussarUtils.isEmpty((Object)depStruId.get())).trueOrFalseHandle(() -> depStruId.set(currentUser.getDeptId()), () -> {
                SysStru currentNodeStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)queryUserDto.getDepStruId()));
                SysStru sysStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)currentUser.getDeptId()));
                if (currentNodeStru.getStruLevel() <= sysStru.getStruLevel()) {
                    depStruId.set(currentUser.getDeptId());
                }
            });
        }
        if (HussarUtils.isNotEmpty((Object)depStruId.get()) && !Objects.equals(Constants.ROOT_NODE_ID, depStruId.get())) {
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(depStruId.get());
            AssertUtil.isNotNull((Object)struTemp, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7ed3\u6784");
            struFid = struTemp.getStruFid();
        } else if (HussarUtils.isBlank((CharSequence)queryUserDto.getUserName()) || HussarUtils.isBlank((CharSequence)queryUserDto.getUserAccount()) || HussarUtils.isBlank((CharSequence)queryUserDto.getAccountStatus()) || HussarUtils.isBlank((CharSequence)queryUserDto.getAccountProperty())) {
            queryParams.put("containSys", StringUtils.trimToNull((String)queryUserDto.getContainSys()));
        }
        Object[] arr = new String[]{UserStatus.LOCKED.getCode(), UserStatus.OK.getCode()};
        String accountStatus = queryUserDto.getAccountStatus();
        if (ArrayUtils.contains((Object[])arr, (Object)accountStatus)) {
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            if (HussarUtils.isEmpty((Object)keyList) && HussarUtils.equals((Object)accountStatus, (Object)UserStatus.LOCKED.getCode())) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            ArrayList<Long> lockUserIds = new ArrayList<Long>();
            queryUserDto.setLockUserIds(lockUserIds);
            if (CollectionUtils.isNotEmpty((Collection)keyList)) {
                String tmpKey = null;
                Iterator iterator = keyList.iterator();
                while (iterator.hasNext()) {
                    String cacheKey;
                    tmpKey = cacheKey = (String)iterator.next();
                    lockUserIds.add(Long.parseLong(tmpKey));
                }
            }
            if (HussarUtils.isNotEmpty(lockUserIds)) {
                queryParams.put("lockUserIds", lockUserIds);
            }
        }
        queryParams.put("depStruId", depStruId.get());
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("userAccount", StringUtils.trimToEmpty((String)queryUserDto.getUserAccount()));
        queryParams.put("accountStatus", StringUtils.trimToEmpty((String)queryUserDto.getAccountStatus()));
        queryParams.put("userName", StringUtils.trimToEmpty((String)queryUserDto.getUserName()));
        queryParams.put("accountProperty", StringUtils.trimToEmpty((String)queryUserDto.getAccountProperty()));
        queryParams.put("struFid", StringUtils.trimToNull((String)struFid));
        List<SearchUserVo> userInfoList = this.sysUsersMapper.searchUsers((Page<SearchUserVo>)page, queryParams);
        this.wrapUsers(userInfoList);
        page.setRecords(userInfoList);
        return page;
    }

    @Override
    public Page<SearchUserVo> searchCopyRoleUsers(PageInfo pageInfo, QueryCopyRoleUserDto queryCopyRoleUserDto) {
        String accountStatus;
        Object[] arr;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        String struFid = "/";
        AtomicReference<Long> depStruId = new AtomicReference<Long>(queryCopyRoleUserDto.getDepStruId());
        if (currentUser.isGradeadmin()) {
            ConditionUtils.isTureOrFalse((boolean)HussarUtils.isEmpty((Object)depStruId.get())).trueOrFalseHandle(() -> depStruId.set(currentUser.getDeptId()), () -> {
                SysStru currentNodeStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)queryCopyRoleUserDto.getDepStruId()));
                SysStru sysStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)currentUser.getDeptId()));
                if (currentNodeStru.getStruLevel() <= sysStru.getStruLevel()) {
                    depStruId.set(currentUser.getDeptId());
                }
            });
        }
        if (HussarUtils.isNotEmpty((Object)depStruId.get()) && !Objects.equals(Constants.ROOT_NODE_ID, depStruId.get())) {
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(depStruId.get());
            AssertUtil.isNotNull((Object)struTemp, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7ed3\u6784");
            struFid = struTemp.getStruFid();
        }
        if (ArrayUtils.contains((Object[])(arr = new String[]{UserStatus.LOCKED.getCode(), UserStatus.OK.getCode()}), (Object)(accountStatus = queryCopyRoleUserDto.getAccountStatus()))) {
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            ArrayList<Long> lockUserIds = new ArrayList<Long>();
            queryCopyRoleUserDto.setLockUserIds(lockUserIds);
            if (CollectionUtils.isNotEmpty((Collection)keyList)) {
                String tmpKey = null;
                Iterator iterator = keyList.iterator();
                while (iterator.hasNext()) {
                    String cacheKey;
                    tmpKey = cacheKey = (String)iterator.next();
                    lockUserIds.add(Long.parseLong(tmpKey));
                }
            }
            if (UserStatus.LOCKED.getCode().equals(accountStatus) && HussarUtils.isNotEmpty(lockUserIds)) {
                queryParams.put("lockUserIds", lockUserIds);
            }
        }
        queryParams.put("sourceUserId", queryCopyRoleUserDto.getSourceUserId());
        queryParams.put("depStruId", depStruId.get());
        queryParams.put("userAccount", StringUtils.trimToEmpty((String)queryCopyRoleUserDto.getUserAccount()));
        queryParams.put("accountStatus", StringUtils.trimToEmpty((String)queryCopyRoleUserDto.getAccountStatus()));
        queryParams.put("userName", StringUtils.trimToEmpty((String)queryCopyRoleUserDto.getUserName()));
        queryParams.put("accountProperty", StringUtils.trimToEmpty((String)queryCopyRoleUserDto.getAccountProperty()));
        queryParams.put("struFid", StringUtils.trimToNull((String)struFid));
        List<SearchUserVo> userInfoList = this.sysUsersMapper.searchCopyRoleUsers((Page<SearchUserVo>)page, queryParams);
        this.wrapUsers(userInfoList);
        page.setRecords(userInfoList);
        return page;
    }

    @Override
    public List<SysUsers> selectUsersByStruIds(List<Long> struIds) {
        if (HussarUtils.isEmpty(struIds)) {
            return Collections.emptyList();
        }
        return this.sysUsersMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysUsers::getEmployeeId, struIds));
    }

    @Override
    public List<SysUsers> selectUsersByIds(List<Long> ids) {
        if (HussarUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.sysUsersMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysUsers::getId, ids));
    }

    @Override
    public Page<ResetSecureUserVo> searchResetSecureUsers(PageInfo pageInfo, ResetSecureUserDto resetSecureUserDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        String struFid = "/";
        Long depStruId = null;
        if (currentUser.isGradeadmin()) {
            depStruId = currentUser.getDeptId();
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(depStruId);
            AssertUtil.isNotNull((Object)struTemp, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7ed3\u6784");
            struFid = struTemp.getStruFid();
        } else {
            queryParams.put("containSys", "1");
        }
        String userAccount = StringUtils.trimToEmpty((String)resetSecureUserDto.getUserAccount());
        String userName = StringUtils.trimToEmpty((String)resetSecureUserDto.getUserName());
        String mail = StringUtils.trimToEmpty((String)resetSecureUserDto.getMail());
        String mobile = StringUtils.trimToEmpty((String)resetSecureUserDto.getMobile());
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("userAccount", SqlQueryUtil.transferSpecialChar((String)userAccount));
        queryParams.put("userName", SqlQueryUtil.transferSpecialChar((String)userName));
        queryParams.put("mail", SqlQueryUtil.transferSpecialChar((String)mail));
        queryParams.put("mobile", SqlQueryUtil.transferSpecialChar((String)mobile));
        queryParams.put("struFid", StringUtils.trimToNull((String)struFid));
        List<ResetSecureUserVo> userInfoList = this.sysUsersMapper.searchResetSecureUserVo((Page<ResetSecureUserVo>)page, queryParams);
        page.setRecords(userInfoList);
        return page;
    }

    @Override
    public List<UserTreeVo> lazyLoadingUserTree(Long parentId) {
        ArrayList<UserTreeVo> result = new ArrayList<UserTreeVo>();
        List<UserTreeVo> data = this.getUserTree(parentId);
        this.fillUserPermissions(data);
        result.addAll(data);
        return HussarTreeParser.getTreeList(result);
    }

    @Override
    public List<UserTreeVo> getOrderUserTree(Long parentId) {
        HashMap<String, Long> queryParams = new HashMap<String, Long>();
        queryParams.put("parentId", parentId);
        ArrayList<UserTreeVo> result = new ArrayList<UserTreeVo>();
        List<UserTreeVo> data = this.sysUsersMapper.getUserByDepartment(parentId);
        UserTreeVo root = new UserTreeVo();
        OrganizationTreeVo organizationTreeVo = this.queryOrganizationManager.lazyOrganizationById(parentId);
        root.setStruType(organizationTreeVo.getStruType());
        root.setId(organizationTreeVo.getId());
        root.setHasChildren(organizationTreeVo.getHasChildren());
        root.setIcon(organizationTreeVo.getIcon());
        root.setLabel(organizationTreeVo.getLabel());
        root.setDisabled(Boolean.valueOf(true));
        root.setChildren(data);
        result.add(root);
        return result;
    }

    @Override
    public List<UserTreeVo> backUserTree(Long id) {
        List<OrganizationTreeVo> organizations = this.queryOrganizationManager.backOrganizationTree(id);
        return this.convert(organizations);
    }

    private List<UserTreeVo> convert(List<OrganizationTreeVo> children) {
        ArrayList<UserTreeVo> list = new ArrayList<UserTreeVo>();
        if (HussarUtils.isNotEmpty(children)) {
            List<SysStruRule> staffRuleList = this.searchWithStaffRuleList();
            for (OrganizationTreeVo vo : children) {
                UserTreeVo temp = new UserTreeVo();
                temp.setDisabled(vo.getDisabled());
                temp.setStruType(vo.getStruType());
                if (HussarUtils.isNotEmpty((Object)vo.getChildren())) {
                    temp.setChildren(this.convert(vo.getChildren()));
                }
                temp.setId(vo.getId());
                temp.setHasChildren(vo.getHasChildren());
                temp.setIcon(vo.getIcon());
                temp.setLabel(vo.getLabel());
                temp.setParentId(vo.getParentId());
                this.fillSingleUserPermissions(temp, staffRuleList);
                list.add(temp);
            }
        }
        return list;
    }

    @Override
    public UserPartialVo viewUser(Long id) {
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = currentUser.isGradeadmin();
        SysUsers user = (SysUsers)this.sysUsersMapper.selectById(id);
        AssertUtil.isNotNull((Object)user, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        UserPartialVo vo = new UserPartialVo();
        vo.setId(user.getId());
        vo.setTotpKey(user.getTotpKey());
        vo.setUserAccount(user.getUserAccount());
        if (HussarUtils.isNotEmpty((Object)user.getEmployeeId())) {
            SysStru stru = (SysStru)this.sysStruMapper.selectById(user.getEmployeeId());
            vo.setStaffName(stru.getOrganAlias());
        }
        vo.setMaxSessions(user.getMaxSessions());
        vo.setMail(user.geteMail());
        vo.setWeChat(user.getWeChat());
        vo.setMobile(user.getMobile());
        vo.setTelephone(user.getTelephone());
        if (user.getAccountStatus().equals(UserStatus.CANCEL.getCode())) {
            vo.setAccountStatusName(UserStatus.CANCEL.getMessage());
        } else {
            String accountStatusName = this.dicRefService.getDictLabel("account_state", user.getAccountStatus());
            vo.setAccountStatusName(accountStatusName);
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            String cacheKey = null;
            for (String s : keyList) {
                cacheKey = s;
                UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)cacheKey);
                if (model == null || model.getLockTime() == null || !String.valueOf(user.getId()).equals(cacheKey)) continue;
                vo.setAccountStatusName(UserStatus.LOCKED.getMessage());
            }
        }
        String accountPropertyName = this.dicRefService.getDictLabel("account_property", user.getTypeProperty());
        vo.setAccountPropertyName(accountPropertyName);
        vo.setLoginIpLimit(user.getLoginIpLimit().equals("1"));
        if (vo.isLoginIpLimit()) {
            List sysUserIps = this.sysUserIpMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)id)).stream().map(item -> item.getUserIp()).collect(Collectors.toList());
            String allowedIps = String.join((CharSequence)",", sysUserIps);
            vo.setAllowedIps(allowedIps);
        }
        vo.setLoginTimeLimit(user.getLoginTimeLimit().equals("1"));
        if (vo.isLoginTimeLimit()) {
            vo.setAccessLoginStartTime(Java8DateUtils.convertLocalTimeToString((LocalTime)user.getAccessLoginStartTime()));
            vo.setAccessLoginEndTime(Java8DateUtils.convertLocalTimeToString((LocalTime)user.getAccessLoginEndTime()));
        }
        vo.setStartTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)user.getStartTime()));
        vo.setEndTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)user.getExpiredTime()));
        List<RoleData> data = null;
        data = this.getCommonUserRoleData(id, isGradeAdmin);
        vo.setRoles(data);
        boolean flag = false;
        if (HussarUtils.isNotEmpty(data)) {
            flag = data.stream().map(item -> item.getId()).collect(Collectors.toList()).contains(SysUserAndRole.GRADEADMIN_ROLE.getValue());
        }
        vo.setGradeAdmin(flag);
        return vo;
    }

    private List<RoleData> getCommonUserRoleData(Long id, boolean gradeAdmin) {
        return this.sysUserRoleMapper.getCommonUserRoleData(id, gradeAdmin);
    }

    @Override
    public UserInfolVo loadUser(Long id) {
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = currentUser.isGradeadmin();
        SysUsers user = (SysUsers)this.sysUsersMapper.selectById(id);
        AssertUtil.isNotNull((Object)user, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        UserInfolVo vo = new UserInfolVo();
        vo.setId(user.getId());
        vo.setUserAccount(user.getUserAccount());
        vo.setEmployeeId(user.getEmployeeId());
        if (HussarUtils.isNotEmpty((Object)user.getEmployeeId())) {
            SysStru stru = (SysStru)this.sysStruMapper.selectById(user.getEmployeeId());
            vo.setStaffName(stru.getOrganAlias());
            vo.setParentId(stru.getParentId());
        }
        vo.setMaxSessions(user.getMaxSessions());
        vo.setTotpKey(user.getTotpKey());
        vo.setMail(user.geteMail());
        vo.setWeChat(user.getWeChat());
        vo.setMobile(user.getMobile());
        vo.setTelephone(user.getTelephone());
        vo.setAccountProperty(user.getTypeProperty());
        vo.setAccountStatus(user.getAccountStatus());
        String accountStatusName = this.dicRefService.getDictLabel("account_state", user.getAccountStatus());
        vo.setAccountStatusName(accountStatusName);
        List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
        String cacheKey = null;
        for (String s : keyList) {
            cacheKey = s;
            UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)cacheKey);
            if (model == null || model.getLockTime() == null || !String.valueOf(user.getId()).equals(cacheKey)) continue;
            vo.setAccountStatusName(UserStatus.LOCKED.getMessage());
        }
        String accountPropertyName = this.dicRefService.getDictLabel("account_property", user.getTypeProperty());
        vo.setAccountPropertyName(accountPropertyName);
        vo.setLoginIpLimit(user.getLoginIpLimit().equals("1"));
        if (vo.isLoginIpLimit()) {
            List sysUserIps = this.sysUserIpMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)id)).stream().map(item -> item.getUserIp()).collect(Collectors.toList());
            String allowedIps = String.join((CharSequence)",", sysUserIps);
            vo.setAllowedIps(allowedIps);
        }
        vo.setLoginTimeLimit(user.getLoginTimeLimit().equals("1"));
        if (vo.isLoginTimeLimit()) {
            vo.setAccessLoginStartTime(Java8DateUtils.convertLocalTimeToString((LocalTime)user.getAccessLoginStartTime()));
            vo.setAccessLoginEndTime(Java8DateUtils.convertLocalTimeToString((LocalTime)user.getAccessLoginEndTime()));
        }
        vo.setStartTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)user.getStartTime()));
        vo.setEndTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)user.getExpiredTime()));
        List<RoleData> data = null;
        data = this.getCommonUserRoleData(id, isGradeAdmin);
        vo.setRoles(data);
        boolean flag = false;
        if (HussarUtils.isNotEmpty(data)) {
            flag = data.stream().map(item -> item.getId()).collect(Collectors.toList()).contains(SysUserAndRole.GRADEADMIN_ROLE.getValue());
        }
        vo.setGradeAdmin(flag);
        return vo;
    }

    public List<UserTreeVo> convertUser(List<OrganizationTreeVo> organizations) {
        ArrayList<UserTreeVo> list = new ArrayList<UserTreeVo>();
        UserTreeVo temp = null;
        List<SysStruRule> staffRuleList = this.searchWithStaffRuleList();
        for (OrganizationTreeVo vo : organizations) {
            temp = new UserTreeVo();
            temp.setDisabled(vo.getDisabled());
            temp.setStruType(vo.getStruType());
            List children = vo.getChildren();
            temp.setChildren(this.convertUser(children));
            temp.setId(vo.getId());
            temp.setHasChildren(vo.getHasChildren());
            temp.setIcon(vo.getIcon());
            temp.setLabel(vo.getLabel());
            temp.setParentId(vo.getParentId());
            this.fillSingleUserPermissions(temp, staffRuleList);
            list.add(temp);
        }
        return list;
    }

    private List<UserTreeVo> getUserTree(Long parentId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("parentId", parentId);
        return this.sysUsersMapper.searchUserTree(queryParams);
    }

    private void wrapUsers(List<SearchUserVo> userInfoList) {
        List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
        List list1 = this.sysDicRefService.getDicListByType("account_state");
        Map<String, String> mapStatus = list1.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        List list2 = this.sysDicRefService.getDicListByType("account_property");
        Map<String, String> mapProperty = list2.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        boolean flag = HussarUtils.isNotEmpty((Object)keyList);
        if (HussarUtils.isNotEmpty(userInfoList)) {
            for (SearchUserVo vo : userInfoList) {
                vo.setAccoutStatusName(mapStatus.get(vo.getAccountStatus()));
                vo.setAccountPropertyName(mapProperty.get(vo.getAccountProperty()));
                if (!flag) continue;
                Optional<String> optional = keyList.parallelStream().filter(item -> item.equalsIgnoreCase(String.valueOf(vo.getId()))).findAny();
                ConditionUtils.isTrue((boolean)optional.isPresent()).handle(() -> {
                    String tmpkey = (String)optional.get();
                    UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)tmpkey);
                    if (null != model && model.getLockTime() != null) {
                        vo.setAccountStatus(UserStatus.LOCKED.getCode());
                    }
                });
            }
        }
    }

    @Override
    public List<OrganTreeInitVo> getUsersByParentIdAndLevel(Long parentId, int defaultLevelNum) {
        if (!parentId.toString().equals("11")) {
            String fid = this.sysStruMapper.getStruFidByOrganId(parentId);
            int parentLevel = this.sysStruMapper.getStruLevelByStruId(parentId);
            if (defaultLevelNum != 0) {
                defaultLevelNum += parentLevel;
            }
            List<OrganTreeInitVo> users = this.sysUsersMapper.queryUsersByFidAndLevel(fid, defaultLevelNum);
            return users;
        }
        String fid = "";
        List<OrganTreeInitVo> users = this.sysUsersMapper.queryUsersByFidAndLevel(fid, defaultLevelNum);
        return users;
    }

    @Override
    public List<OrganTreeInitVo> getChildrenUsersByParentId(Long parentId) {
        return this.sysUsersMapper.queryChildrenUsersByParentId(parentId);
    }

    @Override
    public List<OrganTreeInitVo> queryUpUsersByFidAndLevel(String fid, int defaultLevelNum) {
        return this.sysUsersMapper.queryUpUsersByFidAndLevel(fid, defaultLevelNum);
    }

    @Override
    public List<OrganTreeInitVo> getUsersLikeName(String searchValue) {
        return this.sysUsersMapper.queryUsersLikeName(searchValue);
    }

    @Override
    public Integer getStaffLevelByUserId(Long userId) {
        return this.sysUsersMapper.getStaffLevelByUserId(userId);
    }

    @Override
    public OrganTreeInitVo getUserInfoByUserId(Long userId) {
        return this.sysUsersMapper.queryUserInfoByUserId(userId);
    }

    @Override
    public Long getUserDepartmentId(Long userId) {
        return this.sysUsersMapper.getUserDepartmentId(userId);
    }

    @Override
    public List<OrganTreeInitVo> getAllChildrenUsers(String fid) {
        return this.sysUsersMapper.queryAllChildrenUsers(fid);
    }
}

