/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.PermissionEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysOfficeMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.UserTreeVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.common.treemodel.HussarTreePermission;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;

public abstract class CommonQueryOrganizationManager {
    protected static final String STRUFID = "struFid";
    protected static final String STRULEVEL = "struLevel";
    protected static final String PARENTID = "parentId";
    protected static final String NOT_FIND_SYSORGAN = "\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u673a\u6784";
    protected static final String NOT_FIND_SYSSTAFF = "\u672a\u67e5\u8be2\u5230\u4eba\u5458\u4fe1\u606f";
    protected static final String NOT_FIND_SYSSTRU = "\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7ed3\u6784";
    protected static final String PARENTIDS = "parentIds";
    @Resource
    protected SysStruMapper sysStruMapper;
    @Resource
    protected SysStaffMapper sysStaffMapper;
    @Resource
    protected SysOrganMapper sysOrganMapper;
    @Resource
    protected SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Resource
    protected SysOfficeMapper sysOfficeMapper;
    @Autowired
    protected ISysOrganTypeService organTypeService;
    @Resource
    protected SysUsersMapper sysUsersMapper;
    @Resource
    protected SysStruRuleMapper sysStruRuleMapper;
    @Autowired
    protected ISysDicRefService sysDicRefService;

    protected List<OrganizationTreeVo> getOrganizationTree(Long parentId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(PARENTID, parentId);
        return this.searchOrganizationTree(queryParams);
    }

    protected List<StaffTreeVo> getStaffTree(Long parentId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(PARENTID, parentId);
        return this.sysStruMapper.searchStaffTree(queryParams);
    }

    protected List<OrganizationTreeVo> searchOrganizationTree(Map<String, Object> queryParams) {
        return this.sysStruMapper.searchOrganizationTree(queryParams);
    }

    protected void fillSingleOrganizationPermissions(OrganizationTreeVo organizationTreeVo, List<SysStruRule> list) {
        String struType = organizationTreeVo.getStruType();
        Boolean hasChildren = organizationTreeVo.getHasChildren();
        List permissions = organizationTreeVo.getPermissions();
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (SysStruRule ssr : list) {
            map.add((Object)ssr.getSysOrganType(), (Object)ssr.getOrganType());
        }
        List rules = (List)map.get((Object)struType);
        organizationTreeVo.setDisabled(Boolean.valueOf(false));
        permissions.add(new HussarTreePermission(PermissionEnum.ADD.getId(), PermissionEnum.ADD.getName(), Boolean.valueOf(HussarUtils.isNotEmpty((Object)rules))));
        permissions.add(new HussarTreePermission(PermissionEnum.EDIT.getId(), PermissionEnum.EDIT.getName(), Boolean.valueOf(true)));
        permissions.add(new HussarTreePermission(PermissionEnum.DELETE.getId(), PermissionEnum.DELETE.getName(), Boolean.valueOf(true)));
        organizationTreeVo.setPermissions(permissions);
    }

    protected void fillOrganizationPermissions(List<OrganizationTreeVo> result) {
        List<SysStruRule> list = this.searchWithoutStaffRuleList();
        for (OrganizationTreeVo organizationTreeVo : result) {
            this.fillSingleOrganizationPermissions(organizationTreeVo, list);
        }
    }

    protected void fillStaffPermissions(List<StaffTreeVo> data) {
        List<SysStruRule> list = this.searchWithStaffRuleList();
        for (StaffTreeVo vo : data) {
            this.fillSingleStaffPermissions(vo, list);
        }
    }

    protected void fillSingleStaffPermissions(StaffTreeVo staffTreeVo, List<SysStruRule> list) {
        List permissions = staffTreeVo.getPermissions();
        String struType = staffTreeVo.getStruType();
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (SysStruRule ssr : list) {
            map.add((Object)ssr.getSysOrganType(), (Object)ssr.getOrganType());
        }
        List rules = (List)map.get((Object)struType);
        staffTreeVo.setDisabled(Boolean.valueOf(false));
        permissions.add(new HussarTreePermission(PermissionEnum.ADD.getId(), "\u65b0\u589e\u4eba\u5458", Boolean.valueOf(HussarUtils.isNotEmpty((Object)rules))));
        staffTreeVo.setPermissions(permissions);
    }

    protected void fillUserPermissions(List<UserTreeVo> data) {
        List<SysStruRule> list = this.searchWithStaffRuleList();
        for (UserTreeVo vo : data) {
            this.fillSingleUserPermissions(vo, list);
        }
    }

    protected void fillSingleUserPermissions(UserTreeVo vo, List<SysStruRule> list) {
        List permissions = vo.getPermissions();
        String struType = vo.getStruType();
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (SysStruRule ssr : list) {
            map.add((Object)ssr.getSysOrganType(), (Object)ssr.getOrganType());
        }
        List rules = (List)map.get((Object)struType);
        vo.setDisabled(Boolean.valueOf(false));
        permissions.add(new HussarTreePermission(PermissionEnum.ADD.getId(), "\u65b0\u589e\u7528\u6237", Boolean.valueOf(HussarUtils.isNotEmpty((Object)rules))));
        vo.setPermissions(permissions);
    }

    protected List<SysStruRule> searchWithStaffRuleList() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysStruRule::getOrganType, (Object)"9");
        return this.sysStruRuleMapper.selectList((Wrapper)wrapper);
    }

    protected List<SysStruRule> searchWithoutStaffRuleList() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.ne(SysStruRule::getOrganType, (Object)"9");
        return this.sysStruRuleMapper.selectList((Wrapper)wrapper);
    }
}

