/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.authorization.permit.dto.FuncDumpDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.migration.plugin.MigrationPlugin;
import com.jxdinfo.hussar.migration.plugin.MigrationPluginMetadata;
import com.jxdinfo.hussar.migration.plugin.context.MigrationDumpContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationLoadContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationPreloadContext;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationDumpItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationLoadItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationPreloadItemVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysFuncResMenuMigrationPlugin
implements MigrationPlugin {
    private static final Logger logger = LoggerFactory.getLogger(SysFuncResMenuMigrationPlugin.class);
    public static final String TYPE = "funcResMenu";
    private static final FuncResMenuMetaData FUNCRESMENUMETADATA = new FuncResMenuMetaData();
    @Resource
    private ISysFunctionsService functionsService;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private ISysMenuManageService sysMenuManageService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysResourceMosulesService sysResourceMosulesService;
    @Resource
    private ISysFunctionResourcesService functionResourcesService;

    public MigrationPluginMetadata metadata() {
        return FUNCRESMENUMETADATA;
    }

    public MigrationDumpItemVo<Object> dump(MigrationDumpContext context, Map<String, Object> parameters) {
        List funcDumpDtoList = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString((Object)parameters.get("funcResMenuInfo")), (TypeReference)new TypeReference<List<FuncDumpDto>>(){});
        List result = new ArrayList();
        if (funcDumpDtoList.isEmpty()) {
            context.setAttribute("total", (Object)0L);
            return MigrationDumpItemVo.success((Long)0L, result);
        }
        Map allData = this.functionsService.getFuncResMenuDumpData(funcDumpDtoList);
        if (HussarUtils.isNotEmpty((Object)allData)) {
            context.setPayloadOfJson("function.json", allData.get("function"));
            context.setPayloadOfJson("functionModule.json", allData.get("functionModule"));
            context.setPayloadOfJson("functionResources.json", allData.get("functionResources"));
            context.setPayloadOfJson("resources.json", allData.get("resources"));
            context.setPayloadOfJson("resourceModule.json", allData.get("resourceModule"));
            context.setPayloadOfJson("menu.json", allData.get("menu"));
            context.setAttribute("total", allData.get("total"));
            result = this.functionsService.getFuncResMenuDumpTree(allData);
        }
        return MigrationDumpItemVo.success((Long)((Long)allData.get("total")), result);
    }

    public MigrationPreloadItemVo<Object> preload(MigrationPreloadContext context) {
        List functionsList = (List)context.getPayloadAsJson("function.json", (TypeReference)new TypeReference<List<SysFunctions>>(){});
        List resourcesList = (List)context.getPayloadAsJson("resources.json", (TypeReference)new TypeReference<List<SysResources>>(){});
        List functionResourcesList = (List)context.getPayloadAsJson("functionResources.json", (TypeReference)new TypeReference<List<SysFunctionResources>>(){});
        List functionModulesList = (List)context.getPayloadAsJson("functionModule.json", (TypeReference)new TypeReference<List<SysFunctionModules>>(){});
        List menuList = (List)context.getPayloadAsJson("menu.json", (TypeReference)new TypeReference<List<SysMenu>>(){});
        List resourceModulesList = (List)context.getPayloadAsJson("resourceModule.json", (TypeReference)new TypeReference<List<SysResourceModules>>(){});
        HashMap<String, List> importData = new HashMap<String, List>();
        importData.put("function", functionsList);
        importData.put("resources", resourcesList);
        importData.put("functionResources", functionResourcesList);
        importData.put("functionModule", functionModulesList);
        importData.put("menu", menuList);
        importData.put("resourceModule", resourceModulesList);
        List result = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)functionsList)) {
            result = this.functionsService.getFuncResMenuCheckTree(importData);
        }
        return MigrationPreloadItemVo.success(result);
    }

    @HussarTransactional
    public MigrationLoadItemVo<Object> load(MigrationLoadContext context, Map<String, Object> parameters) {
        List functionsList = (List)context.getPayloadAsJson("function.json", (TypeReference)new TypeReference<List<SysFunctions>>(){});
        List resourcesList = (List)context.getPayloadAsJson("resources.json", (TypeReference)new TypeReference<List<SysResources>>(){});
        List functionResourcesList = (List)context.getPayloadAsJson("functionResources.json", (TypeReference)new TypeReference<List<SysFunctionResources>>(){});
        List functionModulesList = (List)context.getPayloadAsJson("functionModule.json", (TypeReference)new TypeReference<List<SysFunctionModules>>(){});
        List menuList = (List)context.getPayloadAsJson("menu.json", (TypeReference)new TypeReference<List<SysMenu>>(){});
        List resourceModulesList = (List)context.getPayloadAsJson("resourceModule.json", (TypeReference)new TypeReference<List<SysResourceModules>>(){});
        HashMap<String, List> importData = new HashMap<String, List>();
        importData.put("function", functionsList);
        importData.put("resources", resourcesList);
        importData.put("functionResources", functionResourcesList);
        importData.put("functionModule", functionModulesList);
        importData.put("menu", menuList);
        importData.put("resourceModule", resourceModulesList);
        List result = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)functionsList)) {
            result = this.functionsService.getFuncResMenuCheckTree(importData);
        }
        this.functionsService.saveOrUpdateBatch((Collection)functionsList);
        this.sysFunctionModulesService.saveOrUpdateBatch((Collection)functionModulesList);
        this.sysMenuManageService.saveOrUpdateBatch((Collection)menuList);
        this.sysResourcesService.saveOrUpdateBatch((Collection)resourcesList);
        this.sysResourceMosulesService.saveOrUpdateBatch((Collection)resourceModulesList);
        if (HussarUtils.isNotEmpty((Object)functionResourcesList)) {
            this.functionResourcesService.deleteListByDoubleIds(functionResourcesList);
            this.functionResourcesService.saveBatch((Collection)functionResourcesList);
        }
        int totalInt = (Integer)context.getAttribute("total");
        return MigrationLoadItemVo.success((Long)Long.valueOf(totalInt), result);
    }

    private static final class FuncResMenuMetaData
    implements MigrationPluginMetadata {
        private FuncResMenuMetaData() {
        }

        public String getServiceType() {
            return SysFuncResMenuMigrationPlugin.TYPE;
        }

        public Long getVersion() {
            return super.getVersion();
        }

        public int getDumpPrecedence() {
            return super.getDumpPrecedence();
        }
    }
}

