/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authentication.lock.LoginLock;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.dto.UserSecureDto;
import com.jxdinfo.hussar.authorization.permit.manager.RestUserSecureManager;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.vo.UpdateInfoVo;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.crypto.properties.HussarEncryptProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.service.PasswordEncryptService;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.restUserSecureManagerImpl")
public class RestUserSecureManagerImpl
implements RestUserSecureManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestUserSecureManagerImpl.class);
    @Resource
    private Validator validator;
    @Resource
    private HussarEncryptProperties hussarEncryptProperties;
    @Autowired
    private PasswordEncryptService passwordEncryptService;
    @Autowired
    private IDynamicDataSourceService dynamicDataSourceService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private IHussarPwdConfigService hussarPwdConfigService;
    @Resource
    private SysUsersMapper sysUsersMapper;

    private String validate(Object object) {
        Set validate = this.validator.validate(object, new Class[0]);
        if (HussarUtils.isNotEmpty((Object)validate)) {
            return ((ConstraintViolation)validate.iterator().next()).getMessage();
        }
        return null;
    }

    @Override
    @HussarTransactional
    public UpdateInfoVo resetUserSecure(UserSecureDto userSecureDto) {
        LOGGER.info("\u6267\u884c\u7528\u6237\u5bc6\u7801\u91cd\u7f6e,\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)userSecureDto));
        String validateMsg = this.validate(userSecureDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String userIds = StringUtils.trimToEmpty((String)userSecureDto.getUserIds());
        String superSecure = StringUtils.trimToEmpty((String)userSecureDto.getSuperSecure());
        String resetSecure = StringUtils.trimToEmpty((String)userSecureDto.getResetSecure());
        String resetSecureConfirm = StringUtils.trimToEmpty((String)userSecureDto.getResetSecureConfirm());
        String[] userIdsArr = userIds.split(",");
        if (this.hussarEncryptProperties.isEnablePwEncryption()) {
            superSecure = this.passwordEncryptService.decrypt(superSecure);
            resetSecure = this.passwordEncryptService.decrypt(resetSecure);
            resetSecureConfirm = this.passwordEncryptService.decrypt(resetSecureConfirm);
        }
        String aPwd = this.credentialsMatcher.passwordEncode(superSecure.getBytes());
        Long userId = BaseSecurityUtil.getUser().getId();
        SysUsers user = (SysUsers)this.sysUsersMapper.selectById(userId);
        UpdateInfoVo updateInfoVo = new UpdateInfoVo();
        if (!aPwd.equals(user.getPassword())) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("resetFailPwdError");
            return updateInfoVo;
        }
        if (!resetSecure.equals(resetSecureConfirm)) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("resetFailPwdNotSame");
            return updateInfoVo;
        }
        String regular = this.hussarPwdConfigService.getPwdComplexityRegular().replace("/", "");
        String hint = this.hussarPwdConfigService.getUnmatchedHintMark();
        String unmatchedHint = this.hussarPwdConfigService.getUnmatchedHint();
        String pwdRule = this.hussarPwdConfigService.getPwdRule();
        if (!resetSecure.matches(regular)) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("unmatchedHintMark");
            updateInfoVo.setPwdRule(pwdRule);
            updateInfoVo.setHintMark(hint);
            updateInfoVo.setMsg(unmatchedHint);
            return updateInfoVo;
        }
        Object[] userIdL = (Long[])ConvertUtils.convert((String[])userIdsArr, Long.class);
        List sysUsers = this.sysUsersMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysUsers::getEmployeeId, userIdL));
        for (SysUsers users : sysUsers) {
            if (!resetSecure.toLowerCase().contains(users.getUserAccount().toLowerCase())) continue;
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("pwdContainUsernameMark");
            updateInfoVo.setUserName(users.getUserName());
            return updateInfoVo;
        }
        String nPwd = this.credentialsMatcher.passwordEncode(resetSecure.getBytes());
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        String connName = this.dynamicDataSourceService.currentDsName();
        this.sysUsersMapper.resetAllPwd((Long[])userIdL, nPwd);
        for (String id : userIdsArr) {
            if (!ToolUtil.isNotEmpty((Object)id)) continue;
            if (this.hussarBaseProperties.isTenantOpen()) {
                loginLock.removeUserCache(id, connName);
                continue;
            }
            loginLock.removeUserCache(id);
        }
        updateInfoVo.setSuccess(true);
        return updateInfoVo;
    }
}

