/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteUserManager;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.deleteUserManagerImpl")
public class DeleteUserManagerImpl
implements DeleteUserManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteUserManagerImpl.class);
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Autowired
    private ISysAuditConfigService sysAuditConfig;
    @Autowired
    private ISysUserIpService sysUserIpService;
    @Autowired
    private ISysUsersAuditService sysUsersAuditService;
    @Autowired
    private ISysUserroleAuditService sysUserroleAuditService;

    @Override
    @HussarTransactional
    public String deleteUser(Long id) {
        LOGGER.info("\u5220\u9664\u7528\u6237\uff1a{}", (Object)id);
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        SysUsers sysUser = (SysUsers)this.sysUsersMapper.selectById(id);
        if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u5220\u9664\u7ba1\u7406\u5458\u7528\u6237\uff01\uff09");
        }
        AssertUtil.isFalse((boolean)shiroUser.getId().equals(id), (String)"\u5220\u9664\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u5220\u9664\u5f53\u524d\u7528\u6237\uff01\uff09");
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.sysUsersAuditService.adjustEdit(id)) {
            throw new BaseException("\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
        }
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUser);
            sysUsersAudit.setId(null);
            sysUsersAudit.setUserId(sysUser.getId());
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCurrentStatus("2");
            this.sysUsersAuditService.save((Object)sysUsersAudit);
            return "\u5220\u9664\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
        }
        sysUser.setAccountStatus(UserStatus.DELETE.getCode());
        this.sysStruMapper.updatePrincipal(sysUser.getId());
        this.sysUserroleAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)sysUser.getId()));
        this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)sysUser.getId()));
        this.sysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)sysUser.getId()));
        this.sysUsersMapper.updateById(sysUser);
        return "\u5220\u9664\u6210\u529f\uff01";
    }
}

